/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.common.internal.util.CategoriesHelper;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.AttributeMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryMapper
extends AttributeMapper {
    private IAttribute fAttribute;
    private Map<String, ICategoryHandle> fCategories;

    public CategoryMapper(BugzillaMapping.AttributeMapping attributeMapping, BugzillaMapping.AttributeTypeMapping attributeTypeMapping) {
        super(attributeMapping, attributeTypeMapping);
    }

    @Override
    public XMLString copy(IWorkItem workItem, ReportData data, LocalizationContext localization, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle projectArea = workItem.getProjectArea();
        this.invalidateCachedValues(projectArea);
        if (this.fAttribute == null) {
            this.fAttribute = this.getAttributeMapping().resolveTargetAttribute(projectArea, monitor);
        }
        if (this.fAttribute == null) {
            return null;
        }
        String productName = data.getString("product");
        String componentName = data.getString("component");
        List<String> namePath = this.getNamePath(productName, componentName);
        ICategoryHandle category = this.findOrCreateCategory(projectArea, namePath, monitor);
        if (!workItem.hasAttribute(this.fAttribute)) {
            workItem.addCustomAttribute(this.fAttribute);
        }
        workItem.setValue(this.fAttribute, (Object)category);
        return null;
    }

    @Override
    public void record(ReportData data, IProgressMonitor monitor) {
        String value = data.getString("product");
        if (value == null || value.length() == 0) {
            return;
        }
        String component = data.getString("component");
        if (component != null && component.length() > 0) {
            value = String.valueOf(value) + "/" + component;
        }
        this.getAttributeTypeMapping().recordValueMapping(value);
    }

    private void invalidateCachedValues(IProjectAreaHandle projectArea) {
        if (this.fAttribute != null && !this.fAttribute.getProjectArea().sameItemId((IItemHandle)projectArea)) {
            this.fAttribute = null;
            this.fCategories = null;
        }
    }

    private List<String> getNamePath(String productName, String componentName) {
        StringBuilder namePath = new StringBuilder();
        if (productName != null && productName.length() != 0) {
            namePath.append(productName);
            if (componentName != null && componentName.length() != 0) {
                namePath.append("/");
                namePath.append(componentName);
            }
        }
        int i = namePath.length();
        BugzillaMapping.ValueMapping valueMapping = null;
        while (i > 0 && valueMapping == null) {
            valueMapping = this.getValueMapping(namePath.substring(0, i));
            if (valueMapping != null) continue;
            i = namePath.lastIndexOf("/", i - 1);
        }
        if (valueMapping != null) {
            namePath.replace(0, i, valueMapping.getTargetId());
        }
        return Arrays.asList(namePath.toString().split("/"));
    }

    private ICategoryHandle findOrCreateCategory(IProjectAreaHandle projectArea, List<String> namePath, IProgressMonitor monitor) throws TeamRepositoryException {
        ICategoryHandle category = this.findCategory(projectArea, namePath, monitor);
        if (category != null) {
            return category;
        }
        return this.createCategory(projectArea, namePath, monitor);
    }

    private ICategoryHandle findCategory(IProjectAreaHandle projectArea, List<String> namePath, IProgressMonitor monitor) throws TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        if (this.fCategories == null) {
            this.fCategories = new HashMap<String, ICategoryHandle>();
            List categories = ((WorkItemClient)workItemClient).findAllCategories(projectArea, ICategory.SMALL_PROFILE, monitor);
            for (ICategory category : categories) {
                this.cache(category);
            }
        }
        return this.fCategories.get(this.getPathAsString(namePath));
    }

    private ICategoryHandle createCategory(IProjectAreaHandle projectArea, List<String> namePath, IProgressMonitor monitor) throws TeamRepositoryException {
        ICategory category;
        ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        String name = namePath.get(namePath.size() - 1);
        if (namePath.size() > 1) {
            ICategoryHandle parent = this.findOrCreateCategory(projectArea, namePath.subList(0, namePath.size() - 1), monitor);
            category = workItemClient.createSubcategory(parent, name, monitor);
        } else {
            category = workItemClient.createCategory(projectArea, name, monitor);
        }
        workItemClient.saveCategory(category, monitor);
        this.cache(category);
        return (ICategoryHandle)category.getItemHandle();
    }

    private void cache(ICategory category) {
        List<String> path = Arrays.asList(CategoriesHelper.getNamePath((CategoryId)category.getCategoryId()));
        this.fCategories.put(this.getPathAsString(path), (ICategoryHandle)category.getItemHandle());
    }

    private String getPathAsString(List<String> path) {
        StringBuilder builder = new StringBuilder();
        for (String segment : path) {
            builder.append("/");
            builder.append(segment);
        }
        return builder.toString();
    }
}

