/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers;

import com.ibm.team.foundation.common.internal.util.XMLBuilder;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.model.AttributeDescriptor;
import com.ibm.team.workitem.common.model.AttributeIdentifiers;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.AttributeMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BooleanMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.CategoryMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.ContributorMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.DeliverableMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.DurationMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.EnumerationMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.IterationMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.NumberMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.TimestampMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.CommentData;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class BugzillaMapper {
    private BugzillaMapping fBugzillaMapping;
    private IProjectAreaHandle fProjectArea;
    private List<AttributeMapper> fAttributeMappers;
    private ContributorMapper fCommentAuthorMapper;

    public static BugzillaMapper createMapper(BugzillaMapping bugzillaMapping) {
        return new BugzillaMapper(bugzillaMapping);
    }

    private BugzillaMapper(BugzillaMapping bugzillaMapping) {
        this.fBugzillaMapping = bugzillaMapping;
    }

    public XMLString copy(IWorkItem workItem, ReportData data, LocalizationContext localization, IProgressMonitor monitor) throws TeamRepositoryException {
        IProjectAreaHandle projectArea = workItem.getProjectArea();
        if (this.fAttributeMappers == null || !projectArea.sameItemId((IItemHandle)this.fProjectArea)) {
            this.createMappers(projectArea, monitor);
        }
        XMLBuilder inaccurateMappings = new XMLBuilder();
        for (AttributeMapper attributeMapper : this.fAttributeMappers) {
            XMLString inaccuracy = attributeMapper.copy(workItem, data, localization, monitor);
            if (inaccuracy == null) continue;
            inaccurateMappings.xml("<br/>");
            inaccurateMappings.append(inaccuracy);
            inaccurateMappings.xml(" ");
        }
        return inaccurateMappings.getXMLString();
    }

    public void record(ReportData data, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fAttributeMappers == null) {
            this.createMappers(null, monitor);
        }
        for (AttributeMapper attributeMapper : this.fAttributeMappers) {
            attributeMapper.record(data, monitor);
        }
        for (CommentData comment : data.comments) {
            String value = comment.getString("0");
            if (value == null) {
                return;
            }
            this.fCommentAuthorMapper.getAttributeTypeMapping().recordValueMapping(value);
        }
    }

    public void write(Writer writer, IProgressMonitor monitor) throws TeamRepositoryException {
        this.fBugzillaMapping.write(writer, monitor);
    }

    private void createMappers(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        BugzillaMapping.AttributeMapping attributeMapping2;
        this.fAttributeMappers = new ArrayList<AttributeMapper>();
        for (BugzillaMapping.AttributeMapping attributeMapping2 : this.fBugzillaMapping.getAttributeMappings()) {
            BugzillaMapping.AttributeTypeMapping attributeTypeMapping;
            AttributeMapper mapper;
            String attributeType = "";
            if (projectArea != null) {
                IAttribute attribute = attributeMapping2.resolveTargetAttribute(projectArea, monitor);
                if (attribute != null) {
                    attributeType = attribute.getAttributeType();
                }
            } else {
                String targetId = attributeMapping2.getTargetId();
                String identifier = WorkItemAttributes.getAttributeId((Identifier)Identifier.create(IAttribute.class, (String)targetId));
                AttributeDescriptor[] attributeDescriptorArray = AttributeIdentifiers.ATTRIBUTE_DESCRIPTORS;
                int n = AttributeIdentifiers.ATTRIBUTE_DESCRIPTORS.length;
                int n2 = 0;
                while (n2 < n) {
                    AttributeDescriptor descriptor = attributeDescriptorArray[n2];
                    if (descriptor.getIdentifier().equals(identifier)) {
                        attributeType = descriptor.getAttributeType();
                        break;
                    }
                    ++n2;
                }
            }
            if ("subscriptions".equals(attributeType)) {
                attributeType = "contributor";
            }
            if ((mapper = BugzillaMapper.createMapper(attributeType, attributeMapping2, attributeTypeMapping = this.fBugzillaMapping.findAttributeTypeMapping(attributeType))) == null) continue;
            this.fAttributeMappers.add(mapper);
        }
        attributeMapping2 = new BugzillaMapping.AttributeMapping(this.fBugzillaMapping, "", "");
        BugzillaMapping.AttributeTypeMapping attributeTypeMapping = this.fBugzillaMapping.findAttributeTypeMapping("contributor");
        this.fCommentAuthorMapper = new ContributorMapper(attributeMapping2, attributeTypeMapping);
        this.fProjectArea = projectArea;
    }

    private static AttributeMapper createMapper(String attributeType, BugzillaMapping.AttributeMapping attributeMapping, BugzillaMapping.AttributeTypeMapping attributeTypeMapping) {
        if ("contributor".equals(attributeType)) {
            return new ContributorMapper(attributeMapping, attributeTypeMapping);
        }
        if ("category".equals(attributeType)) {
            return new CategoryMapper(attributeMapping, attributeTypeMapping);
        }
        if ("interval".equals(attributeType)) {
            return new IterationMapper(attributeMapping, attributeTypeMapping);
        }
        if ("deliverable".equals(attributeType)) {
            return new DeliverableMapper(attributeMapping, attributeTypeMapping);
        }
        if ("boolean".equals(attributeType)) {
            return new BooleanMapper(attributeMapping, attributeTypeMapping);
        }
        if ("duration".equals(attributeType)) {
            return new DurationMapper(attributeMapping, attributeTypeMapping);
        }
        if ("tags".equals(attributeType)) {
            return new EnumerationMapper(attributeMapping, attributeTypeMapping);
        }
        if ("type".equals(attributeType)) {
            return new EnumerationMapper(attributeMapping, attributeTypeMapping);
        }
        if ("integer".equals(attributeType)) {
            return new NumberMapper(attributeMapping, attributeTypeMapping);
        }
        if ("long".equals(attributeType)) {
            return new NumberMapper(attributeMapping, attributeTypeMapping);
        }
        if ("timestamp".equals(attributeType)) {
            return new TimestampMapper(attributeMapping, attributeTypeMapping);
        }
        if (AttributeTypes.STRING_TYPES.contains(attributeType)) {
            return new EnumerationMapper(attributeMapping, attributeTypeMapping);
        }
        if (AttributeTypes.HTML_TYPES.contains(attributeType)) {
            return new EnumerationMapper(attributeMapping, attributeTypeMapping);
        }
        if (AttributeTypes.isEnumerationAttributeType((String)attributeType)) {
            return new EnumerationMapper(attributeMapping, attributeTypeMapping);
        }
        return null;
    }

    public ContributorMapper getCommentAuthorMapper() {
        return this.fCommentAuthorMapper;
    }

    public static boolean isSupportedAttributeType(String attributeType) {
        return BugzillaMapper.createMapper(attributeType, null, null) != null;
    }
}

