/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.importer;

import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemWorkingCopyManager;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.importer.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependenciesResolver {
    public static final String IS_DUPLICATE_OF_IDENTIFIER = "com.ibm.team.workitem.rcp.core.is_dup_of";
    public static final String IS_DUPLICATE_OF_NAME = Messages.DependenciesResolver_ATTRIBUTE_DUPLICATE_OF;
    public static final String DUPLICATES_IDENTIFIER = "com.ibm.team.workitem.rcp.core.duplicates";
    public static final String DUPLICATES_NAME = Messages.DependenciesResolver_ATTRIBUTE_DUPLICATES;
    public static final String BLOCKED_IDENTIFIER = "com.ibm.team.workitem.rcp.core.blocks";
    public static final String BLOCKED_NAME = Messages.DependenciesResolver_ATTRIBUTE_BLOCKS;
    public static final String DEPENDSON_IDENTIFIER = "com.ibm.team.workitem.rcp.core.dependson";
    public static final String DEPENDSON_NAME = Messages.DependenciesResolver_ATTRIBUTE_DEPENDS_ON;
    private ITeamRepository fTeamRepository;
    private IWorkItemClient fWorkItemClient;
    private Map<String, IWorkItemHandle> fCache = new HashMap<String, IWorkItemHandle>();
    private IAttribute fDupsAtt = null;
    private IAttribute fDupOfAtt = null;
    private IAttribute fBlocksAtt = null;
    private IAttribute fDependsOnAtt = null;
    private IAttribute fIdAtt = null;

    public DependenciesResolver(ITeamRepository teamRepository) {
        this.fTeamRepository = teamRepository;
        if (this.fTeamRepository != null) {
            this.fWorkItemClient = (IWorkItemClient)this.fTeamRepository.getClientLibrary(IWorkItemClient.class);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void resolve(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException, BugzillaException {
        inverseItems = new ArrayList<WorkItemWorkingCopy>();
        try {
            inverseItems.addAll(this.resolveIsDupOf(workingCopy, monitor));
            inverseItems.addAll(this.resolveHasDuplicates(workingCopy, monitor));
            inverseItems.addAll(this.resolveBlocks(workingCopy, monitor));
            inverseItems.addAll(this.resolveDependsOn(workingCopy, monitor));
            toSave = new HashSet<WorkItemWorkingCopy>(inverseItems);
            toSave.add(workingCopy);
            status = this.fWorkItemClient.getWorkItemWorkingCopyManager().save(toSave.toArray(new WorkItemWorkingCopy[toSave.size()]), monitor);
            if (status.getSeverity() == 8 || status.getSeverity() == 4) {
                throw new TeamRepositoryException((Object)workingCopy.getTeamRepository(), status.getMessage(), status.getException());
            }
        }
        finally {
            var8_8 = inverseItems.iterator();
            if (true) ** GOTO lbl26
        }
        {
        }
        do {
            copy = (WorkItemWorkingCopy)var8_8.next();
            this.fWorkItemClient.getWorkItemWorkingCopyManager().disconnect((IWorkItemHandle)copy.getWorkItem().getItemHandle());
lbl26:
            // 2 sources

        } while (var8_8.hasNext());
    }

    public void putInCache(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        String id = this.getBugzillaId(workingCopy, monitor);
        IWorkItemHandle handle = (IWorkItemHandle)workingCopy.getWorkItem().getItemHandle();
        this.fCache.put(id, handle);
    }

    private IWorkItemHandle getFromCache(String lookupId) {
        return this.fCache.get(lookupId);
    }

    public boolean isInCache(String lookupId) {
        return this.fCache.containsKey(lookupId);
    }

    private List<WorkItemWorkingCopy> resolveHasDuplicates(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fDupsAtt == null) {
            this.fDupsAtt = this.fWorkItemClient.findAttribute(workingCopy.getWorkItem().getProjectArea(), DUPLICATES_IDENTIFIER, monitor);
        }
        if (this.fDupOfAtt == null) {
            this.fDupOfAtt = this.fWorkItemClient.findAttribute(workingCopy.getWorkItem().getProjectArea(), IS_DUPLICATE_OF_IDENTIFIER, monitor);
        }
        return this.resolveBidirectionalRelationship(workingCopy, WorkItemEndPoints.DUPLICATE_WORK_ITEM, this.fDupsAtt, this.fDupOfAtt, monitor);
    }

    private List<WorkItemWorkingCopy> resolveIsDupOf(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fDupsAtt == null) {
            this.fDupsAtt = this.fWorkItemClient.findAttribute(workingCopy.getWorkItem().getProjectArea(), DUPLICATES_IDENTIFIER, monitor);
        }
        if (this.fDupOfAtt == null) {
            this.fDupOfAtt = this.fWorkItemClient.findAttribute(workingCopy.getWorkItem().getProjectArea(), IS_DUPLICATE_OF_IDENTIFIER, monitor);
        }
        return this.resolveBidirectionalRelationship(workingCopy, WorkItemEndPoints.DUPLICATE_OF_WORK_ITEM, this.fDupOfAtt, this.fDupsAtt, monitor);
    }

    private List<WorkItemWorkingCopy> resolveDependsOn(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fBlocksAtt == null) {
            this.fBlocksAtt = this.fWorkItemClient.findAttribute(workingCopy.getWorkItem().getProjectArea(), BLOCKED_IDENTIFIER, monitor);
        }
        if (this.fDependsOnAtt == null) {
            this.fDependsOnAtt = this.fWorkItemClient.findAttribute(workingCopy.getWorkItem().getProjectArea(), DEPENDSON_IDENTIFIER, monitor);
        }
        return this.resolveBidirectionalRelationship(workingCopy, WorkItemEndPoints.DEPENDS_ON_WORK_ITEM, this.fDependsOnAtt, this.fBlocksAtt, monitor);
    }

    private List<WorkItemWorkingCopy> resolveBlocks(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fBlocksAtt == null) {
            this.fBlocksAtt = this.fWorkItemClient.findAttribute(workingCopy.getWorkItem().getProjectArea(), BLOCKED_IDENTIFIER, monitor);
        }
        if (this.fDependsOnAtt == null) {
            this.fDependsOnAtt = this.fWorkItemClient.findAttribute(workingCopy.getWorkItem().getProjectArea(), DEPENDSON_IDENTIFIER, monitor);
        }
        return this.resolveBidirectionalRelationship(workingCopy, WorkItemEndPoints.BLOCKS_WORK_ITEM, this.fBlocksAtt, this.fDependsOnAtt, monitor);
    }

    private List<WorkItemWorkingCopy> resolveBidirectionalRelationship(WorkItemWorkingCopy workingCopy, IEndPointDescriptor endPoint, IAttribute resolvedAtt, IAttribute inverseAtt, IProgressMonitor monitor) throws TeamRepositoryException {
        if (resolvedAtt == null) {
            return Collections.emptyList();
        }
        String idsToResolve = DependenciesResolver.getAttributeValue(workingCopy, resolvedAtt);
        if (idsToResolve == null) {
            return Collections.emptyList();
        }
        if (inverseAtt == null) {
            return Collections.emptyList();
        }
        String[] ids = idsToResolve.split(" ");
        ArrayList<String> newlyLinkedIds = new ArrayList<String>();
        ArrayList<WorkItemWorkingCopy> inverseItems = new ArrayList<WorkItemWorkingCopy>();
        int i = 0;
        while (i < ids.length) {
            IWorkItemHandle handle = this.getFromCache(ids[i]);
            if (handle != null) {
                IWorkItemWorkingCopyManager workingCopyManager = this.fWorkItemClient.getWorkItemWorkingCopyManager();
                ItemProfile profile = ItemProfile.createFullProfile((IItemType)IWorkItem.ITEM_TYPE);
                workingCopyManager.connect(handle, profile, monitor);
                WorkItemWorkingCopy inverseItem = workingCopyManager.getWorkingCopy(handle);
                ArrayList<String> removedId = new ArrayList<String>();
                removedId.add(this.getBugzillaId(workingCopy, monitor));
                boolean changed = DependenciesResolver.removeForwardReference(inverseItem, removedId, inverseAtt);
                if (changed || endPoint != WorkItemEndPoints.DUPLICATE_WORK_ITEM) {
                    workingCopy.getReferences().add(endPoint, (IReference)WorkItemLinkTypes.createWorkItemReference((IWorkItem)inverseItem.getWorkItem()));
                }
                inverseItems.add(inverseItem);
                newlyLinkedIds.add(ids[i]);
            }
            ++i;
        }
        DependenciesResolver.removeForwardReference(workingCopy, newlyLinkedIds, resolvedAtt);
        return inverseItems;
    }

    private static boolean removeForwardReference(WorkItemWorkingCopy workingCopy, List<String> removedIds, IAttribute att) throws TeamRepositoryException {
        if (removedIds.isEmpty() || att == null || !workingCopy.getWorkItem().hasAttribute(att)) {
            return false;
        }
        String value = DependenciesResolver.getAttributeValue(workingCopy, att);
        ArrayList list = new ArrayList(Arrays.asList(value != null ? value.split(" ") : new String[]{}));
        if (!list.removeAll(removedIds)) {
            return false;
        }
        StringBuilder builder = new StringBuilder();
        for (String element : list) {
            builder.append(String.valueOf(element) + " ");
        }
        String updated = builder.toString().trim();
        if (updated.length() == 0) {
            workingCopy.getWorkItem().removeCustomAttribute(att);
        } else {
            workingCopy.getWorkItem().setValue(att, (Object)updated);
        }
        return true;
    }

    public static String getAttributeValue(WorkItemWorkingCopy workingCopy, IAttribute attribute) throws TeamRepositoryException {
        if (attribute == null || !workingCopy.getWorkItem().hasAttribute(attribute)) {
            return null;
        }
        String att = (String)workingCopy.getWorkItem().getValue(attribute);
        if (!"".equals(att)) {
            return att;
        }
        return null;
    }

    private String getBugzillaId(WorkItemWorkingCopy workingCopy, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fIdAtt == null) {
            this.fIdAtt = this.fWorkItemClient.findAttribute(workingCopy.getWorkItem().getProjectArea(), "com.ibm.team.workitem.rcp.core.url", monitor);
        }
        return DependenciesResolver.getAttributeValue(workingCopy, this.fIdAtt);
    }
}

