/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.importer;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.text.StyledDocument;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.model.Comment;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import com.ibm.team.workitem.common.internal.util.Utils;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IComments;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.rcp.core.internal.ContentTypeUtils;
import com.ibm.team.workitem.rcp.core.internal.WorkItemRCPCorePlugin;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaConfiguration;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.IBugRetrievalStrategy;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.importer.BugzillaBugNumbersResolver;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.importer.DependenciesResolver;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.importer.Messages;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.BugzillaMapping;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.mappers.ContributorMapper;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentData;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.AttachmentDescription;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.CommentData;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.xml.ReportData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.jface.text.BadLocationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataCopier {
    private static final long[] DURATIONS = new long[]{14400000L, 28800000L, 57600000L, 86400000L, 0x6DDD000L, 144000000L, 288000000L};
    public static final String URLID_IDENTIFIER = "com.ibm.team.workitem.rcp.core.url";
    public static final String URLID_NAME = Messages.DataCopier_ATTRIBUTE_IMPORTED_FROM;
    public static final String BUGZILLA_SHOW_BUG_CGI_ID = "/show_bug.cgi?id=";
    public static final String BUGZILLA_DELTATIMESTAMP_IDENTIFIER = "com.ibm.team.workitem.rcp.core.deltatimestamp";
    public static final String BUGZILLA_DELTATIMESTAMP_NAME = Messages.DataCopier_ATTRIBUTE_LAST_CHANGE;
    public static final String ORIGIN_IDENTIFIER = "com.ibm.team.workitem.rcp.core.origin";
    public static final String ORIGIN_NAME = Messages.DataCopier_ATTRIBUTE_ORIGIN;
    private static final String BUGZILLA_DUPLICATE_RESOLUTION = "DUPLICATE";
    private static final String ENHANCEMENT = "enhancement";
    private BugzillaBugNumbersResolver fBugNumbersResolver = null;
    private BugzillaConfiguration fConfiguration;
    private BugzillaMapper fMapper = null;
    private Random fRandomNumbers = new Random();
    private IWorkItemType fEnhancementType;

    public DataCopier(BugzillaConfiguration configuration) {
        this.fConfiguration = configuration;
    }

    public void copyData(WorkItemWorkingCopy item, IBugRetrievalStrategy strategy, ReportData data, String serverUrl, boolean checkIfAlreadyImported, boolean isTestRun, Set<String> unresolvedIds, IProgressMonitor monitor) throws TeamRepositoryException, BugzillaException {
        ITeamRepository teamRepository = this.fConfiguration.getTeamRepository();
        IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
        if (this.fBugNumbersResolver == null) {
            this.fBugNumbersResolver = new BugzillaBugNumbersResolver(teamRepository, serverUrl);
        }
        if (isTestRun) {
            this.fBugNumbersResolver.setServerUrl(serverUrl);
        }
        IWorkItem workItem = item.getWorkItem();
        if (ENHANCEMENT.equals(data.getString("bug_severity"))) {
            workItemClient.changeWorkItemType(workItem, this.findEnhancementType(monitor), monitor);
        }
        if (this.fMapper == null) {
            BugzillaMapping mapping = this.fConfiguration.getMapping();
            if (mapping == null) {
                mapping = BugzillaMapping.readDefaultMapping();
            }
            this.fMapper = BugzillaMapper.createMapper(mapping);
        }
        LocalizationContext localization = LocalizationContext.createProjectAreaContext((IAuditableCommon)auditableClient, (IProjectAreaHandle)workItem.getProjectArea(), (IProgressMonitor)monitor);
        XMLString inaccurateMappings = this.fMapper.copy(workItem, data, localization, monitor);
        String string = data.getString("short_desc");
        if (string == null) {
            string = "";
        }
        String summary = this.fBugNumbersResolver.rewriteBugzillaIds(unresolvedIds, item.getWorkItem(), string);
        workItem.setHTMLSummary(XMLString.createFromPlainText((String)summary));
        Date creationDate = data.getDate("creation_ts");
        item.getWorkItem().setCreationDate(creationDate != null ? new Timestamp(creationDate.getTime()) : null);
        this.copyServerURLandId(item, String.valueOf(serverUrl) + data.getString("bug_id"), monitor);
        this.copyDeltaTimeStamp(item, data.getString("delta_ts"), monitor);
        this.copyTags(item, data.keywords, string);
        this.copyComments(item, data.comments, unresolvedIds, monitor);
        IComment[] contents = workItem.getComments().getContents();
        if (contents.length > 0) {
            workItem.setHTMLDescription(contents[0].getHTMLContent());
        }
        this.addImportComment(item, data, serverUrl, inaccurateMappings, localization);
        this.setOrigin(item, NLS.bind((String)Messages.DataCopier_BUGZILLA_ID, (Object[])new Object[]{data.getString("bug_id")}), monitor);
        if (this.fConfiguration.isAssignRandomDuration()) {
            item.getWorkItem().setDuration(this.getRandomDuration().longValue());
        }
        this.copyBlocked(item, data.blocks, serverUrl, monitor);
        this.copyDependsOn(item, data.dependsOn, serverUrl, monitor);
        this.copyDuplicatesOfBug(item, monitor);
        if (BUGZILLA_DUPLICATE_RESOLUTION.equals(data.getString("resolution"))) {
            this.copyIsDupOf(item, monitor);
        }
        this.copyAttachments(strategy, data.getString("bug_id"), item, data.attachments);
    }

    private IWorkItemType findEnhancementType(IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fEnhancementType == null) {
            IWorkItemClient workItemClient = (IWorkItemClient)this.fConfiguration.getTeamRepository().getClientLibrary(IWorkItemClient.class);
            this.fEnhancementType = workItemClient.findWorkItemType(this.fConfiguration.getProjectArea(), ENHANCEMENT, monitor);
            if (this.fEnhancementType == null) {
                this.fEnhancementType = workItemClient.findWorkItemType(this.fConfiguration.getProjectArea(), "task", monitor);
            }
        }
        return this.fEnhancementType;
    }

    private Duration getRandomDuration() {
        int next = this.fRandomNumbers.nextInt(DURATIONS.length + DURATIONS.length / 2);
        if (next >= 0 && next < DURATIONS.length) {
            return new Duration(DURATIONS[next]);
        }
        return Duration.UNSPECIFIED;
    }

    private void copyComments(WorkItemWorkingCopy item, List<CommentData> commentsList, Set<String> unresolvedIds, IProgressMonitor monitor) throws TeamRepositoryException, BugzillaException {
        for (CommentData bugzillaComment : commentsList) {
            String text = this.fBugNumbersResolver.rewriteBugzillaIds(unresolvedIds, item.getWorkItem(), bugzillaComment.getString("2"));
            StyledDocument document = new StyledDocument(XMLString.createFromPlainText((String)text));
            if (document.getLength() != 0) {
                this.createComments(item, bugzillaComment, document, monitor);
                continue;
            }
            IComments comments = item.getWorkItem().getComments();
            comments.append(this.createComment(item.getWorkItem(), bugzillaComment, document.getHTML(), monitor));
        }
    }

    private void createComments(WorkItemWorkingCopy item, CommentData data, StyledDocument content, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            double factor = 0.95;
            int limit = 32768;
            int offset = 0;
            while (offset < content.getLength()) {
                int lineOffset;
                int length = Math.min((int)(factor * (double)limit), content.getLength() - offset);
                if (offset + length < content.getLength() && (lineOffset = content.getLineOffset(content.getLineOfOffset(offset + length))) > offset) {
                    length = lineOffset - offset;
                }
                XMLString html = content.getHTML(offset, length);
                while (html.getXMLText().length() > limit) {
                    int lineOffset2 = content.getLineOffset(content.getLineOfOffset(offset + (length = (int)(factor * (double)length * (double)limit / (double)html.getXMLText().length()))));
                    if (lineOffset2 > offset) {
                        length = lineOffset2 - offset;
                    }
                    html = content.getHTML(offset, length);
                }
                IComments comments = item.getWorkItem().getComments();
                comments.append(this.createComment(item.getWorkItem(), data, html, monitor));
                offset += length;
            }
        }
        catch (BadLocationException x) {
            throw new RuntimeException(x);
        }
    }

    private IComment createComment(IWorkItem workItem, CommentData data, XMLString content, IProgressMonitor monitor) throws TeamRepositoryException {
        ContributorMapper commentAuthorMapper = this.fMapper.getCommentAuthorMapper();
        String author = data.getString("0");
        IContributorHandle creator = commentAuthorMapper.findContributor(this.fConfiguration.getTeamRepository(), author, monitor);
        if (creator == null) {
            creator = this.fConfiguration.getTeamRepository().loggedInContributor();
        }
        IComment comment = workItem.getComments().createComment(creator, content);
        Timestamp creationDate = new Timestamp(data.getDate("1").getTime());
        ((Comment)comment).setCreationDate(creationDate);
        return comment;
    }

    private void copyIsDupOf(WorkItemWorkingCopy item, IProgressMonitor monitor) throws TeamRepositoryException {
        String isDup = this.fBugNumbersResolver.getDuplicateBugId(item.getWorkItem().getComments().getContents());
        if (isDup == null) {
            return;
        }
        IAttribute attribute = this.ensureAttributeExists(item.getWorkItem().getProjectArea(), "com.ibm.team.workitem.rcp.core.is_dup_of", "mediumString", DependenciesResolver.IS_DUPLICATE_OF_NAME, monitor);
        item.getWorkItem().addCustomAttribute(attribute);
        item.getWorkItem().setValue(attribute, (Object)isDup);
    }

    private void copyDuplicatesOfBug(WorkItemWorkingCopy item, IProgressMonitor monitor) throws TeamRepositoryException {
        String duplicates = this.fBugNumbersResolver.getDuplicatesOfBug(item.getWorkItem().getComments().getContents());
        if (duplicates == null) {
            return;
        }
        IAttribute attribute = this.ensureAttributeExists(item.getWorkItem().getProjectArea(), "com.ibm.team.workitem.rcp.core.duplicates", "string", DependenciesResolver.DUPLICATES_NAME, monitor);
        item.getWorkItem().addCustomAttribute(attribute);
        item.getWorkItem().setValue(attribute, (Object)duplicates);
    }

    private void copyDeltaTimeStamp(WorkItemWorkingCopy item, String deltatime, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttribute attribute = this.ensureAttributeExists(item.getWorkItem().getProjectArea(), BUGZILLA_DELTATIMESTAMP_IDENTIFIER, "smallString", BUGZILLA_DELTATIMESTAMP_NAME, monitor);
        item.getWorkItem().addCustomAttribute(attribute);
        item.getWorkItem().setValue(attribute, (Object)deltatime);
    }

    private void copyTags(WorkItemWorkingCopy item, List<String> tagsList, String summary) throws TeamRepositoryException {
        Iterator<String> iter = tagsList.iterator();
        String tags = "";
        while (iter.hasNext()) {
            String newTag = iter.next();
            tags = String.valueOf(tags) + newTag.replaceAll(",", "");
            if (!iter.hasNext()) continue;
            tags = String.valueOf(tags) + " ";
        }
        int beginPos = summary.indexOf("[");
        int endPos = summary.indexOf("]");
        if (beginPos != -1 && endPos != -1) {
            String tag = summary.substring(summary.indexOf("[") + 1, summary.indexOf("]"));
            if (tags.indexOf(tag = tag.replaceAll(" ", "_")) == -1) {
                if (tags.length() > 0) {
                    tags = String.valueOf(tags) + " ";
                }
                tags = String.valueOf(tags) + tag.trim();
            }
        }
        item.getWorkItem().setTags(tags);
    }

    private String createSpaceSeparatedString(Iterator<String> iter, String fServerUrl) throws BugzillaException {
        String list = "";
        while (iter.hasNext()) {
            String id = iter.next().trim();
            if ("".equals(id)) continue;
            list = String.valueOf(list) + fServerUrl + id;
            if (!iter.hasNext()) continue;
            list = String.valueOf(list) + " ";
        }
        return list;
    }

    private void copyDependsOn(WorkItemWorkingCopy item, List<String> depend, String fServerUrl, IProgressMonitor monitor) throws TeamRepositoryException, BugzillaException {
        String dependsOn = this.createSpaceSeparatedString(depend.iterator(), fServerUrl);
        if ("".equals(dependsOn)) {
            return;
        }
        IAttribute attribute = this.ensureAttributeExists(item.getWorkItem().getProjectArea(), "com.ibm.team.workitem.rcp.core.dependson", "string", DependenciesResolver.DEPENDSON_NAME, monitor);
        item.getWorkItem().addCustomAttribute(attribute);
        item.getWorkItem().setValue(attribute, (Object)dependsOn);
    }

    private void copyBlocked(WorkItemWorkingCopy item, List<String> blocked, String fServerUrl, IProgressMonitor monitor) throws TeamRepositoryException, BugzillaException {
        String blocks = this.createSpaceSeparatedString(blocked.iterator(), fServerUrl);
        if ("".equals(blocks)) {
            return;
        }
        IAttribute attribute = this.ensureAttributeExists(item.getWorkItem().getProjectArea(), "com.ibm.team.workitem.rcp.core.blocks", "string", DependenciesResolver.BLOCKED_NAME, monitor);
        item.getWorkItem().addCustomAttribute(attribute);
        item.getWorkItem().setValue(attribute, (Object)blocks);
    }

    private void copyServerURLandId(WorkItemWorkingCopy item, String value, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttribute attribute = this.ensureAttributeExists(item.getWorkItem().getProjectArea(), URLID_IDENTIFIER, "mediumString", URLID_NAME, monitor);
        item.getWorkItem().addCustomAttribute(attribute);
        item.getWorkItem().setValue(attribute, (Object)value);
    }

    private void addImportComment(WorkItemWorkingCopy item, ReportData data, String fServerUrl, XMLString inaccurateMappings, LocalizationContext localization) throws TeamRepositoryException {
        IWorkItem workItem = item.getWorkItem();
        IComments comments = workItem.getComments();
        String bugzillaId = data.getString("bug_id");
        String id = "<a href=\"" + XMLString.createFromPlainText((String)(String.valueOf(fServerUrl) + bugzillaId)).getXMLText() + "\">" + bugzillaId + "</a>";
        String importComment = String.valueOf(NLS.bind((String)XMLString.createFromPlainText((String)Messages.getString(localization, "DataCopier_IMPORT_COMMENT")).getXMLText(), (Object[])new Object[]{id})) + inaccurateMappings.getXMLText();
        IContributor creator = this.fConfiguration.getTeamRepository().loggedInContributor();
        IComment comment = workItem.getComments().createComment((IContributorHandle)creator.getItemHandle(), Utils.createSynthetic((XMLString)XMLString.createFromXMLText((String)importComment.trim())));
        comments.append(comment);
    }

    private void setOrigin(WorkItemWorkingCopy item, String origin, IProgressMonitor monitor) throws TeamRepositoryException {
        IAttribute attribute = this.ensureAttributeExists(item.getWorkItem().getProjectArea(), ORIGIN_IDENTIFIER, "smallString", ORIGIN_NAME, monitor);
        item.getWorkItem().addCustomAttribute(attribute);
        item.getWorkItem().setValue(attribute, (Object)origin);
    }

    private void copyAttachments(IBugRetrievalStrategy strategy, String id, WorkItemWorkingCopy item, List<AttachmentDescription> descriptions) throws TeamRepositoryException, BugzillaException {
        AttachmentData[] attachments = strategy.getAttachments(Integer.valueOf(id), descriptions);
        if (attachments == null || attachments.length == 0) {
            return;
        }
        AttachmentDescription[] attachmentsDescriptions = descriptions.toArray(new AttachmentDescription[descriptions.size()]);
        if (attachmentsDescriptions.length != attachments.length) {
            throw new BugzillaException(4, "Error retrieving attachment metadata.");
        }
        int i = 0;
        while (i < attachments.length) {
            String fileName = attachments[i].getString("0");
            String descrString = attachmentsDescriptions[i].getString("2");
            IWorkItemClient workItemClient = (IWorkItemClient)this.fConfiguration.getTeamRepository().getClientLibrary(IWorkItemClient.class);
            String mimeType = attachments[i].getString("1");
            String charset = attachments[i].getString("2");
            IContentDescription contentDescription = null;
            if (mimeType == null || mimeType.length() == 0 || charset == null || charset.length() == 0) {
                try {
                    contentDescription = Platform.getContentTypeManager().getDescriptionFor((InputStream)new ByteArrayInputStream(attachments[i].data), fileName, IContentDescription.ALL);
                }
                catch (IOException x) {
                    WorkItemRCPCorePlugin.getDefault().log(x);
                }
            }
            if (mimeType == null || mimeType.length() == 0) {
                mimeType = ContentTypeUtils.getMIMEType(fileName, contentDescription);
            }
            if (charset == null || charset.length() == 0) {
                charset = ContentTypeUtils.getCharSet(contentDescription, mimeType);
            }
            IAttachment attachment = workItemClient.createAttachment(this.fConfiguration.getProjectArea(), fileName, descrString, mimeType, charset, (InputStream)new ByteArrayInputStream(attachments[i].data), null);
            IWorkItemReferences references = item.getReferences();
            references.add(WorkItemEndPoints.ATTACHMENT, (IReference)WorkItemLinkTypes.createAttachmentReference((IAttachment)attachment));
            ++i;
        }
    }

    private IAttribute ensureAttributeExists(IProjectAreaHandle projectArea, String id, String type, String name, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemClient workItemClient = (IWorkItemClient)this.fConfiguration.getTeamRepository().getClientLibrary(IWorkItemClient.class);
        IAttribute attribute = workItemClient.findAttribute(projectArea, id, monitor);
        if (attribute == null) {
            attribute = workItemClient.createAttribute(projectArea, id, type, name, monitor);
        }
        return attribute;
    }

    public void addToCache(WorkItemWorkingCopy workingCopy, Set<String> unresolvedIds) throws TeamRepositoryException {
        this.fBugNumbersResolver.addToCache(workingCopy, unresolvedIds);
    }

    public void recordMapping(IBugRetrievalStrategy strategy, ReportData data, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fMapper == null) {
            BugzillaMapping mapping = BugzillaMapping.createMappingForRecording();
            this.fMapper = BugzillaMapper.createMapper(mapping);
        }
        this.fMapper.record(data, monitor);
    }

    public void writeMapping(Writer writer, IProgressMonitor monitor) throws TeamRepositoryException {
        if (this.fMapper == null) {
            BugzillaMapping mapping = BugzillaMapping.createMappingForRecording();
            this.fMapper = BugzillaMapper.createMapper(mapping);
        }
        this.fMapper.write(writer, monitor);
    }
}

