/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.bugzilla.http;

import com.ibm.team.workitem.rcp.core.internal.WorkItemRCPCorePlugin;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaConfiguration;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.BugzillaException;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.Messages;
import com.ibm.team.workitem.rcp.core.internal.bugzilla.http.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class CookieLoginOperation {
    private static final String DATA_ENCODING = "UTF-8";
    private BugzillaConfiguration fConfiguration;

    public CookieLoginOperation(BugzillaConfiguration conf) {
        this.fConfiguration = conf;
    }

    public void getCookie() throws BugzillaException {
        if (this.fConfiguration.getUsername() == null) {
            throw new BugzillaException(1, com.ibm.team.workitem.rcp.core.internal.bugzilla.http.Messages.CookieLoginOperation_LOGIN_FAILED);
        }
        OutputStreamWriter out = null;
        try {
            String data = this.getLoginData(this.fConfiguration.getUsername(), this.fConfiguration.getPassword());
            URL url = this.getLoginUrl(this.fConfiguration);
            URLConnection connection = this.open(url);
            out = this.sendData(connection, data);
            String loginCookie = this.getLoginCookie(connection);
            this.dumpPage(connection);
            if (loginCookie == null) {
                throw new BugzillaException(1, com.ibm.team.workitem.rcp.core.internal.bugzilla.http.Messages.CookieLoginOperation_LOGIN_FAILED);
            }
            this.fConfiguration.setLoginCookie(loginCookie);
        }
        catch (Throwable throwable) {
            this.close(out);
            throw throwable;
        }
        this.close(out);
    }

    private URLConnection open(URL url) throws BugzillaException {
        try {
            return url.openConnection();
        }
        catch (IOException e) {
            throw new BugzillaException(101, Messages.Messages_EXCEPTION_CONTACTING_BUGZILLA, e);
        }
    }

    private void dumpPage(URLConnection connection) {
        block15: {
            BufferedReader in = null;
            try {
                try {
                    in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    while (in.readLine() != null) {
                    }
                }
                catch (IOException e) {
                    WorkItemRCPCorePlugin.getDefault().log((Throwable)((Object)new BugzillaException("IO error while reading " + e.getMessage(), e)));
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private OutputStreamWriter sendData(URLConnection connection, String data) throws BugzillaException {
        OutputStreamWriter out = null;
        try {
            connection.setDoOutput(true);
            out = new OutputStreamWriter(connection.getOutputStream());
            out.write(data);
            out.flush();
            return out;
        }
        catch (IOException e) {
            this.close(out);
            throw new BugzillaException(Messages.Messages_EXCEPTION_CONTACTING_BUGZILLA, e);
        }
    }

    private void close(OutputStreamWriter out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException iOException) {}
    }

    private URL getLoginUrl(BugzillaConfiguration config) throws BugzillaException {
        String urlString = Util.appendPath(config.getBaseURL(), "query.cgi");
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new BugzillaException(e.getLocalizedMessage(), e);
        }
    }

    private String getLoginData(String email, String password) throws BugzillaException {
        try {
            StringBuffer data = new StringBuffer();
            data.append(URLEncoder.encode("Bugzilla_login", DATA_ENCODING));
            data.append("=");
            data.append(URLEncoder.encode(email, DATA_ENCODING));
            data.append("&");
            data.append(URLEncoder.encode("Bugzilla_password", DATA_ENCODING));
            data.append("=");
            data.append(URLEncoder.encode(password, DATA_ENCODING));
            data.append("&");
            data.append(URLEncoder.encode("GoAheadAndLogIn", DATA_ENCODING));
            data.append("=");
            data.append(URLEncoder.encode("1", DATA_ENCODING));
            return data.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new BugzillaException("Unsupported encoding: UTF-8", e);
        }
    }

    private String getLoginCookie(URLConnection connection) {
        String login = null;
        String password = null;
        int i = 0;
        while (true) {
            String name = connection.getHeaderFieldKey(i);
            String value = connection.getHeaderField(i);
            if (name == null && value == null) break;
            if ("Set-Cookie".equalsIgnoreCase(name)) {
                int index = value.indexOf(";");
                String cookie = value.substring(0, index).trim();
                if (cookie.startsWith("Bugzilla_logincookie")) {
                    password = cookie;
                } else if (cookie.startsWith("Bugzilla_login")) {
                    login = cookie;
                }
            }
            ++i;
        }
        if (login != null && password != null) {
            return String.valueOf(login) + "; " + password;
        }
        return null;
    }
}

