/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal.activation;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.core.activation.IWorkItemActivationManager;
import com.ibm.team.workitem.rcp.core.activation.WorkItemActivationEvent;
import com.ibm.team.workitem.rcp.core.activation.WorkItemActivationParticipant;
import com.ibm.team.workitem.rcp.core.internal.WorkItemRCPCorePlugin;
import com.ibm.team.workitem.rcp.core.internal.activation.Messages;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public final class WorkItemActivationManager
implements IWorkItemActivationManager {
    private static WorkItemActivationManager fgInstance = null;
    private static final int HISTORY_CAPACITY = 32;
    private static final String PREFERENCE_ACTIVE = "com.ibm.team.workitem.active.workitem";
    private static final String PREFERENCE_HISTORY = "com.ibm.team.workitem.activation.history";
    private final LinkedList<IWorkItemHandle> fActivationHistory = new LinkedList();
    private IWorkItemHandle fActiveWorkItem = null;
    private final Object fActiveWorkItemLock = new Object();
    private boolean fActiveWorkLoaded = false;
    private WorkItemActivationEvent fCurrentEvent = null;
    private final Object fCurrentEventLock = new Object();
    private boolean fHistoryLoaded = false;
    private final ListenerList fParticipants = new ListenerList(1);

    public static synchronized WorkItemActivationManager getInstance() {
        if (fgInstance == null) {
            fgInstance = new WorkItemActivationManager();
        }
        return fgInstance;
    }

    private WorkItemActivationManager() {
    }

    public IStatus activateWorkItem(IWorkItemHandle handle, IProgressMonitor monitor) {
        return this.activateWorkItem(null, handle, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus activateWorkItem(WorkItemActivationParticipant participant, IWorkItemHandle handle, IProgressMonitor monitor) {
        Assert.isNotNull((Object)handle);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IWorkItemHandle active;
            monitor.beginTask(Messages.WorkItemActivationManager_START_WORKING, 100);
            this.loadActivationHistory();
            this.loadActiveWorkItem();
            Object object = this.fActiveWorkItemLock;
            synchronized (object) {
                block22: {
                    if (!handle.sameItemId((IItemHandle)this.fActiveWorkItem)) break block22;
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                active = this.fActiveWorkItem;
            }
            IStatus status = null;
            if (active != null) {
                status = this.fireWorkItemDeactivate(null, active, false, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                if (monitor.isCanceled() || status.matches(8) || status.matches(4)) {
                    IStatus iStatus = status;
                    return iStatus;
                }
            }
            status = this.fireWorkItemActivate(participant, handle, true, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            if (!(monitor.isCanceled() || status.matches(8) || status.matches(4))) {
                LinkedList<IWorkItemHandle> linkedList = this.fActiveWorkItemLock;
                synchronized (linkedList) {
                    this.fActiveWorkItem = handle;
                }
                linkedList = this.fActivationHistory;
                synchronized (linkedList) {
                    this.removeFromHistory(handle);
                    this.fActivationHistory.addFirst(handle);
                    int delta = this.fActivationHistory.size() - 32;
                    int index = 0;
                    while (index < delta) {
                        this.fActivationHistory.removeLast();
                        ++index;
                    }
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            if (active != null) {
                FoundationJob job = new FoundationJob(Messages.WorkItemActivationManager_RESTORING_CURRENT_WORK){

                    protected IStatus runProtected(IProgressMonitor progress) {
                        return WorkItemActivationManager.this.fireWorkItemActivate(null, active, false, progress);
                    }
                };
                job.setSystem(false);
                job.setPriority(30);
                job.schedule();
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public void addActivationParticipant(WorkItemActivationParticipant participant) {
        Assert.isNotNull((Object)participant);
        this.fParticipants.add((Object)participant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToHistory(IWorkItemHandle handle) {
        Assert.isNotNull((Object)handle);
        LinkedList<IWorkItemHandle> linkedList = this.fActivationHistory;
        synchronized (linkedList) {
            IWorkItemHandle result = null;
            for (IWorkItemHandle entry : this.fActivationHistory) {
                if (!entry.sameItemId((IItemHandle)handle)) continue;
                result = entry;
                break;
            }
            if (result == null) {
                this.fActivationHistory.add(handle);
            }
        }
    }

    public IStatus deactivateWorkItem(IWorkItemHandle handle, IProgressMonitor monitor) {
        return this.deactivateWorkItem(null, handle, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IStatus deactivateWorkItem(WorkItemActivationParticipant participant, IWorkItemHandle handle, IProgressMonitor monitor) {
        Assert.isNotNull((Object)handle);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.loadActivationHistory();
        this.loadActiveWorkItem();
        Object object = this.fActiveWorkItemLock;
        synchronized (object) {
            if (!handle.sameItemId((IItemHandle)this.fActiveWorkItem)) {
                return Status.OK_STATUS;
            }
        }
        IStatus status = this.fireWorkItemDeactivate(participant, handle, true, monitor);
        if (status.isOK()) {
            Object object2 = this.fActiveWorkItemLock;
            synchronized (object2) {
                this.fActiveWorkItem = null;
            }
            return Status.OK_STATUS;
        }
        return status;
    }

    /*
     * Exception decompiling
     */
    private IStatus fireWorkItemActivate(WorkItemActivationParticipant caller, IWorkItemHandle handle, boolean explicit, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[WHILELOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private IStatus fireWorkItemDeactivate(WorkItemActivationParticipant caller, IWorkItemHandle handle, boolean explicit, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[WHILELOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorkItemHandle[] getActivationHistory() {
        LinkedList<IWorkItemHandle> linkedList = this.fActivationHistory;
        synchronized (linkedList) {
            this.loadActivationHistory();
            return this.fActivationHistory.toArray(new IWorkItemHandle[this.fActivationHistory.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorkItemHandle getActiveWorkItem() {
        Object object = this.fActiveWorkItemLock;
        synchronized (object) {
            this.loadActiveWorkItem();
            return this.fActiveWorkItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkItemActivationEvent getCurrentEvent() {
        Object object = this.fCurrentEventLock;
        synchronized (object) {
            return this.fCurrentEvent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadActivationHistory() {
        LinkedList<IWorkItemHandle> linkedList = this.fActivationHistory;
        synchronized (linkedList) {
            if (!this.fHistoryLoaded) {
                try {
                    String value = WorkItemRCPCorePlugin.getDefault().getPluginPreferences().getString(PREFERENCE_HISTORY);
                    if (value != null && !"".equals(value)) {
                        StringTokenizer tokenizer = new StringTokenizer(value, String.valueOf('!'), false);
                        while (tokenizer.hasMoreTokens()) {
                            IAuditableHandle handle;
                            IAuditableClient client;
                            ITeamRepository repository;
                            String uuid;
                            String repositoryURI = tokenizer.nextToken();
                            if ("".equals(repositoryURI) || !tokenizer.hasMoreTokens() || "".equals(uuid = tokenizer.nextToken()) || (repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURI, 4)) == null || !repository.loggedIn() || (client = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class)) == null || !((handle = client.createAuditableHandle(IWorkItem.ITEM_TYPE, UUID.valueOf((String)uuid), null)) instanceof IWorkItemHandle)) continue;
                            IWorkItemHandle extended = (IWorkItemHandle)handle;
                            this.addToHistory(extended);
                        }
                    }
                }
                finally {
                    this.fHistoryLoaded = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadActiveWorkItem() {
        Object object = this.fActiveWorkItemLock;
        synchronized (object) {
            if (!this.fActiveWorkLoaded) {
                try {
                    IAuditableHandle handle;
                    IAuditableClient client;
                    ITeamRepository repository;
                    String uuid;
                    String repositoryURI;
                    StringTokenizer tokenizer;
                    String value = WorkItemRCPCorePlugin.getDefault().getPluginPreferences().getString(PREFERENCE_ACTIVE);
                    if (value != null && !"".equals(value) && (tokenizer = new StringTokenizer(value, String.valueOf('!'), false)).hasMoreTokens() && !"".equals(repositoryURI = tokenizer.nextToken()) && tokenizer.hasMoreTokens() && !"".equals(uuid = tokenizer.nextToken()) && (repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryURI, 4)) != null && repository.loggedIn() && (client = (IAuditableClient)repository.getClientLibrary(IAuditableClient.class)) != null && (handle = client.createAuditableHandle(IWorkItem.ITEM_TYPE, UUID.valueOf((String)uuid), null)) instanceof IWorkItemHandle) {
                        this.fActiveWorkItem = (IWorkItemHandle)handle;
                    }
                }
                finally {
                    this.fActiveWorkLoaded = true;
                }
            }
        }
    }

    public void removeActivationParticipant(WorkItemActivationParticipant participant) {
        Assert.isNotNull((Object)participant);
        this.fParticipants.remove((Object)participant);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromHistory(IWorkItemHandle handle) {
        Assert.isNotNull((Object)handle);
        LinkedList<IWorkItemHandle> linkedList = this.fActivationHistory;
        synchronized (linkedList) {
            IWorkItemHandle result = null;
            for (IWorkItemHandle entry : this.fActivationHistory) {
                if (!entry.sameItemId((IItemHandle)handle)) continue;
                result = entry;
                break;
            }
            if (result != null) {
                this.fActivationHistory.remove(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetActivationHistory() {
        LinkedList<IWorkItemHandle> linkedList = this.fActivationHistory;
        synchronized (linkedList) {
            this.fHistoryLoaded = true;
            this.fActivationHistory.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveActivationHistory() {
        LinkedList<IWorkItemHandle> linkedList = this.fActivationHistory;
        synchronized (linkedList) {
            if (this.fHistoryLoaded) {
                StringBuilder builder = new StringBuilder(256);
                for (IWorkItemHandle handle : this.fActivationHistory) {
                    Object origin = handle.getOrigin();
                    if (!(origin instanceof ITeamRepository)) continue;
                    ITeamRepository repository = (ITeamRepository)origin;
                    builder.append(repository.getRepositoryURI());
                    builder.append('!');
                    builder.append(handle.getItemId().getUuidValue());
                    builder.append('!');
                }
                WorkItemRCPCorePlugin plugin = WorkItemRCPCorePlugin.getDefault();
                plugin.getPluginPreferences().setValue(PREFERENCE_HISTORY, builder.toString());
                plugin.savePluginPreferences();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveActiveWorkItem() {
        StringBuilder builder = new StringBuilder(256);
        Object object = this.fActiveWorkItemLock;
        synchronized (object) {
            Object origin;
            if (this.fActiveWorkItem != null && (origin = this.fActiveWorkItem.getOrigin()) instanceof ITeamRepository) {
                ITeamRepository repository = (ITeamRepository)origin;
                builder.append(repository.getRepositoryURI());
                builder.append('!');
                builder.append(this.fActiveWorkItem.getItemId().getUuidValue());
                builder.append('!');
            }
        }
        WorkItemRCPCorePlugin plugin = WorkItemRCPCorePlugin.getDefault();
        plugin.getPluginPreferences().setValue(PREFERENCE_ACTIVE, builder.toString());
        plugin.savePluginPreferences();
    }
}

