/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.internal;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.workitem.rcp.core.internal.WorkItemRCPCorePlugin;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FavoriteValues {
    private static final String STATE_FILE_NAME = "favorite-values.xml";
    private static final String FAVORITE_VALUES = "values";
    private static final String FAVORITE_CATEGORY = "category";
    private static final String FAVORITE_ITEM = "item";
    private static final String FAVORITE_LOCATION = "loc";
    private static final int MAX_ENTRIES = 50;
    private static FavoriteValues fgInstance;
    private HashMap<String, MRUItemSet> fValues = new HashMap();

    public static FavoriteValues getInstance() {
        if (fgInstance == null) {
            fgInstance = new FavoriteValues();
            fgInstance.restore();
        }
        return fgInstance;
    }

    private FavoriteValues() {
    }

    public void addItems(String category, Collection<? extends IItemHandle> handles) {
        MRUItemSet favorites = this.fValues.get(category);
        if (favorites == null) {
            favorites = new MRUItemSet(50);
            this.fValues.put(category, favorites);
        }
        for (IItemHandle iItemHandle : handles) {
            favorites.add(new ItemEntry(iItemHandle));
        }
        this.saveState();
    }

    public void removeItems(String category, Collection<? extends IItemHandle> handles) {
        MRUItemSet favorites = this.fValues.get(category);
        if (favorites != null) {
            for (IItemHandle iItemHandle : handles) {
                favorites.remove(new ItemEntry(iItemHandle));
            }
        }
    }

    public Collection<IItemHandle> getItems(String category) {
        MRUItemSet favorites = this.fValues.get(category);
        LinkedList<IItemHandle> handles = new LinkedList<IItemHandle>();
        if (favorites != null) {
            for (ItemEntry entry : favorites) {
                handles.add(entry.handle);
            }
        }
        return handles;
    }

    public <T extends IItemHandle> List<T> getItems(ITeamRepository repository, String category, Class<T> clazz) {
        MRUItemSet favorites = this.fValues.get(category);
        LinkedList<IItemHandle> handles = new LinkedList<IItemHandle>();
        if (favorites != null) {
            for (ItemEntry entry : favorites) {
                if (!repository.equals(entry.handle.getOrigin()) || !clazz.isAssignableFrom(entry.handle.getClass())) continue;
                handles.add(entry.handle);
            }
        }
        return handles;
    }

    private void restore() {
        block6: {
            FileReader reader = null;
            try {
                File stateFile = this.getStateFile();
                reader = new FileReader(stateFile);
                XMLMemento memento = XMLMemento.createReadRoot((Reader)reader);
                this.restore((IMemento)memento);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.close(reader);
                break block6;
            }
            catch (CoreException e) {
                try {
                    WorkItemRCPCorePlugin.getDefault().log(e);
                    this.close(reader);
                    break block6;
                }
                catch (Throwable throwable) {
                    this.close(reader);
                    throw throwable;
                }
            }
            this.close(reader);
        }
    }

    private void saveState() {
        block5: {
            XMLMemento memento = XMLMemento.createWriteRoot((String)FAVORITE_VALUES);
            this.saveState((IMemento)memento);
            File stateFile = this.getStateFile();
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(stateFile);
                    memento.save((Writer)writer);
                }
                catch (IOException e) {
                    WorkItemRCPCorePlugin.getDefault().log(e);
                    this.close(writer);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                this.close(writer);
                throw throwable;
            }
            this.close(writer);
        }
    }

    private void restore(IMemento memento) {
        IMemento[] categories;
        IMemento[] iMementoArray = categories = memento.getChildren(FAVORITE_CATEGORY);
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento[] items;
            IMemento category = iMementoArray[n2];
            MRUItemSet set = new MRUItemSet(50);
            IMemento[] iMementoArray2 = items = category.getChildren(FAVORITE_ITEM);
            int n3 = items.length;
            int n4 = 0;
            while (n4 < n3) {
                IMemento item = iMementoArray2[n4];
                IItemHandle handle = this.createItemHandle(item);
                if (handle != null) {
                    set.add(new ItemEntry(handle));
                }
                ++n4;
            }
            this.fValues.put(category.getID(), set);
            ++n2;
        }
    }

    private IItemHandle createItemHandle(IMemento item) {
        ITeamRepository repository;
        Location location;
        block4: {
            String loc = item.getString(FAVORITE_LOCATION);
            URI resource = new URI(loc);
            location = Location.location((URI)resource);
            String repositoryUri = location.getRepoUri();
            repository = TeamPlatform.getTeamRepositoryService().getTeamRepository(repositoryUri, 4);
            if (repository != null) break block4;
            return null;
        }
        try {
            ItemHandle handle = (ItemHandle)location.getItemHandle();
            handle.setOrigin((Object)repository);
            return handle;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
        catch (TeamRepositoryException teamRepositoryException) {
            return null;
        }
    }

    private void saveState(IMemento memento) {
        for (String key : this.fValues.keySet()) {
            IMemento category = memento.createChild(FAVORITE_CATEGORY, key);
            MRUItemSet set = this.fValues.get(key);
            for (ItemEntry entry : set) {
                IMemento item = category.createChild(FAVORITE_ITEM);
                this.saveState(item, entry.handle);
            }
        }
    }

    private void saveState(IMemento item, IItemHandle handle) {
        ITeamRepository repository = (ITeamRepository)handle.getOrigin();
        Location location = Location.itemLocation((IItemHandle)handle, (String)repository.getRepositoryURI());
        item.putString(FAVORITE_LOCATION, location.toAbsoluteUri().toString());
    }

    private File getStateFile() {
        IPath stateLocation = WorkItemRCPCorePlugin.getDefault().getStateLocation();
        File stateFile = stateLocation.append(STATE_FILE_NAME).toFile();
        return stateFile;
    }

    private void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            WorkItemRCPCorePlugin.getDefault().log(e);
        }
    }

    private static class ItemEntry {
        public IItemHandle handle;

        public ItemEntry(IItemHandle itemHandle) {
            this.handle = itemHandle;
        }

        public int hashCode() {
            return this.handle.getItemId().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ItemEntry)) {
                return false;
            }
            return this.handle.sameItemId(((ItemEntry)obj).handle);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MRUItemSet
    extends LinkedHashSet<ItemEntry> {
        private static final long serialVersionUID = 1L;
        private final int fLimit;

        public MRUItemSet(int limit) {
            this.fLimit = limit;
        }

        @Override
        public boolean add(ItemEntry entry) {
            if (this.remove(entry)) {
                super.add(entry);
                return false;
            }
            if (this.size() >= this.fLimit) {
                this.remove(this.iterator().next());
            }
            super.add(entry);
            return true;
        }
    }
}

