/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.rcp.core.history;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.rcp.core.ClientModel;
import com.ibm.team.workitem.rcp.core.CoreFactory;
import com.ibm.team.workitem.rcp.core.WorkItemEditorHistoryEntry;
import com.ibm.team.workitem.rcp.core.history.HistoryChangeEvent;
import com.ibm.team.workitem.rcp.core.history.IHistoryListener;
import com.ibm.team.workitem.rcp.core.history.Messages;
import com.ibm.team.workitem.rcp.core.internal.WorkItemRCPCorePlugin;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class HistoryManager {
    private static final int DEFERRED_STORE_DELAY = 300000;
    private static final int MAX_ENTRIES = 100;
    private WorkItemRCPCorePlugin fClientModelPlugin;
    private List fListeners = new ArrayList();
    private boolean fIsStoreScheduled = false;
    private Object fDeferredStoreMutex = new Object();
    private Job fDeferredStoreJob = new FoundationJob(Messages.HistoryManager_DEFERRED_STORE_WORKITEM_HISTORY){

        protected IStatus runProtected(IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ClientModel.store();
            HistoryManager.this.fIsStoreScheduled = false;
            return Status.OK_STATUS;
        }
    };

    public HistoryManager(WorkItemRCPCorePlugin clientModelPlugin) {
        this.fClientModelPlugin = clientModelPlugin;
    }

    public void addHistoryListener(IHistoryListener listener) {
        if (!this.fListeners.contains(listener)) {
            this.fListeners.add(listener);
        }
    }

    public void removeHistoryListener(IHistoryListener listener) {
        this.fListeners.remove(listener);
    }

    private void fireChange(HistoryChangeEvent event) {
        IHistoryListener[] listeners = this.fListeners.toArray(new IHistoryListener[this.fListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].historyChanged(event);
            ++i;
        }
    }

    public void addToHistory(IWorkItemHandle workItemHandle, String description) {
        if (workItemHandle == null) {
            return;
        }
        WorkItemEditorHistoryEntry entry = null;
        List internalContents = this.fClientModelPlugin.getModelRoot().getWorkItemEditorHistory().getInternalContents();
        Iterator iter = internalContents.iterator();
        while (iter.hasNext()) {
            WorkItemEditorHistoryEntry w = (WorkItemEditorHistoryEntry)iter.next();
            if (w.getRepository() == null) {
                iter.remove();
                continue;
            }
            if (!workItemHandle.sameItemId((IItemHandle)w.getWorkItem())) continue;
            iter.remove();
            entry = w;
        }
        if (entry == null) {
            ITeamRepository teamRepository = (ITeamRepository)workItemHandle.getOrigin();
            if (workItemHandle instanceof IWorkItem) {
                workItemHandle = (IWorkItemHandle)((IWorkItem)workItemHandle).getItemHandle();
            }
            CoreFactory factory = CoreFactory.eINSTANCE;
            entry = factory.createWorkItemEditorHistoryEntry();
            entry.setRepository(teamRepository.getRepositoryURI());
            entry.setWorkItem(workItemHandle);
            entry.setDescription(description);
        }
        entry.setDate(new Date());
        internalContents.add(0, entry);
        while (internalContents.size() > 100) {
            WorkItemEditorHistoryEntry toremove = (WorkItemEditorHistoryEntry)internalContents.remove(100);
            this.fireChange(new HistoryChangeEvent(2, toremove));
        }
        this.fireChange(new HistoryChangeEvent(1, entry));
        this.deferredStore();
    }

    public WorkItemEditorHistoryEntry[] getHistoryEntries() {
        List contentsList = this.fClientModelPlugin.getModelRoot().getWorkItemEditorHistory().getInternalContents();
        WorkItemEditorHistoryEntry[] contents = contentsList.toArray(new WorkItemEditorHistoryEntry[contentsList.size()]);
        int i = 0;
        while (i < contents.length) {
            IWorkItemHandle workItem;
            ITeamRepository teamRepository;
            String repository = contents[i].getRepository();
            if (repository != null && (teamRepository = this.getTeamRepository(contents[i].getRepository())) != null && (workItem = contents[i].getWorkItem()) != null) {
                ((ItemHandle)workItem).setOrigin((Object)teamRepository);
            } else {
                contentsList.remove(contents[i]);
            }
            ++i;
        }
        return contentsList.toArray(new WorkItemEditorHistoryEntry[contentsList.size()]);
    }

    private ITeamRepository getTeamRepository(String uri) {
        ITeamRepository[] all = TeamPlatform.getTeamRepositoryService().getTeamRepositories();
        int i = 0;
        while (i < all.length) {
            if (all[i].getRepositoryURI().equals(uri)) {
                return all[i];
            }
            ++i;
        }
        return null;
    }

    public void wipe() {
        this.fireChange(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deferredStore() {
        Object object = this.fDeferredStoreMutex;
        synchronized (object) {
            if (!this.fIsStoreScheduled) {
                this.fIsStoreScheduled = true;
                if (!this.fDeferredStoreJob.isSystem()) {
                    this.fDeferredStoreJob.setSystem(true);
                }
                this.fDeferredStoreJob.schedule(300000L);
            }
        }
    }
}

