/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemStore;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.internal.SCMClientUtil;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.IRepositoryProgressMonitor;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionableManager
extends EventSource
implements IVersionableManager {
    private final WorkspaceManager workspaceManager;
    private final Store stateStore = new Store();

    VersionableManager(WorkspaceManager workspaceManager) {
        if (workspaceManager == null) {
            throw new IllegalArgumentException();
        }
        this.workspaceManager = workspaceManager;
    }

    @Override
    public ITeamRepository teamRepository() {
        return this.workspaceManager.teamRepository();
    }

    @Override
    public IVersionable fetchCompleteState(IVersionableHandle itemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (itemHandle == null) {
            throw new IllegalArgumentException();
        }
        return (IVersionable)this.stateStore.fetchItem((IItemHandle)itemHandle, false, null, monitor);
    }

    @Override
    public List fetchCompleteStates(List itemHandles, IProgressMonitor monitor) throws TeamRepositoryException {
        if (itemHandles == null) {
            throw new IllegalArgumentException();
        }
        for (Object element : itemHandles) {
            if (element == null) {
                throw new IllegalArgumentException();
            }
            if (element instanceof IVersionableHandle) continue;
            throw new IllegalArgumentException();
        }
        return this.stateStore.fetchItems(itemHandles, false, null, monitor);
    }

    @Override
    public IVersionable fetchPartialState(IVersionableHandle itemHandle, Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        if (itemHandle == null) {
            throw new IllegalArgumentException();
        }
        if (requiredProperties == null) {
            requiredProperties = Collections.EMPTY_LIST;
        }
        return (IVersionable)this.stateStore.fetchItem((IItemHandle)itemHandle, false, new HashSet(requiredProperties), monitor);
    }

    @Override
    public List fetchPartialStates(List itemHandles, Collection requiredProperties, IProgressMonitor monitor) throws TeamRepositoryException {
        if (itemHandles == null) {
            throw new IllegalArgumentException();
        }
        if (requiredProperties == null) {
            requiredProperties = Collections.EMPTY_LIST;
        }
        for (Object element : itemHandles) {
            if (element == null) {
                throw new IllegalArgumentException();
            }
            if (element instanceof IVersionableHandle) continue;
            throw new IllegalArgumentException();
        }
        return this.stateStore.fetchItems(itemHandles, false, new HashSet(requiredProperties), monitor);
    }

    public List applyItemStates(List itemStates) {
        if (itemStates == null) {
            throw new IllegalArgumentException();
        }
        ArrayList<IVersionable> newItemStates = new ArrayList<IVersionable>(itemStates.size());
        for (Object element : itemStates) {
            if (element == null) {
                newItemStates.add(null);
                continue;
            }
            if (!(element instanceof IVersionable)) {
                throw new IllegalArgumentException();
            }
            IVersionable item = (IVersionable)Store.getImmutableItem((IItem)((IVersionable)element));
            if (item == null) {
                item = (IVersionable)element;
            }
            item = (IVersionable)EcoreUtil.copy((EObject)((EObject)item));
            newItemStates.add(item);
            Object oldOrigin = item.getOrigin();
            if (oldOrigin != null && oldOrigin != this.teamRepository()) {
                throw new IllegalArgumentException();
            }
            if (oldOrigin != null) continue;
            SCMClientUtil.makeImmutable(this.teamRepository(), (IVersionableHandle)item);
        }
        try {
            this.acquire();
            List list = this.stateStore.putItems(newItemStates, true);
            return list;
        }
        finally {
            this.release();
        }
    }

    private IVersionable internalFetchState(IVersionableHandle itemHandle, Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            IVersionableHandle itemHandleToFetch = null;
            itemHandleToFetch = itemHandle instanceof IVersionable ? (IVersionableHandle)((IVersionable)itemHandle).getStateHandle() : itemHandle;
            IVersionable iVersionable = this.workspaceManager.getServerConfigurationService().fetchState(itemHandleToFetch, this.getMinimalProperties(itemHandleToFetch.getItemType(), properties), IRepositoryProgressMonitor.ITEM_FACTORY.createItem(monitor));
            return iVersionable;
        }
        finally {
            monitor.done();
        }
    }

    private List internalFetchStates(List itemHandles, Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = SCMClientUtil.getMonitor(monitor, 100);
        try {
            List cleanedupItemHandles = this.removeDuplicates(itemHandles);
            ArrayList<Object> itemHandlesToFetch = new ArrayList<Object>(cleanedupItemHandles.size());
            IItemType commonItemType = null;
            for (Object object : cleanedupItemHandles) {
                if (object instanceof IVersionableHandle) {
                    IVersionableHandle itemHandle = (IVersionableHandle)object;
                    if (!itemHandle.hasStateId()) {
                        throw new IllegalArgumentException();
                    }
                    IItemType itemType = itemHandle.getItemType();
                    if (commonItemType == null) {
                        commonItemType = itemType;
                    }
                    if (properties != null && !properties.isEmpty() && itemType != commonItemType) {
                        throw new IllegalArgumentException();
                    }
                    if (itemHandle instanceof IVersionable) {
                        itemHandlesToFetch.add(((IVersionable)itemHandle).getStateHandle());
                        continue;
                    }
                    itemHandlesToFetch.add(itemHandle);
                    continue;
                }
                throw new IllegalArgumentException();
            }
            ArrayList<IVersionable> states = new ArrayList<IVersionable>(itemHandlesToFetch.size());
            int left = itemHandlesToFetch.size();
            int i = 0;
            while (left > 0) {
                int from = i * 2048;
                int size = Math.min(2048, left);
                List<IVersionable> result = Arrays.asList(this.workspaceManager.getServerConfigurationService().fetchStates(itemHandlesToFetch.subList(from, from + size).toArray(new IVersionableHandle[size]), this.getMinimalProperties(commonItemType, properties), SCMClientUtil.monitorFor(monitor)));
                states.addAll(result);
                left -= size;
                ++i;
            }
            List list = Collections.unmodifiableList(this.addDuplicates(itemHandles, states));
            return list;
        }
        finally {
            monitor.done();
        }
    }

    private List removeDuplicates(List duplicateHandles) {
        ArrayList<IItemHandle> cleanedupHandles = new ArrayList<IItemHandle>(duplicateHandles.size());
        HashSet<UUID> visited = new HashSet<UUID>();
        for (IItemHandle itemHandle : duplicateHandles) {
            UUID key;
            if (itemHandle == null || visited.contains(key = ((IVersionableHandle)itemHandle).getStateId())) continue;
            visited.add(key);
            cleanedupHandles.add(itemHandle);
        }
        return cleanedupHandles;
    }

    private List addDuplicates(List<IVersionableHandle> duplicateHandles, List<IVersionable> cleanedupItems) {
        UUID key;
        ArrayList<IVersionable> duplicateItems = new ArrayList<IVersionable>(duplicateHandles.size());
        HashMap<UUID, IVersionable> visited = new HashMap<UUID, IVersionable>();
        for (IVersionable item : cleanedupItems) {
            if (item == null) continue;
            key = item.getStateId();
            visited.put(key, item);
        }
        for (IVersionableHandle itemHandle : duplicateHandles) {
            if (itemHandle == null) {
                duplicateItems.add(null);
                continue;
            }
            key = itemHandle.getStateId();
            duplicateItems.add((IVersionable)visited.get(key));
        }
        return duplicateItems;
    }

    private String[] getMinimalProperties(IItemType itemType, Set properties) {
        if (properties == null) {
            return null;
        }
        List minimalProperties = ItemUtil.getMinimalPropertyNames((ItemType)((ItemType)itemType));
        if (properties.containsAll(minimalProperties)) {
            return properties.toArray(new String[properties.size()]);
        }
        HashSet actualProperties = new HashSet(properties);
        actualProperties.addAll(minimalProperties);
        return actualProperties.toArray(new String[actualProperties.size()]);
    }

    private class Store
    extends ItemStore {
        public Store() {
            super(false, true);
        }

        public IItem fetchItem(IItemHandle itemHandle, boolean refresh, Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            try {
                IItem storedItem = null;
                Set storedProperties = null;
                try {
                    VersionableManager.this.acquire();
                    storedItem = this.getItem(itemHandle);
                    storedProperties = this.getProperties(itemHandle);
                }
                finally {
                    VersionableManager.this.release();
                }
                if (!refresh && storedItem != null && Store.contains((Set)storedProperties, (Set)properties)) {
                    this.notifyItemHit(itemHandle);
                    IItem iItem = storedItem;
                    return iItem;
                }
                if (refresh) {
                    this.notifyItemRefresh(itemHandle);
                } else {
                    this.notifyItemMiss(itemHandle);
                }
                IItem iItem = this.retrieveItem(itemHandle, storedItem == null ? properties : Store.addAll((Set)storedProperties, (Set)properties), (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                return iItem;
            }
            finally {
                monitor.done();
            }
        }

        public List fetchItems(List itemHandles, boolean refresh, Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            try {
                ArrayList<Object> items = new ArrayList<Object>(itemHandles);
                ArrayList<IItemHandle> storedItemHandles = new ArrayList<IItemHandle>(itemHandles.size());
                ArrayList<IItemHandle> nonStoredItemHandles = new ArrayList<IItemHandle>(itemHandles.size());
                Set allProperties = properties;
                try {
                    VersionableManager.this.acquire();
                    int index = 0;
                    for (IItemHandle itemHandle : itemHandles) {
                        IItem storedItem = this.getItem(itemHandle);
                        Set storedProperties = this.getProperties(itemHandle);
                        if (!refresh && storedItem != null && Store.contains((Set)storedProperties, (Set)properties)) {
                            storedItemHandles.add(itemHandle);
                            items.set(index, storedItem);
                        } else {
                            items.set(index, null);
                            nonStoredItemHandles.add(itemHandle);
                            if (storedItem != null) {
                                allProperties = Store.addAll((Set)allProperties, (Set)storedProperties);
                            }
                        }
                        ++index;
                    }
                }
                finally {
                    VersionableManager.this.release();
                }
                if (!storedItemHandles.isEmpty()) {
                    this.notifyItemHits(storedItemHandles);
                }
                if (!nonStoredItemHandles.isEmpty()) {
                    if (refresh) {
                        this.notifyItemRefreshes(nonStoredItemHandles);
                    } else {
                        this.notifyItemMisses(nonStoredItemHandles);
                    }
                    List nonStoredItems = this.retrieveItems(nonStoredItemHandles, allProperties, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                    Iterator itemIterator = nonStoredItems.iterator();
                    int i = 0;
                    int count = items.size();
                    while (i < count && itemIterator.hasNext()) {
                        IItem item = (IItem)items.get(i);
                        if (item == null) {
                            items.set(i, itemIterator.next());
                        }
                        ++i;
                    }
                }
                ArrayList<Object> arrayList = items;
                return arrayList;
            }
            finally {
                monitor.done();
            }
        }

        public void refreshItem(IItemHandle itemHandle, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            try {
                IItem storedItem = null;
                Set storedProperties = null;
                try {
                    VersionableManager.this.acquire();
                    storedItem = this.getItem(itemHandle);
                    storedProperties = this.getProperties(itemHandle);
                }
                finally {
                    VersionableManager.this.release();
                }
                if (storedItem != null) {
                    this.notifyItemRefresh(itemHandle);
                    this.retrieveItem(itemHandle, storedProperties, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                }
            }
            finally {
                monitor.done();
            }
        }

        public void refreshItems(List itemHandles, IProgressMonitor monitor) throws TeamRepositoryException {
            monitor = SCMClientUtil.getMonitor(monitor, 100);
            try {
                ArrayList<IItem> storedItems = new ArrayList<IItem>(itemHandles.size());
                Set allProperties = new HashSet();
                try {
                    VersionableManager.this.acquire();
                    for (IItemHandle itemHandle : itemHandles) {
                        IItem storedItem = this.getItem(itemHandle);
                        if (storedItem == null) continue;
                        Set storedProperties = this.getProperties(itemHandle);
                        storedItems.add(storedItem);
                        allProperties = Store.addAll(allProperties, (Set)storedProperties);
                    }
                }
                finally {
                    VersionableManager.this.release();
                }
                if (!storedItems.isEmpty()) {
                    this.notifyItemRefreshes(storedItems);
                    this.retrieveItems(storedItems, allProperties, (IProgressMonitor)new SubProgressMonitor(monitor, 90));
                }
            }
            finally {
                monitor.done();
            }
        }

        protected void notifyItemChanged(IItem item, IItem beforeState, IItem afterState) {
        }

        protected void notifyIncrease(IItemType itemType, long size, long count) {
            VersionableManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.statistics.itemType", (Object)itemType, "itemTypeCacheSize", size);
            VersionableManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.totalContext", (Object)VersionableManager.this.teamRepository(), "totalCacheSize", size);
            VersionableManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.statistics.itemType", (Object)itemType, "itemTypeCacheCount", count);
            VersionableManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.totalContext", (Object)VersionableManager.this.teamRepository(), "totalCacheCount", count);
        }

        protected void notifyDecrease(IItemType itemType, long size, long count) {
            VersionableManager.this.teamRepository().statistics().decStatisticValue("com.ibm.team.repository.statistics.itemType", (Object)itemType, "itemTypeCacheSize", size);
            VersionableManager.this.teamRepository().statistics().decStatisticValue("com.ibm.team.repository.totalContext", (Object)VersionableManager.this.teamRepository(), "totalCacheSize", size);
            VersionableManager.this.teamRepository().statistics().decStatisticValue("com.ibm.team.repository.statistics.itemType", (Object)itemType, "itemTypeCacheCount", count);
            VersionableManager.this.teamRepository().statistics().decStatisticValue("com.ibm.team.repository.totalContext", (Object)VersionableManager.this.teamRepository(), "totalCacheCount", count);
        }

        protected boolean statisticsEnabled() {
            return VersionableManager.this.teamRepository().statistics().enabled();
        }

        private IItem retrieveItem(IItemHandle itemHandle, Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
            IVersionable item = VersionableManager.this.internalFetchState((IVersionableHandle)itemHandle, properties, monitor);
            try {
                VersionableManager.this.acquire();
                if (item != null) {
                    item = this.putItem((IItem)item, true);
                } else {
                    this.removeItem(itemHandle);
                }
            }
            finally {
                VersionableManager.this.release();
            }
            return item;
        }

        private List retrieveItems(List itemHandles, Set properties, IProgressMonitor monitor) throws TeamRepositoryException {
            ArrayList<IItem> items = new ArrayList<IItem>(VersionableManager.this.internalFetchStates(itemHandles, properties, monitor));
            try {
                VersionableManager.this.acquire();
                Iterator handleIterator = itemHandles.iterator();
                int i = 0;
                int count = items.size();
                while (i < count) {
                    IItem item = (IItem)items.get(i);
                    IItemHandle itemHandle = (IItemHandle)handleIterator.next();
                    if (item != null) {
                        items.set(i, this.putItem(item, true));
                    } else {
                        this.removeItem(itemHandle);
                    }
                    ++i;
                }
            }
            finally {
                VersionableManager.this.release();
            }
            return items;
        }

        private void notifyItemHits(List itemHandles) {
            this.notifyItemStatistics(itemHandles, "itemTypeCacheHits", "totalCacheHits");
        }

        private void notifyItemMisses(List itemHandles) {
            this.notifyItemStatistics(itemHandles, "itemTypeCacheMisses", "totalCacheMisses");
        }

        private void notifyItemRefreshes(List itemHandles) {
            this.notifyItemStatistics(itemHandles, "itemTypeCacheRefreshes", "totalCacheRefreshes");
        }

        private void notifyItemStatistics(List itemHandles, String itemTypeStatistic, String totalStatistic) {
            long total = 0L;
            for (IItemHandle itemHandle : itemHandles) {
                if (itemHandle == null) continue;
                VersionableManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.statistics.itemType", (Object)itemHandle.getItemType(), itemTypeStatistic, 1L);
                ++total;
            }
            VersionableManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.totalContext", (Object)VersionableManager.this.teamRepository(), totalStatistic, total);
        }

        private void notifyItemHit(IItemHandle itemHandle) {
            this.notifyItemStatistic(itemHandle, "itemTypeCacheHits", "totalCacheHits");
        }

        private void notifyItemMiss(IItemHandle itemHandle) {
            this.notifyItemStatistic(itemHandle, "itemTypeCacheMisses", "totalCacheMisses");
        }

        private void notifyItemRefresh(IItemHandle itemHandle) {
            this.notifyItemStatistic(itemHandle, "itemTypeCacheRefreshes", "totalCacheRefreshes");
        }

        private void notifyItemStatistic(IItemHandle itemHandle, String itemTypeStatistic, String totalStatistic) {
            VersionableManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.statistics.itemType", (Object)itemHandle.getItemType(), itemTypeStatistic, 1L);
            VersionableManager.this.teamRepository().statistics().incStatisticValue("com.ibm.team.repository.totalContext", (Object)VersionableManager.this.teamRepository(), totalStatistic, 1L);
        }
    }
}

