/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.internal.WorkspaceManager;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.ISynchronizationTimes;
import com.ibm.team.scm.common.internal.dto.SynchronizationInfo;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class Connection
extends EventSource
implements IConnection {
    protected static final boolean MANAGE_CONNECTIONS = true;
    protected final WorkspaceManager workspaceManager;

    Connection(WorkspaceManager workspaceManager) {
        if (workspaceManager == null) {
            throw new IllegalArgumentException();
        }
        this.workspaceManager = workspaceManager;
    }

    public ITeamRepository teamRepository() {
        return this.workspaceManager.teamRepository();
    }

    public boolean hasChangeSets(List changeSets, IProgressMonitor monitor) throws TeamRepositoryException {
        return ItemUtil.isSame((Collection)changeSets, (Collection)this.changeSetsInHistory(changeSets, monitor));
    }

    protected IClientLibraryContext getContext() {
        return this.workspaceManager().getContext();
    }

    WorkspaceManager workspaceManager() {
        return this.workspaceManager;
    }

    void validate() throws ItemNotFoundException {
    }

    protected static ISynchronizationTimes[] getSyncTimes(ISynchronizationInfo syncInfo) {
        if (syncInfo == null) {
            return null;
        }
        return ((SynchronizationInfo)syncInfo).getSyncTimes();
    }
}

