/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.scm.client.internal.RepositoryItemProvider;
import com.ibm.team.scm.client.internal.RepositoryLinkProvider;
import com.ibm.team.scm.client.internal.ScmClientProvider;
import com.ibm.team.scm.common.providers.ItemProvider;
import com.ibm.team.scm.common.providers.LinkProvider;
import com.ibm.team.scm.common.providers.ProviderFactory;
import com.ibm.team.scm.common.providers.ScmProvider;

public class ClientProviderFactory
implements ProviderFactory {
    private final ITeamRepository repo;
    private ItemProvider itemProvider;
    private LinkProvider linkProvider;
    private ScmClientProvider scmProvider;

    public ClientProviderFactory(ITeamRepository repo) {
        this.repo = repo;
    }

    public ItemProvider getItemProvider() {
        if (this.itemProvider == null) {
            this.itemProvider = new RepositoryItemProvider(this.repo);
        }
        return this.itemProvider;
    }

    public LinkProvider getLinkProvider() {
        if (this.linkProvider == null) {
            this.linkProvider = new RepositoryLinkProvider(this.repo);
        }
        return this.linkProvider;
    }

    public ScmProvider getScmProvider() {
        if (this.scmProvider == null) {
            this.scmProvider = new ScmClientProvider(this.repo);
        }
        return this.scmProvider;
    }
}

