/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.dashboard;

import com.ibm.icu.text.Collator;
import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.IChannelListener;
import com.ibm.team.feed.core.INewsManagerListener;
import com.ibm.team.feed.core.internal.ChannelManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.ui.internal.AddSubscriptionAction;
import com.ibm.team.feed.ui.internal.ColorDefinitions;
import com.ibm.team.feed.ui.internal.DeleteSubscriptionAction;
import com.ibm.team.feed.ui.internal.EditFeedAction;
import com.ibm.team.feed.ui.internal.HelpContextIds;
import com.ibm.team.feed.ui.internal.dashboard.FeedSectionState;
import com.ibm.team.feed.ui.internal.dashboard.Messages;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.itemview.ItemViewerFilter;
import com.ibm.team.jface.itemview.ItemViewerSorter;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FeedSectionConfigurationDialog
extends PreferenceDialog {
    private static final String FILTERID_ALL = "all";
    private static final ItemViewerFilter ALL_FILTER = new ItemViewerFilter(null, "all", Messages.getString("FeedSectionConfigurationDialog.ALL_FILTER"), 2);
    FeedSectionState fOrigState;
    FeedSectionState fTempState;
    private FeedSectionState.FeedSectionStateListener fFeedSectionStateListener;

    private FeedSectionConfigurationDialog(Shell parentShell, PreferenceManager manager, FeedSectionState state, FeedSectionState tmpState) {
        super(parentShell, manager);
        this.fOrigState = state;
        this.fTempState = tmpState;
        this.fFeedSectionStateListener = new FeedSectionState.FeedSectionStateListener(){

            public void channelSelectionChanged(Channel channel, boolean selected) {
                FeedSectionConfigurationDialog.this.fTempState.changeChannelSelection(channel, selected);
            }
        };
        this.fOrigState.addFeedSectionStateListener(this.fFeedSectionStateListener);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("FeedSectionConfigurationDialog.FEED_SECTION_CONFIGURATION"));
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FeedSectionConfigurationDialog.this.fOrigState != null) {
                    FeedSectionConfigurationDialog.this.fOrigState.removeFeedSectionStateListener(FeedSectionConfigurationDialog.this.fFeedSectionStateListener);
                }
            }
        });
        HelpContextIds.hookHelpListener((Control)newShell, "com.ibm.team.feed.ui.feed_section_configuration_dialog");
    }

    public static void show(Shell parentShell, FeedSectionState state) {
        PreferenceManager manager = new PreferenceManager();
        FeedSectionState tmpState = new FeedSectionState(state);
        manager.addToRoot((IPreferenceNode)new PreferenceNode("feeds_id", (IPreferencePage)new FeedsPreferencePage(tmpState)));
        manager.addToRoot((IPreferenceNode)new PreferenceNode("filters_id", (IPreferencePage)new FiltersPreferencePage(tmpState)));
        manager.addToRoot((IPreferenceNode)new PreferenceNode("markread_id", (IPreferencePage)new MarkReadPreferencePage(tmpState)));
        new FeedSectionConfigurationDialog(parentShell, manager, state, tmpState).open();
    }

    protected void okPressed() {
        this.save();
        super.okPressed();
    }

    private void save() {
        this.fOrigState.removeFeedSectionStateListener(this.fFeedSectionStateListener);
        this.saveSelectedFeeds();
        this.saveSelectedFilters();
        if (this.fOrigState.getPreferredSorterId() != this.fTempState.getPreferredSorterId()) {
            this.fOrigState.setPreferredSorterId(this.fTempState.getPreferredSorterId());
        }
        if (this.fOrigState.isEnableMarkReadOnFocus() != this.fTempState.isEnableMarkReadOnFocus()) {
            this.fOrigState.setEnableMarkReadOnFocus(this.fTempState.isEnableMarkReadOnFocus());
        }
        if (this.fOrigState.isEnableMarkReadOnHover() != this.fTempState.isEnableMarkReadOnHover()) {
            this.fOrigState.setEnableMarkReadOnHover(this.fTempState.isEnableMarkReadOnHover());
        }
        if (this.fOrigState.getMarkReadAfter() != this.fTempState.getMarkReadAfter()) {
            this.fOrigState.setMarkReadAfter(this.fTempState.getMarkReadAfter());
        }
        if (this.fOrigState.isEnableMarkReadOnSlideout() != this.fTempState.isEnableMarkReadOnSlideout()) {
            this.fOrigState.setEnableMarkReadOnSlideout(this.fTempState.isEnableMarkReadOnSlideout());
        }
    }

    private void saveSelectedFilters() {
        Set tempFilterIds = this.fTempState.getPreferredFilterIds();
        Set origFilterIds = this.fOrigState.getPreferredFilterIds();
        ArrayList<String> toremove = new ArrayList<String>();
        for (String id : origFilterIds) {
            if (tempFilterIds.contains(id)) continue;
            toremove.add(id);
        }
        this.fOrigState.getPreferredFilterIds().removeAll(toremove);
        for (String id : tempFilterIds) {
            if (origFilterIds.contains(id)) continue;
            origFilterIds.add(id);
        }
    }

    private void saveSelectedFeeds() {
        HashSet tempChannels = this.fTempState.getChannelManager().getSelectedChannelUrls();
        ChannelManager origChannelManager = this.fOrigState.getChannelManager();
        HashSet origChannels = origChannelManager.getSelectedChannelUrls();
        Channel[] channels = FeedManager.getDefault().getChannels();
        HashMap<String, Channel> urlToChannel = new HashMap<String, Channel>();
        Channel[] channelArray = channels;
        int n = channels.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            urlToChannel.put(channel.getUrl(), channel);
            ++n2;
        }
        ArrayList<String> toremove = new ArrayList<String>();
        for (String url : origChannels) {
            if (tempChannels.contains(url)) continue;
            toremove.add(url);
        }
        for (String url : toremove) {
            this.fOrigState.changeChannelSelection((Channel)urlToChannel.get(url), false);
        }
        for (String url : tempChannels) {
            if (origChannels.contains(url)) continue;
            this.fOrigState.changeChannelSelection((Channel)urlToChannel.get(url), true);
        }
    }

    private static class FeedLabelProvider
    extends LabelProvider
    implements IViewerLabelProvider {
        private ResourceManager fResources = new LocalResourceManager(JFaceResources.getResources());
        private StandardLabelProvider fStdLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        private IChannelListener fChannelListener = new IChannelListener(){

            public void channelEdited(final ChannelEvent event) {
                new FoundationUIJob(Messages.getString("FeedSectionConfigurationDialog.REFRESHING_CHANNEL")){

                    public IStatus runProtectedInUI(IProgressMonitor monitor) {
                        FeedLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)FeedLabelProvider.this, (Object)event.getChannel()));
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }

            public void channelStatusChanged(ChannelEvent event) {
            }
        };

        public FeedLabelProvider() {
            FeedManager.getDefault().addChannelListener(this.fChannelListener);
        }

        public void updateLabel(ViewerLabel label, Object element) {
            this.fStdLabelProvider.updateLabel(label, element);
            label.setForeground(this.fResources.createColor(ColorDefinitions.convertToRGB(((Channel)element).getColor())));
        }

        public void addListener(ILabelProviderListener listener) {
            this.fStdLabelProvider.addListener(listener);
            super.addListener(listener);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.fStdLabelProvider.removeListener(listener);
            super.removeListener(listener);
        }

        public void dispose() {
            this.fResources.dispose();
            this.fStdLabelProvider.dispose();
            FeedManager.getDefault().removeChannelListener(this.fChannelListener);
            super.dispose();
        }
    }

    private static class FeedsPreferencePage
    extends MyPreferencePage {
        private CheckboxTableViewer fFeedsTable;
        private FeedSectionState fTempState;

        public FeedsPreferencePage(FeedSectionState tmpState) {
            this.fTempState = tmpState;
        }

        public String getTitle() {
            return Messages.getString("FeedSectionConfigurationDialog.FEEDS");
        }

        protected Control doCreateContents(Composite parent) {
            this.noDefaultAndApplyButton();
            Composite area = new Composite(parent, 0);
            GridLayout areaLayout = new GridLayout(2, false);
            areaLayout.marginHeight = 0;
            areaLayout.marginWidth = 0;
            area.setLayout((Layout)areaLayout);
            area.setLayoutData((Object)new GridData(4, 4, true, true));
            this.fFeedsTable = CheckboxTableViewer.newCheckList((Composite)area, (int)2048);
            this.fFeedsTable.getTable().setLayout((Layout)new GridLayout());
            GridData data = new GridData(4, 4, true, true);
            this.fFeedsTable.getTable().setLayoutData((Object)data);
            this.fFeedsTable.setContentProvider((IContentProvider)new FeedsTableContentProvider());
            this.fFeedsTable.setLabelProvider((IBaseLabelProvider)new FeedLabelProvider());
            this.fFeedsTable.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    FeedsPreferencePage.this.onEdit();
                }
            });
            this.fFeedsTable.setInput((Object)"");
            ChannelManager channelManager = this.fTempState.getChannelManager();
            ArrayList<Channel> checked = new ArrayList<Channel>();
            Channel[] channelArray = FeedManager.getDefault().getChannels();
            int n = channelArray.length;
            int n2 = 0;
            while (n2 < n) {
                Channel channel = channelArray[n2];
                if (channelManager.isChannelSelected(channel)) {
                    checked.add(channel);
                }
                ++n2;
            }
            this.fFeedsTable.setCheckedElements(checked.toArray());
            this.fFeedsTable.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    Channel channel = (Channel)event.getElement();
                    if (event.getChecked()) {
                        FeedsPreferencePage.this.fTempState.getChannelManager().selectChannel(channel);
                    } else {
                        FeedsPreferencePage.this.fTempState.getChannelManager().deselectChannel(channel);
                    }
                }
            });
            Composite buttonComposite = new Composite(area, 0);
            GridLayout buttonLayout = new GridLayout();
            buttonLayout.marginHeight = 0;
            buttonLayout.marginWidth = 0;
            buttonComposite.setLayout((Layout)buttonLayout);
            buttonComposite.setLayoutData((Object)new GridData(4, 4, false, false));
            Button add = new Button(buttonComposite, 8);
            this.setButtonLayoutData(add);
            add.setText(Messages.getString("FeedSectionConfigurationDialog.ADD"));
            add.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)FeedsPreferencePage.this.fFeedsTable.getSelection();
                    FeedsPreferencePage.this.fFeedsTable.setSelection((ISelection)new StructuredSelection());
                    AddSubscriptionAction action = new AddSubscriptionAction();
                    action.run(null);
                    Channel addedChannel = action.getAddedChannel();
                    if (addedChannel != null) {
                        FeedsPreferencePage.this.fFeedsTable.refresh();
                        FeedsPreferencePage.this.fFeedsTable.setSelection((ISelection)new StructuredSelection((Object)addedChannel));
                        FeedsPreferencePage.this.fFeedsTable.setChecked((Object)addedChannel, true);
                        FeedsPreferencePage.this.fTempState.getChannelManager().selectChannel(addedChannel);
                    } else {
                        FeedsPreferencePage.this.fFeedsTable.setSelection((ISelection)selection);
                    }
                }
            });
            final Button edit = new Button(buttonComposite, 8);
            this.setButtonLayoutData(edit);
            edit.setEnabled(!this.fFeedsTable.getSelection().isEmpty());
            edit.setText(Messages.getString("FeedSectionConfigurationDialog.EDIT"));
            edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FeedsPreferencePage.this.onEdit();
                }
            });
            final Button delete = new Button(buttonComposite, 8);
            delete.setText(Messages.getString("FeedSectionConfigurationDialog.DELETE"));
            this.setButtonLayoutData(delete);
            delete.setEnabled(!this.fFeedsTable.getSelection().isEmpty());
            delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)FeedsPreferencePage.this.fFeedsTable.getSelection();
                    DeleteSubscriptionAction action = new DeleteSubscriptionAction(FeedsPreferencePage.this.getShell(), selection);
                    action.run(null);
                }
            });
            this.fFeedsTable.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    boolean enabled = !FeedsPreferencePage.this.fFeedsTable.getSelection().isEmpty();
                    edit.setEnabled(enabled);
                    delete.setEnabled(enabled);
                }
            });
            Dialog.applyDialogFont((Control)area);
            return area;
        }

        private void onEdit() {
            IStructuredSelection selection = (IStructuredSelection)this.fFeedsTable.getSelection();
            EditFeedAction action = new EditFeedAction(selection, this.getShell());
            action.run(null);
        }
    }

    private static class FeedsTableContentProvider
    implements IStructuredContentProvider {
        INewsManagerListener fNewsManagerListener = new INewsManagerListener(){

            public void channelAdded(ChannelEvent event) {
                FeedsTableContentProvider.this.refresh();
            }

            public void channelRemoved(ChannelEvent event) {
                FeedsTableContentProvider.this.refresh();
            }
        };
        Viewer fViewer;
        boolean fIsRefreshing = false;
        Collator fCollator = Collator.getInstance();

        private FeedsTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] channels = FeedManager.getDefault().getChannels();
            Arrays.sort(channels, new Comparator<Channel>(){

                @Override
                public int compare(Channel o1, Channel o2) {
                    return FeedsTableContentProvider.this.fCollator.compare(o1.getTitle(), o2.getTitle());
                }
            });
            return channels;
        }

        public void dispose() {
            FeedManager.getDefault().removeNewsManagerListener(this.fNewsManagerListener);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fViewer = viewer;
            FeedManager.getDefault().addNewsManagerListener(this.fNewsManagerListener);
        }

        void refresh() {
            if (this.fIsRefreshing) {
                return;
            }
            this.fIsRefreshing = true;
            FoundationUIJob job = new FoundationUIJob(Messages.getString("FeedSectionConfigurationDialog.REFRESHING")){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    FeedsTableContentProvider.this.fViewer.refresh();
                    FeedsTableContentProvider.this.fIsRefreshing = false;
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FiltersPreferencePage
    extends MyPreferencePage {
        private FeedSectionState fTempState;

        public FiltersPreferencePage(FeedSectionState tmpState) {
            this.fTempState = tmpState;
        }

        public String getTitle() {
            return Messages.getString("FeedSectionConfigurationDialog.FILTERS");
        }

        @Override
        protected Control doCreateContents(Composite parent) {
            List<ItemViewerFilter> excludeFilter;
            this.noDefaultAndApplyButton();
            Composite area = new Composite(parent, 0);
            GridLayout areaLayout = new GridLayout();
            areaLayout.marginHeight = 0;
            areaLayout.marginWidth = 0;
            area.setLayout((Layout)areaLayout);
            area.setLayoutData((Object)new GridData(4, 4, true, true));
            Map<Integer, List<ItemViewerFilter>> filters = this.getFilter();
            final Set preferredFilterIds = this.fTempState.getPreferredFilterIds();
            HashMap<ItemViewerFilter, Button> mapFilterToButton = new HashMap<ItemViewerFilter, Button>();
            List<ItemViewerFilter> scopeFilter = filters.get(2);
            if (!scopeFilter.isEmpty()) {
                Label label = new Label(area, 0);
                label.setText(Messages.getString("FeedSectionConfigurationDialog.SCOPE"));
                label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
                Composite c = new Composite(area, 0);
                c.setLayoutData((Object)new GridData(4, 1, true, false));
                c.setLayout((Layout)new GridLayout(scopeFilter.size(), false));
                ((GridLayout)c.getLayout()).marginBottom = 10;
                boolean selection = false;
                for (ItemViewerFilter filter : scopeFilter) {
                    Button b = new Button(c, 16);
                    mapFilterToButton.put(filter, b);
                    b.setText(filter.getName());
                    if (!preferredFilterIds.contains(filter.getId())) continue;
                    b.setSelection(true);
                    selection = true;
                }
                if (!selection) {
                    ((Button)mapFilterToButton.get(ALL_FILTER)).setSelection(true);
                }
            }
            Composite container = new Composite(area, 0);
            container.setLayoutData((Object)new GridData(4, 1, true, false));
            container.setLayout((Layout)new GridLayout(2, false));
            ((GridLayout)container.getLayout()).marginHeight = 0;
            ((GridLayout)container.getLayout()).marginWidth = 0;
            List<ItemViewerFilter> displayFilter = filters.get(0);
            if (!displayFilter.isEmpty()) {
                Composite c = new Composite(container, 0);
                c.setLayoutData((Object)new GridData(4, 1, false, false));
                c.setLayout((Layout)new GridLayout());
                ((GridLayout)c.getLayout()).marginHeight = 0;
                ((GridLayout)c.getLayout()).marginWidth = 0;
                Label label = new Label(c, 0);
                label.setText(Messages.getString("FeedSectionConfigurationDialog.SHOW"));
                label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
                c = new Composite(c, 0);
                c.setLayoutData((Object)new GridData(4, 1, false, false));
                c.setLayout((Layout)new GridLayout());
                for (ItemViewerFilter filter : displayFilter) {
                    Button b = new Button(c, 32);
                    mapFilterToButton.put(filter, b);
                    b.setText(filter.getName());
                    b.setSelection(!preferredFilterIds.contains(filter.getId()));
                }
            }
            if (!(excludeFilter = filters.get(1)).isEmpty()) {
                Composite c = new Composite(container, 0);
                c.setLayoutData((Object)new GridData(4, 1, false, false));
                c.setLayout((Layout)new GridLayout());
                ((GridLayout)c.getLayout()).marginHeight = 0;
                ((GridLayout)c.getLayout()).marginWidth = 0;
                Label label = new Label(c, 0);
                label.setText(Messages.getString("FeedSectionConfigurationDialog.EXCLUDE"));
                label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
                c = new Composite(c, 0);
                c.setLayoutData((Object)new GridData(4, 1, false, false));
                c.setLayout((Layout)new GridLayout());
                for (ItemViewerFilter filter : excludeFilter) {
                    Button b = new Button(c, 32);
                    mapFilterToButton.put(filter, b);
                    b.setText(filter.getName());
                    b.setSelection(preferredFilterIds.contains(filter.getId()));
                }
            }
            Set entries = mapFilterToButton.entrySet();
            for (Map.Entry entry : entries) {
                final ItemViewerFilter filter = (ItemViewerFilter)entry.getKey();
                final Button button = (Button)entry.getValue();
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        boolean selected = button.getSelection();
                        boolean add = true;
                        switch (filter.getGroup()) {
                            case 0: {
                                add = !selected;
                                break;
                            }
                            case 1: {
                                add = selected;
                                break;
                            }
                            case 2: {
                                add = selected;
                            }
                        }
                        if (add) {
                            preferredFilterIds.add(filter.getId());
                        } else {
                            preferredFilterIds.remove(filter.getId());
                        }
                    }
                });
            }
            TreeSet sortedSorters = new TreeSet();
            sortedSorters.addAll(this.fTempState.getConfigurer().getSorters());
            if (!sortedSorters.isEmpty()) {
                Composite c = new Composite(container, 0);
                c.setLayoutData((Object)new GridData(4, 1, false, false));
                c.setLayout((Layout)new GridLayout());
                ((GridLayout)c.getLayout()).marginHeight = 10;
                ((GridLayout)c.getLayout()).marginWidth = 0;
                Label label = new Label(c, 0);
                label.setText(Messages.getString("FeedSectionConfigurationDialog.SORT_BY"));
                label.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
                c = new Composite(c, 0);
                c.setLayoutData((Object)new GridData(4, 1, true, false));
                c.setLayout((Layout)new GridLayout());
                ComboViewer viewer = new ComboViewer(c, 2056);
                viewer.getCombo().setVisibleItemCount(10);
                viewer.getCombo().setLayoutData((Object)new GridData(4, 1, true, false));
                viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
                viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        return ((ItemViewerSorter)element).getName();
                    }
                });
                viewer.setInput(sortedSorters);
                for (ItemViewerSorter sorter : sortedSorters) {
                    if (!sorter.getId().equals(this.fTempState.getPreferredSorterId())) continue;
                    viewer.setSelection((ISelection)new StructuredSelection((Object)sorter));
                    break;
                }
                viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        if (!selection.isEmpty()) {
                            FiltersPreferencePage.this.fTempState.setPreferredSorterId(((ItemViewerSorter)selection.getFirstElement()).getId());
                        }
                    }
                });
            }
            Dialog.applyDialogFont((Control)area);
            return area;
        }

        private Map<Integer, List<ItemViewerFilter>> getFilter() {
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            int[] groups = nArray;
            HashMap<Integer, List<ItemViewerFilter>> map = new HashMap<Integer, List<ItemViewerFilter>>(groups.length);
            List filters = this.fTempState.getConfigurer().getFilters();
            block0: for (ItemViewerFilter filter : filters) {
                int filterGroup = filter.getGroup();
                int[] nArray2 = groups;
                int n = groups.length;
                int n2 = 0;
                while (n2 < n) {
                    int group = nArray2[n2];
                    if (filterGroup == group) {
                        ArrayList<ItemViewerFilter> list = (ArrayList<ItemViewerFilter>)map.get(group);
                        if (list == null) {
                            list = new ArrayList<ItemViewerFilter>();
                            map.put(group, list);
                        }
                        list.add(filter);
                        continue block0;
                    }
                    ++n2;
                }
            }
            if (map.containsKey(2)) {
                ((List)map.get(2)).add(ALL_FILTER);
            }
            int[] nArray3 = groups;
            int n = groups.length;
            int n3 = 0;
            while (n3 < n) {
                int group = nArray3[n3];
                if (map.containsKey(group)) {
                    Collections.sort((List)map.get(group));
                }
                ++n3;
            }
            return map;
        }
    }

    private static class MarkReadPreferencePage
    extends MyPreferencePage {
        private FeedSectionState fTempState;

        public MarkReadPreferencePage(FeedSectionState tmpState) {
            this.fTempState = tmpState;
        }

        public String getTitle() {
            return Messages.getString("FeedSectionConfigurationDialog.MARK_READ_OPTIONS");
        }

        protected Control doCreateContents(Composite parent) {
            this.noDefaultAndApplyButton();
            Composite area = new Composite(parent, 0);
            GridLayout areaLayout = new GridLayout();
            areaLayout.marginHeight = 0;
            areaLayout.marginWidth = 0;
            area.setLayout((Layout)areaLayout);
            final Button markReadOnSlideoutButton = new Button(area, 32);
            markReadOnSlideoutButton.setText(Messages.getString("FeedSectionConfigurationDialog.MARK_READ_SLIDEOUT"));
            markReadOnSlideoutButton.setSelection(this.fTempState.isEnableMarkReadOnSlideout());
            markReadOnSlideoutButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    MarkReadPreferencePage.this.fTempState.setEnableMarkReadOnSlideout(markReadOnSlideoutButton.getSelection());
                }
            });
            Composite readAfterComp = new Composite(area, 0);
            GridLayout readAfterLayout = new GridLayout(3, false);
            readAfterLayout.marginHeight = 0;
            readAfterLayout.marginWidth = 0;
            readAfterComp.setLayout((Layout)readAfterLayout);
            readAfterComp.setLayoutData((Object)new GridData(4, 4, true, true));
            final Button markReadOnHover = new Button(readAfterComp, 32);
            markReadOnHover.setText(Messages.getString("FeedSectionConfigurationDialog.MARK_READ_DELAY"));
            markReadOnHover.setSelection(this.fTempState.isEnableMarkReadOnHover());
            final Text readAfterText = new Text(readAfterComp, 2048);
            readAfterText.setText(Integer.toString(this.fTempState.getMarkReadAfter()));
            readAfterText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    char[] chars = e.text.toCharArray();
                    int i = 0;
                    while (i < chars.length) {
                        if ('0' > chars[i] || chars[i] > '9') {
                            e.doit = false;
                            return;
                        }
                        ++i;
                    }
                }
            });
            readAfterText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    MarkReadPreferencePage.this.fTempState.setMarkReadAfter(Integer.parseInt(readAfterText.getText()));
                }
            });
            Label msLabel = new Label(readAfterComp, 0);
            msLabel.setText(Messages.getString("FeedSectionConfigurationDialog.MILLI_SECONDS"));
            markReadOnHover.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = markReadOnHover.getSelection();
                    MarkReadPreferencePage.this.fTempState.setEnableMarkReadOnHover(isSelected);
                }
            });
            Dialog.applyDialogFont((Control)area);
            return area;
        }
    }

    private static abstract class MyPreferencePage
    extends PreferencePage {
        private Control fControl;

        private MyPreferencePage() {
        }

        public Point computeSize() {
            return this.doComputeSize();
        }

        protected Point doComputeSize() {
            if (this.fControl != null && !this.fControl.isDisposed()) {
                Point size = this.fControl.computeSize(-1, -1);
                this.setSize(size);
            }
            return super.doComputeSize();
        }

        protected Control createContents(Composite parent) {
            this.fControl = this.doCreateContents(parent);
            return this.fControl;
        }

        protected abstract Control doCreateContents(Composite var1);
    }
}

