/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.setup.client.internal;

import com.ibm.team.foundation.setup.client.IProjectSetupContribution;
import com.ibm.team.foundation.setup.client.IProjectSetupDelegate;
import com.ibm.team.foundation.setup.client.ProcessDescription;
import com.ibm.team.foundation.setup.client.ProjectSetupException;
import com.ibm.team.foundation.setup.client.internal.registry.ProjectSetupDefinition;
import com.ibm.team.foundation.setup.client.internal.repository.ClientProjectSetup;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class ProjectSetupExecutor {
    public static Object executeSetup(ITeamRepository teamRepository, ProjectSetupDefinition setupDefinition, IProgressMonitor monitor) throws TeamRepositoryException, ProjectSetupException {
        IProjectSetupDelegate setupDelegate = setupDefinition.getRepositorySetupDelegate();
        Collection<IProjectSetupContribution> setupContributions = setupDefinition.getRepositorySetupContributions();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format("Setting Up ''{0}''...", setupDefinition.getName()), (int)(5 + setupContributions.size() * 11));
        try {
            ClientProjectSetup projectSetup = new ClientProjectSetup(teamRepository);
            setupDelegate.canCreateProject(projectSetup, (IProgressMonitor)progress.newChild(1));
            setupDelegate.beginProjectSetup(projectSetup, (IProgressMonitor)progress.newChild(1));
            ProcessDescription processSpec = setupDelegate.getProcessSpecificationDescription(projectSetup, (IProgressMonitor)progress.newChild(1));
            for (IProjectSetupContribution setupContribution : setupContributions) {
                setupContribution.contributeToProcessSpec(projectSetup, processSpec, (IProgressMonitor)progress.newChild(1));
            }
            for (IProjectSetupContribution setupContribution : setupContributions) {
                setupContribution.contributeArtifacts(projectSetup, processSpec, (IProgressMonitor)progress.newChild(10, 0));
            }
            setupDelegate.endProjectSetup(projectSetup, (IProgressMonitor)progress.newChild(1));
            Object object = setupDelegate.getSetupResult(projectSetup, (IProgressMonitor)progress.newChild(1));
            return object;
        }
        finally {
            monitor.done();
        }
    }
}

