/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.tools.verify;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.INameItemPair;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileSystemComparator {
    private final IFileStorage anchorRoot;
    private IPath copyFileAreaRoot;

    public FileSystemComparator(IPath copyFileAreaRoot, IFileStorage anchorRoot) {
        this.anchorRoot = anchorRoot;
        this.copyFileAreaRoot = copyFileAreaRoot;
    }

    public void assertEquals(IConnection connection, IComponentHandle component, IVersionableHandle remoteHandle, Set excludedItems) throws TeamRepositoryException, FileNotFoundException, IOException, CoreException {
        IVersionable remote = null;
        try {
            remote = FileSystemComparator.fetch(connection, component, remoteHandle);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            Assert.fail((String)("Could not find remote file system item for " + this.anchorRoot.getFullPath()));
        }
        String remoteName = this.locate(connection, component, remoteHandle);
        this.validateSharingDescriptor(connection, component, remoteName);
        HashSet itemsSeen = new HashSet();
        this.walkRemoteRepo(connection, component, remote, remoteName, excludedItems, itemsSeen, true);
        Assert.assertTrue((String)"Local root resource does not exist", (boolean)this.rootExists());
        this.walkFileSystem(new FileSystemValidator(excludedItems, itemsSeen));
        for (String name : excludedItems) {
            Assert.assertTrue((String)("Excluded item missing" + name), (boolean)this.exists(name));
        }
        Shareable localShareable = this.anchorRoot.getShareable();
        Assert.assertNotNull((String)"Missing Shareable information", (Object)localShareable);
        localShareable.accept((IShareableVisitor)new ShareableVisitor(itemsSeen), Integer.MAX_VALUE, true, false, null);
    }

    private void validateSharingDescriptor(IConnection connection, IComponentHandle component, String remoteName) throws TeamRepositoryException {
        IFileStorage storage = this.getStorage(remoteName);
        Shareable shareable = storage.getShareable();
        Assert.assertNotNull((String)"Can't validate share", (Object)shareable);
        IShare share = shareable.getShare();
        Assert.assertNotNull((String)("Item is not shared with copy file area " + remoteName), (Object)share);
        SharingDescriptor sharingDescriptor = (SharingDescriptor)share.getSharingDescriptor();
        Assert.assertNotNull((String)("Item is not shared with copy file area " + remoteName), (Object)sharingDescriptor);
        Assert.assertEquals((String)"mis-matched share component", (Object)component.getItemId(), (Object)sharingDescriptor.getComponent().getItemId());
        ISyncTime expected = null;
        FileSystemServiceProxy fss = ((FileSystemManager)FileSystemCore.getFileSystemManager((ITeamRepository)connection.teamRepository())).getFileSystemService();
        List summaries = fss.getComponentStateSummaries(connection, null);
        for (IComponentStateSummary summary : summaries) {
            if (!summary.getComponent().sameItemId((IItemHandle)component)) continue;
            expected = summary.getConfigurationTime();
            break;
        }
        Assert.assertEquals((String)"Configuration state mismatch", expected, (Object)sharingDescriptor.getConfigurationState());
    }

    protected abstract void walkFileSystem(FileSystemValidator var1) throws CoreException, IOException;

    protected abstract boolean exists(String var1);

    protected abstract boolean rootExists();

    protected abstract IFileStorage getStorage(String var1);

    public void assertEquals(IConnection connection, IComponentHandle component, IVersionableHandle remoteHandle) throws TeamRepositoryException, IOException, CoreException {
        this.assertEquals(connection, component, remoteHandle, Collections.EMPTY_SET);
    }

    public void assertEquals(ISharingDescriptor descriptor, Set<String> excludedItems) throws TeamRepositoryException, FileNotFoundException, IOException, CoreException {
        ITeamRepository repo = this.getRepo(descriptor.getRepositoryUri());
        repo.login((IProgressMonitor)new NullProgressMonitor());
        IWorkspaceConnection connection = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)descriptor.getConnectionHandle(), null);
        this.assertEquals((IConnection)connection, descriptor.getComponent(), (IVersionableHandle)descriptor.getRootFolder(), excludedItems);
        repo.logout(null);
    }

    public void assertEquals(ISharingDescriptor descriptor) throws TeamRepositoryException, IOException, CoreException {
        this.assertEquals(descriptor, Collections.EMPTY_SET);
    }

    private ITeamRepository getRepo(String uri) {
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getUnmanagedRepository(uri);
        repo.registerLoginHandler(new ITeamRepository.ILoginHandler(){

            public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repo) {
                return new ITeamRepository.ILoginHandler.ILoginInfo(){

                    public String getUserId() {
                        return "ADMIN";
                    }

                    public String getPassword() {
                        return "ADMIN";
                    }
                };
            }
        });
        return repo;
    }

    private void walkRemoteRepo(IConnection connection, IComponentHandle component, IVersionable remote, String remoteName, Set excludedItems, Set itemsSeen, boolean verifyMetaData) throws FileNotFoundException, TeamRepositoryException, IOException, CoreException {
        IFileStorage fileStorage = this.getStorage(remoteName);
        Assert.assertNotNull((String)("Remote resource missing in copy file area " + remoteName), (Object)fileStorage);
        if (verifyMetaData) {
            this.verifyMetaData(remote, fileStorage);
        }
        FileSystemComparator.assertEquals(connection, remote, fileStorage);
        boolean isFolder = remote instanceof IFolder;
        String stdName = FileSystemComparator.ResourceTestUtils_standardizePath(remoteName, isFolder);
        Assert.assertFalse((String)("Excluded item in repo " + remoteName), (boolean)excludedItems.contains(stdName));
        itemsSeen.add(stdName);
        if (isFolder) {
            Map children = connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)connection).configuration(component).childEntries((IFolderHandle)remote, null) : ((IBaselineConnection)connection).configuration().childEntries((IFolderHandle)remote, null);
            for (Map.Entry entry : children.entrySet()) {
                IVersionable child = null;
                try {
                    child = FileSystemComparator.fetch(connection, component, (IVersionableHandle)entry.getValue());
                }
                catch (TeamRepositoryException e) {
                    e.printStackTrace();
                    Assert.fail((String)("Could not find remote file system item for " + remoteName));
                }
                this.walkRemoteRepo(connection, component, child, String.valueOf(remoteName) + "/" + (String)entry.getKey(), excludedItems, itemsSeen, verifyMetaData);
            }
        }
    }

    private static String ResourceTestUtils_standardizePath(String path, boolean isFolder) {
        if (path.equals("")) {
            return "/";
        }
        if (path.charAt(0) != '/') {
            path = "/" + path;
        }
        if (isFolder && path.charAt(path.length() - 1) != '/') {
            path = String.valueOf(path) + "/";
        }
        return path;
    }

    private static IVersionable fetch(IConnection connection, IComponentHandle component, IVersionableHandle handle) throws TeamRepositoryException {
        IConfiguration config = connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)connection).configuration(component) : ((IBaselineConnection)connection).configuration();
        IVersionable child = config.fetchCompleteItem(handle, null);
        return child;
    }

    private void verifyMetaData(IVersionable remote, IFileStorage fileStorage) {
        String name = fileStorage.getFullPath().toString();
        FileItemInfo itemInfo = CopyFileAreaStore.getCopyFileArea((IPath)this.copyFileAreaRoot).getItemInfo(fileStorage.getFullPath());
        Assert.assertNotNull((String)("Missing FileItemInfo for " + name), (Object)itemInfo);
        Assert.assertEquals((String)("FileItemInfo " + name), (Object)remote.getItemId(), (Object)itemInfo.getVersionableHandle().getItemId());
        Assert.assertEquals((String)("FileItemInfo " + name), (boolean)(remote instanceof IFolder), (boolean)itemInfo.isFolder());
        if (remote instanceof IFileItem) {
            Assert.assertEquals((String)("FileItemInfo " + name), (Object)remote.getStateId(), (Object)itemInfo.getVersionableHandle().getStateId());
        }
        Shareable shareable = fileStorage.getShareable();
        Assert.assertNotNull((String)("Missing ISharable for " + name), (Object)shareable);
        Assert.assertFalse((String)("IShareable " + name + " is dirty"), (boolean)shareable.isLocallyModified());
        boolean remoteFolder = remote instanceof IFolder;
        Assert.assertTrue((String)("FileItemInfo " + name), (remoteFolder == itemInfo.isFolder() ? 1 : 0) != 0);
    }

    public static void assertEquals(IConnection connection, IVersionable remote, IFileStorage fileStorage) throws FileNotFoundException, TeamRepositoryException, IOException, CoreException {
        String name = fileStorage.getFullPath().toString();
        boolean remoteFolder = remote instanceof IFolder;
        boolean localFolder = fileStorage.isFolder();
        Assert.assertTrue((String)("Not same type " + name), (remoteFolder == localFolder ? 1 : 0) != 0);
        if (!remoteFolder) {
            IContentManager contentManager = connection.teamRepository().contentManager();
            IContent remoteContents = ((IFileItem)remote).getContent();
            ByteArrayOutputStream remoteBytes = new ByteArrayOutputStream((int)remoteContents.getEstimatedConvertedLength());
            contentManager.retrieveContent(remoteContents, (OutputStream)remoteBytes, null);
            ByteArrayOutputStream localBytes = new ByteArrayOutputStream();
            InputStream fis = fileStorage.getContents();
            FileSystemComparator.ResourceTestUtils_transferStreams(fis, localBytes);
            FileSystemComparator.assertEquals(fileStorage.getFullPath().toString(), remoteBytes.toByteArray(), localBytes.toByteArray());
        }
    }

    private static void ResourceTestUtils_transferStreams(InputStream source, OutputStream destination) throws IOException {
        block27: {
            byte[] buffer = new byte[8192];
            try {
                while (true) {
                    int bytesRead = -1;
                    bytesRead = source.read(buffer);
                    if (bytesRead != -1) {
                        destination.write(buffer, 0, bytesRead);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                block25: {
                    try {
                        try {
                            source.close();
                        }
                        catch (IOException iOException) {
                            try {
                                destination.close();
                            }
                            catch (IOException iOException2) {}
                            break block25;
                        }
                    }
                    catch (Throwable throwable2) {
                        try {
                            destination.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable2;
                    }
                    try {
                        destination.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                try {
                    source.close();
                }
                catch (IOException iOException) {
                    try {
                        destination.close();
                    }
                    catch (IOException iOException3) {}
                    break block27;
                }
            }
            catch (Throwable throwable) {
                try {
                    destination.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                destination.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void assertEquals(String path, byte[] expected, byte[] actual) {
        Assert.assertEquals((String)("content lengths do not match for " + path), (int)expected.length, (int)actual.length);
        int i = 0;
        while (i < actual.length) {
            Assert.assertEquals((String)("content does not match (" + i + "/" + actual.length + ") for " + path), (byte)expected[i], (byte)actual[i]);
            ++i;
        }
    }

    public void assertEquals(ISharingDescriptor descriptor, IVersionableHandle remoteHandle) throws TeamRepositoryException, IOException, CoreException {
        ITeamRepository repo = this.getRepo(descriptor.getRepositoryUri());
        repo.login((IProgressMonitor)new NullProgressMonitor());
        Object connection = descriptor.associatedWithWorkspace() ? SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getWorkspaceConnection((IWorkspaceHandle)descriptor.getConnectionHandle(), null) : SCMPlatform.getWorkspaceManager((ITeamRepository)repo).getBaselineConnection((IBaselineHandle)descriptor.getConnectionHandle(), null);
        this.assertEquals((IConnection)connection, descriptor.getComponent(), remoteHandle, new HashSet());
        repo.logout(null);
    }

    protected final IPath getCopyFileAreaRoot() {
        return this.copyFileAreaRoot;
    }

    public void assertLoaded(IWorkspaceConnection connection, IComponentHandle component, IVersionableHandle remoteHandle, HashSet excludes) throws TeamRepositoryException, FileNotFoundException, IOException, CoreException {
        IVersionable remote = null;
        try {
            remote = FileSystemComparator.fetch((IConnection)connection, component, remoteHandle);
        }
        catch (TeamRepositoryException e) {
            e.printStackTrace();
            Assert.fail((String)("Could not find remote file system item for " + this.anchorRoot.getFullPath()));
        }
        String remoteName = this.locate((IConnection)connection, component, remoteHandle);
        HashSet itemsSeen = new HashSet();
        this.walkRemoteRepo((IConnection)connection, component, remote, remoteName, excludes, itemsSeen, false);
        Assert.assertTrue((String)"Local root resource does not exist", (boolean)this.rootExists());
        this.walkFileSystem(new FileSystemValidator(excludes, itemsSeen));
        for (String name : excludes) {
            Assert.assertTrue((String)("Excluded item missing" + name), (boolean)this.exists(name));
        }
        Assert.assertFalse((boolean)CopyFileAreaStore.copyFileAreaExists((IPath)this.anchorRoot.getFullPath()));
    }

    private String locate(IConnection connection, IComponentHandle component, IVersionableHandle handle) throws TeamRepositoryException {
        IConfiguration configuration = connection instanceof IWorkspaceConnection ? ((IWorkspaceConnection)connection).configuration(component) : ((IBaselineConnection)connection).configuration();
        List ancestors = configuration.locateAncestors(Collections.singletonList(handle), null);
        StringBuffer buffer = new StringBuffer();
        Iterator iAncestors = ((IAncestorReport)ancestors.get(0)).getNameItemPairs().iterator();
        iAncestors.next();
        while (iAncestors.hasNext()) {
            INameItemPair pair = (INameItemPair)iAncestors.next();
            buffer.append('/').append(pair.getName());
        }
        return buffer.toString();
    }

    protected static class FileSystemValidator {
        private Set excludedItems;
        private Set itemsSeen;

        public FileSystemValidator(Set excludedItems, Set itemsSeen) {
            this.excludedItems = excludedItems;
            this.itemsSeen = itemsSeen;
        }

        public void validate(String relativePath, boolean isFolder) {
            String stdName = FileSystemComparator.ResourceTestUtils_standardizePath(relativePath, isFolder);
            Assert.assertTrue((String)("Not seen nor excluded " + stdName), (this.excludedItems.contains(stdName) || this.itemsSeen.contains(stdName) ? 1 : 0) != 0);
        }
    }

    private static class ShareableVisitor
    implements IShareableVisitor {
        private final Set itemsSeen;

        public ShareableVisitor(Set itemsSeen) {
            this.itemsSeen = itemsSeen;
        }

        public boolean visit(IShareable shareable, IProgressMonitor monitor) {
            if ((shareable.getState() & 2) != 0) {
                String stdName = FileSystemComparator.ResourceTestUtils_standardizePath(shareable.getLocalFullPath().toString(), shareable.getRemote() instanceof IFolderHandle);
                Assert.assertTrue((String)(String.valueOf(stdName) + " is said to be remote, but it is not"), (boolean)this.itemsSeen.contains(stdName));
            }
            return true;
        }
    }
}

