/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.tools.verify;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.core.subcommands.IClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.tools.verify.EclipseWorkspaceComparator;
import com.ibm.team.filesystem.cli.tools.verify.EclipseWorkspaceCompareCmdOptions;
import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;

public class EclipseWorkspaceCompareCmd
extends AbstractSubcommand {
    public void run(IClientConfiguration config) throws FileSystemClientException {
        HashSet<String> excludes = new HashSet<String>();
        List toExclude = config.getSubcommandCommandLine().getOptions(EclipseWorkspaceCompareCmdOptions.OPT_EXCLUDES);
        excludes.addAll(toExclude);
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (CoreException e) {
            throw StatusHelper.failure((String)"Refresh failed", (Throwable)e);
        }
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IShareable shareable = (IShareable)project.getAdapter(IShareable.class);
            ISharingDescriptor desc = shareable.getShare().getSharingDescriptor();
            try {
                new EclipseWorkspaceComparator((IResource)project).assertEquals(desc, excludes);
            }
            catch (Exception e) {
                throw StatusHelper.failure((String)"Compare failed", (Throwable)e);
            }
            ++n2;
        }
    }
}

