/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.utils.ILRUCache;
import com.ibm.team.filesystem.client.internal.utils.ILRUCacheable;
import com.ibm.team.filesystem.client.internal.utils.LRUCache$1;
import com.ibm.team.filesystem.client.internal.utils.LRUCache$LRUCacheEntry;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class LRUCache
implements ILRUCache {
    protected int fCurrentSpace = 0;
    protected int fSpaceLimit;
    protected int fTimestampCounter = 0;
    protected HashMap fEntryTable;
    protected LRUCache$LRUCacheEntry fEntryQueue = null;
    protected LRUCache$LRUCacheEntry fEntryQueueTail = null;
    protected static final int DEFAULT_SPACELIMIT = 100;

    public LRUCache() {
        this(100);
    }

    public LRUCache(int n) {
        this.fEntryTable = new HashMap(n);
        this.fSpaceLimit = n;
    }

    public Object clone() {
        LRUCache lRUCache = this.newInstance(this.fSpaceLimit);
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = this.fEntryQueueTail;
        while (lRUCache$LRUCacheEntry != null) {
            lRUCache.privateAdd(lRUCache$LRUCacheEntry._fKey, lRUCache$LRUCacheEntry._fValue, lRUCache$LRUCacheEntry._fSpace);
            lRUCache$LRUCacheEntry = lRUCache$LRUCacheEntry._fPrevious;
        }
        return lRUCache;
    }

    public double fillingRatio() {
        return (double)this.fCurrentSpace * 100.0 / (double)this.fSpaceLimit;
    }

    public void flush() {
        this.fCurrentSpace = 0;
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = this.fEntryQueueTail;
        this.fEntryTable = new HashMap();
        this.fEntryQueueTail = null;
        this.fEntryQueue = null;
        while (lRUCache$LRUCacheEntry != null) {
            this.privateNotifyDeletionFromCache(lRUCache$LRUCacheEntry);
            if (!$assertionsDisabled && lRUCache$LRUCacheEntry == lRUCache$LRUCacheEntry._fPrevious) {
                throw (Throwable)((Object)new AssertionError());
            }
            lRUCache$LRUCacheEntry = lRUCache$LRUCacheEntry._fPrevious;
        }
    }

    public void flush(Object object) {
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = (LRUCache$LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCache$LRUCacheEntry == null) {
            return;
        }
        this.privateRemoveEntry(lRUCache$LRUCacheEntry, false);
    }

    public Object get(Object object) {
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = (LRUCache$LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCache$LRUCacheEntry == null) {
            return null;
        }
        this.updateTimestamp(lRUCache$LRUCacheEntry);
        return lRUCache$LRUCacheEntry._fValue;
    }

    public boolean containsKey(Object object) {
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = (LRUCache$LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCache$LRUCacheEntry == null) {
            return false;
        }
        this.updateTimestamp(lRUCache$LRUCacheEntry);
        return true;
    }

    public int getCurrentSpace() {
        return this.fCurrentSpace;
    }

    public int getSpaceLimit() {
        return this.fSpaceLimit;
    }

    public Iterator keys() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.fEntryTable.keySet());
        return new LRUCache$1(this, linkedList);
    }

    /*
     * Unable to fully structure code
     */
    protected boolean makeSpace(int var1_1) {
        var2_2 = this.getSpaceLimit();
        if (this.fCurrentSpace + var1_1 <= var2_2) {
            return true;
        }
        if (var1_1 <= var2_2) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            this.privateRemoveEntry(this.fEntryQueueTail, false);
lbl7:
            // 2 sources

            ** while (this.fCurrentSpace + var1_1 > var2_2 && this.fEntryQueueTail != null)
        }
lbl8:
        // 1 sources

        return true;
    }

    protected LRUCache newInstance(int n) {
        return new LRUCache(n);
    }

    public Object peek(Object object) {
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = (LRUCache$LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCache$LRUCacheEntry == null) {
            return null;
        }
        return lRUCache$LRUCacheEntry._fValue;
    }

    protected void privateAdd(Object object, Object object2, int n) {
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = new LRUCache$LRUCacheEntry(object, object2, n);
        this.privateAddEntry(lRUCache$LRUCacheEntry, false);
    }

    protected void privateAddEntry(LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry, boolean bl) {
        if (!bl) {
            this.fEntryTable.put(lRUCache$LRUCacheEntry._fKey, lRUCache$LRUCacheEntry);
            this.fCurrentSpace += lRUCache$LRUCacheEntry._fSpace;
        }
        lRUCache$LRUCacheEntry._fTimestamp = this.fTimestampCounter++;
        lRUCache$LRUCacheEntry._fNext = this.fEntryQueue;
        lRUCache$LRUCacheEntry._fPrevious = null;
        if (this.fEntryQueue == null) {
            this.fEntryQueueTail = lRUCache$LRUCacheEntry;
        } else {
            this.fEntryQueue._fPrevious = lRUCache$LRUCacheEntry;
        }
        this.fEntryQueue = lRUCache$LRUCacheEntry;
    }

    protected void privateNotifyDeletionFromCache(LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry) {
    }

    protected void privateRemoveEntry(LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry, boolean bl) {
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry2 = lRUCache$LRUCacheEntry._fPrevious;
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry3 = lRUCache$LRUCacheEntry._fNext;
        if (!bl) {
            this.fEntryTable.remove(lRUCache$LRUCacheEntry._fKey);
            this.fCurrentSpace -= lRUCache$LRUCacheEntry._fSpace;
            this.privateNotifyDeletionFromCache(lRUCache$LRUCacheEntry);
        }
        if (lRUCache$LRUCacheEntry2 == null) {
            this.fEntryQueue = lRUCache$LRUCacheEntry3;
        } else {
            lRUCache$LRUCacheEntry2._fNext = lRUCache$LRUCacheEntry3;
        }
        if (lRUCache$LRUCacheEntry3 == null) {
            this.fEntryQueueTail = lRUCache$LRUCacheEntry2;
        } else {
            lRUCache$LRUCacheEntry3._fPrevious = lRUCache$LRUCacheEntry2;
        }
    }

    public Object put(Object object, Object object2) {
        int n = this.spaceFor(object2);
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = (LRUCache$LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCache$LRUCacheEntry != null) {
            int n2 = lRUCache$LRUCacheEntry._fSpace;
            int n3 = this.getCurrentSpace() - n2 + n;
            if (n3 <= this.getSpaceLimit()) {
                this.updateTimestamp(lRUCache$LRUCacheEntry);
                lRUCache$LRUCacheEntry._fValue = object2;
                lRUCache$LRUCacheEntry._fSpace = n;
                this.fCurrentSpace = n3;
                return object2;
            }
            this.privateRemoveEntry(lRUCache$LRUCacheEntry, false);
        }
        if (this.makeSpace(n)) {
            this.privateAdd(object, object2, n);
        }
        return object2;
    }

    public Object removeKey(Object object) {
        LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry = (LRUCache$LRUCacheEntry)this.fEntryTable.get(object);
        if (lRUCache$LRUCacheEntry == null) {
            return null;
        }
        Object object2 = lRUCache$LRUCacheEntry._fValue;
        this.privateRemoveEntry(lRUCache$LRUCacheEntry, false);
        return object2;
    }

    public void setSpaceLimit(int n) {
        if (n < this.fSpaceLimit) {
            this.makeSpace(this.fSpaceLimit - n);
        }
        this.fSpaceLimit = n;
    }

    protected int spaceFor(Object object) {
        if (object instanceof ILRUCacheable) {
            return ((ILRUCacheable)object).getCacheFootprint();
        }
        return 1;
    }

    public String toString() {
        return this.toStringFillingRation("LRUCache");
    }

    public String toStringFillingRation(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('[');
        stringBuffer.append(this.getSpaceLimit());
        stringBuffer.append("]: ");
        stringBuffer.append(NumberFormat.getInstance().format(this.fillingRatio()));
        stringBuffer.append("% full");
        return stringBuffer.toString();
    }

    protected void updateTimestamp(LRUCache$LRUCacheEntry lRUCache$LRUCacheEntry) {
        lRUCache$LRUCacheEntry._fTimestamp = this.fTimestampCounter++;
        if (this.fEntryQueue != lRUCache$LRUCacheEntry) {
            this.privateRemoveEntry(lRUCache$LRUCacheEntry, true);
            this.privateAddEntry(lRUCache$LRUCacheEntry, true);
        }
    }
}

