/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.scm.client.ContextLock;
import com.ibm.team.scm.common.IContextHandle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantLock;

public class FlowNodeLock {
    private HashMap contextsToReadLock;
    private HashMap contextsToWriteLock;
    private HashSet configurationsToReadLock;
    private HashSet configurationsToWriteLock;
    private boolean hasLocked = false;
    private ContextLock locks;
    private Collection determinantsForLockDecisions = new ArrayList();
    private final ReentrantLock lock = new ReentrantLock();

    public void toReadLock(IContextHandle iContextHandle) {
        if (iContextHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            if (this.hasLocked) {
                throw (Throwable)new IllegalStateException();
            }
            if (this.contextsToWriteLock != null && this.contextsToWriteLock.get(iContextHandle.getItemId()) != null) {
                throw (Throwable)new IllegalStateException();
            }
            if (this.contextsToReadLock == null) {
                this.contextsToReadLock = new HashMap();
            }
            this.contextsToReadLock.put(iContextHandle.getItemId(), iContextHandle);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addDeterminants(Collection collection) {
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            this.determinantsForLockDecisions.addAll(collection);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void toReadLock(ConfigurationDescriptor configurationDescriptor) {
        if (configurationDescriptor == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            if (this.hasLocked) {
                throw (Throwable)new IllegalStateException();
            }
            if (this.configurationsToWriteLock != null && this.configurationsToWriteLock.contains(configurationDescriptor)) {
                throw (Throwable)new IllegalStateException();
            }
            if (this.configurationsToReadLock == null) {
                this.configurationsToReadLock = new HashSet();
            }
            this.configurationsToReadLock.add(configurationDescriptor);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void toWriteLock(IContextHandle iContextHandle) {
        if (iContextHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            if (this.hasLocked) {
                throw (Throwable)new IllegalStateException();
            }
            if (this.contextsToReadLock != null && this.contextsToReadLock.get(iContextHandle.getItemId()) != null) {
                throw (Throwable)new IllegalStateException();
            }
            if (this.contextsToWriteLock == null) {
                this.contextsToWriteLock = new HashMap();
            }
            this.contextsToWriteLock.put(iContextHandle.getItemId(), iContextHandle);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void toWriteLock(ConfigurationDescriptor configurationDescriptor) {
        if (configurationDescriptor == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            if (this.hasLocked) {
                throw (Throwable)new IllegalStateException();
            }
            if (this.configurationsToReadLock != null && this.configurationsToReadLock.contains(configurationDescriptor)) {
                throw (Throwable)new IllegalStateException();
            }
            if (this.configurationsToWriteLock == null) {
                this.configurationsToWriteLock = new HashSet();
            }
            this.configurationsToWriteLock.add(configurationDescriptor);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void acquire() {
        block18: {
            ContextLock contextLock = null;
            boolean bl = false;
            boolean bl2 = false;
            try {
                this.lock.lock();
                try {
                    if (this.hasLocked) {
                        throw (Throwable)new IllegalStateException();
                    }
                    this.hasLocked = true;
                    if (this.needReadLocks() && this.needWriteLocks()) {
                        contextLock = new ContextLock();
                        this.populateWriteLock(contextLock, this.contextsToWriteLock, this.configurationsToWriteLock);
                        this.populateReadLock(contextLock, this.contextsToReadLock, this.configurationsToReadLock);
                    } else if (this.needReadLocks()) {
                        contextLock = new ContextLock();
                        this.populateReadLock(contextLock, this.contextsToReadLock, this.configurationsToReadLock);
                    } else if (this.needWriteLocks()) {
                        contextLock = new ContextLock();
                        this.populateWriteLock(contextLock, this.contextsToWriteLock, this.configurationsToWriteLock);
                    }
                }
                finally {
                    this.lock.unlock();
                }
                if (contextLock == null) break block18;
                contextLock.acquire();
                bl = true;
                this.lock.lock();
                try {
                    if (this.locks != null) {
                        throw (Throwable)new IllegalStateException();
                    }
                    this.locks = contextLock;
                    bl2 = true;
                }
                finally {
                    this.lock.unlock();
                }
            }
            finally {
                if (contextLock != null && bl && !bl2) {
                    contextLock.release();
                }
            }
        }
    }

    private boolean needWriteLocks() {
        return this.configurationsToWriteLock != null || this.contextsToWriteLock != null;
    }

    private boolean needReadLocks() {
        return this.configurationsToReadLock != null || this.contextsToReadLock != null;
    }

    private void populateWriteLock(ContextLock contextLock, HashMap hashMap, HashSet hashSet) {
        if (hashMap != null) {
            for (Object object : hashMap.values()) {
                contextLock.addExclusive(object);
            }
        }
        if (hashSet != null) {
            for (Object object : hashSet) {
                contextLock.addExclusive(object.connectionHandle, object.componentHandle);
            }
        }
    }

    private void populateReadLock(ContextLock contextLock, HashMap hashMap, HashSet hashSet) {
        if (hashMap != null) {
            for (Object object : hashMap.values()) {
                contextLock.addShared(object);
            }
        }
        if (hashSet != null) {
            for (Object object : hashSet) {
                contextLock.addShared(object.connectionHandle, object.componentHandle);
            }
        }
    }

    public void release() {
        this.lock.lock();
        try {
            if (this.locks != null) {
                this.locks.release();
            }
            this.hasLocked = false;
        }
        finally {
            this.lock.unlock();
        }
    }
}

