/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.utils;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.utils.LineDelimiterUtil;
import com.ibm.team.repository.common.utils.ReaderToInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.runtime.IProgressMonitor;

public class FileContentInputStream
extends InputStream {
    private InputStream underlyingInputStream = null;
    private ITeamRepository repository;
    private IContent content;
    private LineDelimiter desiredLineDelimiter;
    private final IProgressMonitor monitor;

    public FileContentInputStream(ITeamRepository repository, IContent content, IProgressMonitor monitor) {
        this(repository, content, content.getLineDelimiter(), monitor);
    }

    public FileContentInputStream(ITeamRepository repository, IContent content, LineDelimiter desiredLineDelimiter, IProgressMonitor monitor) {
        this.repository = repository;
        this.content = content;
        this.desiredLineDelimiter = desiredLineDelimiter;
        this.monitor = monitor;
    }

    public int available() throws IOException {
        if (this.underlyingInputStream == null) {
            return 0;
        }
        return this.underlyingInputStream.available();
    }

    public int read() throws IOException {
        InputStream underlyingStream = this.getUnderlyingStream();
        return underlyingStream.read();
    }

    private InputStream getUnderlyingStream() throws IOException {
        if (this.underlyingInputStream == null) {
            try {
                this.underlyingInputStream = this.repository.contentManager().retrieveContentStream(this.content, this.monitor);
            }
            catch (TeamRepositoryException e) {
                IOException ex = new IOException(e.getMessage());
                ex.initCause(e);
                throw ex;
            }
            if (!(this.content.getLineDelimiter() == this.desiredLineDelimiter || this.content.getLineDelimiter() == LineDelimiter.LINE_DELIMITER_PLATFORM && LineDelimiter.getPlatformDelimiter() == this.desiredLineDelimiter || this.desiredLineDelimiter == LineDelimiter.LINE_DELIMITER_PLATFORM && this.content.getLineDelimiter() == LineDelimiter.getPlatformDelimiter() || this.desiredLineDelimiter == LineDelimiter.LINE_DELIMITER_NONE)) {
                this.underlyingInputStream = new ReaderToInputStream((InputStreamReader)LineDelimiterUtil.getNonVerifyingLineDelimiterConverter((InputStream)this.underlyingInputStream, (String)this.content.getCharacterEncoding(), (LineDelimiter)this.desiredLineDelimiter));
            }
        }
        InputStream underlyingStream = this.underlyingInputStream;
        return underlyingStream;
    }

    public int read(byte[] b) throws IOException {
        return this.getUnderlyingStream().read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.getUnderlyingStream().read(b, off, len);
    }

    public synchronized void reset() throws IOException {
        this.getUnderlyingStream().reset();
    }

    public long skip(long n) throws IOException {
        return this.getUnderlyingStream().skip(n);
    }

    public void close() throws IOException {
        if (this.underlyingInputStream != null) {
            this.underlyingInputStream.close();
            this.underlyingInputStream = null;
        }
        super.close();
    }
}

