/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.ShareOutOfSync;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.ConnectionDescriptor;
import com.ibm.team.filesystem.client.operations.IShareOutOfSync;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.ICurrentComponentInfo;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class VerifySharesOperation
extends FileSystemOperation
implements IVerifyInSyncOperation {
    private boolean alreadyExecuted;
    protected final OutOfSyncDilemmaHandler verifyInSyncDilemmaHandler;
    protected final IPath copyFileAreaRoot;
    private boolean verifyAgainstCache;
    private HashMap connectionsToVerify;
    private HashMap configurationsToVerify;
    private ArrayList sharesToVerify;
    private ArrayList shareConnections;
    private HashMap connectionComponentStates;

    public VerifySharesOperation(IPath iPath, OutOfSyncDilemmaHandler outOfSyncDilemmaHandler) {
        super(outOfSyncDilemmaHandler == null ? OutOfSyncDilemmaHandler.getDefault() : outOfSyncDilemmaHandler);
        this.verifyInSyncDilemmaHandler = outOfSyncDilemmaHandler == null ? OutOfSyncDilemmaHandler.getDefault() : outOfSyncDilemmaHandler;
        this.verifyAgainstCache = false;
        this.copyFileAreaRoot = iPath;
        this.connectionsToVerify = new HashMap();
        this.configurationsToVerify = new HashMap();
        this.sharesToVerify = new ArrayList();
        this.shareConnections = new ArrayList();
        this.connectionComponentStates = new HashMap();
    }

    public void setVerifyAgainstCache(boolean bl) {
        this.verifyAgainstCache = bl;
    }

    public void addToVerify(IWorkspaceConnection iWorkspaceConnection) {
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.connectionsToVerify.put(iWorkspaceConnection.getContextHandle().getItemId(), iWorkspaceConnection);
    }

    public void addToVerify(IConnection iConnection, IComponentHandle iComponentHandle) {
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iComponentHandle == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.configurationsToVerify.put(new ConfigurationDescriptor(iConnection, iComponentHandle), iConnection);
    }

    public void addToVerify(IConnection iConnection, Collection collection) {
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        for (IShare iShare : collection) {
            if (!iShare.getSharingDescriptor().isAssociatedWithConnection(iConnection)) {
                throw (Throwable)new IllegalArgumentException();
            }
            this.shareConnections.add(iConnection);
            this.sharesToVerify.add(iShare);
        }
    }

    public void addToVerify(IConnection iConnection, IShare iShare) {
        if (iShare == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (!iShare.getSharingDescriptor().isAssociatedWithConnection(iConnection)) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.shareConnections.add(iConnection);
        this.sharesToVerify.add(iShare);
    }

    public void addToVerifyAgainst(IConnection iConnection, Collection collection) {
        Object object2;
        IWorkspace iWorkspace;
        if (iConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iConnection instanceof IWorkspaceConnection) {
            iWorkspace = ((IWorkspaceConnection)iConnection).getResolvedWorkspace();
        } else if (iConnection instanceof IBaselineConnection) {
            iWorkspace = ((IBaselineConnection)iConnection).getBaseline();
        } else {
            throw (Throwable)new IllegalArgumentException();
        }
        for (Object object2 : collection) {
            if (object2 != null) continue;
            throw (Throwable)new IllegalArgumentException();
        }
        object2 = (HashMap)this.connectionComponentStates.get(iWorkspace.getItemId());
        if (object2 == null) {
            object2 = new HashMap();
            this.connectionComponentStates.put(iWorkspace.getItemId(), object2);
        }
        for (IComponentStateSummary iComponentStateSummary : collection) {
            ((HashMap)object2).put(iComponentStateSummary.getComponent().getItemId(), iComponentStateSummary.getConfigurationTime());
        }
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        if (this.alreadyExecuted) {
            throw (Throwable)new IllegalStateException();
        }
        this.alreadyExecuted = true;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        if (this.sharesToVerify.isEmpty() && this.configurationsToVerify.isEmpty() && this.connectionsToVerify.isEmpty()) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)200);
        this.getComponentStatesToVerifyAgainst((IProgressMonitor)subMonitor.newChild(50));
        HashMap hashMap = this.verifyShares((IProgressMonitor)subMonitor.newChild(25));
        HashMap hashMap2 = new HashMap(hashMap);
        HashMap hashMap3 = this.verifyConnections(hashMap2, (IProgressMonitor)subMonitor.newChild(25));
        if (!hashMap2.isEmpty()) {
            this.handleOutOfSyncShares(hashMap, hashMap3, hashMap2, (IProgressMonitor)subMonitor.newChild(100));
        }
        if (iProgressMonitor.isCanceled()) {
            throw (Throwable)new OperationCanceledException();
        }
    }

    private void getComponentStatesToVerifyAgainst(IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        block9: {
            SubMonitor subMonitor;
            block8: {
                IConnection iConnection;
                Object object2;
                subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(2 * (this.sharesToVerify.size() + this.configurationsToVerify.size() + this.connectionsToVerify.size())));
                if (!this.verifyAgainstCache) break block8;
                for (Object object2 : this.connectionsToVerify.values()) {
                    for (Object object3 : object2.getComponentsInfo()) {
                        this.addSyncTime((IContextHandle)object2.getResolvedWorkspace(), object3.getComponent(), object3.configurationTime());
                    }
                }
                for (Object object2 : this.configurationsToVerify.keySet()) {
                    Object object3;
                    object3 = ((ConnectionDescriptor)object2).getConnection((IProgressMonitor)subMonitor.newChild(1));
                    if (object3 instanceof IBaselineConnection) {
                        this.addSyncTime(object3.getContextHandle(), ((IBaselineConnection)object3).getComponent(), ISyncTime.FACTORY.getConfigTimeFor((IBaselineHandle)((IBaselineConnection)object3).getResolvedBaseline(), null));
                        continue;
                    }
                    iConnection = ((IWorkspaceConnection)object3).getComponentInfo(((ConfigurationDescriptor)object2).componentHandle);
                    this.addSyncTime(object3.getContextHandle(), ((ConfigurationDescriptor)object2).componentHandle, iConnection.configurationTime());
                }
                object2 = this.shareConnections.iterator();
                for (Object object4 : this.sharesToVerify) {
                    iConnection = (IConnection)object2.next();
                    if (iConnection instanceof IBaselineConnection) {
                        this.addSyncTime(iConnection.getContextHandle(), ((IBaselineConnection)iConnection).getComponent(), ISyncTime.FACTORY.getConfigTimeFor((IBaselineHandle)((IBaselineConnection)iConnection).getResolvedBaseline(), null));
                        continue;
                    }
                    ISharingDescriptor iSharingDescriptor = object4.getSharingDescriptor();
                    ICurrentComponentInfo iCurrentComponentInfo = ((IWorkspaceConnection)iConnection).getComponentInfo(iSharingDescriptor.getComponent());
                    this.addSyncTime(iConnection.getContextHandle(), iSharingDescriptor.getComponent(), iCurrentComponentInfo.configurationTime());
                }
                break block9;
            }
            if (!this.connectionComponentStates.isEmpty()) break block9;
            HashSet hashSet = new HashSet();
            hashSet.addAll(this.connectionsToVerify.values());
            hashSet.addAll(this.configurationsToVerify.values());
            hashSet.addAll(this.shareConnections);
            for (IConnection iConnection : hashSet) {
                FileSystemServiceProxy fileSystemServiceProxy = ((FileSystemManager)FileSystemCore.getFileSystemManager(iConnection.teamRepository())).getFileSystemService();
                List list = fileSystemServiceProxy.getComponentStateSummaries(iConnection, (IProgressMonitor)subMonitor.newChild(1));
                for (IComponentStateSummary iComponentStateSummary : list) {
                    this.addSyncTime(iConnection.getContextHandle(), iComponentStateSummary.getComponent(), iComponentStateSummary.getConfigurationTime());
                }
            }
        }
    }

    private void addSyncTime(IContextHandle iContextHandle, IComponentHandle iComponentHandle, ISyncTime iSyncTime) {
        HashMap<UUID, ISyncTime> hashMap = (HashMap<UUID, ISyncTime>)this.connectionComponentStates.get(iContextHandle.getItemId());
        if (hashMap == null) {
            hashMap = new HashMap<UUID, ISyncTime>();
            this.connectionComponentStates.put(iContextHandle.getItemId(), hashMap);
        }
        hashMap.put(iComponentHandle.getItemId(), iSyncTime);
    }

    private HashMap verifyShares(IProgressMonitor iProgressMonitor) {
        HashMap hashMap = new HashMap();
        Iterator iterator = this.shareConnections.iterator();
        for (IShare iShare : this.sharesToVerify) {
            IConnection iConnection = (IConnection)iterator.next();
            this.validShare(iConnection, iShare, hashMap);
        }
        return hashMap;
    }

    private boolean validShare(IConnection iConnection, IShare iShare, HashMap hashMap) {
        SharingDescriptor sharingDescriptor = (SharingDescriptor)iShare.getSharingDescriptor();
        HashMap hashMap2 = (HashMap)this.connectionComponentStates.get(sharingDescriptor.getConnectionHandle().getItemId());
        ISyncTime iSyncTime = (ISyncTime)hashMap2.get(sharingDescriptor.getComponent().getItemId());
        if (!sharingDescriptor.getConfigurationState().equals(iSyncTime)) {
            String string = iShare.getPath().toString();
            hashMap.put(string, new ShareOutOfSync(iShare));
            return false;
        }
        return true;
    }

    private HashMap verifyConnections(HashMap hashMap, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IShare[] iShareArray;
        HashMap hashMap2 = new HashMap();
        IShare[] iShareArray2 = iShareArray = SharingManager.getInstance().allShares(this.copyFileAreaRoot);
        int n = iShareArray.length;
        int n2 = 0;
        while (n2 < n) {
            HashMap hashMap3;
            IShare iShare = iShareArray2[n2];
            SharingDescriptor sharingDescriptor = (SharingDescriptor)iShare.getSharingDescriptor();
            IConnection iConnection = (IConnection)this.connectionsToVerify.get(sharingDescriptor.getConnectionHandle().getItemId());
            if (iConnection != null && !this.validShare(iConnection, iShare, hashMap)) {
                hashMap3 = (HashMap)hashMap2.get(iConnection);
                if (hashMap3 == null) {
                    hashMap3 = new HashMap();
                    hashMap2.put(iConnection, hashMap3);
                }
                hashMap3.put(sharingDescriptor.getComponent().getItemId(), sharingDescriptor.getComponent());
            }
            if (!this.configurationsToVerify.isEmpty() && (iConnection = (IConnection)this.configurationsToVerify.get(hashMap3 = new ConfigurationDescriptor(sharingDescriptor.getRepositoryId(), sharingDescriptor.getRepositoryUri(), sharingDescriptor.getConnectionHandle(), sharingDescriptor.getComponent()))) != null && !this.validShare(iConnection, iShare, hashMap)) {
                HashMap<UUID, IComponentHandle> hashMap4 = (HashMap<UUID, IComponentHandle>)hashMap2.get(iConnection);
                if (hashMap4 == null) {
                    hashMap4 = new HashMap<UUID, IComponentHandle>();
                    hashMap2.put(iConnection, hashMap4);
                }
                hashMap4.put(sharingDescriptor.getComponent().getItemId(), sharingDescriptor.getComponent());
            }
            ++n2;
        }
        return hashMap2;
    }

    private void handleOutOfSyncShares(HashMap hashMap, HashMap hashMap2, HashMap hashMap3, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        int n = this.verifyInSyncDilemmaHandler.outOfSync(Collections.unmodifiableCollection(hashMap3.values()));
        if (n == 100) {
            this.reloadOutOfSync(hashMap, hashMap2, hashMap3, iProgressMonitor);
        } else if (n != 1) {
            IShareOutOfSync iShareOutOfSync2;
            IStatus[] iStatusArray = new IStatus[hashMap3.size()];
            int n2 = 0;
            for (IShareOutOfSync iShareOutOfSync2 : hashMap3.values()) {
                iStatusArray[n2] = new FileSystemStatus(1, 208, NLS.bind((String)Messages.VerifySharesOperation_0, (Object)iShareOutOfSync2.getShare().getPath().toString()));
                ++n2;
            }
            iShareOutOfSync2 = new MultiStatus("com.ibm.team.filesystem.client", 4, iStatusArray, Messages.VerifySharesOperation_1, null);
            if (n == 0) {
                LoggingHelper.log((IStatus)iShareOutOfSync2);
            } else {
                this.collectStatus((IStatus)iShareOutOfSync2);
            }
        } else {
            throw (Throwable)new OperationCanceledException();
        }
    }

    protected void reloadOutOfSync(HashMap hashMap, HashMap hashMap2, HashMap hashMap3, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        iProgressMonitor.done();
    }
}

