/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.CopyFileAreaLockUtil;
import com.ibm.team.filesystem.client.operations.UpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.SharePoint;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.dto.IComponentStateSummary;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import com.ibm.team.scm.common.dto.IUpdateReport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public abstract class UpdateOperation
extends FileSystemOperation {
    private final List updateReports;
    private final HashSet affectedComponents;
    private final IWorkspaceConnection connection;
    public static final int PROCESS_UPDATES = 1;
    public static final int PROCESS_INCIDENTAL_UPDATES = 2;
    public static final int PROCESS_ALL_UPDATES = 3;
    private final int updatesToProcess;
    private int updateCount;
    private HashMap excludedComponents;
    private ISynchronizationInfo synchronizationInfo;
    protected final UpdateDilemmaHandler problemHandler;

    protected UpdateOperation(IWorkspaceConnection iWorkspaceConnection, List list, Collection collection, int n, UpdateDilemmaHandler updateDilemmaHandler) {
        super(updateDilemmaHandler == null ? UpdateDilemmaHandler.getDefault() : updateDilemmaHandler);
        UpdateDilemmaHandler updateDilemmaHandler2 = this.problemHandler = updateDilemmaHandler == null ? UpdateDilemmaHandler.getDefault() : updateDilemmaHandler;
        if (iWorkspaceConnection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (list == null || list.isEmpty()) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (collection == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if ((n | 3) != 3 || n == 0) {
            throw (Throwable)new IllegalArgumentException();
        }
        this.excludedComponents = new HashMap();
        for (Object object : collection) {
            this.excludedComponents.put(object.getItemId(), object);
        }
        this.connection = iWorkspaceConnection;
        this.updateReports = list;
        this.affectedComponents = new HashSet();
        for (Iterator iterator : list) {
            if (!(iterator instanceof IUpdateReport)) {
                throw (Throwable)new IllegalArgumentException();
            }
            IUpdateReport iUpdateReport = (IUpdateReport)iterator;
            for (IComponentHandle iComponentHandle : iUpdateReport.getAffectedComponents()) {
                this.affectedComponents.add(new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iComponentHandle));
            }
            for (IComponentHandle iComponentHandle : iUpdateReport.getComponentStatesBefore()) {
                this.affectedComponents.add(new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iComponentHandle.getComponent()));
            }
            for (IComponentHandle iComponentHandle : iUpdateReport.getComponentStatesAfter()) {
                this.affectedComponents.add(new ConfigurationDescriptor((IConnection)iWorkspaceConnection, iComponentHandle.getComponent()));
            }
        }
        int n2 = 0;
        if ((n & 1) == 1) {
            n2 |= 1;
        }
        if ((n & 2) == 2) {
            n2 |= 2;
        }
        this.updatesToProcess = n2;
    }

    public void setSynchronizationInfo(ISynchronizationInfo iSynchronizationInfo) {
        this.synchronizationInfo = iSynchronizationInfo;
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        iProgressMonitor.setTaskName(Messages.UpdateOperation_0);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(10 + 100 * this.updateReports.size()));
        CopyFileAreaStore copyFileAreaStore = this.getCopyFileArea();
        ISchedulingRule iSchedulingRule = CopyFileAreaLockUtil.getCopyFileAreaLock(copyFileAreaStore, this.getAffectedConfigurations(), (IProgressMonitor)subMonitor.newChild(1));
        try {
            Collection collection = this.getAdditionalComponentsToExclude(this.connection, this.excludedComponents.values(), this.updateReports);
            for (IComponentHandle iComponentHandle : collection) {
                this.excludedComponents.put(iComponentHandle.getItemId(), iComponentHandle);
            }
            FileSystemServiceProxy fileSystemServiceProxy = ((FileSystemManager)FileSystemCore.getFileSystemManager(this.connection.teamRepository())).getFileSystemService();
            this.verifyShares((IProgressMonitor)subMonitor.newChild(8));
            int n = 0;
            try {
                int n2 = this.updateReports.size();
                int n3 = 1;
                iProgressMonitor.setTaskName(Messages.UpdateOperation_1);
                SharingManager.getInstance().disableChangeMonitoring();
                for (IUpdateReport iUpdateReport : this.updateReports) {
                    if (n2 > 1) {
                        iProgressMonitor.setTaskName(NLS.bind((String)Messages.UpdateOperation_2, (Object)n3, (Object)n2));
                    }
                    try {
                        IComponentHandle iComponentHandle;
                        Collection collection2 = this.getSharePoints(iUpdateReport, (IProgressMonitor)subMonitor.newChild(1));
                        iComponentHandle = fileSystemServiceProxy.incrementalFileLoadStream(this.connection, iUpdateReport, this.excludedComponents.values(), collection2, true, this.updatesToProcess, this.synchronizationInfo, (IProgressMonitor)subMonitor.newChild(50));
                        this.loadFileArea(this.connection, iUpdateReport.getComponentStatesBefore(), iUpdateReport.getComponentStatesAfter(), (FileAreaUpdateReport)iComponentHandle, (IProgressMonitor)subMonitor.newChild(49));
                        this.updateCount += iComponentHandle.getAdds().size() + iComponentHandle.getDeletes().size() + iComponentHandle.getModifies().size() + iComponentHandle.getMoves().size();
                        ++n;
                    }
                    catch (FileSystemClientException fileSystemClientException) {
                        this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
                    }
                    catch (TeamRepositoryException teamRepositoryException) {
                        this.collectStatus(FileSystemStatus.getStatusFor(4, Messages.UpdateOperation_3, (Throwable)teamRepositoryException));
                    }
                }
            }
            finally {
                SharingManager.getInstance().enableChangeMonitoring();
                copyFileAreaStore.sync();
            }
        }
        finally {
            copyFileAreaStore.release(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    private Collection getSharePoints(IUpdateReport iUpdateReport, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)iUpdateReport.getAffectedComponents().size());
        ArrayList<SharePoint> arrayList = new ArrayList<SharePoint>();
        for (IComponentHandle iComponentHandle : iUpdateReport.getAffectedComponents()) {
            if (this.excludedComponents.containsKey(iComponentHandle.getItemId())) continue;
            ISharingManager iSharingManager = FileSystemCore.getSharingManager();
            try {
                Collection collection = iSharingManager.getShares(iSharingManager.getDefaultCFARoot(), this.connection.getContextHandle(), iComponentHandle, (IProgressMonitor)subMonitor.newChild(1));
                for (ISharingDescriptor iSharingDescriptor : collection) {
                    SharePoint sharePoint = FilesystemDTOFactory.eINSTANCE.createSharePoint();
                    sharePoint.setContext(this.connection.getContextHandle());
                    sharePoint.setComponent(iComponentHandle);
                    sharePoint.setVersionable((IVersionableHandle)iSharingDescriptor.getRootFolder());
                    arrayList.add(sharePoint);
                }
            }
            catch (FileSystemClientException fileSystemClientException) {
                this.collectStatus(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
            }
        }
        return arrayList;
    }

    protected final Collection getAffectedConfigurations() {
        return this.affectedComponents;
    }

    private void verifyShares(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        if (!this.verifyInSyncEnabled() || this.problemHandler.willIgnoreAllSharesOutOfSync()) {
            iProgressMonitor.done();
            return;
        }
        VerifySharesOperation verifySharesOperation = new VerifySharesOperation(this.getCopyFileArea().getRoot(), this.problemHandler);
        HashMap<UUID, IComponentHandle> hashMap = new HashMap<UUID, IComponentHandle>();
        for (IUpdateReport iUpdateReport : this.updateReports) {
            Object object2;
            if (this.excludedComponents.isEmpty()) {
                for (Object object2 : iUpdateReport.getAffectedComponents()) {
                    verifySharesOperation.addToVerify((IConnection)this.connection, (IComponentHandle)object2);
                }
            } else {
                for (IComponentHandle iComponentHandle : iUpdateReport.getAffectedComponents()) {
                    if (this.excludedComponents.containsKey(iComponentHandle.getItemId())) continue;
                    verifySharesOperation.addToVerify((IConnection)this.connection, iComponentHandle);
                }
            }
            object2 = iUpdateReport.getComponentStatesBefore().iterator();
            while (object2.hasNext()) {
                IComponentHandle iComponentHandle;
                iComponentHandle = (IComponentStateSummary)object2.next();
                if (hashMap.get(iComponentHandle.getComponent().getItemId()) != null) continue;
                hashMap.put(iComponentHandle.getComponent().getItemId(), iComponentHandle);
            }
        }
        verifySharesOperation.addToVerifyAgainst((IConnection)this.connection, hashMap.values());
        verifySharesOperation.run(iProgressMonitor);
    }

    protected abstract CopyFileAreaStore getCopyFileArea();

    protected abstract void loadFileArea(IWorkspaceConnection var1, Collection var2, Collection var3, FileAreaUpdateReport var4, IProgressMonitor var5) throws FileSystemClientException, TeamRepositoryException;

    private Collection getAdditionalComponentsToExclude(IWorkspaceConnection iWorkspaceConnection, Collection collection, List list) {
        IWorkspace iWorkspace2;
        HashMap<UUID, IComponentHandle> hashMap = new HashMap<UUID, IComponentHandle>();
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (IWorkspace iWorkspace2 : collection) {
            hashSet.add(iWorkspace2.getItemId());
        }
        iWorkspace2 = iWorkspaceConnection.getResolvedWorkspace();
        for (IUpdateReport iUpdateReport : list) {
            for (IComponentHandle iComponentHandle : iUpdateReport.getAffectedComponents()) {
                if (hashSet.contains(iComponentHandle.getItemId())) continue;
                try {
                    if (!this.getCopyFileArea().isLoaded(iComponentHandle, (IContextHandle)iWorkspace2, null)) {
                        hashMap.put(iComponentHandle.getItemId(), iComponentHandle);
                    }
                }
                catch (FileSystemClientException fileSystemClientException) {}
                hashSet.add(iComponentHandle.getItemId());
            }
        }
        return hashMap.values();
    }

    protected String getTraceMessage() {
        return String.valueOf(super.getTraceMessage()) + " : " + this.connection.getName() + " " + this.updateCount + " updates";
    }
}

