/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.RepositoryUtils;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.IContentManager;
import com.ibm.team.repository.client.IContentManagerSession;
import com.ibm.team.repository.client.IDownloadHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.DownloadAdapter;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.repository.common.utils.HashComputingInputStream;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConfiguration;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.IWorkspaceManager;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import com.ibm.team.scm.common.dto.ISynchronizationInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public class SynchronizeOperation {
    private SynchronizeOperation() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void synchronize(IShare ishare, IRepositoryResolver resolver, ISynchronizationInfo synchronizationInfo, IProgressMonitor monitor) throws TeamRepositoryException, FileSystemClientException {
        if (resolver == null) {
            resolver = LocalChangeManager.DEFAULT_RESOLVER;
        }
        Share share = (Share)ishare;
        ISharingDescriptor desc = share.getSharingDescriptor();
        IComponentHandle component = desc.getComponent();
        IContextHandle connection = desc.getConnectionHandle();
        ITeamRepository repo = resolver.getRepoFor(desc.getRepositoryUri(), desc.getRepositoryId());
        IContentManager contentManager = repo.contentManager();
        CopyFileAreaStore cfa = share.getCopyFileArea();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        ISchedulingRule trackingRule = SharingManager.getInstance().getTrackingRule(share.getAnchor());
        try {
            Job.getJobManager().beginRule(trackingRule, (IProgressMonitor)progress.newChild(1));
            ISchedulingRule rule = cfa.lock(component, connection, (IProgressMonitor)progress.newChild(1));
            try {
                InverseFileItemInfo oldInfo;
                DownloadAdapter dwnHandler;
                IContentManagerSession contentSession;
                HashMap fetchedHashes;
                LoadTree tree;
                boolean needHashes;
                block40: {
                    IBaselineConnection lconnection;
                    IConfiguration configuration;
                    ISharingDescriptor newDesc = cfa.getSharingInfo(share.getPath());
                    if (!desc.equals(newDesc)) {
                        return;
                    }
                    IWorkspaceManager wMgr = SCMPlatform.getWorkspaceManager((ITeamRepository)repo);
                    if (desc.getConnectionHandle() instanceof IBaselineHandle) {
                        IBaselineConnection bConnection = wMgr.getBaselineConnection((IBaselineHandle)desc.getConnectionHandle(), (IProgressMonitor)progress.newChild(3));
                        configuration = bConnection.configuration();
                        lconnection = bConnection;
                    } else {
                        IWorkspaceConnection wConnection = wMgr.getWorkspaceConnection((IWorkspaceHandle)desc.getConnectionHandle(), (IProgressMonitor)progress.newChild(3));
                        configuration = wConnection.configuration(component);
                        lconnection = wConnection;
                    }
                    IFileSystemManager fsm = FileSystemCore.getFileSystemManager(repo);
                    FileSystemServiceProxy fss = ((FileSystemManager)fsm).getFileSystemService();
                    needHashes = LineDelimiter.getPlatformDelimiter() != LineDelimiter.LINE_DELIMITER_LF;
                    try {
                        tree = fss.getFileTreeByVersionable((IConnection)lconnection, desc.getComponent(), new IVersionableHandle[]{desc.getRootFolder()}, -1, true, synchronizationInfo, (IProgressMonitor)progress.newChild(needHashes ? 20 : 35));
                        break block40;
                    }
                    catch (TeamRepositoryException e) {
                        progress.setWorkRemaining(56);
                        try {
                            List folder = configuration.fetchCompleteItems(Collections.singletonList(desc.getRootFolder()), (IProgressMonitor)progress.newChild(15));
                            if (folder.get(0) != null) throw e;
                            SubMonitor subProgress = progress.newChild(20);
                            InverseFileItemInfo inverse = cfa.getItemInfo((IVersionableHandle)desc.getRootFolder(), component, connection);
                            subProgress.setWorkRemaining(inverse.getRemoteChildren().size());
                            for (IVersionableHandle child : inverse.getRemoteChildren().values()) {
                                cfa.deleteTreeInfo(child, component, connection, (IProgressMonitor)subProgress.newChild(1));
                            }
                            subProgress.done();
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            throw e;
                        }
                    }
                    SynchronizeOperation.refreshChanges(share, (IProgressMonitor)progress.newChild(20));
                    return;
                }
                List updates = tree.getFileAreaUpdates();
                HashSet<UUID> inTree = new HashSet<UUID>((int)((double)updates.size() / 0.75));
                HashMap<UUID, HashMap<String, IVersionableHandle>> childMap = new HashMap<UUID, HashMap<String, IVersionableHandle>>();
                if (needHashes) {
                    fetchedHashes = new HashMap();
                    contentSession = contentManager.createSession("", true, (long)updates.size(), (IProgressMonitor)progress.newChild(15));
                    dwnHandler = new DownloadAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void downloadStreamAcquired(IContent content, InputStream in) throws TeamRepositoryException {
                            HashComputingInputStream inStream = new HashComputingInputStream(in);
                            byte[] readInto = new byte[4096];
                            try {
                                try {
                                    while (-1 != inStream.read(readInto)) {
                                    }
                                }
                                catch (IOException e) {
                                    throw new TeamRepositoryException((Throwable)e);
                                }
                            }
                            catch (Throwable throwable) {
                                try {
                                    inStream.close();
                                }
                                catch (IOException iOException) {}
                                throw throwable;
                            }
                            try {
                                inStream.close();
                            }
                            catch (IOException iOException) {}
                            Map map = fetchedHashes;
                            synchronized (map) {
                                fetchedHashes.put(content.getContentId(), new HashCode(inStream.getChecksum()));
                            }
                        }
                    };
                } else {
                    fetchedHashes = null;
                    contentSession = null;
                    dwnHandler = null;
                }
                for (FileAreaUpdate update : updates) {
                    inTree.add(update.getItem().getItemId());
                    if (!update.getItem().sameItemId((IItemHandle)desc.getRootFolder())) {
                        HashMap<String, IVersionableHandle> children = (HashMap<String, IVersionableHandle>)childMap.get(update.getDestinationParent().getItemId());
                        if (children == null) {
                            children = new HashMap<String, IVersionableHandle>();
                            childMap.put(update.getDestinationParent().getItemId(), children);
                        }
                        children.put(update.getName(), update.getItem());
                    }
                    if (!needHashes) continue;
                    if (update.getOptionalContent() != null && contentManager.convertDelimitersDuringRetrieval(update.getOptionalContent())) {
                        InverseFileItemInfo oldInfo2 = cfa.getItemInfo(update.getItem(), component, connection);
                        if (oldInfo2 != null && update.afterState().sameStateId((IItemHandle)oldInfo2.getVersionableHandle())) {
                            contentSession.decrementTransferCount(1);
                            continue;
                        }
                        contentSession.retrieveContent(update.getOptionalContent(), (IDownloadHandler)dwnHandler);
                        continue;
                    }
                    contentSession.decrementTransferCount(1);
                }
                if (needHashes) {
                    contentSession.join();
                    RepositoryUtils.throwAppropriateException(Messages.SynchronizeOperation_1, contentSession.getErrorStatus());
                }
                ISharingMetadata md = cfa.getMetadata();
                ArrayList<IVersionableHandle> deletedItems = new ArrayList<IVersionableHandle>();
                SubMonitor subProgress = progress.newChild(25);
                subProgress.setWorkRemaining(updates.size());
                for (FileAreaUpdate update : updates) {
                    InverseFileItemInfo newInfo;
                    String name;
                    IFolderHandle parent;
                    SubMonitor subSubProgress = subProgress.newChild(1);
                    subSubProgress.setWorkRemaining(100);
                    oldInfo = cfa.getItemInfo(update.getItem(), component, connection);
                    IPath localPath = cfa.getLocalPathFor(update.getItem(), component, connection, (IProgressMonitor)subSubProgress.newChild(33));
                    Map children = (Map)childMap.get(update.getItem().getItemId());
                    if (children == null) {
                        children = Collections.EMPTY_MAP;
                    }
                    IVersionableHandle item = update.afterState();
                    if (update.getItem().sameItemId((IItemHandle)desc.getRootFolder())) {
                        parent = null;
                        name = null;
                    } else {
                        parent = update.getDestinationParent();
                        name = update.getName();
                    }
                    HashCode hash = null;
                    long size = -1L;
                    LineDelimiter originalLineDelimiter = null;
                    String originalContentType = null;
                    UUID contentId = null;
                    UUID deltaPredecessor = null;
                    long sizeInRepo = -1L;
                    String encoding = null;
                    long checksumInRepo = -1L;
                    long numLineDelimiters = -1L;
                    if (update.getOptionalContent() != null) {
                        size = update.getOptionalContent().getEstimatedConvertedLength();
                        hash = needHashes ? (update.getOptionalContent().getLineDelimiter() == LineDelimiter.LINE_DELIMITER_PLATFORM ? (oldInfo != null && update.afterState().sameStateId((IItemHandle)oldInfo.getVersionableHandle()) ? oldInfo.getHash() : (HashCode)fetchedHashes.get(update.getOptionalContent().getContentId())) : update.getOptionalContent().getRawHashCode()) : update.getOptionalContent().getRawHashCode();
                        originalLineDelimiter = update.getOptionalContent().getLineDelimiter();
                        originalContentType = update.getOptionalContent().getContentType();
                        Content content = (Content)update.getOptionalContent();
                        contentId = content.getContentId();
                        deltaPredecessor = content.getDeltaPredecessor();
                        sizeInRepo = content.getContentLength();
                        encoding = content.getCharacterEncoding();
                        checksumInRepo = content.getChecksum();
                        numLineDelimiters = content.getLineDelimiterCount();
                    }
                    if (oldInfo == null) {
                        newInfo = new InverseFileItemInfo(item, -1L, parent, name, children, null, null, hash, size, originalLineDelimiter, originalLineDelimiter, originalContentType, originalContentType, contentId, deltaPredecessor, sizeInRepo, encoding, checksumInRepo, numLineDelimiters, update.isExecutable(), update.isExecutable());
                    } else {
                        long modStamp = hash != null && hash.equals((Object)oldInfo.getHash()) && size == oldInfo.getContentLength() ? oldInfo.getLastModification() : -1L;
                        newInfo = new InverseFileItemInfo(item, modStamp, parent, name, children, oldInfo.getLocalParent(), oldInfo.getLocalName(), hash, size, originalLineDelimiter, oldInfo.getLineDelimiter(), originalContentType, oldInfo.getContentType(), contentId, deltaPredecessor, sizeInRepo, encoding, checksumInRepo, numLineDelimiters, oldInfo.isExecutable(), update.isExecutable());
                        if (localPath != null) {
                            md.setFileItemInfo(localPath, newInfo);
                            subSubProgress.worked(33);
                        }
                        for (IVersionableHandle h : oldInfo.getRemoteChildren().values()) {
                            if (inTree.contains(h.getItemId())) continue;
                            deletedItems.add(h);
                        }
                    }
                    subSubProgress.setWorkRemaining(33);
                    md.setFileItemInfo(item, component, connection, newInfo);
                    subSubProgress.done();
                }
                subProgress.done();
                subProgress = progress.newChild(9);
                while (!deletedItems.isEmpty()) {
                    subProgress.setWorkRemaining(deletedItems.size() + 1);
                    SubMonitor subSubProgress = subProgress.newChild(1);
                    subSubProgress.setWorkRemaining(100);
                    IVersionableHandle deleted = (IVersionableHandle)deletedItems.remove(deletedItems.size() - 1);
                    IPath localPath = cfa.getLocalPathFor(deleted, component, connection, (IProgressMonitor)subSubProgress.newChild(25));
                    oldInfo = md.setFileItemInfo(deleted, component, connection, null);
                    subSubProgress.worked(25);
                    if (localPath != null) {
                        IVersionableHandle newHandle = (IVersionableHandle)oldInfo.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null);
                        InverseFileItemInfo newInfo = new InverseFileItemInfo(newHandle, -1L, null, null, Collections.EMPTY_MAP, oldInfo.getLocalParent(), oldInfo.getLocalName(), null, -1L, null, oldInfo.getLineDelimiter(), null, oldInfo.getContentType(), null, null, -1L, null, -1L, -1L, oldInfo.isExecutable(), false);
                        md.setFileItemInfo(localPath, newInfo);
                        subSubProgress.worked(12);
                        md.setFileItemInfo(newHandle, component, connection, newInfo);
                        subSubProgress.worked(13);
                        if (oldInfo.isFolder()) {
                            IShareable shareable = share.getShareable(localPath, true);
                            Map childInfos = cfa.getChildInfos(shareable, (IProgressMonitor)subSubProgress.newChild(5));
                            IFolderHandle parent = (IFolderHandle)newHandle;
                            subSubProgress.setWorkRemaining(childInfos.size());
                            for (FileItemInfo info : childInfos.values()) {
                                InverseFileItemInfo inverseInfo = cfa.getItemInfo(info.getVersionableHandle(), component, connection);
                                InverseFileItemInfo newChildInfo = new InverseFileItemInfo(inverseInfo.getVersionableHandle(), inverseInfo.getLastModification(), inverseInfo.getParent(), inverseInfo.getName(), inverseInfo.getRemoteChildren(), parent, inverseInfo.getLocalName(), inverseInfo.getHash(), inverseInfo.getContentLength(), inverseInfo.getOriginalLineDelimiter(), inverseInfo.getLineDelimiter(), inverseInfo.getOriginalContentType(), inverseInfo.getContentType(), inverseInfo.getStoredContentId(), inverseInfo.getStoredDeltaPredecessor(), inverseInfo.getStoredSize(), inverseInfo.getStoredEncoding(), inverseInfo.getStoredChecksum(), inverseInfo.getStoredNumLineDelimiters(), inverseInfo.isExecutable(), inverseInfo.isOriginalExecutable());
                                md.setFileItemInfo(newChildInfo.getVersionableHandle(), component, connection, newChildInfo);
                                subSubProgress.worked(1);
                            }
                        }
                    }
                    for (IVersionableHandle h : oldInfo.getRemoteChildren().values()) {
                        if (inTree.contains(h.getItemId())) continue;
                        deletedItems.add(h);
                    }
                    subSubProgress.done();
                }
                subProgress.done();
                cfa.setConfigurationState(connection, component, share.getPath(), ISyncTime.FACTORY.createFrom(tree.getConfigurationState()), (IProgressMonitor)progress.newChild(1));
                SynchronizeOperation.refreshChanges(share, (IProgressMonitor)progress.newChild(24));
                return;
            }
            finally {
                cfa.release(rule, (IProgressMonitor)progress.newChild(1));
            }
        }
        finally {
            Job.getJobManager().endRule(trackingRule);
            progress.done();
        }
    }

    private static void refreshChanges(IShare share, IProgressMonitor monitor) throws FileSystemClientException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        Shareable rootShareable = (Shareable)share.getShareable(share.getPath(), true);
        SharingManager shMgr = SharingManager.getInstance();
        shMgr.disableChangeMonitoring();
        try {
            rootShareable.getFileStorage().refreshCachedSubTree((IProgressMonitor)progress.newChild(40));
        }
        finally {
            shMgr.enableChangeMonitoring();
        }
        ILocalChangeManager changeManager = shMgr.getLocalChangeManager();
        ((LocalChangeManager)changeManager).refreshChanges(share, rootShareable, (IProgressMonitor)progress.newChild(60));
    }
}

