/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.operations;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.LocalFileSystemLoadMutator;
import com.ibm.team.filesystem.client.internal.load.LocalFileSystemMergeLoadMutator;
import com.ibm.team.filesystem.client.internal.operations.FileSystemOperation;
import com.ibm.team.filesystem.client.internal.operations.LoadOperation;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemVerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public class LocalFileSystemLoadOperation
extends LoadOperation {
    public static final int NONE = 0;
    public static final int MAINTAIN_SHARE_INFO = 1;
    public static final int MERGE_LOAD = 2;
    private final IPath fileAreaRoot;
    private final int loadFlags;
    private CopyFileAreaStore cfa;

    public LocalFileSystemLoadOperation(IPath iPath, int n, LoadDilemmaHandler loadDilemmaHandler) {
        super(loadDilemmaHandler);
        this.fileAreaRoot = iPath;
        this.loadFlags = n;
        this.cfa = CopyFileAreaStore.getCopyFileArea(iPath);
    }

    public void requestReLoad(Collection collection, IProgressMonitor iProgressMonitor) throws TeamRepositoryException {
        for (IShare iShare : collection) {
            if (iShare.getAnchor().equals((Object)this.fileAreaRoot)) continue;
            throw (Throwable)new IllegalArgumentException();
        }
        super.requestReLoad(collection, iProgressMonitor);
    }

    protected void execute(IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Collection collection = this.getAffectedConfigurations();
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireRead(collection);
        try {
            super.doLoad(iProgressMonitor);
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
    }

    protected FileSystemOperation getLoadMutator(IConnection iConnection, IComponentHandle iComponentHandle, Collection collection, Collection collection2, LoadTree loadTree, LoadDilemmaHandler loadDilemmaHandler) throws TeamRepositoryException {
        if ((this.loadFlags & 2) == 2) {
            Map<ConfigurationDescriptor, Collection> map = Collections.singletonMap(new ConfigurationDescriptor(iConnection, iComponentHandle), collection);
            return new LocalFileSystemMergeLoadMutator(iConnection, map, loadTree, this.fileAreaRoot, collection2, loadDilemmaHandler);
        }
        int n = 0;
        if ((this.loadFlags & 1) == 1) {
            n = 1;
        }
        return new LocalFileSystemLoadMutator(iConnection, iComponentHandle, collection, loadTree, this.fileAreaRoot, collection2, n, loadDilemmaHandler);
    }

    protected boolean maintainShareInfo() {
        return (this.loadFlags & 2) == 2 || (this.loadFlags & 1) == 1;
    }

    protected IShareable getShareable(String string) {
        return new ShareableFile(this.fileAreaRoot, this.fileAreaRoot.append(string).toFile());
    }

    protected boolean existsOnMirror(String string) {
        return this.fileAreaRoot.append(string).toFile().exists();
    }

    protected CopyFileAreaStore getCopyFileArea() {
        return this.cfa;
    }

    private void deleteSubtree(File file) throws FileSystemClientException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                this.deleteSubtree(fileArray[n]);
                ++n;
            }
        }
        file.delete();
    }

    protected IShare[] getAllShares() throws FileSystemClientException {
        return SharingManager.getInstance().allShares(this.cfa);
    }

    protected void deleteShare(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (iShareable.getLocalFullPath().segmentCount() > 0) {
            File file = ((ShareableFile)iShareable).getFile();
            this.deleteSubtree(file);
        }
        ((Shareable)iShareable).unshare(iProgressMonitor);
    }

    protected IVerifyInSyncOperation getVerifyInSyncOperation(OutOfSyncDilemmaHandler outOfSyncDilemmaHandler) {
        return new LocalFileSystemVerifySharesOperation(this.fileAreaRoot, outOfSyncDilemmaHandler);
    }
}

