/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

class LocalChangeTracker$LocalChangesComputer
extends Job {
    volatile long lastRecompute;
    volatile long lastRequest;
    final /* synthetic */ LocalChangeTracker this$0;

    public LocalChangeTracker$LocalChangesComputer(LocalChangeTracker localChangeTracker, ISchedulingRule iSchedulingRule) {
        this.this$0 = localChangeTracker;
        super(Messages.LocalChangeTracker_1);
        this.setPriority(30);
        this.setRule(iSchedulingRule);
        this.setSystem(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            if (subMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            ISchedulingRule iSchedulingRule = LocalChangeTracker.access$0(this.this$0).lock((IProgressMonitor)subMonitor.newChild(1));
            try {
                long l = System.nanoTime();
                long l2 = this.lastRequest;
                long l3 = (l2 + 200000000L - l) / 1000000L;
                if (l3 > 5L) {
                    this.schedule(l3);
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                this.runRecompute();
                subMonitor.worked(98);
                return Status.OK_STATUS;
            }
            finally {
                LocalChangeTracker.access$0(this.this$0).unlock(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                subMonitor.done();
            }
        }
        catch (FileSystemClientException fileSystemClientException) {
            return FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException));
        }
    }

    public boolean belongsTo(Object object) {
        return object == LocalChangeTracker.CHANGES_COMPUTER_JOB_FAMILY;
    }

    public void requestRefresh() {
        this.lastRequest = System.nanoTime();
        if (this.getState() == 4) {
            this.cancel();
        }
        this.schedule(200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRecompute() throws FileSystemClientException {
        this.lastRecompute = System.nanoTime();
        LocalChangeTracker localChangeTracker = this.this$0;
        synchronized (localChangeTracker) {
            LocalChangeTracker.access$1(this.this$0);
        }
    }

    public void rejoin() {
        if (LocalChangeTracker.access$0(this.this$0).isLocked()) {
            this.cancel();
            if (this.lastRequest <= this.lastRecompute) {
                return;
            }
            try {
                this.runRecompute();
            }
            catch (FileSystemClientException fileSystemClientException) {
                LoggingHelper.log(fileSystemClientException);
            }
        } else {
            while (true) {
                if (this.getState() == 0) {
                    if (this.lastRequest <= this.lastRecompute) {
                        return;
                    }
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

