/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.localchanges;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeListener;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemManager;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IRepositoryResolver;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.localchanges.IVersionableTree;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeContext;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager$1;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager$2;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager$3;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager$DefaultRepoResolver;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager$RecomputePendingChangesJob;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager$RefreshRequest;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeNotifier;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFileAddition;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFileChange;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFileDeletion;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFolderAddition;
import com.ibm.team.filesystem.client.internal.localchanges.LocalFolderDeletion;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveFrom;
import com.ibm.team.filesystem.client.internal.localchanges.LocalMoveTo;
import com.ibm.team.filesystem.client.internal.localchanges.NoOpChange;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.internal.utils.FlowNodeLock;
import com.ibm.team.filesystem.client.internal.utils.WorkspaceLockUtil;
import com.ibm.team.filesystem.client.operations.UndoDilemmaHandler;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdate;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.filesystem.common.internal.dto.FilesystemDTOFactory;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.model.RepositoryFactory;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.repository.common.utils.HashComputingInputStream;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.internal.dto.ComponentStateSummary;
import com.ibm.team.scm.common.internal.dto.ScmDtoFactory;
import com.ibm.team.scm.common.internal.dto.SynchronizationTime;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class LocalChangeManager
implements ILocalChangeManager {
    public static final IRepositoryResolver DEFAULT_RESOLVER = new LocalChangeManager$DefaultRepoResolver(null);
    private Object avoidNotification = new Object();
    private int avoidNotificationCount = 0;
    public static final ILocalChange[] NO_CHANGES = new ILocalChange[0];
    private static LocalChangeManager instance;
    public static String RECOMPUTE_PENDING_CHANGES_FAMILY;
    private Set toRefresh = new HashSet();
    private Object refreshLock = new Object();
    private Map trackers = new HashMap();
    private LocalChangeNotifier notifier = new LocalChangeNotifier();
    private LocalChangeManager$RecomputePendingChangesJob recomputeJob = new LocalChangeManager$RecomputePendingChangesJob(this);
    private static final String BACKUP_NAME = "#apo";

    static {
        RECOMPUTE_PENDING_CHANGES_FAMILY = LocalChangeManager$RecomputePendingChangesJob.class.getName();
    }

    public static synchronized LocalChangeManager getInstance() {
        if (instance == null) {
            instance = new LocalChangeManager();
        }
        return instance;
    }

    private LocalChangeManager() {
    }

    public void addLocalChangeListener(ILocalChangeListener iLocalChangeListener) {
        this.notifier.addListener(iLocalChangeListener);
    }

    public String getProgressDescription(ILocalChange iLocalChange) {
        if (iLocalChange instanceof LocalFileAddition) {
            return NLS.bind((String)Messages.LocalChangeManager_2, (Object)iLocalChange.getPath());
        }
        if (iLocalChange instanceof LocalFileChange) {
            return NLS.bind((String)Messages.LocalChangeManager_3, (Object)iLocalChange.getPath());
        }
        if (iLocalChange instanceof LocalFileDeletion) {
            return NLS.bind((String)Messages.LocalChangeManager_4, (Object)iLocalChange.getPath());
        }
        if (iLocalChange instanceof LocalFolderAddition) {
            return NLS.bind((String)Messages.LocalChangeManager_5, (Object)iLocalChange.getResultingPath());
        }
        if (iLocalChange instanceof LocalFolderDeletion) {
            return NLS.bind((String)Messages.LocalChangeManager_6, (Object)iLocalChange.getPath());
        }
        if (iLocalChange instanceof LocalMoveFrom) {
            return NLS.bind((String)Messages.LocalChangeManager_7, (Object)iLocalChange.getPath());
        }
        if (iLocalChange instanceof LocalMoveTo) {
            return NLS.bind((String)Messages.LocalChangeManager_8, (Object)iLocalChange.getResultingPath());
        }
        LoggingHelper.log((IStatus)new Status(2, "com.ibm.team.filesystem.client", String.valueOf(Messages.LocalChangeManager_9) + this.getClass().getName()));
        return Messages.LocalChangeManager_10;
    }

    public void cancelChanges(IShare iShare) {
        LocalChangeTracker localChangeTracker = this.findTracker(iShare);
        if (localChangeTracker != null) {
            localChangeTracker.cancelChanges(localChangeTracker.getPendingChanges(iShare.getPath(), false));
        }
    }

    private LocalChangeTracker findTracker(IShare iShare) {
        ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
        return this.findTracker(iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent(), iShare.getAnchor());
    }

    private Map getChangesMap(ILocalChange[] iLocalChangeArray) {
        HashMap<LocalChangeContext, ArrayList<ILocalChange>> hashMap = new HashMap<LocalChangeContext, ArrayList<ILocalChange>>();
        ILocalChange[] iLocalChangeArray2 = iLocalChangeArray;
        int n = iLocalChangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILocalChange iLocalChange = iLocalChangeArray2[n2];
            LocalChangeContext localChangeContext = ((LocalChange)iLocalChange).context;
            if (localChangeContext != null) {
                ArrayList<ILocalChange> arrayList = (ArrayList<ILocalChange>)hashMap.get(localChangeContext);
                if (arrayList == null) {
                    arrayList = new ArrayList<ILocalChange>();
                    hashMap.put(localChangeContext, arrayList);
                }
                arrayList.add(iLocalChange);
            }
            ++n2;
        }
        return hashMap;
    }

    public void cancelChanges(ILocalChange[] iLocalChangeArray) {
        for (Map.Entry entry : this.getChangesMap(iLocalChangeArray).entrySet()) {
            LocalChangeTracker localChangeTracker = this.findTracker((LocalChangeContext)entry.getKey());
            localChangeTracker.cancelChanges(((List)entry.getValue()).toArray(new ILocalChange[((List)entry.getValue()).size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPendingChanges(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IPath iPath) {
        Map map = this.trackers;
        synchronized (map) {
            this.trackers.remove(new LocalChangeContext(iComponentHandle, iContextHandle, iPath));
        }
    }

    public void commitChanges(ILocalChange[] iLocalChangeArray) {
        for (Map.Entry entry : this.getChangesMap(iLocalChangeArray).entrySet()) {
            LocalChangeTracker localChangeTracker = this.findTracker((LocalChangeContext)entry.getKey());
            localChangeTracker.confirmChanges(((List)entry.getValue()).toArray(new ILocalChange[((List)entry.getValue()).size()]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRefresh(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Set set;
        Object object = this.refreshLock;
        synchronized (object) {
            if (this.toRefresh.isEmpty()) {
                return;
            }
            set = this.toRefresh;
            this.toRefresh = new HashSet();
        }
        object = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (String)Messages.LocalChangeManager_11, (int)set.size());
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                ILocalChange[] iLocalChangeArray;
                ILocalChange[] iLocalChangeArray2;
                SubMonitor subMonitor = object.newChild(1);
                subMonitor.setWorkRemaining(100);
                LocalChangeManager$RefreshRequest localChangeManager$RefreshRequest = (LocalChangeManager$RefreshRequest)iterator.next();
                Share share = (Share)localChangeManager$RefreshRequest.getShare();
                LocalChangeTracker localChangeTracker = share.getTracker();
                LocalChangeNotifier.disableChangeNotification();
                try {
                    IShareable iShareable = localChangeManager$RefreshRequest.getStartingPoint();
                    if (iShareable == null) {
                        iShareable = share.getShareable(share.getPath(), true);
                    }
                    ISchedulingRule iSchedulingRule = SharingManager.getInstance().getTrackingRule(share.getAnchor());
                    try {
                        Job.getJobManager().beginRule(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                        ISchedulingRule iSchedulingRule2 = share.lock((IProgressMonitor)subMonitor.newChild(1));
                        try {
                            LocalChangeTracker localChangeTracker2 = localChangeTracker;
                            synchronized (localChangeTracker2) {
                                iLocalChangeArray2 = localChangeTracker.getPendingChanges(true);
                                localChangeTracker.computePendingChanges(iShareable, (IProgressMonitor)subMonitor.newChild(98));
                                localChangeTracker.syncChanges();
                                iLocalChangeArray = localChangeTracker.getPendingChanges();
                            }
                        }
                        finally {
                            share.unlock(iSchedulingRule2, (IProgressMonitor)subMonitor.newChild(1));
                        }
                    }
                    finally {
                        Job.getJobManager().endRule(iSchedulingRule);
                    }
                }
                finally {
                    LocalChangeNotifier.enableChangeNotification();
                }
                this.notifier.changesCanceled(localChangeTracker.getContext(), iLocalChangeArray2);
                this.notifier.changesOccurred(localChangeTracker.getContext(), iLocalChangeArray);
                subMonitor.done();
            }
        }
        finally {
            object.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LocalChangeTracker findTracker(LocalChangeContext localChangeContext) {
        Map map = this.trackers;
        synchronized (map) {
            return (LocalChangeTracker)this.trackers.get(localChangeContext);
        }
    }

    public LocalChangeTracker findTracker(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IPath iPath) {
        return this.findTracker(new LocalChangeContext(iComponentHandle, iContextHandle, iPath));
    }

    public ILocalChange getPendingChange(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IShareable iShareable) {
        LocalChangeTracker localChangeTracker = this.findTracker(iContextHandle, iComponentHandle, iShareable.getRoot());
        return localChangeTracker == null ? NoOpChange.NO_OP : localChangeTracker.getPendingChange(iShareable.getVersionable());
    }

    public ILocalChange getPendingChange(IShare iShare, IVersionableHandle iVersionableHandle) {
        LocalChangeTracker localChangeTracker = this.findTracker(iShare.getSharingDescriptor().getConnectionHandle(), iShare.getSharingDescriptor().getComponent(), iShare.getAnchor());
        return localChangeTracker == null ? NoOpChange.NO_OP : localChangeTracker.getPendingChange(iVersionableHandle);
    }

    public void syncPendingChanges(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IPath iPath) {
        LocalChangeTracker localChangeTracker = this.findTracker(iContextHandle, iComponentHandle, iPath);
        if (localChangeTracker != null) {
            localChangeTracker.syncChanges();
        }
    }

    public ILocalChange[] getPendingChanges(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IPath iPath) {
        LocalChangeTracker localChangeTracker = this.findTracker(iContextHandle, iComponentHandle, iPath);
        if (localChangeTracker == null) {
            return NO_CHANGES;
        }
        return localChangeTracker.getPendingChanges();
    }

    public ILocalChange[] getPendingChanges(IShareable[] iShareableArray) {
        Object object;
        HashMap<LocalChangeContext, ArrayList<Object>> hashMap = new HashMap<LocalChangeContext, ArrayList<Object>>();
        Object object2 = iShareableArray;
        int n = iShareableArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object3;
            object = object2[n2];
            Object object4 = object.getShare();
            if (object4 != null && (object3 = object4.getSharingDescriptor()) != null) {
                LocalChangeContext localChangeContext = new LocalChangeContext(object3.getComponent(), object3.getConnectionHandle(), object.getRoot());
                ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(localChangeContext);
                if (arrayList == null) {
                    arrayList = new ArrayList<Object>();
                    hashMap.put(localChangeContext, arrayList);
                }
                arrayList.add(object);
            }
            ++n2;
        }
        object = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = this.findTracker((LocalChangeContext)entry.getKey());
            if (object2 == null) continue;
            for (Object object4 : (List)entry.getValue()) {
                object.addAll((Collection)Arrays.asList(((LocalChangeTracker)object2).getPendingChanges(object4.getLocalFullPath(), false)));
            }
        }
        return object.toArray(new ILocalChange[object.size()]);
    }

    public IShareable getShareable(LocalChange localChange) throws FileSystemClientException {
        Assert.isNotNull((Object)localChange.path);
        Assert.isNotNull((Object)localChange.target);
        Assert.isNotNull((Object)localChange.context);
        IPath iPath = localChange.isType(16) ? localChange.getResultingPath() : localChange.getPath();
        Share share = SharingManager.getInstance().getShare(localChange.context.getRoot(), iPath);
        if (share == null) {
            return null;
        }
        IShareable iShareable = share.getShareable(iPath, localChange.getTarget() instanceof IFolderHandle);
        return iShareable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalChangeTracker getTracker(IVersionableTree iVersionableTree, IContextHandle iContextHandle, IComponentHandle iComponentHandle, IPath iPath, ISchedulingRule iSchedulingRule) {
        Map map = this.trackers;
        synchronized (map) {
            LocalChangeContext localChangeContext = new LocalChangeContext(iComponentHandle, iContextHandle, iPath);
            LocalChangeTracker localChangeTracker = (LocalChangeTracker)this.trackers.get(localChangeContext);
            if (localChangeTracker == null) {
                localChangeTracker = new LocalChangeTracker(iPath, iVersionableTree, this.notifier, localChangeContext, iSchedulingRule);
                this.trackers.put(localChangeContext, localChangeTracker);
            }
            return localChangeTracker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadChanges(IShare iShare, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        LocalChangeTracker localChangeTracker = ((Share)iShare).getTracker();
        IShareable iShareable = iShare.getShareable(iShare.getPath(), true);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ISchedulingRule iSchedulingRule = SharingManager.getInstance().getTrackingRule(iShare.getAnchor());
        try {
            Job.getJobManager().beginRule(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(3));
            ISchedulingRule iSchedulingRule2 = ((Share)iShare).lock((IProgressMonitor)subMonitor.newChild(2));
            try {
                LocalChangeTracker localChangeTracker2 = localChangeTracker;
                synchronized (localChangeTracker2) {
                    localChangeTracker.computePendingChanges(iShareable, (IProgressMonitor)subMonitor.newChild(90));
                }
            }
            finally {
                ((Share)iShare).unlock(iSchedulingRule2, (IProgressMonitor)subMonitor.newChild(5));
                subMonitor.done();
            }
        }
        finally {
            Job.getJobManager().endRule(iSchedulingRule);
        }
    }

    public void refreshAllChanges(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.refreshChanges(SharingManager.getInstance().allShares(), iProgressMonitor);
    }

    public void computeChanges(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Share share = (Share)iShareable.getShare();
        share.getTracker().computePendingChanges(iShareable, iProgressMonitor);
    }

    public void refreshChanges(IShare iShare, IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.addToRefresh(iShare, iShareable);
        this.doRefresh(iProgressMonitor);
    }

    public void refreshChanges(IShare[] iShareArray, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        int n = 0;
        while (n < iShareArray.length) {
            this.addToRefresh(iShareArray[n], null);
            ++n;
        }
        this.doRefresh(iProgressMonitor);
    }

    public void refreshChanges(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IShare[] iShareArray = SharingManager.getInstance().allShares();
        int n = 0;
        while (n < iShareArray.length) {
            ISharingDescriptor iSharingDescriptor = iShareArray[n].getSharingDescriptor();
            if (iSharingDescriptor.getComponent().sameItemId((IItemHandle)iComponentHandle) && iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iContextHandle)) {
                this.addToRefresh(iShareArray[n], null);
            }
            ++n;
        }
        this.doRefresh(iProgressMonitor);
    }

    public void undoChanges(ILocalChange[] iLocalChangeArray, IRepositoryResolver iRepositoryResolver, UndoDilemmaHandler undoDilemmaHandler, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object;
        Object object2;
        if (iLocalChangeArray.length == 0) {
            return;
        }
        SharingManager sharingManager = SharingManager.getInstance();
        IRepositoryResolver iRepositoryResolver2 = iRepositoryResolver == null ? DEFAULT_RESOLVER : iRepositoryResolver;
        HashMap<LocalChangeContext, Set[]> hashMap = new HashMap<LocalChangeContext, Set[]>();
        HashMap<LocalChangeContext, ITeamRepository> hashMap2 = new HashMap<LocalChangeContext, ITeamRepository>();
        IPath iPath = null;
        ILocalChange[] iLocalChangeArray2 = iLocalChangeArray;
        int n = iLocalChangeArray.length;
        int n2 = 0;
        while (n2 < n) {
            object2 = iLocalChangeArray2[n2];
            object = (LocalChange)object2;
            Set[] setArray = (Set[])hashMap.get(((LocalChange)object).context);
            if (setArray == null) {
                setArray = new Set[]{new HashSet(), new HashSet(), new HashSet()};
                hashMap.put(((LocalChange)object).context, setArray);
            }
            if (((LocalChange)object).isType(4)) {
                setArray[0].add(object);
            } else if (((LocalChange)object).isType(2)) {
                setArray[2].add(object);
            } else if (((LocalChange)object).isType(16)) {
                setArray[1].add((LocalChange)((LocalChange)object).getCounterpart());
            } else {
                setArray[1].add(object);
            }
            ITeamRepository iTeamRepository = (ITeamRepository)hashMap2.get(((LocalChange)object).context);
            if (iTeamRepository == null) {
                Share share = sharingManager.getShare(((LocalChange)object).context.getRoot(), ((LocalChange)object).getPath());
                iTeamRepository = iRepositoryResolver2.getRepoFor(share.getSharingDescriptor().getRepositoryUri(), share.getSharingDescriptor().getRepositoryId());
                hashMap2.put(((LocalChange)object).context, iTeamRepository);
            }
            iPath = ((LocalChange)object).context.getRoot();
            ++n2;
        }
        object2 = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        HashSet hashSet = this.getConfigurationsAffected(hashMap, hashMap2, object2.newChild(1));
        FlowNodeLock flowNodeLock = WorkspaceLockUtil.acquireRead(hashSet);
        try {
            try {
                iLocalChangeArray2 = iPath;
                sharingManager.runWithinFileSystemLock(new LocalChangeManager$1(this, iLocalChangeArray, sharingManager, (IPath)iLocalChangeArray2, undoDilemmaHandler, hashSet, hashMap, hashMap2, iRepositoryResolver2), (IProgressMonitor)object2.newChild(95));
            }
            catch (InvocationTargetException invocationTargetException) {
                object = invocationTargetException.getCause();
                if (object instanceof TeamRepositoryException) {
                    throw (Throwable)object;
                }
                if (object instanceof FileSystemClientException) {
                    throw (Throwable)object;
                }
                throw (Throwable)new TeamRepositoryException(Messages.LocalChangeManager_12, (Throwable)object);
            }
            catch (InterruptedException interruptedException) {
                throw (Throwable)new OperationCanceledException();
            }
        }
        finally {
            WorkspaceLockUtil.release(flowNodeLock);
        }
        object2.done();
    }

    private HashSet getConfigurationsAffected(Map map, Map map2, SubMonitor subMonitor) throws TeamRepositoryException {
        HashSet<ConfigurationDescriptor> hashSet = new HashSet<ConfigurationDescriptor>();
        for (Map.Entry entry : map.entrySet()) {
            LocalChangeContext localChangeContext = (LocalChangeContext)entry.getKey();
            ITeamRepository iTeamRepository = (ITeamRepository)map2.get(localChangeContext);
            if (iTeamRepository == null) continue;
            hashSet.add(new ConfigurationDescriptor(iTeamRepository.getId(), iTeamRepository.getRepositoryURI(), localChangeContext.getConnection(), localChangeContext.getComponent()));
        }
        return hashSet;
    }

    private void undoChanges(LocalChangeTracker localChangeTracker, ITeamRepository iTeamRepository, Set[] setArray, IRepositoryResolver iRepositoryResolver, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        if (iTeamRepository == null) {
            return;
        }
        ISchedulingRule iSchedulingRule = SharingManager.getInstance().getTrackingRule(localChangeTracker.getContext().getRoot());
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            Job.getJobManager().beginRule(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            CopyFileAreaStore copyFileAreaStore = CopyFileAreaStore.getCopyFileArea(localChangeTracker.getContext().getRoot());
            ISchedulingRule iSchedulingRule2 = copyFileAreaStore.lock(localChangeTracker.getContext().getComponent(), localChangeTracker.getContext().getConnection(), (IProgressMonitor)subMonitor.newChild(1));
            try {
                Object object3;
                Set set;
                localChangeTracker.syncChanges();
                Object object22 = setArray;
                int n = setArray.length;
                int n2 = 0;
                while (n2 < n) {
                    set = object22[n2];
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        object3 = (LocalChange)iterator.next();
                        if (!((LocalChange)object3).isCanceled()) continue;
                        iterator.remove();
                    }
                    ++n2;
                }
                this.validateUndoPrereq(localChangeTracker, copyFileAreaStore, setArray[0], setArray[1], setArray[2], (IProgressMonitor)subMonitor.newChild(1));
                set = localChangeTracker.getContext().getConnection() instanceof IBaselineHandle ? SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).getBaselineConnection((IBaselineHandle)localChangeTracker.getContext().getConnection(), (IProgressMonitor)subMonitor.newChild(1)) : SCMPlatform.getWorkspaceManager((ITeamRepository)iTeamRepository).getWorkspaceConnection((IWorkspaceHandle)localChangeTracker.getContext().getConnection(), (IProgressMonitor)subMonitor.newChild(1));
                FileSystemServiceProxy fileSystemServiceProxy = ((FileSystemManager)FileSystemCore.getFileSystemManager(iTeamRepository)).getFileSystemService();
                SubMonitor subMonitor2 = subMonitor.newChild(94);
                subMonitor2.setWorkRemaining(setArray[0].size() + setArray[1].size() + setArray[2].size());
                for (Object object22 : setArray[0]) {
                    this.undoDeletion((LocalChange)object22, localChangeTracker, copyFileAreaStore, (IConnection)set, fileSystemServiceProxy, (IProgressMonitor)subMonitor2.newChild(1));
                }
                int n3 = setArray[1].size() + setArray[2].size();
                while (true) {
                    object22 = new HashSet();
                    for (Object object3 : setArray[1]) {
                        if (!this.undoChange((LocalChange)object3, localChangeTracker, copyFileAreaStore, (IConnection)set, (IProgressMonitor)subMonitor2.newChild(1))) {
                            object22.add(object3);
                            subMonitor2.setWorkRemaining(n3);
                            continue;
                        }
                        --n3;
                    }
                    if (object22.isEmpty()) break;
                    if (setArray[1].size() == object22.size()) {
                        object3 = new StringBuilder(Messages.LocalChangeManager_13);
                        boolean bl = true;
                        Iterator iterator = object22.iterator();
                        while (iterator.hasNext()) {
                            LocalChange localChange = (LocalChange)iterator.next();
                            if (!bl) {
                                ((StringBuilder)object3).append(", ");
                            } else {
                                bl = false;
                            }
                            ((StringBuilder)object3).append(localChange.toString());
                            if (!localChange.isType(8)) continue;
                            ((StringBuilder)object3).append(" - ").append(localChange.getCounterpart().toString());
                        }
                        throw (Throwable)new IllegalStateException(((StringBuilder)object3).toString());
                    }
                    setArray[1] = object22;
                }
                for (Object object3 : setArray[2]) {
                    this.undoAddition((LocalChange)object3, localChangeTracker, copyFileAreaStore, (IConnection)set, (IProgressMonitor)subMonitor2.newChild(1));
                }
                subMonitor2.done();
            }
            finally {
                copyFileAreaStore.release(iSchedulingRule2, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        finally {
            Job.getJobManager().endRule(iSchedulingRule);
            subMonitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateUndoPrereq(LocalChangeTracker localChangeTracker, CopyFileAreaStore copyFileAreaStore, Set set, Set set2, Set set3, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Object object4;
        Object object2;
        SubMonitor subMonitor;
        Object object32;
        for (Object object32 : set) {
            subMonitor = localChangeTracker.getPendingChangesAt(((LocalChange)object32).getPath());
            object2 = subMonitor;
            int n = ((SubMonitor)object2).length;
            int n2 = 0;
            while (n2 < n) {
                object4 = object2[n2];
                if (object4.isType(2)) {
                    if (!set3.contains(object4)) {
                        throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_16, (Object)((LocalChange)object32).getPath(), (Object)object4.getResultingPath()))));
                    }
                } else if (object4.isType(8)) {
                    if (!set2.contains(object4)) {
                        throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_17, (Object)((LocalChange)object32).getPath(), (Object)object4.getResultingPath()))));
                    }
                } else if (!object4.equals(object32)) {
                    throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_18, (Object)object4, (Object)object32));
                }
                ++n2;
            }
        }
        object32 = localChangeTracker.getContext().getComponent();
        IContextHandle iContextHandle = localChangeTracker.getContext().getConnection();
        subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)set2.size());
        block5: for (Object object4 : set2) {
            Object object5;
            Object object6;
            ILocalChange[] iLocalChangeArray;
            if (!object4.isType(8)) {
                subMonitor.worked(1);
                continue;
            }
            IFolderHandle iFolderHandle = object4.getCounterpart().getTargetParent();
            object2 = subMonitor.newChild(1);
            object2.setWorkRemaining(2);
            IPath iPath = copyFileAreaStore.getLocalPathFor((IVersionableHandle)iFolderHandle, (IComponentHandle)object32, iContextHandle, (IProgressMonitor)object2.newChild(1));
            String string = object4.getCounterpart().getPath().lastSegment();
            if (iPath != null) {
                iLocalChangeArray = localChangeTracker.getPendingChangesAt(iPath.append(string));
                object6 = iLocalChangeArray;
                int n = iLocalChangeArray.length;
                int n3 = 0;
                while (n3 < n) {
                    object5 = object6[n3];
                    if (object5.isType(2)) {
                        if (!set3.contains(object5)) {
                            throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_19, (Object)object4.getResultingPath(), (Object)object5.getResultingPath()))));
                        }
                    } else if (object5.isType(8)) {
                        if (!set2.contains(object5)) {
                            throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_20, (Object)object4.getResultingPath(), (Object)object5.getResultingPath()))));
                        }
                    } else {
                        throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.LocalChangeManager_21, (Object)object5, (Object)object4));
                    }
                    ++n3;
                }
            }
            iLocalChangeArray = new ArrayList();
            object5 = new HashSet<UUID>();
            object5.add(object4.getTarget().getItemId());
            Object object7 = object4;
            while (!copyFileAreaStore.isShareRoot(iFolderHandle, object4.getComponent(), object4.getConnection())) {
                iLocalChangeArray.add(iFolderHandle);
                InverseFileItemInfo inverseFileItemInfo = copyFileAreaStore.getItemInfo((IVersionableHandle)iFolderHandle, object4.getComponent(), object4.getConnection());
                object6 = localChangeTracker.getPendingChange((IVersionableHandle)iFolderHandle);
                if (object6.isType(4)) {
                    if (!set.contains(object6)) {
                        throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_22, (Object)object7.getResultingPath(), (Object)object6.getPath()))));
                    }
                    iFolderHandle = inverseFileItemInfo.getParent();
                } else if (object6.isType(2)) {
                    if (set3.contains(object6)) continue block5;
                    iFolderHandle = inverseFileItemInfo.getLocalParent();
                } else if (object6.isType(8)) {
                    if (set2.contains(object6)) {
                        iFolderHandle = inverseFileItemInfo.getParent();
                        object7 = object6;
                    } else {
                        iFolderHandle = inverseFileItemInfo.getLocalParent();
                    }
                } else {
                    iFolderHandle = inverseFileItemInfo.getLocalParent();
                    if (iFolderHandle == null) {
                        iFolderHandle = inverseFileItemInfo.getParent();
                    }
                }
                if (object5.contains(iFolderHandle.getItemId())) {
                    iLocalChangeArray.add(iFolderHandle);
                    object2.setWorkRemaining(iLocalChangeArray.size());
                    HashMap<UUID, IFolderHandle> hashMap = new HashMap<UUID, IFolderHandle>((int)((double)iLocalChangeArray.size() / 0.75));
                    HashSet<UUID> hashSet = new HashSet<UUID>((int)((double)iLocalChangeArray.size() / 0.75));
                    int n = 0;
                    while (n < iLocalChangeArray.size()) {
                        IFolderHandle iFolderHandle2 = (IFolderHandle)iLocalChangeArray.get(n);
                        ILocalChange iLocalChange = localChangeTracker.getPendingChange((IVersionableHandle)iFolderHandle2);
                        hashSet.add(iFolderHandle2.getItemId());
                        if (iLocalChange.isType(8)) {
                            if (set2.contains(iLocalChange)) {
                                UUID uUID;
                                HashSet hashSet2 = new HashSet(hashMap.keySet());
                                while ((uUID = copyFileAreaStore.getRemoteAncestor(hashSet2, (IVersionableHandle)iFolderHandle2, object4.getComponent(), object4.getConnection(), (IProgressMonitor)object2.newChild(1))) != null) {
                                    ILocalChange iLocalChange2 = localChangeTracker.getPendingChange((IVersionableHandle)hashMap.get(uUID));
                                    if (!hashSet.contains(iLocalChange2.getCounterpart().getTargetParent().getItemId())) {
                                        throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalChangeManager_23, (Object)iLocalChange.getResultingPath(), (Object)iLocalChange2.getResultingPath()))));
                                    }
                                    hashSet2.remove(uUID);
                                }
                            } else {
                                hashMap.put(iFolderHandle2.getItemId(), iFolderHandle2);
                            }
                        }
                        ++n;
                    }
                    throw (Throwable)new IllegalStateException(Messages.LocalChangeManager_24);
                }
                object5.add(iFolderHandle.getItemId());
            }
            object2.done();
        }
        object4 = new FileSystemClientException[1];
        LocalChangeTracker localChangeTracker2 = localChangeTracker;
        synchronized (localChangeTracker2) {
            for (LocalChange localChange : set3) {
                localChange.getNode().basicAccept(new LocalChangeManager$2(this, localChange, set3, (FileSystemClientException[])object4, set2));
                if (object4[0] == null) continue;
                throw (Throwable)object4[0];
            }
        }
        subMonitor.done();
    }

    private void undoDeletion(LocalChange localChange, LocalChangeTracker localChangeTracker, CopyFileAreaStore copyFileAreaStore, IConnection iConnection, FileSystemServiceProxy fileSystemServiceProxy, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        LoadTree loadTree = fileSystemServiceProxy.getFileTreeByVersionable(iConnection, localChange.getComponent(), new IVersionableHandle[]{localChange.getTarget()}, -1, true, null, (IProgressMonitor)subMonitor);
        FileAreaUpdateReport fileAreaUpdateReport = this.getUpdatesForDeletion(localChange, localChangeTracker, loadTree.getFileAreaUpdates());
        ComponentStateSummary componentStateSummary = ScmDtoFactory.eINSTANCE.createComponentStateSummary();
        componentStateSummary.setComponent(localChange.getComponent());
        componentStateSummary.setConfigurationState(((SynchronizationTime)loadTree.getConfigurationState()).getTime());
        List<ComponentStateSummary> list = Collections.singletonList(componentStateSummary);
        SharingManager sharingManager = SharingManager.getInstance();
        subMonitor.worked(50);
        IPath iPath = copyFileAreaStore.getLocalPathFor((IVersionableHandle)localChange.getTargetParent(), localChange.getComponent(), localChange.getConnection(), (IProgressMonitor)subMonitor.newChild(1)).append(localChange.getPath().lastSegment());
        Share share = sharingManager.getShare(localChange.context.getRoot(), iPath);
        IShareable iShareable = share.getShareable(localChange.getPath(), localChange.getTarget() instanceof IFolderHandle);
        IFileStorage iFileStorage = ((Shareable)iShareable).getFileStorage();
        IFileStorage iFileStorage2 = iFileStorage.getParent().getChild(iFileStorage.getName());
        if (iFileStorage2 != null) {
            this.preserve(iFileStorage2, (IProgressMonitor)subMonitor.newChild(5));
            iFileStorage2 = null;
        }
        subMonitor.setWorkRemaining(100);
        sharingManager.getUpdateMutator(iConnection, list, list, fileAreaUpdateReport, localChange.context.getRoot()).run((IProgressMonitor)subMonitor.newChild(100));
        subMonitor.done();
    }

    private FileAreaUpdateReport getUpdatesForDeletion(LocalChange localChange, LocalChangeTracker localChangeTracker, List list) throws TeamRepositoryException {
        FileAreaUpdateReport fileAreaUpdateReport = FilesystemDTOFactory.eINSTANCE.createFileAreaUpdateReport();
        HashSet<UUID> hashSet = new HashSet<UUID>();
        for (FileAreaUpdate fileAreaUpdate : list) {
            if (localChange.getTarget().sameItemId((IItemHandle)fileAreaUpdate.getItem()) || !hashSet.contains(fileAreaUpdate.getDestinationParent().getItemId()) && localChangeTracker.getPendingChange(fileAreaUpdate.getItem()).getType() == 0) {
                fileAreaUpdateReport.getAdds().add(fileAreaUpdate);
                continue;
            }
            hashSet.add(fileAreaUpdate.getItem().getItemId());
        }
        return fileAreaUpdateReport;
    }

    private void preserve(IFileStorage iFileStorage, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IFileStorage iFileStorage2 = iFileStorage.getParent();
        String string = String.valueOf(iFileStorage.getName()) + BACKUP_NAME;
        int n = 2;
        String string2 = string;
        while (iFileStorage2.getChild(string2) != null) {
            string2 = String.valueOf(string) + Integer.toString(n++);
        }
        Share share = (Share)iFileStorage.getShareable().getShare();
        IShareable iShareable = share.getShareable(iFileStorage2.getFullPath().append(string2), iFileStorage.isFolder());
        iFileStorage.move(((Shareable)iShareable).getFileStorage(), iProgressMonitor);
    }

    private boolean undoChange(LocalChange localChange, LocalChangeTracker localChangeTracker, CopyFileAreaStore copyFileAreaStore, IConnection iConnection, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Object object;
        Object object2;
        Object object3;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IPath iPath = copyFileAreaStore.getLocalPathFor(localChange.getTarget(), localChange.getComponent(), localChange.getConnection(), (IProgressMonitor)subMonitor.newChild(1));
        Share share = SharingManager.getInstance().getShare(localChange.context.getRoot(), iPath);
        Object object4 = share.getShareable(iPath, localChange.getTarget() instanceof IFolderHandle);
        if (localChange.isType(8)) {
            object3 = subMonitor.newChild(localChange.isType(1) ? 19 : 99);
            object3.setWorkRemaining(100);
            IPath iPath2 = copyFileAreaStore.getLocalPathFor((IVersionableHandle)localChange.getCounterpart().getTargetParent(), localChange.getComponent(), localChange.getConnection(), (IProgressMonitor)object3.newChild(20)).append(localChange.getCounterpart().getPath().lastSegment());
            if (iPath.isPrefixOf(iPath2)) {
                object3.done();
                subMonitor.done();
                return false;
            }
            object2 = share.getShareable(iPath2, localChange.getTarget() instanceof IFolderHandle);
            object = ((Shareable)object2).getFileStorage();
            IFileStorage iFileStorage = object.getParent().getChild(object.getName());
            if (iFileStorage != null) {
                this.preserve(iFileStorage, (IProgressMonitor)object3.newChild(20));
            }
            if (iPath2.isPrefixOf(iPath)) {
                iPath = copyFileAreaStore.getLocalPathFor(localChange.getTarget(), localChange.getComponent(), localChange.getConnection(), (IProgressMonitor)object3.newChild(20));
                object4 = share.getShareable(iPath, localChange.getTarget() instanceof IFolderHandle);
            }
            object3.setWorkRemaining(40);
            ((Shareable)object4).getFileStorage().move((IFileStorage)object, (IProgressMonitor)object3.newChild(40));
            iPath = iPath2;
            object4 = object2;
            object3.done();
        }
        object3 = null;
        boolean bl = false;
        if (localChange.isType(1)) {
            IFileItem iFileItem;
            boolean bl2;
            boolean bl3;
            subMonitor.setWorkRemaining(100);
            object3 = copyFileAreaStore.getItemInfo(iPath);
            object2 = ((Shareable)object4).getFileStorage();
            if (((FileItemInfo)object3).getStoredContentId() != null) {
                object = RepositoryFactory.eINSTANCE.createContent();
                object.setContentId(((FileItemInfo)object3).getStoredContentId());
                object.setDeltaPredecessor(((FileItemInfo)object3).getStoredDeltaPredecessor());
                object.setLineDelimiter(((FileItemInfo)object3).getOriginalLineDelimiter());
                object.setContentType(((FileItemInfo)object3).getOriginalContentType());
                object.setContentLength(((FileItemInfo)object3).getStoredSize());
                object.setCharacterEncoding(((FileItemInfo)object3).getStoredEncoding());
                object.setChecksum(((FileItemInfo)object3).getStoredChecksum());
                object.setLineDelimiterCount(((FileItemInfo)object3).getStoredNumLineDelimiters());
                bl3 = ((FileItemInfo)object3).isExecutable();
                bl2 = ((FileItemInfo)object3).isOriginalExecutable();
            } else {
                iFileItem = (IFileItem)SCMPlatform.getWorkspaceManager((ITeamRepository)iConnection.teamRepository()).versionableManager().fetchCompleteState(localChange.getTarget(), (IProgressMonitor)subMonitor.newChild(30));
                object = (Content)iFileItem.getContent();
                bl2 = iFileItem.isExecutable();
                bl3 = object2.supportsExecBit() ? false : bl2;
                bl = bl3 ^ bl2;
            }
            iFileItem = new HashComputingInputStream(iConnection.teamRepository().contentManager().retrieveContentStream((IContent)object, (IProgressMonitor)subMonitor.newChild(68)));
            object2.setContents((InputStream)iFileItem, (IProgressMonitor)new CancellationMonitor((IProgressMonitor)subMonitor));
            FileItemInfo fileItemInfo = new FileItemInfo(((FileItemInfo)object3).getVersionableHandle(), object2.getModificationStamp(), ((FileItemInfo)object3).getParent(), ((FileItemInfo)object3).getName(), new HashCode(iFileItem.getChecksum()), iFileItem.getContentSize(), object.getLineDelimiter(), object.getLineDelimiter(), object.getContentType(), object.getContentType(), object.getContentId(), object.getDeltaPredecessor(), object.getContentLength(), object.getCharacterEncoding(), object.getChecksum(), object.getLineDelimiterCount(), bl3, bl2);
            copyFileAreaStore.setItemInfo((IShareable)object4, fileItemInfo, (IProgressMonitor)subMonitor.newChild(1));
            object3 = fileItemInfo;
        }
        if (bl || localChange.isType(32)) {
            subMonitor.setWorkRemaining(1);
            if (object3 == null) {
                object3 = copyFileAreaStore.getItemInfo(iPath);
            }
            object2 = ((Shareable)object4).getFileStorage();
            object2.setExecutable(((FileItemInfo)object3).isOriginalExecutable(), (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
        return true;
    }

    private void undoAddition(LocalChange localChange, LocalChangeTracker localChangeTracker, CopyFileAreaStore copyFileAreaStore, IConnection iConnection, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IPath iPath = copyFileAreaStore.getLocalPathFor(localChange.getTarget(), localChange.getComponent(), localChange.getConnection(), (IProgressMonitor)subMonitor.newChild(1));
        if (iPath != null) {
            Share share = SharingManager.getInstance().getShare(localChange.context.getRoot(), iPath);
            IShareable iShareable = share.getShareable(iPath, localChange.getTarget() instanceof IFolderHandle);
            ((Shareable)iShareable).getFileStorage().delete((IProgressMonitor)subMonitor.newChild(99));
        }
        subMonitor.done();
    }

    public void removeLocalChangeListener(ILocalChangeListener iLocalChangeListener) {
        this.notifier.removeListener(iLocalChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRefresh(IShare iShare, IShareable iShareable) {
        Object object = this.refreshLock;
        synchronized (object) {
            this.toRefresh.add(new LocalChangeManager$RefreshRequest(iShare, iShareable));
            this.recomputeJob.schedule(500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginAvoidNotify() {
        Object object = this.avoidNotification;
        synchronized (object) {
            ++this.avoidNotificationCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAvoidNotify() throws FileSystemClientException {
        Object object = this.avoidNotification;
        synchronized (object) {
            --this.avoidNotificationCount;
            Assert.isTrue((this.avoidNotificationCount >= 0 ? 1 : 0) != 0, (String)"Unmatched start/end notification");
            if (this.avoidNotificationCount < 0) {
                this.avoidNotificationCount = 0;
            }
            if (this.avoidNotificationCount == 0) {
                this.notifier.scheduleNotification();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNotificationEnabled() {
        Object object = this.avoidNotification;
        synchronized (object) {
            return this.avoidNotificationCount == 0;
        }
    }

    public ILocalChange[] getPendingChanges(IShare[] iShareArray) {
        Object object;
        HashMap<Object, ArrayList<IPath>> hashMap = new HashMap<Object, ArrayList<IPath>>();
        Object object2 = iShareArray;
        int n = iShareArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISharingDescriptor iSharingDescriptor;
            object = object2[n2];
            if (object != null && (iSharingDescriptor = object.getSharingDescriptor()) != null) {
                LocalChangeContext localChangeContext = new LocalChangeContext(iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), object.getAnchor());
                ArrayList<IPath> arrayList = (ArrayList<IPath>)hashMap.get(localChangeContext);
                if (arrayList == null) {
                    arrayList = new ArrayList<IPath>();
                    hashMap.put(localChangeContext, arrayList);
                }
                arrayList.add(object.getPath());
            }
            ++n2;
        }
        object = new ArrayList();
        for (Map.Entry entry : hashMap.entrySet()) {
            object2 = this.findTracker((LocalChangeContext)entry.getKey());
            if (object2 == null) continue;
            for (ISharingDescriptor iSharingDescriptor : (List)entry.getValue()) {
                object.addAll((Collection)Arrays.asList(((LocalChangeTracker)object2).getPendingChanges((IPath)iSharingDescriptor, false)));
            }
        }
        return object.toArray(new ILocalChange[object.size()]);
    }

    public void undoChanges(ILocalChange[] iLocalChangeArray, UndoDilemmaHandler undoDilemmaHandler, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        this.undoChanges(iLocalChangeArray, null, undoDilemmaHandler, iProgressMonitor);
    }

    public void combineDeleteAdd(ILocalChange iLocalChange, ILocalChange iLocalChange2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.combineDeleteAdd(DEFAULT_RESOLVER, iLocalChange, iLocalChange2, iProgressMonitor);
    }

    public void combineDeleteAdd(IRepositoryResolver iRepositoryResolver, ILocalChange iLocalChange, ILocalChange iLocalChange2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (iLocalChange == null || !iLocalChange.isType(4)) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (iLocalChange2 == null || !iLocalChange2.isType(2)) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (!iLocalChange.getConnection().sameItemId((IItemHandle)iLocalChange2.getConnection())) {
            throw (Throwable)new IllegalArgumentException("Changes must be in the same workspace");
        }
        if (!iLocalChange.getComponent().sameItemId((IItemHandle)iLocalChange2.getComponent())) {
            throw (Throwable)new IllegalArgumentException("Changes must be in the same component");
        }
        SharingManager sharingManager = SharingManager.getInstance();
        Object object = iLocalChange.getShareable();
        if (object == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        Object object2 = iLocalChange2.getShareable();
        if (object2 == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (!object.getRoot().equals((Object)object2.getRoot())) {
            throw (Throwable)new IllegalArgumentException("Changes have different roots");
        }
        IVersionableHandle iVersionableHandle = iLocalChange.getTarget();
        if (iVersionableHandle == null) {
            throw (Throwable)new IllegalArgumentException("No versionable");
        }
        FileSystemClientException[] fileSystemClientExceptionArray = object.getShare();
        if (fileSystemClientExceptionArray == null) {
            throw (Throwable)new IllegalArgumentException();
        }
        ITeamRepository iTeamRepository = iRepositoryResolver.getRepoFor(fileSystemClientExceptionArray.getSharingDescriptor().getRepositoryUri(), fileSystemClientExceptionArray.getSharingDescriptor().getRepositoryId());
        ((Share)fileSystemClientExceptionArray).getCopyFileArea();
        object = new ConfigurationDescriptor(iTeamRepository.getId(), iTeamRepository.getRepositoryURI(), iLocalChange2.getConnection(), iLocalChange2.getComponent());
        object2 = WorkspaceLockUtil.acquireRead(Collections.singleton(object));
        try {
            try {
                fileSystemClientExceptionArray = new FileSystemClientException[1];
                sharingManager.runWithinFileSystemLock(new LocalChangeManager$3(this, iLocalChange2, iLocalChange, iVersionableHandle, fileSystemClientExceptionArray), iProgressMonitor);
                if (fileSystemClientExceptionArray[0] != null) {
                    throw (Throwable)((Object)fileSystemClientExceptionArray[0]);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
                WorkspaceLockUtil.release((FlowNodeLock)object2);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                WorkspaceLockUtil.release((FlowNodeLock)object2);
            }
        }
        finally {
            WorkspaceLockUtil.release((FlowNodeLock)object2);
        }
    }

    private void combineDeleteAddInternal(CopyFileAreaStore copyFileAreaStore, IVersionableHandle iVersionableHandle, ILocalChange iLocalChange, ILocalChange iLocalChange2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IShareable iShareable;
        IComponentHandle iComponentHandle = iLocalChange.getComponent();
        IContextHandle iContextHandle = iLocalChange.getConnection();
        Shareable shareable = (Shareable)((LocalChange)iLocalChange2).getShareable();
        LinkedList<Shareable> linkedList = new LinkedList<Shareable>();
        LinkedList<IVersionableHandle> linkedList2 = new LinkedList<IVersionableHandle>();
        linkedList.add(shareable);
        linkedList2.add(iVersionableHandle);
        while (!linkedList.isEmpty()) {
            if (!$assertionsDisabled && linkedList2.isEmpty()) {
                throw (Throwable)((Object)new AssertionError());
            }
            iShareable = (Shareable)linkedList.removeFirst();
            IVersionableHandle iVersionableHandle2 = (IVersionableHandle)linkedList2.removeFirst();
            InverseFileItemInfo inverseFileItemInfo = copyFileAreaStore.getItemInfo(iVersionableHandle2, iComponentHandle, iContextHandle);
            copyFileAreaStore.setItemInfo(iShareable, inverseFileItemInfo, iProgressMonitor);
            Map map = inverseFileItemInfo.getRemoteChildren();
            IFileStorage iFileStorage = ((Shareable)iShareable).getFileStorage();
            IFileStorage[] iFileStorageArray = iFileStorage.getChildren();
            if (iFileStorageArray == null) continue;
            IFileStorage[] iFileStorageArray2 = iFileStorageArray;
            int n = iFileStorageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStorage iFileStorage2 = iFileStorageArray2[n2];
                if (!$assertionsDisabled && !iFileStorage2.exists()) {
                    throw (Throwable)((Object)new AssertionError());
                }
                Shareable shareable2 = iFileStorage2.getShareable();
                IVersionableHandle iVersionableHandle3 = (IVersionableHandle)map.get(iFileStorage2.getName());
                if (iVersionableHandle3 != null) {
                    linkedList.addFirst(shareable2);
                    linkedList2.addFirst(iVersionableHandle3);
                }
                ++n2;
            }
        }
        if (!$assertionsDisabled && !linkedList2.isEmpty()) {
            throw (Throwable)((Object)new AssertionError());
        }
        iShareable = iLocalChange.getShareable();
        this.refreshChanges(iShareable.getShare(), iShareable, iProgressMonitor);
        iShareable = iLocalChange2.getShareable();
        this.refreshChanges(iShareable.getShare(), iShareable, iProgressMonitor);
        this.doRefresh(iProgressMonitor);
    }

    static /* synthetic */ LocalChangeTracker access$0(LocalChangeManager localChangeManager, LocalChangeContext localChangeContext) {
        return localChangeManager.findTracker(localChangeContext);
    }

    static /* synthetic */ void access$1(LocalChangeManager localChangeManager, LocalChangeTracker localChangeTracker, ITeamRepository iTeamRepository, Set[] setArray, IRepositoryResolver iRepositoryResolver, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        localChangeManager.undoChanges(localChangeTracker, iTeamRepository, setArray, iRepositoryResolver, iProgressMonitor);
    }

    static /* synthetic */ void access$2(LocalChangeManager localChangeManager, CopyFileAreaStore copyFileAreaStore, IVersionableHandle iVersionableHandle, ILocalChange iLocalChange, ILocalChange iLocalChange2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        localChangeManager.combineDeleteAddInternal(copyFileAreaStore, iVersionableHandle, iLocalChange, iLocalChange2, iProgressMonitor);
    }
}

