/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.operations.IRemovedShare;

public class RemovedShare
implements IRemovedShare {
    private final int uncommittedChangeCount;
    private final IShareable shareable;
    private boolean toDelete;
    private String localPath;

    public RemovedShare(IShare iShare) {
        this.shareable = iShare.getShareable(iShare.getPath(), true);
        this.uncommittedChangeCount = LocalChangeManager.getInstance().getPendingChanges(new IShare[]{iShare}).length;
        this.toDelete = false;
        this.localPath = iShare.getPath().toString();
    }

    public IShareable getShareable() {
        return this.shareable;
    }

    public boolean isToBeDeleted() {
        return this.toDelete;
    }

    public void isToBeDeleted(boolean bl) {
        this.toDelete = bl;
    }

    public int getUncommittedChangeCount() {
        return this.uncommittedChangeCount;
    }

    public String getShareableLocalPath() {
        return this.localPath;
    }
}

