/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.DeferredDownloadInformation;
import com.ibm.team.filesystem.client.internal.load.LocalFileSystemUpdateMutator$1;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator;
import com.ibm.team.filesystem.client.internal.utils.CancellationMonitor;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.repository.client.IDownloadHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.util.Collection;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class LocalFileSystemUpdateMutator
extends UpdateMutator {
    private final IConnection connection;
    private final ITeamRepository repository;
    private static final String COLLISION_RENAME = "#apo";
    private final IPath fileSystemRoot;
    private final File fileSystemRootFile;
    private final CopyFileAreaStore copyFileArea;

    public LocalFileSystemUpdateMutator(IConnection iConnection, Collection collection, Collection collection2, FileAreaUpdateReport fileAreaUpdateReport, IPath iPath, DilemmaHandler dilemmaHandler) throws TeamRepositoryException {
        super(iConnection.teamRepository(), iConnection, collection, collection2, fileAreaUpdateReport, dilemmaHandler);
        this.repository = iConnection.teamRepository();
        this.connection = iConnection;
        this.fileSystemRoot = iPath;
        this.fileSystemRootFile = iPath.toFile();
        this.copyFileArea = CopyFileAreaStore.getCopyFileArea(iPath);
    }

    private void retrieveContent(DeferredDownloadInformation deferredDownloadInformation, IPath iPath, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        File file = new File(this.fileSystemRootFile, iPath.toString());
        this.contentSession.retrieveContent(deferredDownloadInformation.getContent(), (IDownloadHandler)new LocalFileSystemUpdateMutator$1(this, file, deferredDownloadInformation));
    }

    private IFileStorage createFolder(IPath iPath) throws FileSystemClientException {
        File file = new File(this.fileSystemRootFile, iPath.toString());
        if (!file.mkdirs()) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, 368, NLS.bind((String)Messages.LocalFileSystemUpdateMutator_2, (Object)iPath.toString()), null)));
        }
        return new LocalFileStorage(this.fileSystemRoot, file);
    }

    private static void deleteFileTree(File file) throws FileSystemClientException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    LocalFileSystemUpdateMutator.deleteFileTree(fileArray[n]);
                    ++n;
                }
            }
            if (!file.delete()) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, 370, NLS.bind((String)Messages.LocalFileSystemUpdateMutator_3, (Object)file.getPath()), null)));
            }
        }
    }

    protected void createFile(IComponent iComponent, DeferredDownloadInformation deferredDownloadInformation, Shareable shareable, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        this.retrieveContent(deferredDownloadInformation, shareable.getLocalFullPath().append(deferredDownloadInformation.getName()), iProgressMonitor);
    }

    protected void createFolder(IComponent iComponent, IFolderHandle iFolderHandle, Shareable shareable, String string, IFolderHandle iFolderHandle2, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        Object object;
        Object object2 = shareable == null ? new Path(string) : shareable.getLocalFullPath().append(string);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        subMonitor.subTask(NLS.bind((String)Messages.LocalFileSystemUpdateMutator_4, (Object)object2.toString()));
        IFileStorage iFileStorage = this.createFolder((IPath)object2);
        Shareable shareable2 = iFileStorage.getShareable();
        if (shareable == null) {
            object = new SharingDescriptor(this.repository.getRepositoryURI(), this.repository.getId(), this.connection, (IComponentHandle)iComponent, iComponent.getName(), iFolderHandle2);
            if (shareable2.getShare() == null) {
                shareable2.share((ISharingDescriptor)object, true, (IProgressMonitor)subMonitor.newChild(50));
            } else {
                this.copyFileArea.setSharingInfo(shareable2, (ISharingDescriptor)object, (IProgressMonitor)subMonitor.newChild(50));
            }
            iFolderHandle = null;
            string = null;
        }
        object = new FileItemInfo(iFolderHandle2, iFolderHandle, string);
        this.copyFileArea.setItemInfo(shareable2, (FileItemInfo)object, (IProgressMonitor)subMonitor.newChild(50));
        subMonitor.done();
    }

    protected void deleteSubtree(IComponent iComponent, Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        File file = ((ShareableFile)shareable).getFile();
        LocalFileSystemUpdateMutator.deleteFileTree(file);
        if (this.isRoot(shareable)) {
            shareable.unshare(iProgressMonitor);
        } else {
            shareable.forget(iProgressMonitor);
        }
    }

    protected Shareable getRootFolder(String string) {
        return new ShareableFile(this.fileSystemRoot, new File(this.fileSystemRootFile, string));
    }

    protected void modifyFile(IComponent iComponent, DeferredDownloadInformation deferredDownloadInformation, Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        this.retrieveContent(deferredDownloadInformation, shareable.getLocalFullPath(), iProgressMonitor);
    }

    protected void move(IComponent iComponent, IComponentHandle iComponentHandle, Shareable shareable, Shareable shareable2, IFolderHandle iFolderHandle, String string, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        File file = ((ShareableFile)shareable).getFile();
        File file2 = shareable2 == null ? new File(this.fileSystemRootFile, string) : new File(this.fileSystemRootFile, shareable2.getLocalFullPath().append(string).toString());
        this.move(iComponent, iComponentHandle, iVersionableHandle, true, shareable, file, file2, (IProgressMonitor)subMonitor);
        subMonitor.done();
    }

    private void move(IComponent iComponent, IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, boolean bl, Shareable shareable, File file, File file2, IProgressMonitor iProgressMonitor) throws TeamRepositoryException, FileSystemClientException {
        if (!file.renameTo(file2)) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, 371, Messages.LocalFileSystemUpdateMutator_5, null)));
        }
        ShareableFile shareableFile = new ShareableFile(this.fileSystemRoot, file2);
        this.updateMetaDataAfterMove(iComponent, iComponentHandle, iVersionableHandle, bl, shareable, shareableFile, shareable.getLocalFullPath().segmentCount() == 1, iProgressMonitor);
    }

    protected void preserve(IComponent iComponent, Shareable shareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        String string;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        File file = ((ShareableFile)shareable).getFile();
        String string2 = shareable.getLocalFullPath().toString();
        String string3 = ((LocalFileStorage)shareable.getFileStorage()).getFile().getName();
        int n = string3.lastIndexOf(".");
        if (n < 0) {
            string3 = "";
        } else {
            string3 = string3.substring(n);
            string2 = string2.substring(0, string2.length() - string3.length());
        }
        string2 = String.valueOf(string2) + COLLISION_RENAME;
        int n2 = 0;
        File file2 = null;
        do {
            string = String.valueOf(string2) + n2 + string3;
            ++n2;
        } while ((file2 = new File(this.fileSystemRootFile, string)).exists());
        this.move(iComponent, (IComponentHandle)iComponent, null, false, shareable, file, file2, (IProgressMonitor)subMonitor.newChild(100));
    }

    protected CopyFileAreaStore getCopyFileArea() {
        return this.copyFileArea;
    }

    protected Shareable getShareableFor(IPath iPath, boolean bl) {
        ShareableFile shareableFile = null;
        if (iPath != null) {
            shareableFile = new ShareableFile(this.fileSystemRoot, iPath);
        }
        return shareableFile;
    }

    protected void updateMetaData(DeferredDownloadInformation deferredDownloadInformation, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        Shareable shareable = deferredDownloadInformation.getShareable();
        if (shareable instanceof ShareableFile) {
            String string;
            IFolderHandle iFolderHandle;
            File file = ((ShareableFile)shareable).getFile();
            long l = file.lastModified();
            Content content = (Content)deferredDownloadInformation.getContent();
            LineDelimiter lineDelimiter = content.getLineDelimiter();
            String string2 = content.getContentType();
            FileItemInfo fileItemInfo = this.getCopyFileArea().getItemInfo(shareable.getLocalFullPath());
            if (fileItemInfo == null) {
                iFolderHandle = deferredDownloadInformation.getParent();
                string = deferredDownloadInformation.getName();
            } else {
                iFolderHandle = fileItemInfo.getParent();
                string = fileItemInfo.getName();
            }
            FileItemInfo fileItemInfo2 = new FileItemInfo((IVersionableHandle)deferredDownloadInformation.getFileItem(), l, iFolderHandle, string, new HashCode(deferredDownloadInformation.getChecksum()), deferredDownloadInformation.getContentSize(), lineDelimiter, lineDelimiter, string2, string2, content.getContentId(), content.getDeltaPredecessor(), content.getContentLength(), content.getCharacterEncoding(), content.getChecksum(), content.getLineDelimiterCount(), deferredDownloadInformation.isExecutable(), deferredDownloadInformation.isExecutable());
            this.copyFileArea.setItemInfo(new ShareableFile(this.fileSystemRoot, file), fileItemInfo2, (IProgressMonitor)new CancellationMonitor(iProgressMonitor));
        }
    }

    static /* synthetic */ IPath access$0(LocalFileSystemUpdateMutator localFileSystemUpdateMutator) {
        return localFileSystemUpdateMutator.fileSystemRoot;
    }
}

