/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LocalFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator$DeferredUpdateInformation;
import com.ibm.team.filesystem.client.internal.load.MergeLoadMutator$DownloadHandler;
import com.ibm.team.filesystem.client.internal.utils.PathUtils;
import com.ibm.team.filesystem.client.operations.DilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.LoadTree;
import com.ibm.team.repository.client.IDownloadHandler;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class LocalFileSystemMergeLoadMutator
extends MergeLoadMutator {
    private final File root;

    public LocalFileSystemMergeLoadMutator(IConnection iConnection, Map map, LoadTree loadTree, IPath iPath, Collection collection, DilemmaHandler dilemmaHandler) throws TeamRepositoryException {
        super(iConnection, map, loadTree, iPath, collection, dilemmaHandler);
        this.root = iPath.toFile();
        if (!this.root.exists() || !this.root.isDirectory()) {
            throw (Throwable)new IllegalArgumentException(NLS.bind((String)Messages.LocalFileSystemMergeLoadMutator_0, (Object)iPath));
        }
    }

    protected void createNewFile(IComponentHandle iComponentHandle, String[] stringArray, IVersionableHandle iVersionableHandle, Date date, ITeamRepository iTeamRepository, IContent iContent, MergeLoadMutator$DeferredUpdateInformation mergeLoadMutator$DeferredUpdateInformation, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        File file = PathUtils.getFile(this.root, stringArray);
        file.setLastModified(date.getTime());
        if (file.exists()) {
            this.deleteSubtree(file);
        }
        try {
            file.createNewFile();
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, 367, NLS.bind((String)Messages.LocalFileSystemMergeLoadMutator_1, (Object)file.getPath()), iOException)));
        }
        if (iContent != null) {
            this.contentSession.retrieveContent(iContent, (IDownloadHandler)new MergeLoadMutator$DownloadHandler(mergeLoadMutator$DeferredUpdateInformation, iVersionableHandle, this));
        }
    }

    protected IFileStorage createNewFolder(IComponentHandle iComponentHandle, String[] stringArray, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        File file = PathUtils.getFile(this.root, stringArray);
        if (!file.exists() && !file.mkdir()) {
            throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(4, 368, NLS.bind((String)Messages.LocalFileSystemMergeLoadMutator_2, (Object[])stringArray))));
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
        return new LocalFileStorage(this.getRoot(), file);
    }

    private void deleteSubtree(File file) throws FileSystemClientException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = 0;
            while (n < fileArray.length) {
                this.deleteSubtree(fileArray[n]);
                ++n;
            }
        }
        file.delete();
    }

    protected void deleteSubtree(IPath iPath, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        File file = PathUtils.getFile(this.root, iPath.segments());
        if (iPath.segmentCount() == 0) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (file.exists()) {
            this.deleteSubtree(file);
        }
    }

    protected List getChildren(IPath iPath) throws FileSystemClientException {
        File file = PathUtils.getFile(this.root, iPath.segments());
        File[] fileArray = file.listFiles();
        if (fileArray == null || fileArray.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ShareableFile> arrayList = new ArrayList<ShareableFile>();
        int n = 0;
        while (n < fileArray.length) {
            arrayList.add(new ShareableFile(this.getRoot(), fileArray[n]));
            ++n;
        }
        return arrayList;
    }

    protected Shareable getShareable(IPath iPath) {
        File file = PathUtils.getFile(this.root, iPath.segments());
        if (file.exists()) {
            return new ShareableFile(this.getRoot(), file);
        }
        return null;
    }

    protected boolean isSpecialCase(IShareable iShareable) {
        return false;
    }

    protected IFileStorage pathToIFileStorage(IPath iPath) {
        File file = PathUtils.getFile(this.root, iPath.segments());
        return new LocalFileStorage(this.getRoot(), file);
    }

    protected void modifyFile(IComponentHandle iComponentHandle, IVersionableHandle iVersionableHandle, ITeamRepository iTeamRepository, Date date, MergeLoadMutator$DeferredUpdateInformation mergeLoadMutator$DeferredUpdateInformation, IProgressMonitor iProgressMonitor) throws FileSystemClientException, TeamRepositoryException {
        this.contentSession.retrieveContent(mergeLoadMutator$DeferredUpdateInformation.content, (IDownloadHandler)new MergeLoadMutator$DownloadHandler(mergeLoadMutator$DeferredUpdateInformation, iVersionableHandle, this));
    }

    protected Shareable getNonExistantShareable(FileItemInfo fileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IPath iPath = CopyFileAreaStore.getCopyFileArea(this.getRoot()).getLocalPathFor(fileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle, iProgressMonitor);
        File file = PathUtils.getFile(this.root, iPath.segments());
        return new ShareableFile(this.getRoot(), file);
    }
}

