/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.load;

import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.operations.ILoadOverlap;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.IAncestorReport;
import com.ibm.team.scm.common.dto.INameItemPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class LoadOverlap
implements ILoadOverlap {
    private IConnection connection;
    private IComponentHandle component;
    private ArrayList overlappingFolders;
    private ArrayList overlappingShares;
    private IAncestorReport overlappedFolder;

    public LoadOverlap(IConnection iConnection, IComponentHandle iComponentHandle, IAncestorReport iAncestorReport) {
        this.connection = iConnection;
        this.component = iComponentHandle;
        this.overlappedFolder = iAncestorReport;
        this.overlappingFolders = new ArrayList();
        this.overlappingShares = new ArrayList();
    }

    public IComponentHandle getComponent() {
        return this.component;
    }

    public IConnection getConnection() {
        return this.connection;
    }

    public IFolderHandle getFolder() {
        return (IFolderHandle)this.getVersionableRepresented(this.overlappedFolder);
    }

    public String[] getFolderPath() {
        return this.getPathRepresented(this.overlappedFolder);
    }

    public Collection getOverlappingShares() {
        return Collections.unmodifiableCollection(this.overlappingShares);
    }

    public Collection getOverlappingFolders() {
        ArrayList<IFolderHandle> arrayList = new ArrayList<IFolderHandle>(this.overlappingFolders.size());
        for (IAncestorReport iAncestorReport : this.overlappingFolders) {
            arrayList.add((IFolderHandle)this.getVersionableRepresented(iAncestorReport));
        }
        return Collections.unmodifiableCollection((Collection)arrayList);
    }

    public Collection getOverlappingFolderPaths() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>(this.overlappingFolders.size());
        for (IAncestorReport iAncestorReport : this.overlappingFolders) {
            arrayList.add(this.getPathRepresented(iAncestorReport));
        }
        return Collections.unmodifiableCollection((Collection)arrayList);
    }

    public void addOverlappingFolder(IAncestorReport iAncestorReport) {
        this.overlappingFolders.add(iAncestorReport);
    }

    public void addOverlappingShare(IShare iShare) {
        this.overlappingShares.add(iShare);
    }

    private IVersionableHandle getVersionableRepresented(IAncestorReport iAncestorReport) {
        List list = iAncestorReport.getNameItemPairs();
        INameItemPair iNameItemPair = (INameItemPair)list.get(list.size() - 1);
        return iNameItemPair.getItem();
    }

    private String[] getPathRepresented(IAncestorReport iAncestorReport) {
        List list = iAncestorReport.getNameItemPairs();
        String[] stringArray = new String[list.size() - 1];
        int n = 0;
        Iterator iterator = list.iterator();
        iterator.next();
        while (iterator.hasNext()) {
            INameItemPair iNameItemPair = (INameItemPair)iterator.next();
            stringArray[n] = iNameItemPair.getName();
            ++n;
        }
        return stringArray;
    }
}

