/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore.loaders;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider$IFilesystemAbstraction;
import com.ibm.team.filesystem.client.internal.ignore.GlobalIgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader$IIgnoreFileLoader;
import com.ibm.team.filesystem.client.internal.ignore.IgnorePattern;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRuleComparator;
import com.ibm.team.filesystem.client.internal.ignore.JazzIgnoreFile;
import com.ibm.team.filesystem.client.internal.ignore.LocalIgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.loaders.PropertiesLoader_0;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JazzIgnoreFileLoader_0
implements IgnoreFileLoader$IIgnoreFileLoader {
    public static final String ENCODING = "UTF-8";
    private static Collection<IgnorePattern> rootIgnorePatterns;
    int VERSION = 0;
    public static final char DELIM_START = '{';
    public static final char DELIM_END = '}';
    public static final char ESCAPE = '\\';
    public static final String ESCAPED_DELIM_END = "\\}";
    public static final String ESCAPED_ESCAPE = "\\\\";

    static {
        String pattern;
        rootIgnorePatterns = new ArrayList<IgnorePattern>(JazzIgnoreFile.DEFAULT_PROP_IGNORE_GLOBAL.length + JazzIgnoreFile.DEFAULT_PROP_IGNORE_LOCAL.length);
        String[] stringArray = JazzIgnoreFile.DEFAULT_PROP_IGNORE_GLOBAL;
        int n = JazzIgnoreFile.DEFAULT_PROP_IGNORE_GLOBAL.length;
        int n2 = 0;
        while (n2 < n) {
            pattern = stringArray[n2];
            rootIgnorePatterns.add(new IgnorePattern(){

                public String getPattern() {
                    return pattern;
                }

                public boolean isGlobal() {
                    return true;
                }
            });
            ++n2;
        }
        stringArray = JazzIgnoreFile.DEFAULT_PROP_IGNORE_LOCAL;
        n = JazzIgnoreFile.DEFAULT_PROP_IGNORE_LOCAL.length;
        n2 = 0;
        while (n2 < n) {
            pattern = stringArray[n2];
            rootIgnorePatterns.add(new IgnorePattern(){

                public String getPattern() {
                    return pattern;
                }

                public boolean isGlobal() {
                    return false;
                }
            });
            ++n2;
        }
        rootIgnorePatterns = Collections.unmodifiableCollection(rootIgnorePatterns);
    }

    @Override
    public JazzIgnoreFile load(int version, String encoding, DefaultIgnoreProvider$IFilesystemAbstraction filesystem, InputStream inputStream, IIgnoreProvider p, IShareable ignoreFile) throws FileSystemClientException {
        DefaultIgnoreProvider provider = (DefaultIgnoreProvider)p;
        Properties props = this.loadProperties(ignoreFile, encoding, inputStream);
        SortedSet<IgnoreRule> rules = this.parseProperties(ignoreFile, provider, props);
        return new JazzIgnoreFile(provider, ignoreFile, rules, filesystem.lastModified(ignoreFile), filesystem.size(ignoreFile, null));
    }

    private Properties loadProperties(IShareable ignoreFile, String encoding, InputStream inputStream) {
        Properties props;
        try {
            try {
                props = PropertiesLoader_0.load(inputStream, encoding);
            }
            catch (IOException e) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(4, "Unable to load properties file " + ignoreFile.getLocalFullPath(), (Throwable)e));
                Properties properties = new Properties();
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                return properties;
            }
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return props;
    }

    private SortedSet<IgnoreRule> parseProperties(IShareable ignoreFile, DefaultIgnoreProvider provider, Properties properties) {
        String prop;
        boolean ignoreCase = false;
        TreeSet<IgnoreRule> contents = new TreeSet<IgnoreRule>(IgnoreRuleComparator.INSTANCE);
        boolean isGlobal = this.isGlobal(ignoreFile.getLocalFullPath());
        String[] localProps = JazzIgnoreFileLoader_0.tokenizeProperties("core.ignore", properties);
        if (localProps == null) {
            localProps = isGlobal ? JazzIgnoreFile.DEFAULT_PROP_IGNORE_LOCAL : new String[]{};
        }
        String[] stringArray = localProps;
        int n = localProps.length;
        int n2 = 0;
        while (n2 < n) {
            prop = stringArray[n2];
            contents.add(new LocalIgnoreRule(ignoreFile, provider, prop, ignoreCase, false));
            ++n2;
        }
        if (isGlobal) {
            String[] globalProps = JazzIgnoreFileLoader_0.tokenizeProperties("core.global.ignore", properties);
            if (globalProps == null) {
                globalProps = JazzIgnoreFile.DEFAULT_PROP_IGNORE_GLOBAL;
            }
            stringArray = globalProps;
            n = globalProps.length;
            n2 = 0;
            while (n2 < n) {
                prop = stringArray[n2];
                contents.add(new GlobalIgnoreRule(ignoreFile, provider, prop, ignoreCase, false));
                ++n2;
            }
        }
        return contents;
    }

    public static String[] tokenizeProperties(String name, Properties properties) {
        String prop = properties.getProperty(name);
        if (prop == null) {
            return null;
        }
        String trimmed = prop.trim();
        ParseState state = ParseState.IN_SEP;
        LinkedList<String> patterns = new LinkedList<String>();
        StringBuffer accumulator = new StringBuffer();
        int i = 0;
        while (i < trimmed.length()) {
            char c = trimmed.charAt(i);
            switch (state) {
                case IN_SEP: {
                    if (Character.isWhitespace(c)) break;
                    if (c == '{') {
                        state = ParseState.IN_DELIM_PATTERN;
                        break;
                    }
                    state = ParseState.IN_NON_DELIM_PATTERN;
                    accumulator.append(c);
                    break;
                }
                case IN_DELIM_PATTERN: {
                    if (c == '\\') {
                        state = ParseState.ESCAPED;
                        break;
                    }
                    if (c == '}') {
                        state = ParseState.IN_SEP;
                        patterns.add(accumulator.toString());
                        accumulator = new StringBuffer();
                        break;
                    }
                    accumulator.append(c);
                    break;
                }
                case IN_NON_DELIM_PATTERN: {
                    if (Character.isWhitespace(c)) {
                        state = ParseState.IN_SEP;
                        patterns.add(accumulator.toString());
                        accumulator = new StringBuffer();
                        break;
                    }
                    accumulator.append(c);
                    break;
                }
                case ESCAPED: {
                    accumulator.append(c);
                    state = ParseState.IN_DELIM_PATTERN;
                }
            }
            ++i;
        }
        if (accumulator.length() > 0) {
            patterns.add(accumulator.toString());
        }
        if (trimmed.length() == 0) {
            return new String[0];
        }
        return patterns.toArray(new String[patterns.size()]);
    }

    private boolean isGlobal(IPath path) {
        return path.segmentCount() == 2;
    }

    public JazzIgnoreFile store(DefaultIgnoreProvider$IFilesystemAbstraction filesystem, DefaultIgnoreProvider provider, IShareable ignoreFile, SortedSet<IgnoreRule> rules) throws FileSystemClientException {
        byte[] bytes = this.asBytes(ignoreFile.getLocalFullPath(), rules);
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        filesystem.write(ignoreFile, in);
        return new JazzIgnoreFile(provider, ignoreFile, rules, filesystem.lastModified(ignoreFile), filesystem.size(ignoreFile, null));
    }

    private void writeRules(IPath path, Collection<IgnoreRule> toWrite, OutputStreamWriter writer) throws IOException {
        LinkedList<StringBuffer> local = new LinkedList<StringBuffer>();
        LinkedList global = new LinkedList();
        for (IgnoreRule ignoreRule : toWrite) {
            StringBuffer pattern = this.encodePattern(ignoreRule.getMatcher().getPattern());
            LinkedList<StringBuffer> dest = local;
            if (ignoreRule.isGlobal()) {
                dest = global;
            }
            dest.add(pattern);
        }
        if (this.isGlobal(path)) {
            writer.write("core.global.ignore= ");
            for (CharSequence charSequence : global) {
                writer.write("\\\n\t" + charSequence + " ");
            }
        }
        writer.write("\n\n");
        writer.write("core.ignore= ");
        for (CharSequence charSequence : local) {
            writer.write("\\\n\t" + charSequence + " ");
        }
    }

    private StringBuffer encodePattern(String pattern) {
        StringBuffer buf = new StringBuffer(pattern.length() + 2);
        buf.append('{');
        int i = 0;
        while (i < pattern.length()) {
            char c = pattern.charAt(i);
            if (c == '}') {
                buf.append(ESCAPED_DELIM_END);
            } else if (c == '\\') {
                buf.append(ESCAPED_ESCAPE);
            } else {
                buf.append(c);
            }
            ++i;
        }
        buf.append('}');
        return buf;
    }

    private String getComment(IPath path) {
        String baseExplanation = Messages.JazzIgnoreFileLoader_0_11;
        baseExplanation = String.valueOf(baseExplanation) + Messages.JazzIgnoreFileLoader_0_12;
        if (this.isGlobal(path)) {
            return String.valueOf(NLS.bind((String)Messages.JazzIgnoreFileLoader_0_13, (Object[])new Object[]{"core.global.ignore", "*.class", "core.ignore", "bin"})) + baseExplanation;
        }
        return String.valueOf(NLS.bind((String)Messages.JazzIgnoreFileLoader_0_14, (Object[])new Object[]{"core.ignore", "core.global.ignore"})) + baseExplanation;
    }

    @Override
    public int getVersion() {
        return this.VERSION;
    }

    public byte[] asBytes(IPath path, SortedSet<IgnoreRule> rules) throws FileSystemClientException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            stream.write(IgnoreFileLoader.getInstance().getIgnorePreamble(this.VERSION));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, ENCODING);
            writer.write(this.getComment(path));
            this.writeRules(path, rules, writer);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new FileSystemClientException(FileSystemStatus.getStatusFor(e));
        }
        return stream.toByteArray();
    }

    @Override
    public Collection<IgnorePattern> getDefaultIgnorePatterns(IPath path) {
        if (this.isGlobal(path)) {
            return rootIgnorePatterns;
        }
        return Collections.EMPTY_LIST;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ParseState {
        IN_SEP,
        IN_DELIM_PATTERN,
        ESCAPED,
        IN_NON_DELIM_PATTERN;

    }
}

