/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider$IFilesystemAbstraction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class ReadThroughFilesystemAbstraction
implements DefaultIgnoreProvider$IFilesystemAbstraction {
    private HashMap<IShareable, FileRecord> filesystem = new HashMap();

    public void copyToDisk(IProgressMonitor progress) throws FileSystemClientException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)this.filesystem.size());
        try {
            monitor.setTaskName(Messages.ReadThroughFilesystemAbstraction_STORE_PROGRESS);
            for (Map.Entry<IShareable, FileRecord> entry : this.filesystem.entrySet()) {
                monitor.subTask(NLS.bind((String)Messages.ReadThroughFilesystemAbstraction_STORE_ITEM, (Object)entry.getKey().getLocalFullPath()));
                ByteArrayInputStream in = new ByteArrayInputStream(entry.getValue().bytes);
                IFileStorage store = ((Shareable)entry.getKey()).getFileStorage();
                if (store.exists()) {
                    store.setContents(in, (IProgressMonitor)monitor.newChild(1));
                    continue;
                }
                store.create(in, (IProgressMonitor)monitor.newChild(1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private static byte[] copyIntoByteArray(InputStream in) throws IOException {
        ByteArrayOutputStream store = new ByteArrayOutputStream();
        byte[] data = new byte[1024];
        try {
            int read;
            while ((read = in.read(data)) != -1) {
                store.write(data, 0, read);
            }
        }
        catch (Throwable throwable) {
            try {
                store.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            store.close();
        }
        catch (IOException iOException) {}
        return store.toByteArray();
    }

    public boolean exists(IShareable file) {
        if (this.filesystem.containsKey(file)) {
            return true;
        }
        return ((Shareable)file).getFileStorage().exists();
    }

    public InputStream read(IShareable file) throws FileSystemClientException {
        if (!this.filesystem.containsKey(file)) {
            IFileStorage storage = ((Shareable)file).getFileStorage();
            if (storage.exists()) {
                InputStream inputStream = storage.getContents();
                try {
                    try {
                        this.filesystem.put(file, new FileRecord(ReadThroughFilesystemAbstraction.copyIntoByteArray(inputStream), 0L));
                    }
                    catch (IOException e) {
                        throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", String.valueOf(Messages.ReadThroughFilesystemAbstraction_EXCEPTION_READING) + file.getLocalFullPath(), (Throwable)e));
                    }
                }
                catch (Throwable throwable) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            } else {
                return null;
            }
        }
        return new ByteArrayInputStream(this.filesystem.get((Object)file).bytes);
    }

    public void write(IShareable file, InputStream in) throws FileSystemClientException {
        FileRecord oldRecord = this.filesystem.get(file);
        try {
            try {
                this.filesystem.put(file, new FileRecord(ReadThroughFilesystemAbstraction.copyIntoByteArray(in), oldRecord == null ? 0L : oldRecord.lastModified + 1L));
            }
            catch (IOException e) {
                throw new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", String.valueOf(Messages.ReadThroughFilesystemAbstraction_EXCEPTION_WRITING) + file.getLocalFullPath(), (Throwable)e));
            }
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    public long lastModified(IShareable file) {
        FileRecord record = this.filesystem.get(file);
        return record == null ? -1L : record.lastModified;
    }

    public long size(IShareable file, IProgressMonitor monitor) throws FileSystemClientException {
        FileRecord record = this.filesystem.get(file);
        if (record == null) {
            return ((Shareable)file).getFileStorage().getSize(monitor);
        }
        return record.bytes.length;
    }

    public Object clone() {
        return new ReadThroughFilesystemAbstraction();
    }

    private class FileRecord {
        byte[] bytes;
        long lastModified;

        public FileRecord(byte[] bytes, long lastModified) {
            this.bytes = bytes;
            this.lastModified = lastModified;
        }
    }
}

