/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider$IFilesystemAbstraction;
import com.ibm.team.filesystem.client.internal.ignore.GlobalIgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader$FileInaccessibleException;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader$IIgnoreFileLoader;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader$IgnoreFileMetadata;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader$IgnoreFileVersionException;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRuleComparator;
import com.ibm.team.filesystem.client.internal.ignore.JazzIgnoreFile;
import com.ibm.team.filesystem.client.internal.ignore.LocalIgnoreRule;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class IgnoreFileLoader {
    static final byte[] PREAMBLE = "### Jazz Ignore ".getBytes();
    public static final String PT_IGNORE_FORMAT = "ignoreFileFormat";
    private IgnoreFileLoader$IIgnoreFileLoader latestLoader = null;
    private Map loaders = new HashMap();
    private static IgnoreFileLoader instance;

    public static synchronized IgnoreFileLoader getInstance() {
        if (instance == null) {
            IConfigurationElement[] iConfigurationElementArray;
            instance = new IgnoreFileLoader();
            int n = -1;
            IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", PT_IGNORE_FORMAT);
            int n2 = iConfigurationElementArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n3];
                try {
                    IgnoreFileLoader$IIgnoreFileLoader ignoreFileLoader$IIgnoreFileLoader = (IgnoreFileLoader$IIgnoreFileLoader)iConfigurationElement.createExecutableExtension("class");
                    if (IgnoreFileLoader.instance.loaders.containsKey(ignoreFileLoader$IIgnoreFileLoader.getVersion())) {
                        LoggingHelper.error("com.ibm.team.filesystem.client", "Duplicate ignore providers for version " + ignoreFileLoader$IIgnoreFileLoader.getVersion(), null);
                    } else {
                        IgnoreFileLoader.instance.loaders.put(ignoreFileLoader$IIgnoreFileLoader.getVersion(), ignoreFileLoader$IIgnoreFileLoader);
                        n = Math.max(ignoreFileLoader$IIgnoreFileLoader.getVersion(), n);
                    }
                }
                catch (CoreException coreException) {
                    LoggingHelper.log(coreException);
                }
                ++n3;
            }
            if (n > -1) {
                IgnoreFileLoader.instance.latestLoader = (IgnoreFileLoader$IIgnoreFileLoader)IgnoreFileLoader.instance.loaders.get(n);
            }
        }
        return instance;
    }

    public byte[] getIgnorePreamble(int n) {
        byte[] byArray = Integer.toString(n).getBytes();
        byte[] byArray2 = new byte[PREAMBLE.length + byArray.length + 1];
        System.arraycopy(PREAMBLE, 0, byArray2, 0, PREAMBLE.length);
        System.arraycopy(byArray, 0, byArray2, PREAMBLE.length, byArray.length);
        byArray2[byArray2.length - 1] = 10;
        return byArray2;
    }

    public JazzIgnoreFile load(DefaultIgnoreProvider defaultIgnoreProvider, IShareable iShareable, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException, IgnoreFileLoader$FileInaccessibleException {
        return this.load(defaultIgnoreProvider.getFilesystem(), defaultIgnoreProvider, iShareable, bl, iProgressMonitor);
    }

    public JazzIgnoreFile load(DefaultIgnoreProvider$IFilesystemAbstraction defaultIgnoreProvider$IFilesystemAbstraction, DefaultIgnoreProvider defaultIgnoreProvider, IShareable iShareable, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException, IgnoreFileLoader$FileInaccessibleException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)1);
        JazzIgnoreFile jazzIgnoreFile = null;
        jazzIgnoreFile = this.load(defaultIgnoreProvider$IFilesystemAbstraction, defaultIgnoreProvider, iShareable, (IProgressMonitor)subMonitor);
        if (jazzIgnoreFile == null) {
            if (this.isGlobal(iShareable.getLocalFullPath())) {
                return this.createGlobalIgnoreFile(defaultIgnoreProvider, iShareable);
            }
            if (bl) {
                jazzIgnoreFile = new JazzIgnoreFile(defaultIgnoreProvider, iShareable, new TreeSet(IgnoreRuleComparator.INSTANCE), -1L, -2L);
            }
        }
        subMonitor.done();
        return jazzIgnoreFile;
    }

    public JazzIgnoreFile createGlobalIgnoreFile(DefaultIgnoreProvider defaultIgnoreProvider, IShareable iShareable) {
        TreeSet<IgnoreRule> treeSet = new TreeSet<IgnoreRule>(IgnoreRuleComparator.INSTANCE);
        treeSet.add(new LocalIgnoreRule(iShareable, defaultIgnoreProvider, JazzIgnoreFile.DEFAULT_PROP_IGNORE_LOCAL[0], false, false));
        treeSet.add(new GlobalIgnoreRule(iShareable, defaultIgnoreProvider, JazzIgnoreFile.DEFAULT_PROP_IGNORE_GLOBAL[0], false, false));
        return new JazzIgnoreFile(defaultIgnoreProvider, iShareable, treeSet, -1L, -2L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JazzIgnoreFile load(DefaultIgnoreProvider$IFilesystemAbstraction defaultIgnoreProvider$IFilesystemAbstraction, DefaultIgnoreProvider defaultIgnoreProvider, IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException, IgnoreFileLoader$FileInaccessibleException {
        JazzIgnoreFile jazzIgnoreFile;
        IgnoreFileLoader$IgnoreFileMetadata ignoreFileLoader$IgnoreFileMetadata;
        IgnoreFileLoader$IIgnoreFileLoader ignoreFileLoader$IIgnoreFileLoader;
        InputStream inputStream;
        block23: {
            inputStream = null;
            ignoreFileLoader$IIgnoreFileLoader = null;
            ignoreFileLoader$IgnoreFileMetadata = null;
            inputStream = defaultIgnoreProvider$IFilesystemAbstraction.read(iShareable);
            if (inputStream == null) {
                if (defaultIgnoreProvider$IFilesystemAbstraction.exists(iShareable)) {
                    throw (Throwable)new IgnoreFileLoader$FileInaccessibleException();
                }
                return null;
            }
            try {
                try {
                    ignoreFileLoader$IgnoreFileMetadata = this.consumeVersionPreamble(inputStream);
                    Map map = this.loaders;
                    synchronized (map) {
                        ignoreFileLoader$IIgnoreFileLoader = (IgnoreFileLoader$IIgnoreFileLoader)this.loaders.get(ignoreFileLoader$IgnoreFileMetadata.version);
                    }
                }
                catch (IgnoreFileLoader$IgnoreFileVersionException ignoreFileLoader$IgnoreFileVersionException) {
                    ignoreFileLoader$IgnoreFileMetadata = new IgnoreFileLoader$IgnoreFileMetadata(null);
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    break block23;
                }
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        if (ignoreFileLoader$IIgnoreFileLoader == null && (ignoreFileLoader$IIgnoreFileLoader = this.latestLoader) == null) {
            return new JazzIgnoreFile(defaultIgnoreProvider, iShareable, new TreeSet(IgnoreRuleComparator.INSTANCE), -1L, -2L);
        }
        try {
            inputStream = defaultIgnoreProvider$IFilesystemAbstraction.read(iShareable);
            jazzIgnoreFile = ignoreFileLoader$IIgnoreFileLoader.load(ignoreFileLoader$IgnoreFileMetadata.version, ignoreFileLoader$IgnoreFileMetadata.encoding, defaultIgnoreProvider$IFilesystemAbstraction, inputStream, defaultIgnoreProvider, iShareable);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {}
        return jazzIgnoreFile;
    }

    private boolean isGlobal(IPath iPath) {
        return iPath.segmentCount() == 2;
    }

    private IgnoreFileLoader$IgnoreFileMetadata consumeVersionPreamble(InputStream inputStream) throws IgnoreFileLoader$IgnoreFileVersionException, FileSystemClientException {
        IgnoreFileLoader$IgnoreFileMetadata ignoreFileLoader$IgnoreFileMetadata = new IgnoreFileLoader$IgnoreFileMetadata(null);
        ignoreFileLoader$IgnoreFileMetadata.version = -1;
        ignoreFileLoader$IgnoreFileMetadata.encoding = "UTF-8";
        try {
            int n;
            int n2 = 0;
            while ((n = inputStream.read()) != -1 && n2 < PREAMBLE.length) {
                if (n == PREAMBLE[n2++]) continue;
                throw (Throwable)new IgnoreFileLoader$IgnoreFileVersionException(NLS.bind((String)Messages.IgnoreFileLoader_6, (Object)n2));
            }
            while ((n = inputStream.read()) != -1 && Character.isDigit(n)) {
                ignoreFileLoader$IgnoreFileMetadata.version = ignoreFileLoader$IgnoreFileMetadata.version * 10 + (n - 48);
            }
            if (n == -1) {
                throw (Throwable)new IgnoreFileLoader$IgnoreFileVersionException(Messages.IgnoreFileLoader_7);
            }
            if (n == 13 || n == 10) {
                return ignoreFileLoader$IgnoreFileMetadata;
            }
            throw (Throwable)new IgnoreFileLoader$IgnoreFileVersionException(Messages.IgnoreFileLoader_8);
        }
        catch (IOException iOException) {
            throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(Messages.IgnoreFileLoader_9)));
        }
    }

    public JazzIgnoreFile createNew(IShareable iShareable, DefaultIgnoreProvider defaultIgnoreProvider, SortedSet sortedSet) throws FileSystemClientException {
        if (this.latestLoader == null) {
            return null;
        }
        return this.latestLoader.store(defaultIgnoreProvider.getFilesystem(), defaultIgnoreProvider, iShareable, sortedSet);
    }

    public byte[] asBytes(IPath iPath, SortedSet sortedSet) throws FileSystemClientException {
        if (this.latestLoader == null) {
            throw (Throwable)new IllegalStateException();
        }
        return this.latestLoader.asBytes(iPath, sortedSet);
    }

    public Collection getDefaultIgnorePatterns(IPath iPath) {
        if (this.latestLoader == null) {
            throw (Throwable)new IllegalStateException();
        }
        return this.latestLoader.getDefaultIgnorePatterns(iPath);
    }
}

