/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.ignore.GlobalIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IDefaultIgnoreProviderEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreEvent$1;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreEvent$2;
import com.ibm.team.filesystem.client.internal.utils.IgnoreUtils;
import com.ibm.team.repository.client.util.IEventSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class IgnoreEvent
implements IDefaultIgnoreProviderEvent {
    private final IShareable ignoreFile;
    private final String type;
    protected Collection changed;
    private final IIgnoreManager source;
    private final List categories;
    protected List roots;
    private Collection rules;

    public IgnoreEvent(IIgnoreManager iIgnoreManager, IShareable iShareable, List list, String string, List list2, Collection collection) {
        this.source = iIgnoreManager;
        this.ignoreFile = iShareable;
        this.roots = list;
        this.type = string;
        if (list2.contains(string)) {
            this.categories = list2;
        } else {
            this.categories = new ArrayList(list2.size() + 1);
            this.categories.add(string);
            this.categories.addAll(list2);
        }
        this.rules = collection;
    }

    public String getChangeType() {
        return this.type;
    }

    public abstract boolean isEffectiveBelow(IShareable var1);

    public Collection getChanged(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if ("unknown".equals(this.getChangeType())) {
            return null;
        }
        if (this.changed == null) {
            this.changed = new LinkedList();
            if ("ignore".equals(this.getChangeType())) {
                this.gatherNewlyIgnored(iProgressMonitor);
            } else if ("unignore".equals(this.getChangeType())) {
                this.gatherNewlyUnignored(iProgressMonitor);
            } else {
                throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.IgnoreEvent_0, (Object)this.getChangeType()));
            }
        }
        return this.changed;
    }

    private Collection gatherNewlyIgnored(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Assert.isTrue((boolean)"ignore".equals(this.getChangeType()));
        IgnoreUtils.findIgnoresForRules(this.rules, new IgnoreEvent$1(this), iProgressMonitor);
        return this.changed;
    }

    private Collection gatherNewlyUnignored(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Assert.isTrue((boolean)"unignore".equals(this.getChangeType()));
        if (this.rules == null) {
            this.changed = null;
            return null;
        }
        IgnoreUtils.findIgnoresForRules(this.rules, false, new IgnoreEvent$2(this), iProgressMonitor);
        return this.changed;
    }

    public Collection getRoots() {
        return this.roots;
    }

    public Collection getRules() {
        return this.rules;
    }

    public List getCategories() {
        return this.categories;
    }

    public IEventSource getEventSource() {
        return this.source;
    }

    public String getEventType() {
        return this.type;
    }

    public IShareable getIgnoreFile() {
        return this.ignoreFile;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (IShareable iShareable : this.roots) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(iShareable.getLocalFullPath().toString());
        }
        return "IgnoreEvent(" + (this instanceof GlobalIgnoreEvent ? "GLOBAL" : "LOCAL") + ", [" + stringBuffer + "], type:" + this.getEventType() + ")";
    }

    static /* synthetic */ IIgnoreManager access$0(IgnoreEvent ignoreEvent) {
        return ignoreEvent.source;
    }
}

