/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider$1;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider$IDefaultIgnoreProviderCopyReason;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider$IFilesystemAbstraction;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider$IIgnoreVisitor;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider$PassThroughFilesystemAbstraction;
import com.ibm.team.filesystem.client.internal.ignore.GlobalIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.GlobalIgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager$ICopyParameter;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager$IIgnoreReason;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider$IIgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreProvider$IIgnoreTester;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreFileLoader$FileInaccessibleException;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreProvider;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRule;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreRuleComparator;
import com.ibm.team.filesystem.client.internal.ignore.JazzIgnoreFile;
import com.ibm.team.filesystem.client.internal.ignore.LocalIgnoreEvent;
import com.ibm.team.filesystem.client.internal.ignore.LocalIgnoreRule;
import com.ibm.team.filesystem.client.internal.operations.IgnoreFileAgeDBHM;
import com.ibm.team.filesystem.client.internal.utils.LRUCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class DefaultIgnoreProvider
extends IgnoreProvider
implements IIgnoreProvider$IIgnoreTester,
ICopyFileAreaListener {
    public static final String EVENT_EXTERNAL_CHANGE = "external_change";
    private static final List CATEGORY_EXTERNAL_CHANGE = Collections.singletonList("external_change");
    public static final double FILE_CACHE_RATIO = 1.2;
    private static final int FILE_CACHE_MIN = 10;
    private static final int FILE_CACHE_NO_DEFAULT_CFA = 300;
    private final LRUCache files;
    private int shareCount;
    private IgnoreFileAgeDBHM fileAges = new IgnoreFileAgeDBHM();
    private boolean shouldInvalidateCache = false;
    private final DefaultIgnoreProvider$IFilesystemAbstraction filesystem;
    public static final String IGNORE_FILE_NAME = ".jazzignore";
    Set modifiedFiles = new HashSet();

    private IShareable getParentFor(IShareable iShareable) {
        return ((Shareable)iShareable).getParent();
    }

    public static DefaultIgnoreProvider getDefault() {
        return (DefaultIgnoreProvider)SharingManager.getInstance().getIgnoreManager().getIgnoreProvider("default");
    }

    public DefaultIgnoreProvider() {
        this(new DefaultIgnoreProvider$PassThroughFilesystemAbstraction());
    }

    public DefaultIgnoreProvider(DefaultIgnoreProvider$IFilesystemAbstraction defaultIgnoreProvider$IFilesystemAbstraction) {
        this.filesystem = defaultIgnoreProvider$IFilesystemAbstraction;
        SharingManager sharingManager = SharingManager.getInstance();
        IPath iPath = sharingManager.getDefaultCFARoot();
        this.shareCount = 300;
        if (iPath != null) {
            try {
                this.shareCount = sharingManager.allShares(iPath).length;
            }
            catch (FileSystemClientException fileSystemClientException) {
                this.shareCount = 0;
            }
            sharingManager.addListener(iPath, this);
        }
        this.files = new LRUCache(DefaultIgnoreProvider.computeFileCacheSize(this.shareCount));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void change(ICopyFileAreaEvent[] iCopyFileAreaEventArray) {
        Object object;
        int n = 0;
        LinkedList<IPath> linkedList = null;
        ICopyFileAreaEvent[] iCopyFileAreaEventArray2 = iCopyFileAreaEventArray;
        int n2 = iCopyFileAreaEventArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = iCopyFileAreaEventArray2[n3];
            switch (object.getReason()) {
                case 1: {
                    ++n;
                    break;
                }
                case 2: {
                    if (linkedList == null) {
                        linkedList = new LinkedList<IPath>();
                    }
                    linkedList.add(object.getPath());
                    --n;
                }
            }
            ++n3;
        }
        if (n == 0) {
            return;
        }
        object = this.files;
        synchronized (object) {
            this.shareCount += n;
            n3 = DefaultIgnoreProvider.computeFileCacheSize(this.shareCount);
            this.files.setSpaceLimit(n3);
            if (linkedList != null) {
                for (IPath iPath : linkedList) {
                    Iterator iterator = this.files.keys();
                    while (iterator.hasNext()) {
                        IPath iPath2 = (IPath)iterator.next();
                        if (!iPath.isPrefixOf(iPath2)) continue;
                        iterator.remove();
                    }
                }
                this.shouldInvalidateCache = true;
            }
        }
    }

    private static int computeFileCacheSize(int n) {
        return (int)Math.max(10.0, (double)n * 1.2);
    }

    public List findIgnoreReasons(IShareable iShareable, IPath iPath) {
        List list;
        if (iPath.segmentCount() < 2) {
            return Collections.EMPTY_LIST;
        }
        IPath iPath2 = iPath.removeLastSegments(1);
        ArrayList arrayList = new ArrayList();
        JazzIgnoreFile jazzIgnoreFile = null;
        try {
            jazzIgnoreFile = this.getGlobalIgnoreFile(iShareable);
        }
        catch (FileSystemClientException fileSystemClientException) {
            LoggingHelper.log(fileSystemClientException.getStatus());
        }
        if (jazzIgnoreFile != null && (list = jazzIgnoreFile.findIgnoreReasons(iPath)) != null) {
            arrayList.addAll(list);
        }
        JazzIgnoreFile jazzIgnoreFile2 = null;
        try {
            jazzIgnoreFile2 = this.getIgnoreFileForFolder(iShareable, iPath2, false);
        }
        catch (FileSystemClientException fileSystemClientException) {
            LoggingHelper.log(fileSystemClientException.getStatus());
        }
        if (jazzIgnoreFile2 == jazzIgnoreFile || jazzIgnoreFile2 == null) {
            return arrayList;
        }
        list = jazzIgnoreFile2.findIgnoreReasons(iPath);
        if (list != null) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    public IgnoreRule getIgnoreRuleFor(IShareable iShareable, boolean bl) {
        IPath iPath = iShareable.getLocalFullPath();
        String string = iPath.lastSegment();
        if (bl) {
            return new GlobalIgnoreRule(this.getGlobalIgnoreShareable(iShareable), this, string, false, false);
        }
        return new LocalIgnoreRule(this.getIgnoreShareableForFolder(iShareable, iPath.removeLastSegments(1)), this, string, false, false);
    }

    public List getIgnoreSuffixRulesFor(List list, boolean bl) {
        HashSet<String> hashSet;
        Object object2;
        HashMap<Object, HashSet<String>> hashMap = new HashMap<Object, HashSet<String>>();
        for (Object object2 : list) {
            IPath iPath = object2.getLocalFullPath();
            String string = iPath.getFileExtension();
            string = string == null || string.length() == 0 ? iPath.lastSegment() : "*." + string;
            Object object3 = null;
            object3 = bl ? this.getShareableForPath((IShareable)object2, this.getGlobalIgnoreRoot((IShareable)object2), false) : this.getShareableForPath((IShareable)object2, object2.getLocalFullPath().removeLastSegments(1), true);
            hashSet = (HashSet<String>)hashMap.get(object3);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
                hashMap.put(object3, hashSet);
            }
            hashSet.add(string);
        }
        object2 = new ArrayList(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            for (String string : (HashSet)entry.getValue()) {
                hashSet = null;
                IShareable iShareable = (IShareable)entry.getKey();
                hashSet = bl ? new GlobalIgnoreRule(this.getGlobalIgnoreShareable(iShareable), this, string, false, false) : new LocalIgnoreRule(this.getIgnoreShareableForFolder(iShareable, iShareable.getLocalFullPath()), this, string, false, false);
                ((ArrayList)object2).add(hashSet);
            }
        }
        return (List)object2;
    }

    public List getIgnoreRulesFor(String string, List list, boolean bl) {
        Object object2;
        HashSet<IShareable> hashSet = new HashSet<IShareable>();
        if (bl) {
            for (Object object2 : list) {
                hashSet.add(this.getShareableForPath((IShareable)object2, this.getGlobalIgnoreRoot((IShareable)object2), true));
            }
        } else {
            for (Object object2 : list) {
                hashSet.add(this.getParentFor((IShareable)object2));
            }
        }
        object2 = new ArrayList(hashSet.size());
        for (IShareable iShareable : hashSet) {
            IgnoreRule ignoreRule = null;
            ignoreRule = bl ? new GlobalIgnoreRule(this.getGlobalIgnoreShareable(iShareable), this, string, false, false) : new LocalIgnoreRule(this.getIgnoreShareableForFolder(iShareable, iShareable.getLocalFullPath()), this, string, false, false);
            object2.add(ignoreRule);
        }
        return (List)object2;
    }

    public IIgnoreProvider$IIgnoreRule ignore(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IShare iShare = iShareable.getShare();
        if (iShare == null) {
            throw (Throwable)((Object)new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", String.valueOf(Messages.DefaultIgnoreProvider_3) + iShareable.getLocalFullPath().toString())));
        }
        IShareable iShareable2 = this.getParentFor(iShareable);
        if (iShareable2 == null) {
            throw (Throwable)((Object)new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_4, (Object)iShareable.getLocalFullPath().toString()))));
        }
        if (!this.canIgnore(iShareable)) {
            throw (Throwable)((Object)new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_5, (Object)iShareable.getLocalFullPath().toString()))));
        }
        IgnoreRule ignoreRule = this.getIgnoreRuleFor(iShareable, false);
        this.addIgnoreRule(ignoreRule, iProgressMonitor);
        return ignoreRule;
    }

    public void unignore(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
        try {
            IIgnoreManager$IIgnoreReason iIgnoreManager$IIgnoreReason = this.getIgnoreManager().findIgnoreReasons(iShareable, iProgressMonitor);
            if (iIgnoreManager$IIgnoreReason == null) {
                throw (Throwable)((Object)new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_6, (Object)iShareable.getLocalFullPath()))));
            }
            if (iIgnoreManager$IIgnoreReason.inherited()) {
                throw (Throwable)((Object)new FileSystemClientException((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_7, (Object)iShareable.getLocalFullPath()))));
            }
            subMonitor.setWorkRemaining(iIgnoreManager$IIgnoreReason.getRules().size());
            for (IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule : iIgnoreManager$IIgnoreReason.getRules()) {
                this.removeIgnoreRule(iIgnoreProvider$IIgnoreRule, (IProgressMonitor)subMonitor.newChild(1));
            }
        }
        finally {
            subMonitor.done();
        }
    }

    public boolean canUnignore(IShareable iShareable) throws FileSystemClientException {
        IIgnoreManager$IIgnoreReason iIgnoreManager$IIgnoreReason = this.getIgnoreManager().findIgnoreReasons(iShareable, null);
        if (iIgnoreManager$IIgnoreReason == null) {
            return false;
        }
        for (IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule : iIgnoreManager$IIgnoreReason.getRules()) {
            if (iIgnoreProvider$IIgnoreRule.getProvider() == this) continue;
            return false;
        }
        Assert.isTrue((iIgnoreManager$IIgnoreReason.getRules().size() > 0 ? 1 : 0) != 0);
        return true;
    }

    public boolean canIgnore(IShareable iShareable) throws FileSystemClientException {
        if (iShareable.getShare() == null) {
            return false;
        }
        IPath iPath = iShareable.getLocalFullPath();
        if (iPath.segmentCount() <= 1) {
            return false;
        }
        return !this.getIgnoreManager().shouldBeIgnored(iShareable);
    }

    public void accept(Collection collection, DefaultIgnoreProvider$IIgnoreVisitor defaultIgnoreProvider$IIgnoreVisitor, DefaultIgnoreProvider$IFilesystemAbstraction defaultIgnoreProvider$IFilesystemAbstraction, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)collection.size());
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 4, Messages.DefaultIgnoreProvider_8, null);
        DefaultIgnoreProvider$IFilesystemAbstraction defaultIgnoreProvider$IFilesystemAbstraction2 = defaultIgnoreProvider$IFilesystemAbstraction == null ? this.filesystem : defaultIgnoreProvider$IFilesystemAbstraction;
        for (IShareable iShareable : collection) {
            boolean[] blArray = new boolean[1];
            iShareable.accept((IShareableVisitor)new DefaultIgnoreProvider$1(this, defaultIgnoreProvider$IFilesystemAbstraction2, multiStatus, blArray, defaultIgnoreProvider$IIgnoreVisitor), Integer.MAX_VALUE, true, false, (IProgressMonitor)subMonitor);
            if (blArray[0]) continue;
            defaultIgnoreProvider$IIgnoreVisitor.visit(this.getGlobalIgnoreFile(iShareable).getRules());
        }
        if (multiStatus.getChildren().length > 0) {
            throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
        }
    }

    private void removeRule(IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (!(iIgnoreProvider$IIgnoreRule instanceof IgnoreRule)) {
            throw (Throwable)new IllegalArgumentException(NLS.bind((String)Messages.DefaultIgnoreProvider_9, (Object)iIgnoreProvider$IIgnoreRule.getClass().getSimpleName()));
        }
        IgnoreRule ignoreRule = (IgnoreRule)iIgnoreProvider$IIgnoreRule;
        IShareable iShareable = ignoreRule.getRootShareable();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)3);
        JazzIgnoreFile jazzIgnoreFile = this.getIgnoreFileForFolder(iShareable, iShareable.getLocalFullPath(), false);
        if (jazzIgnoreFile == null) {
            return;
        }
        ISchedulingRule iSchedulingRule = this.findSchedulingRuleFor(ignoreRule.getFile());
        try {
            Job.getJobManager().beginRule(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            this.startModifyingFile(ignoreRule.getFile());
            try {
                JazzIgnoreFile jazzIgnoreFile2 = jazzIgnoreFile.removeRules(Collections.singleton(ignoreRule), (IProgressMonitor)subMonitor.newChild(1));
                this.updateCacheFor(iShareable.getLocalFullPath(), jazzIgnoreFile2);
            }
            finally {
                this.stopModifyingFile(ignoreRule.getFile(), subMonitor.newChild(1));
            }
        }
        finally {
            Job.getJobManager().endRule(iSchedulingRule);
        }
        subMonitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldInvalidateCache(IShareable iShareable) {
        LRUCache lRUCache = this.files;
        synchronized (lRUCache) {
            boolean bl = this.shouldInvalidateCache;
            this.shouldInvalidateCache = false;
            return bl;
        }
    }

    public IIgnoreProvider$IIgnoreTester getTester() {
        return this;
    }

    public boolean shouldBeIgnored(IShareable iShareable, IPath iPath) {
        List list;
        if (iPath.segmentCount() < 2) {
            return false;
        }
        IPath iPath2 = iPath.removeLastSegments(1);
        JazzIgnoreFile jazzIgnoreFile = null;
        try {
            jazzIgnoreFile = this.getGlobalIgnoreFile(iShareable);
        }
        catch (FileSystemClientException fileSystemClientException) {}
        if (jazzIgnoreFile != null && (list = jazzIgnoreFile.findIgnoreReasons(iPath)) != null && list.size() > 0) {
            return true;
        }
        jazzIgnoreFile = null;
        try {
            jazzIgnoreFile = this.getIgnoreFileForFolder(iShareable, iPath2, false);
        }
        catch (FileSystemClientException fileSystemClientException) {}
        if (jazzIgnoreFile == null) {
            return false;
        }
        list = jazzIgnoreFile.findIgnoreReasons(iPath);
        return list != null && list.size() > 0;
    }

    public DefaultIgnoreProvider$IFilesystemAbstraction getFilesystem() {
        return this.filesystem;
    }

    private IPath getGlobalIgnoreRoot(IShareable iShareable) {
        return iShareable.getLocalFullPath().uptoSegment(1);
    }

    private JazzIgnoreFile getGlobalIgnoreFile(IShareable iShareable) throws FileSystemClientException {
        JazzIgnoreFile jazzIgnoreFile = this.getIgnoreFileForFolder(iShareable, this.getGlobalIgnoreRoot(iShareable), false);
        if (jazzIgnoreFile == null) {
            jazzIgnoreFile = IgnoreFileLoader.getInstance().createGlobalIgnoreFile(this, iShareable);
        }
        return jazzIgnoreFile;
    }

    private IShareable getGlobalIgnoreShareable(IShareable iShareable) {
        IPath iPath = this.getGlobalIgnoreRoot(iShareable).append(IGNORE_FILE_NAME);
        return SharingManager.getInstance().findShareable(iShareable.getRoot(), iPath, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JazzIgnoreFile getIgnoreFileForFolder(IShareable iShareable, IPath iPath, boolean bl) throws FileSystemClientException {
        JazzIgnoreFile jazzIgnoreFile;
        Object object = this.files;
        synchronized (object) {
            if (this.files.containsKey(iPath)) {
                jazzIgnoreFile = (JazzIgnoreFile)this.files.get(iPath);
                if (jazzIgnoreFile != null) {
                    return jazzIgnoreFile;
                }
                if (!bl) {
                    return null;
                }
            }
        }
        object = this.getIgnoreShareableForFolder(iShareable, iPath);
        try {
            jazzIgnoreFile = IgnoreFileLoader.getInstance().load(this, (IShareable)object, bl, null);
        }
        catch (IgnoreFileLoader$FileInaccessibleException ignoreFileLoader$FileInaccessibleException) {
            LRUCache lRUCache = this.files;
            synchronized (lRUCache) {
                return (JazzIgnoreFile)this.files.get(iPath);
            }
        }
        LRUCache lRUCache = this.files;
        synchronized (lRUCache) {
            this.files.put(iPath, jazzIgnoreFile);
            if (jazzIgnoreFile == null) {
                this.fileAges.remove(iPath);
            } else {
                long l = this.filesystem.lastModified(iShareable);
                long l2 = this.filesystem.size(iShareable, null);
                this.fileAges.put(iPath, l, l2);
            }
            return jazzIgnoreFile;
        }
    }

    private IShareable getIgnoreShareableForFolder(IShareable iShareable, IPath iPath) {
        return SharingManager.getInstance().findShareable(iShareable.getRoot(), iPath.append(IGNORE_FILE_NAME), false);
    }

    private IShareable getShareableForPath(IShareable iShareable, IPath iPath, boolean bl) {
        return this.getShareableForPath(iShareable.getRoot(), iPath, bl);
    }

    private IShareable getShareableForPath(IPath iPath, IPath iPath2, boolean bl) {
        return SharingManager.getInstance().findShareable(iPath, iPath2, bl);
    }

    public void done() {
    }

    public IStatus ignoreFilesChanged(List list, IProgressMonitor iProgressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(list.size() * 3));
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", -1, Messages.DefaultIgnoreProvider_10, null);
        for (IShareable iShareable : list) {
            IgnoreEvent ignoreEvent;
            try {
                ISchedulingRule iSchedulingRule = SharingManager.getInstance().getExternalSchedulingRule(iShareable);
                try {
                    Job.getJobManager().beginRule(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                    ignoreEvent = this.ignoreFileChanged(iShareable, (IProgressMonitor)subMonitor.newChild(1));
                }
                finally {
                    Job.getJobManager().endRule(iSchedulingRule);
                }
            }
            catch (FileSystemClientException fileSystemClientException) {
                multiStatus.add(fileSystemClientException.getStatus());
                continue;
            }
            if (ignoreEvent != null) {
                try {
                    this.queueEvent(((Shareable)iShareable).getParent(), ignoreEvent, (IProgressMonitor)subMonitor.newChild(1));
                }
                catch (FileSystemClientException fileSystemClientException) {
                    multiStatus.add((IStatus)new Status(4, "com.ibm.team.filesystem.client", NLS.bind((String)Messages.DefaultIgnoreProvider_11, (Object)iShareable.getLocalFullPath()), (Throwable)((Object)fileSystemClientException)));
                }
                continue;
            }
            subMonitor.newChild(1);
        }
        subMonitor.done();
        if (multiStatus.getChildren().length > 0) {
            return (IStatus)multiStatus;
        }
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IgnoreEvent ignoreFileChanged(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Object object;
        String string;
        Object object2;
        IShareable iShareable2;
        block31: {
            IPath iPath;
            block28: {
                block29: {
                    block30: {
                        boolean bl;
                        Assert.isTrue((boolean)iShareable.getLocalFullPath().lastSegment().equals(IGNORE_FILE_NAME));
                        Set set = this.modifiedFiles;
                        synchronized (set) {
                            if (this.modifiedFiles.contains(iShareable)) {
                                return null;
                            }
                        }
                        long l = this.filesystem.lastModified(iShareable);
                        long l2 = this.filesystem.size(iShareable, iProgressMonitor);
                        IPath iPath2 = iShareable.getLocalFullPath().removeLastSegments(1);
                        Object object3 = this.files;
                        synchronized (object3) {
                            if (!this.fileAges.shouldReload(iPath2, l, l2)) {
                                return null;
                            }
                        }
                        IShare iShare = iShareable.getShare();
                        if (iShare == null) {
                            return null;
                        }
                        iShareable2 = this.getParentFor(iShareable);
                        if (iShareable2 != null && iShareable2.shouldBeIgnored()) {
                            return null;
                        }
                        iShareable2 = this.getParentFor(iShareable);
                        iPath = iShareable2.getLocalFullPath();
                        boolean bl2 = ((Shareable)iShareable).getFileStorage().exists();
                        object2 = this.files;
                        synchronized (object2) {
                            bl = this.files.containsKey(iPath);
                            object3 = (JazzIgnoreFile)this.files.get(iPath);
                            this.shouldInvalidateCache = true;
                        }
                        object2 = null;
                        string = null;
                        if (!bl) break block28;
                        if (!bl2) break block29;
                        if (object3 != null) break block30;
                        object = this.files;
                        synchronized (object) {
                            this.files.removeKey(iPath);
                        }
                        object2 = this.getIgnoreFileForFolder(iShareable, iPath, false);
                        if (object2 == null) {
                            object = this.files;
                            synchronized (object) {
                                this.files.removeKey(iPath);
                                this.fileAges.remove(iPath);
                            }
                            string = "unignore";
                            break block31;
                        } else {
                            string = "ignore";
                        }
                        break block31;
                    }
                    string = "unknown";
                    object = this.files;
                    synchronized (object) {
                        this.files.removeKey(iPath);
                    }
                    object2 = this.getIgnoreFileForFolder(iShareable, iPath, false);
                    break block31;
                }
                string = "unignore";
                object = this.files;
                synchronized (object) {
                    this.files.removeKey(iPath);
                    this.fileAges.remove(iPath);
                }
            }
            string = "unknown";
            object2 = this.getIgnoreFileForFolder(iShareable, iPath, false);
        }
        Object object4 = object = object2 == null ? null : ((JazzIgnoreFile)object2).getRules();
        if (this.getGlobalIgnoreFile(iShareable).equals(iShareable)) {
            return new GlobalIgnoreEvent(this.getIgnoreManager(), iShareable, iShareable2, string, CATEGORY_EXTERNAL_CHANGE, (Collection)object);
        }
        return new LocalIgnoreEvent(this.getIgnoreManager(), iShareable, iShareable2, string, CATEGORY_EXTERNAL_CHANGE, (Collection)object);
    }

    private void verifyRule(IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule) {
        if (iIgnoreProvider$IIgnoreRule == null) {
            throw (Throwable)new IllegalArgumentException(Messages.DefaultIgnoreProvider_12);
        }
        if (iIgnoreProvider$IIgnoreRule.getProvider() != this) {
            throw (Throwable)new IllegalArgumentException(Messages.DefaultIgnoreProvider_13);
        }
        if (!(iIgnoreProvider$IIgnoreRule instanceof IgnoreRule)) {
            throw (Throwable)new IllegalArgumentException(Messages.DefaultIgnoreProvider_14);
        }
    }

    private void verifyRules(Collection collection) {
        for (IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule : collection) {
            this.verifyRule(iIgnoreProvider$IIgnoreRule);
        }
    }

    public void addIgnoreRule(IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.addIgnoreRules(Collections.singleton(iIgnoreProvider$IIgnoreRule), iProgressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCacheFor(IPath iPath, JazzIgnoreFile jazzIgnoreFile) {
        LRUCache lRUCache = this.files;
        synchronized (lRUCache) {
            this.files.put(iPath, jazzIgnoreFile);
            if (jazzIgnoreFile == null) {
                this.fileAges.remove(iPath);
            } else {
                this.fileAges.put(iPath, jazzIgnoreFile.getLastModified(), jazzIgnoreFile.getSize());
            }
        }
    }

    private ISchedulingRule findSchedulingRuleFor(IShareable iShareable) {
        IShare iShare = iShareable.getShare();
        if (iShare == null) {
            return null;
        }
        return SharingManager.getInstance().getTrackingRule(iShare.getAnchor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIgnoreRules(Collection collection, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)(collection.size() * 4));
        subMonitor.setTaskName(Messages.DefaultIgnoreProvider_15);
        this.verifyRules(collection);
        for (Map.Entry entry : this.groupRulesByOwner(collection).entrySet()) {
            IgnoreEvent ignoreEvent;
            Cloneable cloneable;
            Object object;
            Collection collection2;
            JazzIgnoreFile jazzIgnoreFile = (JazzIgnoreFile)entry.getKey();
            Collection collection3 = jazzIgnoreFile.computeComplement(collection2 = (Collection)entry.getValue());
            if (collection3.isEmpty()) continue;
            IShareable iShareable = jazzIgnoreFile.getFile();
            ISchedulingRule iSchedulingRule = this.findSchedulingRuleFor(iShareable);
            try {
                Job.getJobManager().beginRule(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                this.startModifyingFile(iShareable);
                try {
                    object = jazzIgnoreFile.addRules(collection3, (IProgressMonitor)subMonitor.newChild(1));
                    this.updateCacheFor(jazzIgnoreFile.getRootShareable().getLocalFullPath(), (JazzIgnoreFile)object);
                    cloneable = this.files;
                    synchronized (cloneable) {
                        this.shouldInvalidateCache = true;
                    }
                }
                finally {
                    this.stopModifyingFile(iShareable, subMonitor.newChild(1));
                }
            }
            finally {
                Job.getJobManager().endRule(iSchedulingRule);
            }
            object = new ArrayList(collection2.size());
            cloneable = new ArrayList(collection2.size());
            this.splitRulesByScope(collection3, (Collection)object, (Collection)((Object)cloneable));
            if (((ArrayList)object).size() > 0) {
                ignoreEvent = new GlobalIgnoreEvent(this.getIgnoreManager(), jazzIgnoreFile.getFile(), jazzIgnoreFile.getRootShareable(), "ignore", Collections.EMPTY_LIST, (Collection)object);
                this.queueEvent(jazzIgnoreFile.getRootShareable(), ignoreEvent, (IProgressMonitor)subMonitor.newChild(1));
            }
            if (((ArrayList)cloneable).size() <= 0) continue;
            ignoreEvent = new LocalIgnoreEvent(this.getIgnoreManager(), jazzIgnoreFile.getFile(), jazzIgnoreFile.getRootShareable(), "ignore", Collections.EMPTY_LIST, collection2);
            this.queueEvent(jazzIgnoreFile.getRootShareable(), ignoreEvent, (IProgressMonitor)subMonitor.newChild(1));
        }
    }

    private Map groupRulesByOwner(Collection collection) throws FileSystemClientException {
        HashMap<JazzIgnoreFile, LinkedList<IgnoreRule>> hashMap = new HashMap<JazzIgnoreFile, LinkedList<IgnoreRule>>();
        for (IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule : collection) {
            IgnoreRule ignoreRule = (IgnoreRule)iIgnoreProvider$IIgnoreRule;
            IShareable iShareable = ignoreRule.getRootShareable();
            JazzIgnoreFile jazzIgnoreFile = this.getIgnoreFileForFolder(iShareable, iShareable.getLocalFullPath(), true);
            LinkedList<IgnoreRule> linkedList = (LinkedList<IgnoreRule>)hashMap.get(jazzIgnoreFile);
            if (linkedList == null) {
                linkedList = new LinkedList<IgnoreRule>();
                hashMap.put(jazzIgnoreFile, linkedList);
            }
            linkedList.add(ignoreRule);
        }
        return hashMap;
    }

    private void splitRulesByScope(Collection collection, Collection collection2, Collection collection3) {
        for (IgnoreRule ignoreRule : collection) {
            if (ignoreRule.isGlobal()) {
                collection2.add(ignoreRule);
                continue;
            }
            collection3.add(ignoreRule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIgnoreRule(IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.verifyRule(iIgnoreProvider$IIgnoreRule);
        IgnoreRule ignoreRule = (IgnoreRule)iIgnoreProvider$IIgnoreRule;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)4);
        this.removeRule(ignoreRule, (IProgressMonitor)subMonitor.newChild(1));
        Object object = this.files;
        synchronized (object) {
            this.shouldInvalidateCache = true;
        }
        object = null;
        object = ignoreRule.isGlobal() ? new GlobalIgnoreEvent(this.getIgnoreManager(), ignoreRule.getFile(), ignoreRule.getRootShareable(), "unignore", Collections.EMPTY_LIST, (Collection)Collections.singletonList(ignoreRule)) : new LocalIgnoreEvent(this.getIgnoreManager(), ignoreRule.getFile(), ignoreRule.getRootShareable(), "unignore", Collections.EMPTY_LIST, (Collection)Collections.singletonList(ignoreRule));
        this.queueEvent(ignoreRule.getRootShareable(), (IIgnoreEvent)object, (IProgressMonitor)subMonitor.newChild(3));
        subMonitor.done();
    }

    public void removeIgnoreRules(List list, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)list.size());
        for (IIgnoreProvider$IIgnoreRule iIgnoreProvider$IIgnoreRule : list) {
            this.removeIgnoreRule(iIgnoreProvider$IIgnoreRule, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startModifyingFile(IShareable iShareable) {
        Set set = this.modifiedFiles;
        synchronized (set) {
            if (!this.modifiedFiles.add(iShareable)) {
                throw (Throwable)new RuntimeException(NLS.bind((String)Messages.DefaultIgnoreProvider_16, (Object)iShareable));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopModifyingFile(IShareable iShareable, SubMonitor subMonitor) {
        Set set = this.modifiedFiles;
        synchronized (set) {
            if (!this.modifiedFiles.remove(iShareable)) {
                throw (Throwable)new RuntimeException(NLS.bind((String)Messages.DefaultIgnoreProvider_17, (Object)iShareable));
            }
        }
        this.ignoreFilesChanged(Collections.singletonList(iShareable), (IProgressMonitor)subMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearFileCache() {
        LRUCache lRUCache = this.files;
        synchronized (lRUCache) {
            this.files.flush();
            this.fileAges.clear();
            this.shouldInvalidateCache = true;
        }
    }

    protected IgnoreProvider createCopyInternal(Collection collection, IIgnoreManager iIgnoreManager, IProgressMonitor iProgressMonitor) {
        DefaultIgnoreProvider$IFilesystemAbstraction defaultIgnoreProvider$IFilesystemAbstraction = null;
        for (IIgnoreManager$ICopyParameter iIgnoreManager$ICopyParameter : collection) {
            DefaultIgnoreProvider$IDefaultIgnoreProviderCopyReason defaultIgnoreProvider$IDefaultIgnoreProviderCopyReason;
            DefaultIgnoreProvider$IFilesystemAbstraction defaultIgnoreProvider$IFilesystemAbstraction2;
            if (!(iIgnoreManager$ICopyParameter instanceof DefaultIgnoreProvider$IDefaultIgnoreProviderCopyReason) || (defaultIgnoreProvider$IFilesystemAbstraction2 = (defaultIgnoreProvider$IDefaultIgnoreProviderCopyReason = (DefaultIgnoreProvider$IDefaultIgnoreProviderCopyReason)iIgnoreManager$ICopyParameter).useFilesystemAbstraction(this.filesystem)) == null) continue;
            if (!$assertionsDisabled && defaultIgnoreProvider$IFilesystemAbstraction != null) {
                throw (Throwable)((Object)new AssertionError((Object)("IFilesystemAbstraction set twice. Original: " + defaultIgnoreProvider$IFilesystemAbstraction + " new: " + defaultIgnoreProvider$IFilesystemAbstraction2)));
            }
            defaultIgnoreProvider$IFilesystemAbstraction = defaultIgnoreProvider$IFilesystemAbstraction2;
        }
        if (defaultIgnoreProvider$IFilesystemAbstraction == null) {
            defaultIgnoreProvider$IFilesystemAbstraction = (DefaultIgnoreProvider$IFilesystemAbstraction)this.filesystem.clone();
        }
        return new DefaultIgnoreProvider(defaultIgnoreProvider$IFilesystemAbstraction);
    }

    protected void syncChangeTrackerForEvent(IShareable iShareable, IIgnoreEvent iIgnoreEvent, SubMonitor subMonitor) throws FileSystemClientException {
        subMonitor = SubMonitor.convert((IProgressMonitor)((IProgressMonitor)subMonitor), (int)2);
        Share share = (Share)iShareable.getShare();
        if (share == null) {
            return;
        }
        Collection collection = iIgnoreEvent.getChanged((IProgressMonitor)subMonitor);
        if (collection == null) {
            if (iShareable == null) {
                throw (Throwable)new IllegalArgumentException(Messages.DefaultIgnoreProvider_18);
            }
            share.refreshChanges(iShareable, (IProgressMonitor)subMonitor.newChild(1));
            return;
        }
        Assert.isNotNull((Object)collection);
        subMonitor.setWorkRemaining(collection.size());
        for (IShareable iShareable2 : collection) {
            SubMonitor subMonitor2 = subMonitor.newChild(1);
            share.refreshChanges(iShareable2, (IProgressMonitor)subMonitor2);
            subMonitor2.done();
        }
    }

    protected void queueEvent(IShareable iShareable, IIgnoreEvent iIgnoreEvent, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor);
        this.syncChangeTrackerForEvent(iShareable, iIgnoreEvent, subMonitor);
        subMonitor.done();
        super.queueEvent(iIgnoreEvent);
    }

    public byte[] getIgnoreFileContents(IPath iPath, Collection collection, Collection collection2) throws FileSystemClientException {
        boolean bl;
        boolean bl2 = bl = iPath.segmentCount() == 1;
        if (!bl && collection != null) {
            throw (Throwable)new IllegalArgumentException(Messages.DefaultIgnoreProvider_19);
        }
        TreeSet<IgnoreRule> treeSet = new TreeSet<IgnoreRule>(IgnoreRuleComparator.INSTANCE);
        if (collection != null) {
            for (String string : collection) {
                treeSet.add(new GlobalIgnoreRule(null, this, string, false, false));
            }
        }
        if (collection2 != null) {
            for (String string : collection2) {
                treeSet.add(new LocalIgnoreRule(null, this, string, false, false));
            }
        }
        return IgnoreFileLoader.getInstance().asBytes(iPath.append(IGNORE_FILE_NAME), treeSet);
    }

    public Collection getDefaultIgnorePatterns(IPath iPath) {
        if (iPath.segmentCount() < 1) {
            throw (Throwable)new IllegalArgumentException();
        }
        return IgnoreFileLoader.getInstance().getDefaultIgnorePatterns(iPath.append(IGNORE_FILE_NAME));
    }

    public void deallocate(IIgnoreManager iIgnoreManager) {
        super.deallocate(iIgnoreManager);
        if (SharingManager.getInstance().getDefaultCFARoot() != null) {
            SharingManager.getInstance().removeListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFileCacheSize() {
        LRUCache lRUCache = this.files;
        synchronized (lRUCache) {
            return this.files.getSpaceLimit();
        }
    }
}

