/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.ignore;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider$IFilesystemAbstraction;
import com.ibm.team.filesystem.client.internal.ignore.DefaultIgnoreProvider$PassThroughFilesystemAbstraction$1;
import java.io.InputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class DefaultIgnoreProvider$PassThroughFilesystemAbstraction
implements DefaultIgnoreProvider$IFilesystemAbstraction {
    public boolean exists(IShareable iShareable) {
        return ((Shareable)iShareable).getFileStorage().exists();
    }

    public InputStream read(IShareable iShareable) throws FileSystemClientException {
        InputStream[] inputStreamArray = new InputStream[1];
        try {
            SharingManager.getInstance().doSilentChange(new DefaultIgnoreProvider$PassThroughFilesystemAbstraction$1(this, inputStreamArray, iShareable));
        }
        catch (CoreException coreException) {
            return null;
        }
        return inputStreamArray[0];
    }

    public void write(IShareable iShareable, InputStream inputStream) throws FileSystemClientException {
        IFileStorage iFileStorage = ((Shareable)iShareable).getFileStorage();
        if (iFileStorage.exists()) {
            iFileStorage.setContents(inputStream, null);
        } else {
            iFileStorage.create(inputStream, null);
        }
    }

    public long lastModified(IShareable iShareable) {
        return ((Shareable)iShareable).getFileStorage().getModificationStamp();
    }

    public long size(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        try {
            SharingManager.getInstance().disableChangeMonitoring();
            long l = ((Shareable)iShareable).getFileStorage().getSize(iProgressMonitor);
            return l;
        }
        finally {
            SharingManager.getInstance().enableChangeMonitoring();
        }
    }

    public Object clone() {
        return new DefaultIgnoreProvider$PassThroughFilesystemAbstraction();
    }
}

