/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IRemoteVisitor;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.ISharingMetadata$IConnectionComponent;
import com.ibm.team.filesystem.client.internal.IVisitor;
import com.ibm.team.filesystem.client.internal.InstantiationLock;
import com.ibm.team.filesystem.client.internal.InverseFileItemInfo;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.SharingDescriptor;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock$ThreadInfo;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaNotifier;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$1;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$10;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$11;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$12;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$13;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$14;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$15;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$16;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$17;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$18;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$19;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$2;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$20;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$3;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$4;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$5;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$6;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$7;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$8;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$9;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$ComponentLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$IOperation;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore$RuleDescriptorPair;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.copyfileareas.IFlushOperation;
import com.ibm.team.filesystem.client.internal.copyfileareas.ILockParticipant;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.utils.LoadedConfigurationDescriptor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.dto.ISyncTime;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class CopyFileAreaStore
implements IFlushOperation {
    private static CopyFileAreaStore instance;
    private static HashMap localStores;
    private BatchingLock batchingLock = new BatchingLock();
    private ISharingMetadata metadata;
    private CopyFileAreaNotifier notifier = new CopyFileAreaNotifier();
    private ReadWriteLock sharingInfoLock = new ReadWriteLock();
    private IPath path;
    private static Set listeners;
    private static final ILockParticipant NULL_PARTICIPANT;

    static {
        localStores = new HashMap();
        listeners = new HashSet();
        NULL_PARTICIPANT = new CopyFileAreaStore$1();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCorruptionListener(ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener) {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            listeners.add(iCorruptCopyFileAreaListener);
            if (instance != null) {
                CopyFileAreaStore.instance.metadata.addCorruptionListener(iCorruptCopyFileAreaListener);
            }
            for (CopyFileAreaStore copyFileAreaStore : localStores.values()) {
                copyFileAreaStore.metadata.addCorruptionListener(iCorruptCopyFileAreaListener);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeCorruptionListener(ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener) {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            listeners.remove(iCorruptCopyFileAreaListener);
            if (instance != null) {
                CopyFileAreaStore.instance.metadata.removeCorruptionListener(iCorruptCopyFileAreaListener);
            }
            for (CopyFileAreaStore copyFileAreaStore : localStores.values()) {
                copyFileAreaStore.metadata.removeCorruptionListener(iCorruptCopyFileAreaListener);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public CopyFileAreaStore(IPath iPath, ISharingMetadata iSharingMetadata) {
        Assert.isNotNull((Object)iPath);
        Assert.isNotNull((Object)iSharingMetadata);
        this.path = iPath;
        this.metadata = iSharingMetadata;
        for (ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener : listeners) {
            iSharingMetadata.addCorruptionListener(iCorruptCopyFileAreaListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CopyFileAreaStore getDefaultCopyFileArea() {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            if (instance == null) {
                IPath iPath = SharingManager.getInstance().getDefaultCFARoot();
                Assert.isLegal((iPath != null ? 1 : 0) != 0);
                instance = new CopyFileAreaStore(iPath, SharingManager.getInstance().createSharingMetadata(iPath));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CopyFileAreaStore getCopyFileArea(IPath iPath) {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            if (iPath.equals((Object)SharingManager.getInstance().getDefaultCFARoot())) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return CopyFileAreaStore.getDefaultCopyFileArea();
            }
            CopyFileAreaStore copyFileAreaStore = (CopyFileAreaStore)localStores.get(iPath);
            if (copyFileAreaStore != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return copyFileAreaStore;
            }
            if ((iPath = CopyFileAreaStore.getCanonicalPath(iPath)).equals((Object)SharingManager.getInstance().getDefaultCFARoot())) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return CopyFileAreaStore.getDefaultCopyFileArea();
            }
            copyFileAreaStore = (CopyFileAreaStore)localStores.get(iPath);
            if (copyFileAreaStore == null) {
                copyFileAreaStore = new CopyFileAreaStore(iPath, SharingManager.getInstance().createSharingMetadata(iPath));
                localStores.put(iPath, copyFileAreaStore);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return copyFileAreaStore;
        }
    }

    public void addListener(ICopyFileAreaListener iCopyFileAreaListener) {
        this.notifier.addListener(iCopyFileAreaListener);
    }

    public void removeListener(ICopyFileAreaListener iCopyFileAreaListener) {
        this.notifier.removeListener(iCopyFileAreaListener);
    }

    public static ISchedulingRule getSchedulingRule(IShareable iShareable) {
        IShare iShare = iShareable.getShare();
        if (iShare != null) {
            ISharingDescriptor iSharingDescriptor = iShare.getSharingDescriptor();
            return new CopyFileAreaStore$ComponentLock(iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent());
        }
        return null;
    }

    public static ISchedulingRule getSchedulingRule(ISharingDescriptor iSharingDescriptor) {
        return new CopyFileAreaStore$ComponentLock(iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent());
    }

    public static ISchedulingRule getSchedulingRule(IContextHandle iContextHandle, IComponentHandle iComponentHandle) {
        return new CopyFileAreaStore$ComponentLock(iContextHandle, iComponentHandle);
    }

    public boolean isLocked(IComponentHandle iComponentHandle, IContextHandle iContextHandle) {
        return this.batchingLock.isLocked(new CopyFileAreaStore$ComponentLock(iContextHandle, iComponentHandle));
    }

    public ISchedulingRule lock(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) {
        return this.batchingLock.acquire(new CopyFileAreaStore$ComponentLock(iContextHandle, iComponentHandle), this, NULL_PARTICIPANT, true, iProgressMonitor);
    }

    public ISchedulingRule lock(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair = this.beginBatching(iShareable, (IProgressMonitor)subMonitor.newChild(99));
        if (copyFileAreaStore$RuleDescriptorPair.desc == null) {
            this.endBatching(copyFileAreaStore$RuleDescriptorPair.rule, (IProgressMonitor)subMonitor.newChild(1));
            return null;
        }
        return copyFileAreaStore$RuleDescriptorPair.rule;
    }

    public void release(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.batchingLock.release(iSchedulingRule, iProgressMonitor);
    }

    private void updateParentInfoForChange(FileItemInfo fileItemInfo, FileItemInfo fileItemInfo2, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        if (fileItemInfo2 != null && !fileItemInfo2.getVersionableHandle().sameItemId((IItemHandle)fileItemInfo.getVersionableHandle())) {
            throw (Throwable)new IllegalArgumentException("Infos must be for the same versionable");
        }
        if (!fileItemInfo.isFolder() || this.metadata.getPathForShareRoot((IFolderHandle)fileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle) == null) {
            if (fileItemInfo2 != null && fileItemInfo2.getParent() != null && fileItemInfo2.getParent().sameItemId((IItemHandle)fileItemInfo.getParent()) && !fileItemInfo2.getName().equals(fileItemInfo.getName())) {
                InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)fileItemInfo.getParent(), iComponentHandle, iContextHandle);
                LinkedHashMap<String, IVersionableHandle> linkedHashMap = new LinkedHashMap<String, IVersionableHandle>(inverseFileItemInfo.getRemoteChildren());
                IVersionableHandle iVersionableHandle = (IVersionableHandle)linkedHashMap.remove(fileItemInfo2.getName());
                if (iVersionableHandle == null) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_0, (Object)fileItemInfo.getName()), null)));
                }
                if (!fileItemInfo2.getVersionableHandle().sameItemId((IItemHandle)iVersionableHandle)) {
                    linkedHashMap.put(fileItemInfo2.getName(), iVersionableHandle);
                }
                linkedHashMap.put(fileItemInfo.getName(), fileItemInfo.getVersionableHandle());
                InverseFileItemInfo inverseFileItemInfo2 = new InverseFileItemInfo(inverseFileItemInfo.getVersionableHandle(), inverseFileItemInfo.getLastModification(), inverseFileItemInfo.getParent(), inverseFileItemInfo.getName(), Collections.unmodifiableMap((Map)linkedHashMap), inverseFileItemInfo.getLocalParent(), inverseFileItemInfo.getLocalName(), inverseFileItemInfo.getHash(), inverseFileItemInfo.getContentLength(), inverseFileItemInfo.getOriginalLineDelimiter(), inverseFileItemInfo.getLineDelimiter(), inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo.getContentType(), inverseFileItemInfo.getStoredContentId(), inverseFileItemInfo.getStoredDeltaPredecessor(), inverseFileItemInfo.getStoredSize(), inverseFileItemInfo.getStoredEncoding(), inverseFileItemInfo.getStoredChecksum(), inverseFileItemInfo.getStoredNumLineDelimiters(), inverseFileItemInfo.isExecutable(), inverseFileItemInfo.isOriginalExecutable());
                this.metadata.setFileItemInfo((IVersionableHandle)fileItemInfo.getParent(), iComponentHandle, iContextHandle, inverseFileItemInfo2);
            } else {
                Object object;
                LinkedHashMap<String, Object> linkedHashMap;
                InverseFileItemInfo inverseFileItemInfo;
                if (fileItemInfo2 != null && fileItemInfo2.getParent() != null && !fileItemInfo2.getParent().sameItemId((IItemHandle)fileItemInfo.getParent()) && (inverseFileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)fileItemInfo2.getParent(), iComponentHandle, iContextHandle)) != null) {
                    linkedHashMap = new LinkedHashMap(inverseFileItemInfo.getRemoteChildren());
                    object = (IVersionableHandle)linkedHashMap.remove(fileItemInfo2.getName());
                    if (object == null) {
                        throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_1, (Object)fileItemInfo.getName()), null)));
                    }
                    if (!fileItemInfo2.getVersionableHandle().sameItemId((IItemHandle)object)) {
                        linkedHashMap.put(fileItemInfo2.getName(), object);
                    }
                    InverseFileItemInfo inverseFileItemInfo3 = new InverseFileItemInfo(inverseFileItemInfo.getVersionableHandle(), inverseFileItemInfo.getLastModification(), inverseFileItemInfo.getParent(), inverseFileItemInfo.getName(), Collections.unmodifiableMap((Map)linkedHashMap), inverseFileItemInfo.getLocalParent(), inverseFileItemInfo.getLocalName(), inverseFileItemInfo.getHash(), inverseFileItemInfo.getContentLength(), inverseFileItemInfo.getOriginalLineDelimiter(), inverseFileItemInfo.getLineDelimiter(), inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo.getContentType(), inverseFileItemInfo.getStoredContentId(), inverseFileItemInfo.getStoredDeltaPredecessor(), inverseFileItemInfo.getStoredSize(), inverseFileItemInfo.getStoredEncoding(), inverseFileItemInfo.getStoredChecksum(), inverseFileItemInfo.getStoredNumLineDelimiters(), inverseFileItemInfo.isExecutable(), inverseFileItemInfo.isOriginalExecutable());
                    this.metadata.setFileItemInfo((IVersionableHandle)fileItemInfo2.getParent(), iComponentHandle, iContextHandle, inverseFileItemInfo3);
                }
                if (!(fileItemInfo.getParent() == null || fileItemInfo2 != null && fileItemInfo.getParent().sameItemId((IItemHandle)fileItemInfo2.getParent()))) {
                    inverseFileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)fileItemInfo.getParent(), iComponentHandle, iContextHandle);
                    if (inverseFileItemInfo == null) {
                        this.metadata.setCorrupt(true, "Unexpected null parent", null);
                        throw (Throwable)new RuntimeException("Detected metadata corruption");
                    }
                    linkedHashMap = new LinkedHashMap<String, IVersionableHandle>(inverseFileItemInfo.getRemoteChildren());
                    linkedHashMap.put(fileItemInfo.getName(), fileItemInfo.getVersionableHandle());
                    object = new InverseFileItemInfo(inverseFileItemInfo.getVersionableHandle(), inverseFileItemInfo.getLastModification(), inverseFileItemInfo.getParent(), inverseFileItemInfo.getName(), Collections.unmodifiableMap((Map)linkedHashMap), inverseFileItemInfo.getLocalParent(), inverseFileItemInfo.getLocalName(), inverseFileItemInfo.getHash(), inverseFileItemInfo.getContentLength(), inverseFileItemInfo.getOriginalLineDelimiter(), inverseFileItemInfo.getLineDelimiter(), inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo.getContentType(), inverseFileItemInfo.getStoredContentId(), inverseFileItemInfo.getStoredDeltaPredecessor(), inverseFileItemInfo.getStoredSize(), inverseFileItemInfo.getStoredEncoding(), inverseFileItemInfo.getStoredChecksum(), inverseFileItemInfo.getStoredNumLineDelimiters(), inverseFileItemInfo.isExecutable(), inverseFileItemInfo.isOriginalExecutable());
                    this.metadata.setFileItemInfo((IVersionableHandle)fileItemInfo.getParent(), iComponentHandle, iContextHandle, (InverseFileItemInfo)object);
                }
            }
        }
    }

    private void updateParentInfoForRemoval(FileItemInfo fileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        if (!(fileItemInfo.getParent() == null || fileItemInfo.isFolder() && this.metadata.getPathForShareRoot((IFolderHandle)fileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle) != null)) {
            InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)fileItemInfo.getParent(), iComponentHandle, iContextHandle);
            if (inverseFileItemInfo == null) {
                return;
            }
            LinkedHashMap<String, IVersionableHandle> linkedHashMap = new LinkedHashMap<String, IVersionableHandle>(inverseFileItemInfo.getRemoteChildren());
            IVersionableHandle iVersionableHandle = (IVersionableHandle)linkedHashMap.remove(fileItemInfo.getName());
            if (iVersionableHandle == null) {
                throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_2, (Object)fileItemInfo.getName()), null)));
            }
            if (!fileItemInfo.getVersionableHandle().sameItemId((IItemHandle)iVersionableHandle)) {
                linkedHashMap.put(fileItemInfo.getName(), iVersionableHandle);
            }
            InverseFileItemInfo inverseFileItemInfo2 = new InverseFileItemInfo(inverseFileItemInfo.getVersionableHandle(), inverseFileItemInfo.getLastModification(), inverseFileItemInfo.getParent(), inverseFileItemInfo.getName(), Collections.unmodifiableMap((Map)linkedHashMap), inverseFileItemInfo.getLocalParent(), inverseFileItemInfo.getLocalName(), inverseFileItemInfo.getHash(), inverseFileItemInfo.getContentLength(), inverseFileItemInfo.getOriginalLineDelimiter(), inverseFileItemInfo.getLineDelimiter(), inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo.getContentType(), inverseFileItemInfo.getStoredContentId(), inverseFileItemInfo.getStoredDeltaPredecessor(), inverseFileItemInfo.getStoredSize(), inverseFileItemInfo.getStoredEncoding(), inverseFileItemInfo.getStoredChecksum(), inverseFileItemInfo.getStoredNumLineDelimiters(), inverseFileItemInfo.isExecutable(), inverseFileItemInfo.isOriginalExecutable());
            this.metadata.setFileItemInfo((IVersionableHandle)fileItemInfo.getParent(), iComponentHandle, iContextHandle, inverseFileItemInfo2);
        }
    }

    private void updateLocalParent(IPath iPath, IFolderHandle iFolderHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        Map map = this.metadata.getChildInfos(iPath);
        for (FileItemInfo fileItemInfo : map.values()) {
            InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo(fileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle);
            if (inverseFileItemInfo.getLocalParent() == null) continue;
            InverseFileItemInfo inverseFileItemInfo2 = new InverseFileItemInfo(inverseFileItemInfo.getVersionableHandle(), inverseFileItemInfo.getLastModification(), inverseFileItemInfo.getParent(), inverseFileItemInfo.getName(), inverseFileItemInfo.getRemoteChildren(), iFolderHandle, inverseFileItemInfo.getLocalName(), inverseFileItemInfo.getHash(), inverseFileItemInfo.getContentLength(), inverseFileItemInfo.getOriginalLineDelimiter(), inverseFileItemInfo.getLineDelimiter(), inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo.getContentType(), inverseFileItemInfo.getStoredContentId(), inverseFileItemInfo.getStoredDeltaPredecessor(), inverseFileItemInfo.getStoredSize(), inverseFileItemInfo.getStoredEncoding(), inverseFileItemInfo.getStoredChecksum(), inverseFileItemInfo.getStoredNumLineDelimiters(), inverseFileItemInfo.isExecutable(), inverseFileItemInfo.isOriginalExecutable());
            this.metadata.setFileItemInfo(inverseFileItemInfo2.getVersionableHandle(), iComponentHandle, iContextHandle, inverseFileItemInfo2);
        }
    }

    public FileItemInfo setItemInfo(IShareable iShareable, FileItemInfo fileItemInfo, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        FileItemInfo fileItemInfo2;
        SubMonitor subMonitor;
        block13: {
            Assert.isNotNull((Object)fileItemInfo);
            ISchedulingRule iSchedulingRule = null;
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)2);
            try {
                Object object;
                FileItemInfo fileItemInfo3;
                String string;
                IFolderHandle iFolderHandle;
                CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair = this.beginBatching(iShareable, (IProgressMonitor)subMonitor.newChild(1));
                ISharingDescriptor iSharingDescriptor = copyFileAreaStore$RuleDescriptorPair.desc;
                iSchedulingRule = copyFileAreaStore$RuleDescriptorPair.rule;
                FileItemInfo fileItemInfo4 = this.metadata.getFileItemInfo(iShareable.getLocalFullPath().removeLastSegments(1));
                if (fileItemInfo4 == null) {
                    iFolderHandle = null;
                    string = null;
                } else {
                    iFolderHandle = (IFolderHandle)fileItemInfo4.getVersionableHandle();
                    string = iShareable.getLocalFullPath().lastSegment();
                }
                InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo(fileItemInfo.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                if (!(inverseFileItemInfo == null || iFolderHandle == null || inverseFileItemInfo.getLocalParent() == null || iFolderHandle.sameItemId((IItemHandle)inverseFileItemInfo.getLocalParent()) && string.equals(inverseFileItemInfo.getLocalName()))) {
                    if (!this.isCaseSensitive() && iFolderHandle.sameItemId((IItemHandle)inverseFileItemInfo.getLocalParent()) && string.toUpperCase().toLowerCase().equals(inverseFileItemInfo.getLocalName().toUpperCase().toLowerCase())) {
                        this.metadata.setFileItemInfo(iShareable.getLocalFullPath(), null);
                    } else {
                        throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_3, (Object)iShareable.getLocalFullPath().toString(), (Object)this.getLocalPathInternal(inverseFileItemInfo, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle())), null)));
                    }
                }
                if ((fileItemInfo3 = this.metadata.setFileItemInfo(iShareable.getLocalFullPath(), fileItemInfo)) != null && !fileItemInfo.getVersionableHandle().sameItemId((IItemHandle)fileItemInfo3.getVersionableHandle())) {
                    if (fileItemInfo3.getVersionableHandle().sameItemId((IItemHandle)iSharingDescriptor.getRootFolder())) {
                        throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, "Internal error: Cannot change share root item id this way", null)));
                    }
                    if (fileItemInfo3.getVersionableHandle() instanceof IFolderHandle) {
                        this.updateLocalParent(iShareable.getLocalFullPath(), (IFolderHandle)fileItemInfo.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                    }
                    if (fileItemInfo3.getVersionableHandle().hasStateId()) {
                        object = this.metadata.getFileItemInfo(fileItemInfo3.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                        object = new InverseFileItemInfo(((FileItemInfo)object).getVersionableHandle(), -1L, ((FileItemInfo)object).getParent(), ((FileItemInfo)object).getName(), ((InverseFileItemInfo)object).getRemoteChildren(), null, null, ((FileItemInfo)object).getHash(), ((FileItemInfo)object).getContentLength(), ((FileItemInfo)object).getOriginalLineDelimiter(), ((FileItemInfo)object).getLineDelimiter(), ((FileItemInfo)object).getOriginalContentType(), ((FileItemInfo)object).getContentType(), ((FileItemInfo)object).getStoredContentId(), ((FileItemInfo)object).getStoredDeltaPredecessor(), ((FileItemInfo)object).getStoredSize(), ((FileItemInfo)object).getStoredEncoding(), ((FileItemInfo)object).getStoredChecksum(), ((FileItemInfo)object).getStoredNumLineDelimiters(), ((FileItemInfo)object).isOriginalExecutable(), ((FileItemInfo)object).isOriginalExecutable());
                        this.metadata.setFileItemInfo(fileItemInfo3.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), (InverseFileItemInfo)object);
                    } else {
                        this.metadata.setFileItemInfo(fileItemInfo3.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), null);
                    }
                }
                this.updateParentInfoForChange(fileItemInfo, inverseFileItemInfo, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                object = fileItemInfo.isFolder() ? (inverseFileItemInfo != null ? inverseFileItemInfo.getRemoteChildren() : Collections.EMPTY_MAP) : Collections.EMPTY_MAP;
                InverseFileItemInfo inverseFileItemInfo2 = new InverseFileItemInfo(fileItemInfo.getVersionableHandle(), fileItemInfo.getLastModification(), fileItemInfo.getParent(), fileItemInfo.getName(), (Map)object, iFolderHandle, string, fileItemInfo.getHash(), fileItemInfo.getContentLength(), fileItemInfo.getOriginalLineDelimiter(), fileItemInfo.getLineDelimiter(), fileItemInfo.getOriginalContentType(), fileItemInfo.getContentType(), fileItemInfo.getStoredContentId(), fileItemInfo.getStoredDeltaPredecessor(), fileItemInfo.getStoredSize(), fileItemInfo.getStoredEncoding(), fileItemInfo.getStoredChecksum(), fileItemInfo.getStoredNumLineDelimiters(), iFolderHandle == null ? fileItemInfo.isOriginalExecutable() : fileItemInfo.isExecutable(), fileItemInfo.isOriginalExecutable());
                this.metadata.setFileItemInfo(fileItemInfo.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), inverseFileItemInfo2);
                fileItemInfo2 = fileItemInfo3;
                if (iSchedulingRule == null) break block13;
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (Throwable throwable) {
                if (iSchedulingRule != null) {
                    this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                }
                subMonitor.done();
                throw throwable;
            }
        }
        subMonitor.done();
        return fileItemInfo2;
    }

    public FileItemInfo setItemInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, FileItemInfo fileItemInfo, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo;
        SubMonitor subMonitor;
        block6: {
            ISchedulingRule iSchedulingRule = null;
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            try {
                IFolderHandle iFolderHandle;
                String string;
                iSchedulingRule = this.beginBatching(new CopyFileAreaStore$ComponentLock(iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
                InverseFileItemInfo inverseFileItemInfo2 = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
                this.updateParentInfoForChange(fileItemInfo, inverseFileItemInfo2, iComponentHandle, iContextHandle);
                Map map = fileItemInfo.isFolder() && inverseFileItemInfo2 != null ? inverseFileItemInfo2.getRemoteChildren() : Collections.EMPTY_MAP;
                IPath iPath = this.getLocalPathInternal(inverseFileItemInfo2, iComponentHandle, iContextHandle);
                if (iPath != null) {
                    this.metadata.setFileItemInfo(iPath, fileItemInfo);
                }
                if (inverseFileItemInfo2 != null) {
                    string = inverseFileItemInfo2.getLocalName();
                    iFolderHandle = inverseFileItemInfo2.getLocalParent();
                } else {
                    string = null;
                    iFolderHandle = null;
                }
                InverseFileItemInfo inverseFileItemInfo3 = new InverseFileItemInfo(fileItemInfo.getVersionableHandle(), fileItemInfo.getLastModification(), fileItemInfo.getParent(), fileItemInfo.getName(), map, iFolderHandle, string, fileItemInfo.getHash(), fileItemInfo.getContentLength(), fileItemInfo.getOriginalLineDelimiter(), fileItemInfo.getLineDelimiter(), fileItemInfo.getOriginalContentType(), fileItemInfo.getContentType(), fileItemInfo.getStoredContentId(), fileItemInfo.getStoredDeltaPredecessor(), fileItemInfo.getStoredSize(), fileItemInfo.getStoredEncoding(), fileItemInfo.getStoredChecksum(), fileItemInfo.getStoredNumLineDelimiters(), iFolderHandle == null ? fileItemInfo.isOriginalExecutable() : fileItemInfo.isExecutable(), fileItemInfo.isOriginalExecutable());
                this.metadata.setFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle, inverseFileItemInfo3);
                subMonitor.worked(98);
                inverseFileItemInfo = inverseFileItemInfo2;
                if (iSchedulingRule == null) break block6;
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (Throwable throwable) {
                if (iSchedulingRule != null) {
                    this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                }
                subMonitor.done();
                throw throwable;
            }
        }
        subMonitor.done();
        return inverseFileItemInfo;
    }

    public Map getChildInfos(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule iSchedulingRule = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair = this.beginBatching(iShareable, (IProgressMonitor)subMonitor.newChild(1));
            iSchedulingRule = copyFileAreaStore$RuleDescriptorPair.rule;
            Map map = this.metadata.getChildInfos(iShareable.getLocalFullPath());
            return map;
        }
        finally {
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    /*
     * Unable to fully structure code
     */
    public UUID getRemoteAncestor(Set var1_1, IVersionableHandle var2_2, IComponentHandle var3_3, IContextHandle var4_4, IProgressMonitor var5_5) throws FileSystemClientException {
        block10: {
            block8: {
                block9: {
                    block7: {
                        var6_6 = SubMonitor.convert((IProgressMonitor)var5_5, (int)100);
                        var7_7 = null;
                        if (!var1_1.isEmpty()) break block7;
                        while (true) {
                            if (var7_7 != null) {
                                this.endBatching(var7_7, (IProgressMonitor)var6_6.newChild(1));
                            }
                            var6_6.done();
                            return null;
                        }
                    }
                    try {
                        if (!var1_1.contains(var2_2.getItemId())) break block8;
                        var11_8 = var2_2.getItemId();
                        if (var7_7 == null) break block9;
                        this.endBatching(var7_7, (IProgressMonitor)var6_6.newChild(1));
                    }
                    catch (Throwable var10_12) {
                        if (var7_7 != null) {
                            this.endBatching(var7_7, (IProgressMonitor)var6_6.newChild(1));
                        }
                        var6_6.done();
                        throw var10_12;
                    }
                }
                var6_6.done();
                return var11_8;
            }
            var7_7 = this.beginBatching(new CopyFileAreaStore$ComponentLock(var4_4, var3_3), (IProgressMonitor)var6_6.newChild(1));
            if ((var8_10 = this.metadata.getFileItemInfo(var2_2, var3_3, var4_4)) == null || var8_10.getVersionableHandle() instanceof IFolderHandle && (var9_11 = this.metadata.getPathForShareRoot((IFolderHandle)var8_10.getVersionableHandle(), var3_3, var4_4)) != null || var8_10.getName() == null) ** continue;
            var11_9 = this.getRemoteAncestorInternal_rec(var1_1, (IVersionableHandle)var8_10.getParent(), var3_3, var4_4);
            if (var7_7 == null) break block10;
            this.endBatching(var7_7, (IProgressMonitor)var6_6.newChild(1));
        }
        var6_6.done();
        return var11_9;
    }

    private UUID getRemoteAncestorInternal(Set set, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        IPath iPath;
        if (set.isEmpty()) {
            return null;
        }
        if (set.contains(iVersionableHandle.getItemId())) {
            return iVersionableHandle.getItemId();
        }
        InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
        if (inverseFileItemInfo == null) {
            return null;
        }
        if (inverseFileItemInfo.getVersionableHandle() instanceof IFolderHandle && (iPath = this.metadata.getPathForShareRoot((IFolderHandle)inverseFileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle)) != null) {
            return null;
        }
        if (inverseFileItemInfo.getName() == null) {
            return null;
        }
        return this.getRemoteAncestorInternal_rec(set, (IVersionableHandle)inverseFileItemInfo.getParent(), iComponentHandle, iContextHandle);
    }

    private UUID getRemoteAncestorInternal_rec(Set set, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        while (!set.contains(iVersionableHandle.getItemId())) {
            Object object;
            if (iVersionableHandle instanceof IFolderHandle && (object = this.metadata.getPathForShareRoot((IFolderHandle)iVersionableHandle, iComponentHandle, iContextHandle)) != null) {
                return null;
            }
            object = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
            if (object == null) {
                throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_6, (Object)((FileItemInfo)object).getVersionableHandle()));
            }
            if (((FileItemInfo)object).getName() == null) {
                throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_7, (Object)((FileItemInfo)object).getVersionableHandle()));
            }
            iVersionableHandle = ((FileItemInfo)object).getParent();
        }
        return iVersionableHandle.getItemId();
    }

    /*
     * Unable to fully structure code
     */
    public IPath getRemotePathFor(IShareable var1_1, IProgressMonitor var2_2) throws FileSystemClientException {
        block10: {
            block8: {
                block9: {
                    block7: {
                        var3_3 = null;
                        var4_4 = SubMonitor.convert((IProgressMonitor)var2_2, (int)100);
                        var5_5 = this.beginBatching(var1_1, (IProgressMonitor)var4_4.newChild(1));
                        var6_6 = var5_5.desc;
                        var3_3 = var5_5.rule;
                        var7_7 = this.metadata.getFileItemInfo(var1_1.getLocalFullPath());
                        if (var7_7 != null) break block7;
                        while (true) {
                            if (var3_3 != null) {
                                this.endBatching(var3_3, (IProgressMonitor)var4_4.newChild(1));
                            }
                            var4_4.done();
                            return null;
                        }
                    }
                    try {
                        if (!(var7_7.getVersionableHandle() instanceof IFolderHandle) || (var8_8 = this.metadata.getPathForShareRoot((IFolderHandle)var7_7.getVersionableHandle(), var6_6.getComponent(), var6_6.getConnectionHandle())) == null) break block8;
                        var10_9 = var8_8;
                        if (var3_3 == null) break block9;
                        this.endBatching(var3_3, (IProgressMonitor)var4_4.newChild(1));
                    }
                    catch (Throwable var9_11) {
                        if (var3_3 != null) {
                            this.endBatching(var3_3, (IProgressMonitor)var4_4.newChild(1));
                        }
                        var4_4.done();
                        throw var9_11;
                    }
                }
                var4_4.done();
                return var10_9;
            }
            if (var7_7.getName() == null) ** continue;
            var10_10 = this.getRemotePathInternal((IVersionableHandle)var7_7.getParent(), var6_6.getComponent(), var6_6.getConnectionHandle()).append(var7_7.getName());
            if (var3_3 == null) break block10;
            this.endBatching(var3_3, (IProgressMonitor)var4_4.newChild(1));
        }
        var4_4.done();
        return var10_10;
    }

    /*
     * Unable to fully structure code
     */
    public IPath getRemotePathFor(IVersionableHandle var1_1, IComponentHandle var2_2, IContextHandle var3_3, IProgressMonitor var4_4) throws FileSystemClientException {
        block10: {
            block8: {
                block9: {
                    block7: {
                        var5_5 = null;
                        var6_6 = SubMonitor.convert((IProgressMonitor)var4_4, (int)100);
                        var5_5 = this.beginBatching(new CopyFileAreaStore$ComponentLock(var3_3, var2_2), (IProgressMonitor)var6_6.newChild(1));
                        var7_7 = this.metadata.getFileItemInfo(var1_1, var2_2, var3_3);
                        if (var7_7 != null) break block7;
                        while (true) {
                            if (var5_5 != null) {
                                this.endBatching(var5_5, (IProgressMonitor)var6_6.newChild(1));
                            }
                            var6_6.done();
                            return null;
                        }
                    }
                    try {
                        if (!(var7_7.getVersionableHandle() instanceof IFolderHandle) || (var8_8 = this.metadata.getPathForShareRoot((IFolderHandle)var7_7.getVersionableHandle(), var2_2, var3_3)) == null) break block8;
                        var10_9 = var8_8;
                        if (var5_5 == null) break block9;
                        this.endBatching(var5_5, (IProgressMonitor)var6_6.newChild(1));
                    }
                    catch (Throwable var9_11) {
                        if (var5_5 != null) {
                            this.endBatching(var5_5, (IProgressMonitor)var6_6.newChild(1));
                        }
                        var6_6.done();
                        throw var9_11;
                    }
                }
                var6_6.done();
                return var10_9;
            }
            if (var7_7.getName() == null) ** continue;
            var10_10 = this.getRemotePathInternal((IVersionableHandle)var7_7.getParent(), var2_2, var3_3).append(var7_7.getName());
            if (var5_5 == null) break block10;
            this.endBatching(var5_5, (IProgressMonitor)var6_6.newChild(1));
        }
        var6_6.done();
        return var10_10;
    }

    private IPath getRemotePathInternal(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo;
        if (iVersionableHandle instanceof IFolderHandle && (inverseFileItemInfo = this.metadata.getPathForShareRoot((IFolderHandle)iVersionableHandle, iComponentHandle, iContextHandle)) != null) {
            return inverseFileItemInfo;
        }
        inverseFileItemInfo = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
        if (inverseFileItemInfo == null) {
            return null;
        }
        return this.getRemotePathInternal_rec(inverseFileItemInfo, iComponentHandle, iContextHandle);
    }

    private IPath getRemotePathInternal_rec(FileItemInfo fileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        ArrayList<String> arrayList = null;
        int n = 0;
        while (true) {
            String string;
            if (fileItemInfo.getVersionableHandle() instanceof IFolderHandle && (string = this.metadata.getPathForShareRoot((IFolderHandle)fileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle)) != null) {
                if (arrayList == null) {
                    return string;
                }
                int n2 = arrayList.size() - 1;
                if (n2 == 0) {
                    return string.append((String)arrayList.get(0));
                }
                StringBuilder stringBuilder = new StringBuilder(n + n2);
                stringBuilder.append((String)arrayList.get(n2));
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    stringBuilder.append('/');
                    stringBuilder.append((String)arrayList.get(n3));
                    --n3;
                }
                return string.append(stringBuilder.toString());
            }
            string = fileItemInfo.getName();
            if (string == null) {
                throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_8, (Object)fileItemInfo.getVersionableHandle()));
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            n += string.length();
            arrayList.add(string);
            fileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)fileItemInfo.getParent(), iComponentHandle, iContextHandle);
        }
    }

    public List getLocalPathFor(List list, IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ArrayList<IPath> arrayList;
        SubMonitor subMonitor;
        block4: {
            ISchedulingRule iSchedulingRule = null;
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            try {
                iSchedulingRule = this.beginBatching(new CopyFileAreaStore$ComponentLock(iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
                ArrayList<IPath> arrayList2 = new ArrayList<IPath>(list.size());
                SubMonitor subMonitor2 = subMonitor.newChild(98);
                subMonitor2.setWorkRemaining(list.size());
                for (IVersionableHandle iVersionableHandle : list) {
                    arrayList2.add(this.getLocalPathInternal(iVersionableHandle, iComponentHandle, iContextHandle));
                    subMonitor2.worked(1);
                }
                subMonitor2.done();
                arrayList = arrayList2;
                if (iSchedulingRule == null) break block4;
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (Throwable throwable) {
                if (iSchedulingRule != null) {
                    this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                }
                subMonitor.done();
                throw throwable;
            }
        }
        subMonitor.done();
        return arrayList;
    }

    public IPath getLocalPathFor(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IPath iPath;
        SubMonitor subMonitor;
        block3: {
            ISchedulingRule iSchedulingRule = null;
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            try {
                iSchedulingRule = this.beginBatching(new CopyFileAreaStore$ComponentLock(iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
                iPath = this.getLocalPathInternal(iVersionableHandle, iComponentHandle, iContextHandle);
                if (iSchedulingRule == null) break block3;
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (Throwable throwable) {
                if (iSchedulingRule != null) {
                    this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                }
                subMonitor.done();
                throw throwable;
            }
        }
        subMonitor.done();
        return iPath;
    }

    private IPath getLocalPathInternal(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
        return this.getLocalPathInternal(inverseFileItemInfo, iComponentHandle, iContextHandle);
    }

    private IPath getLocalPathInternal(InverseFileItemInfo inverseFileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        IPath iPath;
        if (inverseFileItemInfo == null) {
            return null;
        }
        if (inverseFileItemInfo.getVersionableHandle() instanceof IFolderHandle && (iPath = this.metadata.getPathForShareRoot((IFolderHandle)inverseFileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle)) != null) {
            return iPath;
        }
        if (inverseFileItemInfo.getLocalName() == null) {
            return null;
        }
        return this.getLocalPathInternal_rec(this.metadata.getFileItemInfo((IVersionableHandle)inverseFileItemInfo.getLocalParent(), iComponentHandle, iContextHandle), iComponentHandle, iContextHandle).append(inverseFileItemInfo.getLocalName());
    }

    private IPath getLocalPathInternal_rec(InverseFileItemInfo inverseFileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        ArrayList<String> arrayList = null;
        int n = 0;
        while (true) {
            String string;
            if (inverseFileItemInfo.getVersionableHandle() instanceof IFolderHandle && (string = this.metadata.getPathForShareRoot((IFolderHandle)inverseFileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle)) != null) {
                if (arrayList == null) {
                    return string;
                }
                int n2 = arrayList.size() - 1;
                if (n2 == 0) {
                    return string.append((String)arrayList.get(0));
                }
                StringBuilder stringBuilder = new StringBuilder(n + n2);
                stringBuilder.append((String)arrayList.get(n2));
                int n3 = n2 - 1;
                while (n3 >= 0) {
                    stringBuilder.append('/');
                    stringBuilder.append((String)arrayList.get(n3));
                    --n3;
                }
                return string.append(stringBuilder.toString());
            }
            string = inverseFileItemInfo.getLocalName();
            if (string == null) {
                throw (Throwable)new IllegalStateException(NLS.bind((String)Messages.CopyFileAreaStore_10, (Object)inverseFileItemInfo.getVersionableHandle()));
            }
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            n += string.length();
            arrayList.add(string);
            inverseFileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)inverseFileItemInfo.getLocalParent(), iComponentHandle, iContextHandle);
        }
    }

    public InverseFileItemInfo getItemInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) {
        try {
            return this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
        }
        catch (FileSystemClientException fileSystemClientException) {
            LoggingHelper.log(fileSystemClientException);
            return null;
        }
    }

    /*
     * Loose catch block
     */
    public IVersionableHandle getDeletedItem(IFolderHandle iFolderHandle, String string, IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) {
        block17: {
            SubMonitor subMonitor;
            ISchedulingRule iSchedulingRule;
            block14: {
                IVersionableHandle iVersionableHandle;
                block15: {
                    IVersionableHandle iVersionableHandle2;
                    iSchedulingRule = null;
                    subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
                    iSchedulingRule = this.beginBatching(new CopyFileAreaStore$ComponentLock(iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
                    InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)iFolderHandle, iComponentHandle, iContextHandle);
                    if (inverseFileItemInfo == null || (iVersionableHandle2 = (IVersionableHandle)inverseFileItemInfo.getRemoteChildren().get(string)) == null || (inverseFileItemInfo = this.metadata.getFileItemInfo(iVersionableHandle2, iComponentHandle, iContextHandle)).getLocalParent() != null) break block14;
                    iVersionableHandle = iVersionableHandle2;
                    if (iSchedulingRule == null) break block15;
                    try {
                        this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                    }
                    catch (FileSystemClientException fileSystemClientException) {
                        LoggingHelper.log(fileSystemClientException);
                    }
                }
                subMonitor.done();
                return iVersionableHandle;
                catch (FileSystemClientException fileSystemClientException) {
                    block16: {
                        try {
                            LoggingHelper.log(fileSystemClientException);
                            if (iSchedulingRule == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (iSchedulingRule != null) {
                                try {
                                    this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                                }
                                catch (FileSystemClientException fileSystemClientException2) {
                                    LoggingHelper.log(fileSystemClientException2);
                                }
                            }
                            subMonitor.done();
                            throw throwable;
                        }
                        try {
                            this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                        }
                        catch (FileSystemClientException fileSystemClientException3) {
                            LoggingHelper.log(fileSystemClientException3);
                        }
                    }
                    subMonitor.done();
                    break block17;
                }
            }
            if (iSchedulingRule != null) {
                try {
                    this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                }
                catch (FileSystemClientException fileSystemClientException) {
                    LoggingHelper.log(fileSystemClientException);
                }
            }
            subMonitor.done();
        }
        return null;
    }

    public Collection getLocalItemPaths(IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule[] iSchedulingRuleArray = new ISchedulingRule[1];
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            Collection[] collectionArray = new Collection[1];
            CopyFileAreaStore$2 copyFileAreaStore$2 = new CopyFileAreaStore$2(this, collectionArray, iVersionableHandle, iSchedulingRuleArray);
            while (true) {
                this.metadata.run(copyFileAreaStore$2);
                if (iSchedulingRuleArray[0] != null) break;
                if (collectionArray[0].isEmpty()) {
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                if (subMonitor.isCanceled()) {
                    throw (Throwable)new OperationCanceledException();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(interruptedException)));
                }
            }
            subMonitor.worked(1);
            subMonitor.setWorkRemaining(99);
            SubMonitor subMonitor2 = subMonitor.newChild(98);
            subMonitor2.setWorkRemaining(collectionArray[0].size());
            ArrayList<IPath> arrayList = new ArrayList<IPath>(collectionArray[0].size());
            for (ISharingMetadata$IConnectionComponent iSharingMetadata$IConnectionComponent : collectionArray[0]) {
                IPath iPath = this.getLocalPathInternal(iVersionableHandle, iSharingMetadata$IConnectionComponent.getComponent(), iSharingMetadata$IConnectionComponent.getConnection());
                if (iPath != null) {
                    arrayList.add(iPath);
                }
                subMonitor2.worked(1);
            }
            subMonitor2.done();
            ArrayList<IPath> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (iSchedulingRuleArray[0] != null) {
                this.endBatching(iSchedulingRuleArray[0], (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    public Collection getLocalItemPaths(IVersionableHandle iVersionableHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule[] iSchedulingRuleArray = new ISchedulingRule[1];
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            Collection[] collectionArray = new Collection[1];
            int[] nArray = new int[1];
            CopyFileAreaStore$3 copyFileAreaStore$3 = new CopyFileAreaStore$3(this, collectionArray, iVersionableHandle, nArray, iContextHandle, iSchedulingRuleArray);
            while (true) {
                this.metadata.run(copyFileAreaStore$3);
                if (iSchedulingRuleArray[0] != null) break;
                if (nArray[0] == 0) {
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                if (subMonitor.isCanceled()) {
                    throw (Throwable)new OperationCanceledException();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(interruptedException)));
                }
            }
            subMonitor.worked(1);
            subMonitor.setWorkRemaining(99);
            SubMonitor subMonitor2 = subMonitor.newChild(98);
            subMonitor2.setWorkRemaining(nArray[0]);
            ArrayList<IPath> arrayList = new ArrayList<IPath>(nArray[0]);
            for (ISharingMetadata$IConnectionComponent iSharingMetadata$IConnectionComponent : collectionArray[0]) {
                if (!iSharingMetadata$IConnectionComponent.getConnection().sameItemId((IItemHandle)iContextHandle)) continue;
                IPath iPath = this.getLocalPathInternal(iVersionableHandle, iSharingMetadata$IConnectionComponent.getComponent(), iSharingMetadata$IConnectionComponent.getConnection());
                if (iPath != null) {
                    arrayList.add(iPath);
                }
                subMonitor2.worked(1);
            }
            subMonitor2.done();
            ArrayList<IPath> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (iSchedulingRuleArray[0] != null) {
                this.endBatching(iSchedulingRuleArray[0], (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    public Collection getLocalItemPaths(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule[] iSchedulingRuleArray = new ISchedulingRule[1];
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            Collection[] collectionArray = new Collection[1];
            int[] nArray = new int[1];
            CopyFileAreaStore$4 copyFileAreaStore$4 = new CopyFileAreaStore$4(this, collectionArray, iVersionableHandle, nArray, iComponentHandle, iSchedulingRuleArray);
            while (true) {
                this.metadata.run(copyFileAreaStore$4);
                if (iSchedulingRuleArray[0] != null) break;
                if (nArray[0] == 0) {
                    List list = Collections.EMPTY_LIST;
                    return list;
                }
                if (subMonitor.isCanceled()) {
                    throw (Throwable)new OperationCanceledException();
                }
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(interruptedException)));
                }
            }
            subMonitor.worked(1);
            subMonitor.setWorkRemaining(99);
            SubMonitor subMonitor2 = subMonitor.newChild(98);
            subMonitor2.setWorkRemaining(nArray[0]);
            ArrayList<IPath> arrayList = new ArrayList<IPath>(nArray[0]);
            for (ISharingMetadata$IConnectionComponent iSharingMetadata$IConnectionComponent : collectionArray[0]) {
                if (!iSharingMetadata$IConnectionComponent.getComponent().sameItemId((IItemHandle)iComponentHandle)) continue;
                IPath iPath = this.getLocalPathInternal(iVersionableHandle, iSharingMetadata$IConnectionComponent.getComponent(), iSharingMetadata$IConnectionComponent.getConnection());
                if (iPath != null) {
                    arrayList.add(iPath);
                }
                subMonitor2.worked(1);
            }
            subMonitor2.done();
            ArrayList<IPath> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            if (iSchedulingRuleArray[0] != null) {
                this.endBatching(iSchedulingRuleArray[0], (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    public FileItemInfo getItemInfo(IPath iPath) {
        try {
            return this.metadata.getFileItemInfo(iPath);
        }
        catch (FileSystemClientException fileSystemClientException) {
            LoggingHelper.log(fileSystemClientException);
            return null;
        }
    }

    public void moveSharingInfo(IPath iPath, IPath iPath2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule iSchedulingRule = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ISharingDescriptor[] iSharingDescriptorArray = new ISharingDescriptor[1];
        FileSystemClientException[] fileSystemClientExceptionArray = new FileSystemClientException[1];
        try {
            iSchedulingRule = this.beginBatchingWithLock(null, new CopyFileAreaStore$5(this, iPath2, iPath, iSharingDescriptorArray, fileSystemClientExceptionArray), (IProgressMonitor)subMonitor.newChild(1));
            if (fileSystemClientExceptionArray[0] != null) {
                throw (Throwable)((Object)fileSystemClientExceptionArray[0]);
            }
            this.metadata.moveFileItemInfo(iPath, iPath2);
            subMonitor.worked(50);
            this.metadata.setSharingDescriptor(iPath, null, (IProgressMonitor)subMonitor.newChild(24));
            this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)iSharingDescriptorArray[0].getRootFolder(), iPath, 2));
            this.metadata.setSharingDescriptor(iPath2, iSharingDescriptorArray[0], (IProgressMonitor)subMonitor.newChild(24));
            this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)iSharingDescriptorArray[0].getRootFolder(), iPath2, 1));
        }
        catch (Throwable throwable) {
            this.sharingInfoLock.release();
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
            throw throwable;
        }
        this.sharingInfoLock.release();
        if (iSchedulingRule != null) {
            this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    public void setSharingInfo(IShareable iShareable, ISharingDescriptor iSharingDescriptor, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Assert.isNotNull((Object)iSharingDescriptor);
        ISchedulingRule iSchedulingRule = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IPath iPath = iShareable.getLocalFullPath();
        ISharingDescriptor[] iSharingDescriptorArray = new ISharingDescriptor[1];
        FileSystemClientException[] fileSystemClientExceptionArray = new FileSystemClientException[1];
        try {
            iSchedulingRule = this.beginBatchingWithLock(null, new CopyFileAreaStore$6(this, iSharingDescriptorArray, iPath, iSharingDescriptor, fileSystemClientExceptionArray), (IProgressMonitor)subMonitor.newChild(1));
            if (fileSystemClientExceptionArray[0] != null) {
                throw (Throwable)((Object)fileSystemClientExceptionArray[0]);
            }
            if (iSharingDescriptorArray[0] == null) {
                this.metadata.deleteFileItemInfo(iPath, (IProgressMonitor)subMonitor.newChild(70));
            } else if (!(iSharingDescriptorArray[0].getComponent().sameItemId((IItemHandle)iSharingDescriptor.getComponent()) && iSharingDescriptorArray[0].getConnectionHandle().sameItemId((IItemHandle)iSharingDescriptor.getConnectionHandle()) && iSharingDescriptorArray[0].getRootFolder().sameItemId((IItemHandle)iSharingDescriptor.getRootFolder()))) {
                if (!iSharingDescriptorArray[0].getRootFolder().sameItemId((IItemHandle)iSharingDescriptor.getRootFolder())) {
                    this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)iSharingDescriptorArray[0].getRootFolder(), iPath, 2));
                }
                this.moveSubtreeToWC(iPath, iSharingDescriptorArray[0], iSharingDescriptor, (IProgressMonitor)subMonitor.newChild(70));
            } else {
                subMonitor.setWorkRemaining(29);
            }
            this.metadata.setSharingDescriptor(iPath, iSharingDescriptor, (IProgressMonitor)subMonitor.newChild(14));
            if (!(iSharingDescriptorArray[0] == null || iSharingDescriptorArray[0].getComponent().sameItemId((IItemHandle)iSharingDescriptor.getComponent()) && iSharingDescriptorArray[0].getConnectionHandle().sameItemId((IItemHandle)iSharingDescriptor.getConnectionHandle()))) {
                subMonitor.setWorkRemaining(16);
                if (!this.metadata.hasShares(iSharingDescriptorArray[0].getComponent(), iSharingDescriptorArray[0].getConnectionHandle(), (IProgressMonitor)subMonitor.newChild(1))) {
                    LocalChangeManager.getInstance().clearPendingChanges(iSharingDescriptorArray[0].getConnectionHandle(), iSharingDescriptorArray[0].getComponent(), this.getRoot());
                }
            }
            boolean bl = this.metadata.componentLoaded(new LoadedConfigurationDescriptor(iSharingDescriptor.getRepositoryId(), iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getConnectionName(), iSharingDescriptor.getComponent(), iSharingDescriptor.getComponentName()), (IProgressMonitor)subMonitor.newChild(14)) != null;
            this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)iSharingDescriptor.getRootFolder(), iPath, 1));
            if (!bl) {
                this.batchingLock.addChange(new CopyFileAreaEvent(null, null, 7));
            }
        }
        catch (Throwable throwable) {
            this.sharingInfoLock.release();
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
            throw throwable;
        }
        this.sharingInfoLock.release();
        if (iSchedulingRule != null) {
            this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    private void moveSubtreeToWC(IPath iPath, ISharingDescriptor iSharingDescriptor, ISharingDescriptor iSharingDescriptor2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Cloneable cloneable;
        IPath iPath2;
        InverseFileItemInfo inverseFileItemInfo;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        if (this.metadata.getFileItemInfo((IVersionableHandle)iSharingDescriptor2.getRootFolder(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle()) != null) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.CopyFileAreaStore_12, (Object[])new Object[]{iPath, iSharingDescriptor2.getRootFolder().getItemId().getUuidValue(), iSharingDescriptor2.getConnectionName(), iSharingDescriptor2.getComponentName()}), null)));
        }
        if (!iSharingDescriptor.getRootFolder().sameItemId((IItemHandle)iSharingDescriptor2.getRootFolder())) {
            inverseFileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)iSharingDescriptor2.getRootFolder(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
            iPath2 = this.getLocalPathInternal(inverseFileItemInfo, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
        } else {
            inverseFileItemInfo = null;
            iPath2 = null;
        }
        boolean[] blArray = new boolean[1];
        InverseFileItemInfo[] inverseFileItemInfoArray = new InverseFileItemInfo[1];
        if (!iSharingDescriptor.getComponent().sameItemId((IItemHandle)iSharingDescriptor2.getComponent()) || !iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iSharingDescriptor2.getConnectionHandle())) {
            cloneable = new ArrayList();
            this.metadata.accept(new CopyFileAreaStore$7(this, iSharingDescriptor, (List)((Object)cloneable)), iPath, Integer.MAX_VALUE, true, (IProgressMonitor)subMonitor.newChild(25));
            if (!cloneable.isEmpty()) {
                MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaStore_21, null);
                Iterator iterator = cloneable.iterator();
                while (iterator.hasNext()) {
                    FileSystemClientException fileSystemClientException = (FileSystemClientException)((Object)iterator.next());
                    multiStatus.add(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
                }
                throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
            }
            this.metadata.accept(new CopyFileAreaStore$8(this, iSharingDescriptor, (List)((Object)cloneable)), (IVersionableHandle)iSharingDescriptor.getRootFolder(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), Integer.MAX_VALUE, true, (IProgressMonitor)subMonitor.newChild(20));
            if (!cloneable.isEmpty()) {
                MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaStore_22, null);
                Iterator iterator = cloneable.iterator();
                while (iterator.hasNext()) {
                    FileSystemClientException fileSystemClientException = (FileSystemClientException)((Object)iterator.next());
                    multiStatus.add(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
                }
                throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
            }
            this.metadata.accept(new CopyFileAreaStore$9(this, iSharingDescriptor, iSharingDescriptor2, blArray, (List)((Object)cloneable)), (IVersionableHandle)iSharingDescriptor.getRootFolder(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), Integer.MAX_VALUE, true, (IProgressMonitor)subMonitor.newChild(20));
            if (!cloneable.isEmpty()) {
                MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaStore_14, null);
                Iterator iterator = cloneable.iterator();
                while (iterator.hasNext()) {
                    FileSystemClientException fileSystemClientException = (FileSystemClientException)((Object)iterator.next());
                    multiStatus.add(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
                }
                throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
            }
            this.metadata.accept(new CopyFileAreaStore$10(this, iSharingDescriptor, iSharingDescriptor2, inverseFileItemInfoArray, (List)((Object)cloneable)), iPath, Integer.MAX_VALUE, true, (IProgressMonitor)subMonitor.newChild(25));
            if (!cloneable.isEmpty()) {
                MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaStore_15, null);
                Iterator iterator = cloneable.iterator();
                while (iterator.hasNext()) {
                    FileSystemClientException fileSystemClientException = (FileSystemClientException)((Object)iterator.next());
                    multiStatus.add(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
                }
                throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
            }
        } else {
            blArray[0] = this.getRemoteAncestorInternal(Collections.singleton(iSharingDescriptor.getRootFolder().getItemId()), (IVersionableHandle)iSharingDescriptor2.getRootFolder(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle()) != null;
            inverseFileItemInfoArray[0] = this.metadata.getFileItemInfo((IVersionableHandle)iSharingDescriptor.getRootFolder(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle());
        }
        subMonitor.setWorkRemaining(10);
        if (!inverseFileItemInfoArray[0].getVersionableHandle().sameItemId((IItemHandle)iSharingDescriptor2.getRootFolder())) {
            Object object;
            Object object2;
            Object object3;
            IFolderHandle iFolderHandle;
            String string;
            cloneable = new HashMap();
            cloneable.put(inverseFileItemInfoArray[0].getVersionableHandle().getItemId(), inverseFileItemInfoArray[0]);
            if (inverseFileItemInfo != null) {
                inverseFileItemInfo = this.metadata.getFileItemInfo((IVersionableHandle)iSharingDescriptor2.getRootFolder(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle());
            }
            if (inverseFileItemInfo != null) {
                string = inverseFileItemInfo.getLocalName();
                iFolderHandle = inverseFileItemInfo.getLocalParent();
            } else {
                string = null;
                iFolderHandle = null;
            }
            if (blArray[0]) {
                cloneable.put(inverseFileItemInfo.getVersionableHandle().getItemId(), inverseFileItemInfo);
                object3 = this.getFileItemInfo((IVersionableHandle)inverseFileItemInfo.getParent(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle(), (Map)((Object)cloneable));
                object2 = new HashMap(((InverseFileItemInfo)object3).getRemoteChildren());
                object2.remove(inverseFileItemInfo.getName());
                object = new InverseFileItemInfo(((FileItemInfo)object3).getVersionableHandle(), ((FileItemInfo)object3).getLastModification(), ((FileItemInfo)object3).getParent(), ((FileItemInfo)object3).getName(), Collections.unmodifiableMap((Map)object2), ((InverseFileItemInfo)object3).getLocalParent(), ((InverseFileItemInfo)object3).getLocalName(), ((FileItemInfo)object3).getHash(), ((FileItemInfo)object3).getContentLength(), ((FileItemInfo)object3).getOriginalLineDelimiter(), ((FileItemInfo)object3).getLineDelimiter(), ((FileItemInfo)object3).getOriginalContentType(), ((FileItemInfo)object3).getContentType(), ((FileItemInfo)object3).getStoredContentId(), ((FileItemInfo)object3).getStoredDeltaPredecessor(), ((FileItemInfo)object3).getStoredSize(), ((FileItemInfo)object3).getStoredEncoding(), ((FileItemInfo)object3).getStoredChecksum(), ((FileItemInfo)object3).getStoredNumLineDelimiters(), ((FileItemInfo)object3).isExecutable(), ((FileItemInfo)object3).isOriginalExecutable());
                cloneable.put(((FileItemInfo)object).getVersionableHandle().getItemId(), object);
            } else {
                inverseFileItemInfo = new InverseFileItemInfo((IFolderHandle)IFolder.ITEM_TYPE.createItemHandle(iSharingDescriptor2.getRootFolder().getItemId(), UUID.generate()), null, null, Collections.EMPTY_MAP, null, null);
                cloneable.put(inverseFileItemInfo.getVersionableHandle().getItemId(), inverseFileItemInfo);
            }
            inverseFileItemInfoArray[0] = this.getFileItemInfo(inverseFileItemInfoArray[0].getVersionableHandle(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle(), (Map)((Object)cloneable));
            object3 = new HashMap(inverseFileItemInfo.getRemoteChildren());
            object2 = iPath.lastSegment();
            while (object3.containsKey(object2)) {
                object2 = String.valueOf(object2) + "0";
            }
            object3.put(object2, inverseFileItemInfoArray[0].getVersionableHandle());
            object = inverseFileItemInfo.getVersionableHandle().hasStateId() ? inverseFileItemInfo.getVersionableHandle() : (IVersionableHandle)inverseFileItemInfo.getVersionableHandle().getItemType().createItemHandle(inverseFileItemInfo.getVersionableHandle().getItemId(), UUID.generate());
            inverseFileItemInfo = new InverseFileItemInfo((IVersionableHandle)object, inverseFileItemInfo.getLastModification(), null, null, Collections.unmodifiableMap((Map)object3), null, null, inverseFileItemInfo.getHash(), inverseFileItemInfo.getContentLength(), inverseFileItemInfo.getOriginalLineDelimiter(), inverseFileItemInfo.getLineDelimiter(), inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo.getContentType(), inverseFileItemInfo.getStoredContentId(), inverseFileItemInfo.getStoredDeltaPredecessor(), inverseFileItemInfo.getStoredSize(), inverseFileItemInfo.getStoredEncoding(), inverseFileItemInfo.getStoredChecksum(), inverseFileItemInfo.getStoredNumLineDelimiters(), inverseFileItemInfo.isExecutable(), inverseFileItemInfo.isOriginalExecutable());
            cloneable.put(inverseFileItemInfo.getVersionableHandle().getItemId(), inverseFileItemInfo);
            inverseFileItemInfoArray[0] = new InverseFileItemInfo(inverseFileItemInfoArray[0].getVersionableHandle(), inverseFileItemInfoArray[0].getLastModification(), iSharingDescriptor2.getRootFolder(), (String)object2, inverseFileItemInfoArray[0].getRemoteChildren(), iFolderHandle, string, inverseFileItemInfoArray[0].getHash(), inverseFileItemInfoArray[0].getContentLength(), inverseFileItemInfoArray[0].getOriginalLineDelimiter(), inverseFileItemInfoArray[0].getLineDelimiter(), inverseFileItemInfoArray[0].getOriginalContentType(), inverseFileItemInfoArray[0].getContentType(), inverseFileItemInfoArray[0].getStoredContentId(), inverseFileItemInfoArray[0].getStoredDeltaPredecessor(), inverseFileItemInfoArray[0].getStoredSize(), inverseFileItemInfoArray[0].getStoredEncoding(), inverseFileItemInfoArray[0].getStoredChecksum(), inverseFileItemInfoArray[0].getStoredNumLineDelimiters(), inverseFileItemInfoArray[0].isExecutable(), inverseFileItemInfoArray[0].isOriginalExecutable());
            cloneable.put(inverseFileItemInfoArray[0].getVersionableHandle().getItemId(), inverseFileItemInfoArray[0]);
            this.metadata.setFileItemInfo(iPath, inverseFileItemInfo);
            if (iPath2 != null && iPath.isPrefixOf(iPath2)) {
                this.metadata.setFileItemInfo(iPath2, inverseFileItemInfoArray[0]);
            }
            this.adjustChildrenToNewParent(iPath, iSharingDescriptor2.getRootFolder(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle(), (Map)((Object)cloneable), (IProgressMonitor)subMonitor.newChild(5));
            if (iPath2 != null && iPath.isPrefixOf(iPath2)) {
                this.adjustChildrenToNewParent(iPath2, (IFolderHandle)inverseFileItemInfoArray[0].getVersionableHandle(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle(), (Map)((Object)cloneable), (IProgressMonitor)subMonitor.newChild(5));
            }
            for (InverseFileItemInfo inverseFileItemInfo2 : cloneable.values()) {
                this.metadata.setFileItemInfo(inverseFileItemInfo2.getVersionableHandle(), iSharingDescriptor2.getComponent(), iSharingDescriptor2.getConnectionHandle(), inverseFileItemInfo2);
            }
        }
        subMonitor.done();
    }

    private void adjustChildrenToNewParent(IPath iPath, IFolderHandle iFolderHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, Map map, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Map map2 = this.metadata.getChildInfos(iPath);
        for (FileItemInfo fileItemInfo : map2.values()) {
            InverseFileItemInfo inverseFileItemInfo = this.getFileItemInfo(fileItemInfo.getVersionableHandle(), iComponentHandle, iContextHandle, map);
            inverseFileItemInfo = new InverseFileItemInfo(inverseFileItemInfo.getVersionableHandle(), inverseFileItemInfo.getLastModification(), inverseFileItemInfo.getParent(), inverseFileItemInfo.getName(), inverseFileItemInfo.getRemoteChildren(), iFolderHandle, inverseFileItemInfo.getLocalName(), inverseFileItemInfo.getHash(), inverseFileItemInfo.getContentLength(), inverseFileItemInfo.getOriginalLineDelimiter(), inverseFileItemInfo.getLineDelimiter(), inverseFileItemInfo.getOriginalContentType(), inverseFileItemInfo.getContentType(), inverseFileItemInfo.getStoredContentId(), inverseFileItemInfo.getStoredDeltaPredecessor(), inverseFileItemInfo.getStoredSize(), inverseFileItemInfo.getStoredEncoding(), inverseFileItemInfo.getStoredChecksum(), inverseFileItemInfo.getStoredNumLineDelimiters(), inverseFileItemInfo.isExecutable(), inverseFileItemInfo.isOriginalExecutable());
            map.put(inverseFileItemInfo.getVersionableHandle().getItemId(), inverseFileItemInfo);
        }
    }

    private InverseFileItemInfo getFileItemInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, Map map) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo = (InverseFileItemInfo)map.get(iVersionableHandle.getItemId());
        if (inverseFileItemInfo != null) {
            return inverseFileItemInfo;
        }
        inverseFileItemInfo = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
        if (inverseFileItemInfo == null) {
            return null;
        }
        map.put(iVersionableHandle.getItemId(), inverseFileItemInfo);
        return inverseFileItemInfo;
    }

    public ISharingDescriptor getSharingInfo(IPath iPath) {
        try {
            return this.metadata.getSharingDescriptor(iPath);
        }
        catch (FileSystemClientException fileSystemClientException) {
            LoggingHelper.log(fileSystemClientException);
            return null;
        }
    }

    private ISharingDescriptor findSharingDescriptor(IShareable iShareable) {
        return this.getSharingInfo(iShareable.getLocalFullPath().removeLastSegments(iShareable.getLocalFullPath().segmentCount() - 1));
    }

    public boolean isShareRoot(IFolderHandle iFolderHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        return this.metadata.getPathForShareRoot(iFolderHandle, iComponentHandle, iContextHandle) != null;
    }

    public void removeSharingInfo(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule iSchedulingRule = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        IPath iPath = iShareable.getLocalFullPath();
        ISharingDescriptor[] iSharingDescriptorArray = new ISharingDescriptor[1];
        FileSystemClientException[] fileSystemClientExceptionArray = new FileSystemClientException[1];
        try {
            iSchedulingRule = this.beginBatchingWithLock(null, new CopyFileAreaStore$11(this, iSharingDescriptorArray, iPath, fileSystemClientExceptionArray), (IProgressMonitor)subMonitor.newChild(1));
            if (fileSystemClientExceptionArray[0] != null) {
                throw (Throwable)((Object)fileSystemClientExceptionArray[0]);
            }
            if (iSharingDescriptorArray[0] != null) {
                this.metadata.setSharingDescriptor(iPath, null, (IProgressMonitor)subMonitor.newChild(49));
                this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)iSharingDescriptorArray[0].getRootFolder(), iShareable.getLocalFullPath(), 2));
                if (!this.metadata.hasShares(iSharingDescriptorArray[0].getComponent(), iSharingDescriptorArray[0].getConnectionHandle(), (IProgressMonitor)subMonitor.newChild(49))) {
                    LocalChangeManager.getInstance().clearPendingChanges(iSharingDescriptorArray[0].getConnectionHandle(), iSharingDescriptorArray[0].getComponent(), this.getRoot());
                }
            } else {
                subMonitor.setWorkRemaining(1);
            }
        }
        catch (Throwable throwable) {
            this.sharingInfoLock.release();
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
            throw throwable;
        }
        this.sharingInfoLock.release();
        if (iSchedulingRule != null) {
            this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    private CopyFileAreaStore$RuleDescriptorPair beginBatching(IShareable iShareable, IProgressMonitor iProgressMonitor) {
        CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair = new CopyFileAreaStore$RuleDescriptorPair(null);
        try {
            copyFileAreaStore$RuleDescriptorPair.rule = this.beginBatchingWithLock(null, new CopyFileAreaStore$12(this, iShareable, copyFileAreaStore$RuleDescriptorPair), iProgressMonitor);
        }
        finally {
            this.sharingInfoLock.release();
        }
        return copyFileAreaStore$RuleDescriptorPair;
    }

    public ISchedulingRule beginBatching(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) {
        return this.batchingLock.acquire(iSchedulingRule, this, NULL_PARTICIPANT, true, iProgressMonitor);
    }

    public ISchedulingRule beginBatchingWithLock(ISchedulingRule iSchedulingRule, ILockParticipant iLockParticipant, IProgressMonitor iProgressMonitor) {
        return this.batchingLock.acquire(iSchedulingRule, this, iLockParticipant, true, iProgressMonitor);
    }

    public ISchedulingRule beginBatchingNoWait(ISchedulingRule iSchedulingRule) {
        return this.batchingLock.acquire(iSchedulingRule, this, NULL_PARTICIPANT, false, null);
    }

    public ReadWriteLock getSharingLock() {
        return this.sharingInfoLock;
    }

    public void endBatching(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.batchingLock.release(iSchedulingRule, iProgressMonitor);
    }

    public void flush(BatchingLock$ThreadInfo batchingLock$ThreadInfo, IProgressMonitor iProgressMonitor) {
        this.notifier.fireEvents(batchingLock$ThreadInfo.getEvents());
    }

    public void clear() throws FileSystemClientException {
        this.metadata.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getAllCopyFileAreas() {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            ArrayList<CopyFileAreaStore> arrayList = new ArrayList<CopyFileAreaStore>(1 + localStores.size());
            if (instance != null) {
                arrayList.add(instance);
            }
            arrayList.addAll(localStores.values());
            // ** MonitorExit[var0] (shouldn't be in output)
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFileAreaExists(IPath iPath) {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            block7: {
                if (iPath.segmentCount() == 0) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return instance != null;
                }
                if (iPath.equals((Object)SharingManager.getInstance().getDefaultCFARoot())) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return instance != null;
                }
                if (!localStores.containsKey(iPath)) break block7;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            iPath = CopyFileAreaStore.getCanonicalPath(iPath);
            if (iPath.equals((Object)SharingManager.getInstance().getDefaultCFARoot())) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance != null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localStores.containsKey(iPath);
        }
    }

    public boolean isConnectionShared(IContextHandle iContextHandle) throws FileSystemClientException {
        IPath[] iPathArray = this.metadata.allShares();
        int n = 0;
        while (n < iPathArray.length) {
            ISharingDescriptor iSharingDescriptor = this.metadata.getSharingDescriptor(iPathArray[n]);
            if (iSharingDescriptor != null && iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iContextHandle)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void accept(IRemoteVisitor iRemoteVisitor, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, ISchedulingRule iSchedulingRule, int n, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            if (iSchedulingRule != null) {
                iSchedulingRule = this.beginBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            this.metadata.accept(iRemoteVisitor, iVersionableHandle, iComponentHandle, iContextHandle, n, iSchedulingRule != null, (IProgressMonitor)subMonitor.newChild(98));
        }
        finally {
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    public void accept(IVisitor iVisitor, IShareable iShareable, ISchedulingRule iSchedulingRule, int n, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            if (iSchedulingRule != null) {
                iSchedulingRule = this.beginBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            this.metadata.accept(iVisitor, iShareable.getLocalFullPath(), n, iSchedulingRule != null, (IProgressMonitor)subMonitor.newChild(98));
        }
        finally {
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    public IPath[] allSharePaths() throws FileSystemClientException {
        return this.metadata.allShares();
    }

    public void deleteTreeInfo(IShareable iShareable, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule iSchedulingRule = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            IContextHandle iContextHandle;
            IComponentHandle iComponentHandle;
            CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair = this.beginBatching(iShareable, (IProgressMonitor)subMonitor.newChild(1));
            ISharingDescriptor iSharingDescriptor = copyFileAreaStore$RuleDescriptorPair.desc;
            iSchedulingRule = copyFileAreaStore$RuleDescriptorPair.rule;
            if (iSharingDescriptor != null) {
                iComponentHandle = iSharingDescriptor.getComponent();
                iContextHandle = iSharingDescriptor.getConnectionHandle();
            } else {
                iComponentHandle = null;
                iContextHandle = null;
            }
            this.deleteTreeInfoInternal(iShareable.getLocalFullPath(), iComponentHandle, iContextHandle, bl, (IProgressMonitor)subMonitor.newChild(98));
        }
        catch (Throwable throwable) {
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
            throw throwable;
        }
        if (iSchedulingRule != null) {
            this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    public void deleteTreeInfo(IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        InverseFileItemInfo inverseFileItemInfo;
        SubMonitor subMonitor;
        ISchedulingRule iSchedulingRule;
        block8: {
            block9: {
                iSchedulingRule = null;
                subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
                iSchedulingRule = this.beginBatching(new CopyFileAreaStore$ComponentLock(iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
                inverseFileItemInfo = this.metadata.getFileItemInfo(iVersionableHandle, iComponentHandle, iContextHandle);
                if (inverseFileItemInfo != null) break block8;
                if (iSchedulingRule == null) break block9;
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
            return;
        }
        try {
            this.updateParentInfoForRemoval(inverseFileItemInfo, iComponentHandle, iContextHandle);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(iVersionableHandle);
            do {
                IVersionableHandle iVersionableHandle2;
                IPath iPath;
                if ((iPath = this.getLocalPathInternal(inverseFileItemInfo = this.metadata.setFileItemInfo(iVersionableHandle2 = (IVersionableHandle)arrayList.remove(arrayList.size() - 1), iComponentHandle, iContextHandle, null), iComponentHandle, iContextHandle)) != null) {
                    InverseFileItemInfo inverseFileItemInfo2 = new InverseFileItemInfo((IVersionableHandle)inverseFileItemInfo.getVersionableHandle().getItemType().createItemHandle(UUID.generate(), null), -1L, null, null, Collections.EMPTY_MAP, inverseFileItemInfo.getLocalParent(), inverseFileItemInfo.getLocalName(), null, -1L, null, inverseFileItemInfo.getLineDelimiter(), null, inverseFileItemInfo.getContentType(), null, null, -1L, null, -1L, -1L, inverseFileItemInfo.isExecutable(), false);
                    this.metadata.setFileItemInfo(inverseFileItemInfo2.getVersionableHandle(), iComponentHandle, iContextHandle, inverseFileItemInfo2);
                    this.metadata.setFileItemInfo(iPath, inverseFileItemInfo2);
                    if (inverseFileItemInfo.isFolder()) {
                        this.updateLocalParent(iPath, (IFolderHandle)inverseFileItemInfo2.getVersionableHandle(), iComponentHandle, iContextHandle);
                    }
                }
                arrayList.addAll(inverseFileItemInfo.getRemoteChildren().values());
            } while (!arrayList.isEmpty());
        }
        catch (Throwable throwable) {
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
            throw throwable;
        }
        if (iSchedulingRule != null) {
            this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    private void deleteTreeInfoInternal(IPath iPath, IComponentHandle iComponentHandle, IContextHandle iContextHandle, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        ArrayList arrayList = new ArrayList();
        IVersionableHandle[] iVersionableHandleArray = new IVersionableHandle[1];
        this.metadata.accept(new CopyFileAreaStore$13(this, iPath, iVersionableHandleArray, iComponentHandle, iContextHandle, arrayList), iPath, Integer.MAX_VALUE, true, (IProgressMonitor)subMonitor.newChild(33));
        if (iComponentHandle != null && bl && iVersionableHandleArray[0] != null && iVersionableHandleArray[0].hasStateId()) {
            this.metadata.accept(new CopyFileAreaStore$14(this, iVersionableHandleArray, iComponentHandle, iContextHandle, arrayList), iVersionableHandleArray[0], iComponentHandle, iContextHandle, Integer.MAX_VALUE, true, (IProgressMonitor)subMonitor.newChild(34));
        } else {
            subMonitor.setWorkRemaining(33);
        }
        this.metadata.deleteFileItemInfo(iPath, (IProgressMonitor)subMonitor.newChild(33));
        if (!arrayList.isEmpty()) {
            MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaStore_19, null);
            for (FileSystemClientException fileSystemClientException : arrayList) {
                multiStatus.add(FileSystemStatus.getStatusFor((Throwable)((Object)fileSystemClientException)));
            }
            throw (Throwable)((Object)new FileSystemClientException((IStatus)multiStatus));
        }
    }

    public void moveTreeInfo(IShareable iShareable, IShareable iShareable2, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule iSchedulingRule = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            CopyFileAreaStore$RuleDescriptorPair copyFileAreaStore$RuleDescriptorPair = this.beginBatching(iShareable, (IProgressMonitor)subMonitor.newChild(1));
            ISharingDescriptor iSharingDescriptor = copyFileAreaStore$RuleDescriptorPair.desc;
            iSchedulingRule = copyFileAreaStore$RuleDescriptorPair.rule;
            ISharingDescriptor iSharingDescriptor2 = this.findSharingDescriptor(iShareable2);
            Assert.isTrue((iSharingDescriptor2 != null && iSharingDescriptor2.getConnectionHandle().sameItemId((IItemHandle)iSharingDescriptor.getConnectionHandle()) && iSharingDescriptor2.getComponent().sameItemId((IItemHandle)iSharingDescriptor.getComponent()) ? 1 : 0) != 0);
            IPath iPath = iShareable.getLocalFullPath();
            IPath iPath2 = iShareable2.getLocalFullPath();
            FileItemInfo fileItemInfo = this.metadata.getFileItemInfo(iPath);
            if (fileItemInfo != null) {
                String string;
                IFolderHandle iFolderHandle;
                String string2;
                IFolderHandle iFolderHandle2;
                FileItemInfo fileItemInfo2 = this.metadata.getFileItemInfo(iPath2.removeLastSegments(1));
                if (fileItemInfo2 == null) {
                    iFolderHandle2 = null;
                    string2 = null;
                } else {
                    iFolderHandle2 = (IFolderHandle)fileItemInfo2.getVersionableHandle();
                    string2 = iPath2.lastSegment();
                }
                if (bl) {
                    iFolderHandle = iFolderHandle2;
                    string = string2;
                } else {
                    iFolderHandle = fileItemInfo.getParent();
                    string = fileItemInfo.getName();
                }
                InverseFileItemInfo inverseFileItemInfo = this.metadata.getFileItemInfo(fileItemInfo.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                InverseFileItemInfo inverseFileItemInfo2 = new InverseFileItemInfo(fileItemInfo.getVersionableHandle(), fileItemInfo.getLastModification(), iFolderHandle, string, inverseFileItemInfo.getRemoteChildren(), iFolderHandle2, string2, fileItemInfo.getHash(), fileItemInfo.getContentLength(), fileItemInfo.getOriginalLineDelimiter(), fileItemInfo.getLineDelimiter(), fileItemInfo.getOriginalContentType(), fileItemInfo.getContentType(), fileItemInfo.getStoredContentId(), fileItemInfo.getStoredDeltaPredecessor(), fileItemInfo.getStoredSize(), fileItemInfo.getStoredEncoding(), fileItemInfo.getStoredChecksum(), fileItemInfo.getStoredNumLineDelimiters(), iFolderHandle2 == null ? fileItemInfo.isOriginalExecutable() : fileItemInfo.isExecutable(), fileItemInfo.isOriginalExecutable());
                this.updateParentInfoForChange(inverseFileItemInfo2, fileItemInfo, iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle());
                this.metadata.setFileItemInfo(fileItemInfo.getVersionableHandle(), iSharingDescriptor.getComponent(), iSharingDescriptor.getConnectionHandle(), inverseFileItemInfo2);
                if (bl) {
                    this.metadata.setFileItemInfo(iPath, inverseFileItemInfo2);
                }
            }
            this.metadata.moveFileItemInfo(iPath, iShareable2.getLocalFullPath());
        }
        catch (Throwable throwable) {
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
            throw throwable;
        }
        if (iSchedulingRule != null) {
            this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    public void run(ISchedulingRule iSchedulingRule, CopyFileAreaStore$IOperation copyFileAreaStore$IOperation, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            iSchedulingRule = this.beginBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            copyFileAreaStore$IOperation.execute((IProgressMonitor)subMonitor.newChild(98));
        }
        finally {
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    public void run(CopyFileAreaStore$IOperation copyFileAreaStore$IOperation, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.metadata.run(new CopyFileAreaStore$15(this, copyFileAreaStore$IOperation, iProgressMonitor));
    }

    public String toDebugString() {
        return this.metadata.toDebugString();
    }

    public ISharingMetadata getMetadata() {
        return this.metadata;
    }

    public void close() throws FileSystemClientException {
        this.metadata.close();
        CopyFileAreaStore.removeCopyFileArea(this.path);
    }

    public void sync() throws FileSystemClientException {
        this.metadata.close();
    }

    public IPath getRoot() {
        return this.path;
    }

    public boolean isCaseSensitive() {
        return this.metadata.isCaseSensitive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeCopyFileArea(IPath iPath) {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            CopyFileAreaStore copyFileAreaStore = null;
            copyFileAreaStore = (CopyFileAreaStore)localStores.remove(iPath);
            if (iPath.equals((Object)SharingManager.getInstance().getDefaultCFARoot())) {
                Assert.isTrue((copyFileAreaStore == null ? 1 : 0) != 0);
                copyFileAreaStore = instance;
                instance = null;
            }
            for (ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener : listeners) {
                copyFileAreaStore.metadata.removeCorruptionListener(iCorruptCopyFileAreaListener);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static IPath getCanonicalPath(IPath iPath) {
        try {
            return (IPath)new Path(iPath.toFile().getCanonicalPath());
        }
        catch (IOException iOException) {
            return iPath;
        }
    }

    public static Object beginAvoidNotify() {
        Collection collection = CopyFileAreaStore.getAllCopyFileAreas();
        for (CopyFileAreaStore copyFileAreaStore : collection) {
            copyFileAreaStore.beginBatching(BatchingLock.AVOID_NOTIFICATION_RULE, null);
        }
        return collection;
    }

    public static void endAvoidNotify(Object object) throws FileSystemClientException {
        if (!(object instanceof Collection)) {
            throw (Throwable)new IllegalArgumentException();
        }
        Collection collection = (Collection)object;
        for (Object e : collection) {
            if (!(e instanceof CopyFileAreaStore)) {
                throw (Throwable)new IllegalArgumentException();
            }
            CopyFileAreaStore copyFileAreaStore = (CopyFileAreaStore)e;
            copyFileAreaStore.endBatching(BatchingLock.AVOID_NOTIFICATION_RULE, null);
        }
    }

    public void setConfigurationState(IContextHandle iContextHandle, IComponentHandle iComponentHandle, ISyncTime iSyncTime, ISyncTime iSyncTime2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule iSchedulingRule = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            iSchedulingRule = this.beginBatchingWithLock(null, new CopyFileAreaStore$16(this, iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
            Map map = this.metadata.getSharingDescriptors(iComponentHandle, iContextHandle);
            SubMonitor subMonitor2 = subMonitor.newChild(98);
            subMonitor2.setWorkRemaining(map.size());
            for (Map.Entry entry : map.entrySet()) {
                ISharingDescriptor iSharingDescriptor = (ISharingDescriptor)entry.getValue();
                IPath iPath = (IPath)entry.getKey();
                this.updateConfigurationState(iPath, iSharingDescriptor, iSyncTime, iSyncTime2, subMonitor2);
            }
            subMonitor2.done();
        }
        finally {
            this.sharingInfoLock.release();
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    private void updateConfigurationState(IPath iPath, ISharingDescriptor iSharingDescriptor, ISyncTime iSyncTime, ISyncTime iSyncTime2, SubMonitor subMonitor) throws FileSystemClientException {
        SharingDescriptor sharingDescriptor = (SharingDescriptor)iSharingDescriptor;
        if (iSyncTime == null || iSyncTime.equals(sharingDescriptor.getConfigurationState())) {
            SharingDescriptor sharingDescriptor2 = new SharingDescriptor(sharingDescriptor, iSyncTime2);
            this.metadata.setSharingDescriptor(iPath, sharingDescriptor2, (IProgressMonitor)subMonitor.newChild(1));
            this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)sharingDescriptor2.getRootFolder(), iPath, 6));
        } else if (iSyncTime2.equals(sharingDescriptor.getConfigurationState())) {
            subMonitor.worked(1);
        } else if (sharingDescriptor.isUnknownState()) {
            SharingDescriptor sharingDescriptor3 = new SharingDescriptor(sharingDescriptor, ISyncTime.TIME_NONE);
            this.metadata.setSharingDescriptor(iPath, sharingDescriptor3, (IProgressMonitor)subMonitor.newChild(1));
            this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)sharingDescriptor3.getRootFolder(), iPath, 6));
        }
    }

    public void setConfigurationState(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IFolderHandle iFolderHandle, ISyncTime iSyncTime, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule iSchedulingRule = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            SharingDescriptor sharingDescriptor;
            iSchedulingRule = this.beginBatchingWithLock(null, new CopyFileAreaStore$17(this, iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
            IPath iPath = this.getLocalPathInternal((IVersionableHandle)iFolderHandle, iComponentHandle, iContextHandle);
            if (iPath != null && (sharingDescriptor = (SharingDescriptor)this.metadata.getSharingDescriptor(iPath)) != null && !iSyncTime.equals(sharingDescriptor.getConfigurationState())) {
                SharingDescriptor sharingDescriptor2 = new SharingDescriptor(sharingDescriptor, iSyncTime);
                this.metadata.setSharingDescriptor(iPath, sharingDescriptor2, (IProgressMonitor)subMonitor.newChild(98));
                this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)sharingDescriptor2.getRootFolder(), iPath, 6));
            }
            subMonitor.setWorkRemaining(1);
        }
        finally {
            this.sharingInfoLock.release();
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    public void setConfigurationState(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IPath iPath, ISyncTime iSyncTime, ISyncTime iSyncTime2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule iSchedulingRule = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            iSchedulingRule = this.beginBatchingWithLock(null, new CopyFileAreaStore$18(this, iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
            ISharingDescriptor iSharingDescriptor = this.metadata.getSharingDescriptor(iPath);
            if (iSharingDescriptor != null && iSharingDescriptor.getComponent().sameItemId((IItemHandle)iComponentHandle) && iSharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iContextHandle)) {
                this.updateConfigurationState(iPath, iSharingDescriptor, iSyncTime, iSyncTime2, subMonitor.newChild(98));
            }
            subMonitor.setWorkRemaining(1);
        }
        finally {
            this.sharingInfoLock.release();
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    public void setConfigurationState(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IPath iPath, ISyncTime iSyncTime, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule iSchedulingRule = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            iSchedulingRule = this.beginBatchingWithLock(null, new CopyFileAreaStore$19(this, iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
            SharingDescriptor sharingDescriptor = (SharingDescriptor)this.metadata.getSharingDescriptor(iPath);
            if (sharingDescriptor != null && sharingDescriptor.getComponent().sameItemId((IItemHandle)iComponentHandle) && sharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iContextHandle) && !iSyncTime.equals(sharingDescriptor.getConfigurationState())) {
                SharingDescriptor sharingDescriptor2 = new SharingDescriptor(sharingDescriptor, iSyncTime);
                this.metadata.setSharingDescriptor(iPath, sharingDescriptor2, (IProgressMonitor)subMonitor.newChild(98));
                this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)sharingDescriptor2.getRootFolder(), iPath, 6));
            }
            subMonitor.setWorkRemaining(1);
        }
        finally {
            this.sharingInfoLock.release();
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    public void setUnknownConfigurationState(IContextHandle iContextHandle, IComponentHandle iComponentHandle, Path path, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule iSchedulingRule = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            iSchedulingRule = this.beginBatchingWithLock(null, new CopyFileAreaStore$20(this, iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
            SharingDescriptor sharingDescriptor = (SharingDescriptor)this.metadata.getSharingDescriptor((IPath)path);
            if (sharingDescriptor != null && sharingDescriptor.getComponent().sameItemId((IItemHandle)iComponentHandle) && sharingDescriptor.getConnectionHandle().sameItemId((IItemHandle)iContextHandle)) {
                SharingDescriptor sharingDescriptor2 = new SharingDescriptor(sharingDescriptor, ISyncTime.TIME_NONE);
                this.metadata.setSharingDescriptor((IPath)path, sharingDescriptor2, (IProgressMonitor)subMonitor.newChild(98));
                this.batchingLock.addChange(new CopyFileAreaEvent((IVersionableHandle)sharingDescriptor2.getRootFolder(), (IPath)path, 6));
            }
            subMonitor.setWorkRemaining(1);
        }
        finally {
            this.sharingInfoLock.release();
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
        }
    }

    public boolean isLoaded(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.metadata.isLoaded(iComponentHandle, iContextHandle, iProgressMonitor);
    }

    public Collection allLoadedComponents(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.metadata.allLoadedComponents(iProgressMonitor);
    }

    public Collection allLoadedContexts(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.metadata.allLoadedContexts(iProgressMonitor);
    }

    public void componentLoaded(LoadedConfigurationDescriptor loadedConfigurationDescriptor, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule iSchedulingRule = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            boolean bl;
            iSchedulingRule = this.beginBatching(new CopyFileAreaStore$ComponentLock(loadedConfigurationDescriptor.connectionHandle, loadedConfigurationDescriptor.componentHandle), (IProgressMonitor)subMonitor.newChild(1));
            boolean bl2 = bl = this.metadata.componentLoaded(loadedConfigurationDescriptor, (IProgressMonitor)subMonitor.newChild(98)) != null;
            if (!bl) {
                this.batchingLock.addChange(new CopyFileAreaEvent(null, null, 7));
            }
        }
        catch (Throwable throwable) {
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
            throw throwable;
        }
        if (iSchedulingRule != null) {
            this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    public void componentUnloaded(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        ISchedulingRule iSchedulingRule = null;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            boolean bl;
            iSchedulingRule = this.beginBatching(new CopyFileAreaStore$ComponentLock(iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
            if (this.metadata.hasShares(iComponentHandle, iContextHandle, (IProgressMonitor)subMonitor.newChild(49))) {
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(Messages.CopyFileAreaStore_20)));
            }
            boolean bl2 = bl = this.metadata.componentUnloaded(iComponentHandle, iContextHandle, (IProgressMonitor)subMonitor.newChild(49)) != null;
            if (bl) {
                this.batchingLock.addChange(new CopyFileAreaEvent(null, null, 8));
            }
        }
        catch (Throwable throwable) {
            if (iSchedulingRule != null) {
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            subMonitor.done();
            throw throwable;
        }
        if (iSchedulingRule != null) {
            this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
        }
        subMonitor.done();
    }

    public boolean isCorrupted() {
        return this.metadata.isCorrupted();
    }

    public int getNumShares(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        int n;
        SubMonitor subMonitor;
        block3: {
            ISchedulingRule iSchedulingRule = null;
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            try {
                iSchedulingRule = this.beginBatching(new CopyFileAreaStore$ComponentLock(iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
                n = this.metadata.getSharingDescriptors(iComponentHandle, iContextHandle).size();
                if (iSchedulingRule == null) break block3;
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (Throwable throwable) {
                if (iSchedulingRule != null) {
                    this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                }
                subMonitor.done();
                throw throwable;
            }
        }
        subMonitor.done();
        return n;
    }

    public Collection getShares(IContextHandle iContextHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Collection collection;
        SubMonitor subMonitor;
        block3: {
            ISchedulingRule iSchedulingRule = null;
            subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
            try {
                iSchedulingRule = this.beginBatching(new CopyFileAreaStore$ComponentLock(iContextHandle, iComponentHandle), (IProgressMonitor)subMonitor.newChild(1));
                collection = this.metadata.getSharingDescriptors(iComponentHandle, iContextHandle).values();
                if (iSchedulingRule == null) break block3;
                this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
            }
            catch (Throwable throwable) {
                if (iSchedulingRule != null) {
                    this.endBatching(iSchedulingRule, (IProgressMonitor)subMonitor.newChild(1));
                }
                subMonitor.done();
                throw throwable;
            }
        }
        subMonitor.done();
        return collection;
    }

    static /* synthetic */ ISharingMetadata access$0(CopyFileAreaStore copyFileAreaStore) {
        return copyFileAreaStore.metadata;
    }

    static /* synthetic */ ReadWriteLock access$1(CopyFileAreaStore copyFileAreaStore) {
        return copyFileAreaStore.sharingInfoLock;
    }

    static /* synthetic */ IPath access$2(CopyFileAreaStore copyFileAreaStore, InverseFileItemInfo inverseFileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        return copyFileAreaStore.getLocalPathInternal(inverseFileItemInfo, iComponentHandle, iContextHandle);
    }

    static /* synthetic */ void access$3(CopyFileAreaStore copyFileAreaStore, IPath iPath, IFolderHandle iFolderHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        copyFileAreaStore.updateLocalParent(iPath, iFolderHandle, iComponentHandle, iContextHandle);
    }

    static /* synthetic */ ISharingDescriptor access$4(CopyFileAreaStore copyFileAreaStore, IShareable iShareable) {
        return copyFileAreaStore.findSharingDescriptor(iShareable);
    }

    static /* synthetic */ void access$5(CopyFileAreaStore copyFileAreaStore, FileItemInfo fileItemInfo, IComponentHandle iComponentHandle, IContextHandle iContextHandle) throws FileSystemClientException {
        copyFileAreaStore.updateParentInfoForRemoval(fileItemInfo, iComponentHandle, iContextHandle);
    }
}

