/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaNotifier$1;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class CopyFileAreaNotifier
extends Job {
    private static final int SCHEDULING_DELAY = 1000;
    private List collectedEvents = new ArrayList();
    private ListenerList listeners = new ListenerList();
    private volatile long latestRequest;

    public CopyFileAreaNotifier() {
        super(Messages.CopyFileAreaNotifier_0);
        this.setSystem(true);
        this.setPriority(30);
    }

    public void addListener(ICopyFileAreaListener iCopyFileAreaListener) {
        this.listeners.add((Object)iCopyFileAreaListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvents(ICopyFileAreaEvent[] iCopyFileAreaEventArray) {
        if (iCopyFileAreaEventArray.length == 0) {
            return;
        }
        CopyFileAreaNotifier copyFileAreaNotifier = this;
        synchronized (copyFileAreaNotifier) {
            this.collectedEvents.addAll((Collection)Arrays.asList(iCopyFileAreaEventArray));
        }
        this.latestRequest = System.currentTimeMillis();
        this.schedule(1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStatus run(IProgressMonitor iProgressMonitor) {
        ICopyFileAreaEvent[] iCopyFileAreaEventArray;
        if (System.currentTimeMillis() - this.latestRequest < 1000L) {
            this.schedule(1000L);
            return Status.CANCEL_STATUS;
        }
        MultiStatus multiStatus = new MultiStatus("com.ibm.team.filesystem.client", 0, Messages.CopyFileAreaNotifier_1, null);
        Object[] objectArray = this.listeners.getListeners();
        CopyFileAreaNotifier copyFileAreaNotifier = this;
        synchronized (copyFileAreaNotifier) {
            iCopyFileAreaEventArray = this.collectedEvents.toArray(new ICopyFileAreaEvent[this.collectedEvents.size()]);
            this.collectedEvents.clear();
        }
        if (iCopyFileAreaEventArray.length == 0) {
            return Status.OK_STATUS;
        }
        int n = 0;
        while (n < objectArray.length) {
            ICopyFileAreaListener iCopyFileAreaListener = (ICopyFileAreaListener)objectArray[n];
            SafeRunner.run((ISafeRunnable)new CopyFileAreaNotifier$1(this, multiStatus, iCopyFileAreaListener, iCopyFileAreaEventArray));
            ++n;
        }
        return multiStatus.isOK() ? Status.OK_STATUS : multiStatus;
    }

    public void removeListener(ICopyFileAreaListener iCopyFileAreaListener) {
        this.listeners.remove((Object)iCopyFileAreaListener);
    }
}

