/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal.copyfileareas;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaEvent;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.copyfileareas.BatchingLock;
import com.ibm.team.filesystem.client.internal.copyfileareas.IFlushOperation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;

public class BatchingLock$ThreadInfo {
    private List changes = new ArrayList();
    private IFlushOperation operation;
    private Job job;
    private List rules = new ArrayList();
    final /* synthetic */ BatchingLock this$0;

    public BatchingLock$ThreadInfo(BatchingLock batchingLock, IFlushOperation iFlushOperation) {
        this.this$0 = batchingLock;
        this.operation = iFlushOperation;
    }

    public ISchedulingRule pushRule(ISchedulingRule iSchedulingRule) {
        if (iSchedulingRule != BatchingLock.NULL_SCHEDULING_RULE && iSchedulingRule != BatchingLock.AVOID_NOTIFICATION_RULE) {
            this.addAndCheckRule(iSchedulingRule);
        } else {
            this.addRule(iSchedulingRule);
        }
        return iSchedulingRule;
    }

    public void popRule(ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        try {
            if (this.isFlushRequired()) {
                this.flush(iProgressMonitor);
            }
        }
        finally {
            ISchedulingRule iSchedulingRule2 = this.removeRule();
            if (iSchedulingRule == null) {
                iSchedulingRule = BatchingLock.NULL_SCHEDULING_RULE;
            }
            if (!iSchedulingRule2.equals(iSchedulingRule)) {
                Assert.isTrue((boolean)false, (String)("end for resource '" + iSchedulingRule + "' does not match stacked rule '" + iSchedulingRule2 + "'"));
            }
        }
    }

    public boolean isNested() {
        return !this.rules.isEmpty();
    }

    public void addChange(ICopyFileAreaEvent iCopyFileAreaEvent) {
        this.changes.add(iCopyFileAreaEvent);
    }

    public boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public ICopyFileAreaEvent[] getEvents() {
        return this.changes.toArray(new ICopyFileAreaEvent[this.changes.size()]);
    }

    public void flush(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        try {
            try {
                if (this.operation != null) {
                    this.operation.flush(this, iProgressMonitor);
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw (Throwable)outOfMemoryError;
            }
            catch (Error error) {
                this.handleAbortedFlush(error);
                throw (Throwable)error;
            }
            catch (RuntimeException runtimeException) {
                this.handleAbortedFlush(runtimeException);
                throw (Throwable)runtimeException;
            }
        }
        finally {
            this.changes.clear();
        }
    }

    private boolean isFlushRequired() {
        return this.rules.size() == 1 || this.remainingRulesAreNull();
    }

    private boolean remainingRulesAreNull() {
        int n = 0;
        while (n < this.rules.size() - 1) {
            ISchedulingRule iSchedulingRule = (ISchedulingRule)this.rules.get(n);
            if (iSchedulingRule != BatchingLock.NULL_SCHEDULING_RULE) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void handleAbortedFlush(Throwable throwable) {
        LoggingHelper.error("com.ibm.team.filesystem.client", "Flush aborted", throwable);
    }

    private void addAndCheckRule(ISchedulingRule iSchedulingRule) {
        ISchedulingRule iSchedulingRule2 = null;
        for (ISchedulingRule iSchedulingRule3 : this.rules) {
            if (iSchedulingRule3 == BatchingLock.NULL_SCHEDULING_RULE || iSchedulingRule3 == BatchingLock.AVOID_NOTIFICATION_RULE) continue;
            if (iSchedulingRule3.contains(iSchedulingRule)) break;
            iSchedulingRule2 = iSchedulingRule3;
            break;
        }
        if (iSchedulingRule2 != null) {
            throw (Throwable)new IllegalStateException("The rule " + iSchedulingRule + " is not contained in base rule " + iSchedulingRule2);
        }
        this.addRule(iSchedulingRule);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRule(ISchedulingRule iSchedulingRule) {
        List list = this.rules;
        synchronized (list) {
            this.rules.add(iSchedulingRule);
            this.job = Job.getJobManager().currentJob();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISchedulingRule removeRule() {
        List list = this.rules;
        synchronized (list) {
            this.rules.notifyAll();
            this.job = Job.getJobManager().currentJob();
            return (ISchedulingRule)this.rules.remove(this.rules.size() - 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ruleConflicts(ISchedulingRule iSchedulingRule) {
        List list = this.rules;
        synchronized (list) {
            for (ISchedulingRule iSchedulingRule2 : this.rules) {
                if (iSchedulingRule2 == BatchingLock.NULL_SCHEDULING_RULE || iSchedulingRule2 == BatchingLock.AVOID_NOTIFICATION_RULE) continue;
                if (iSchedulingRule2.getClass() == MultiRule.class) {
                    return iSchedulingRule2.isConflicting(iSchedulingRule);
                }
                return iSchedulingRule.isConflicting(iSchedulingRule2);
            }
            return false;
        }
    }

    static /* synthetic */ List access$0(BatchingLock$ThreadInfo batchingLock$ThreadInfo) {
        return batchingLock$ThreadInfo.rules;
    }

    static /* synthetic */ Job access$1(BatchingLock$ThreadInfo batchingLock$ThreadInfo) {
        return batchingLock$ThreadInfo.job;
    }
}

