/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.ItemHandleHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.SharingMetadata2;
import com.ibm.team.filesystem.client.internal.Store;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.internal.util.MigrationUtil;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;

class SharingMetadata2$MetadataStore
extends Store {
    private static final int METADATA_VERSION = 4;
    private static final int METADATA_VERSION_M5D1 = 5;
    private static final int METADATA_VERSION_M6D1 = 6;
    private static final int METADATA_VERSION_RC1 = 7;
    protected static final int STRING_TAG = 1;
    protected static final int FILE_ITEM_INFO_TAG = 2;
    final /* synthetic */ SharingMetadata2 this$0;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        $assertionsDisabled = !SharingMetadata2.class.desiredAssertionStatus();
    }

    public SharingMetadata2$MetadataStore(SharingMetadata2 sharingMetadata2, File file) {
        this.this$0 = sharingMetadata2;
        super(file, SharingMetadata2.access$0(sharingMetadata2));
    }

    protected long persistStream(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        long l = this.heap.allocate((long)byteArrayOutputStream.size());
        byteArrayOutputStream.writeTo(this.heap.getOutputStream(l));
        return l;
    }

    protected long writeObject(Object object, int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        if (object instanceof StringWrapper) {
            dataOutputStream.write(1);
            dataOutputStream.writeUTF(object.toString());
            return this.persistStream(byteArrayOutputStream);
        }
        FileItemInfo fileItemInfo = (FileItemInfo)object;
        dataOutputStream.write(2);
        dataOutputStream.writeInt(7);
        boolean bl = fileItemInfo.isFolder();
        dataOutputStream.writeBoolean(bl);
        dataOutputStream.writeUTF(ItemHandleHelper.toString((IItemHandle)fileItemInfo.getVersionableHandle()));
        if (!bl) {
            dataOutputStream.writeLong(fileItemInfo.getLastModification());
        }
        boolean bl2 = fileItemInfo.getParent() != null;
        dataOutputStream.writeBoolean(bl2);
        if (bl2) {
            dataOutputStream.writeUTF(fileItemInfo.getParent().getItemId().getUuidValue());
            dataOutputStream.writeUTF(fileItemInfo.getName());
        }
        if (bl) {
            if (!$assertionsDisabled && fileItemInfo.getHash() != null) {
                throw (Throwable)((Object)new AssertionError());
            }
            if (!$assertionsDisabled && fileItemInfo.getLineDelimiter() != null) {
                throw (Throwable)((Object)new AssertionError());
            }
            if (!$assertionsDisabled && fileItemInfo.getOriginalLineDelimiter() != null) {
                throw (Throwable)((Object)new AssertionError());
            }
            if (!$assertionsDisabled && fileItemInfo.getContentType() != null) {
                throw (Throwable)((Object)new AssertionError());
            }
            if (!$assertionsDisabled && fileItemInfo.getOriginalContentType() != null) {
                throw (Throwable)((Object)new AssertionError());
            }
        } else if (!$assertionsDisabled && fileItemInfo.getContentLength() != -1L && fileItemInfo.getHash() == null) {
            throw (Throwable)((Object)new AssertionError());
        }
        HashCode.writeOnto((HashCode)fileItemInfo.getHash(), (DataOutputStream)dataOutputStream);
        dataOutputStream.writeLong(fileItemInfo.getContentLength());
        if (fileItemInfo.getOriginalLineDelimiter() == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeInt(fileItemInfo.getOriginalLineDelimiter().columnValue());
        }
        if (fileItemInfo.getLineDelimiter() == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeInt(fileItemInfo.getLineDelimiter().columnValue());
        }
        if (fileItemInfo.getOriginalContentType() == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(fileItemInfo.getOriginalContentType());
        }
        if (fileItemInfo.getContentType() == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(fileItemInfo.getContentType());
        }
        if (fileItemInfo.getStoredContentId() == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(fileItemInfo.getStoredContentId().getUuidValue());
        }
        if (fileItemInfo.getStoredDeltaPredecessor() == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(fileItemInfo.getStoredDeltaPredecessor().getUuidValue());
        }
        dataOutputStream.writeLong(fileItemInfo.getStoredSize());
        if (fileItemInfo.getStoredEncoding() == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(fileItemInfo.getStoredEncoding());
        }
        dataOutputStream.writeLong(fileItemInfo.getStoredChecksum());
        dataOutputStream.writeLong(fileItemInfo.getStoredNumLineDelimiters());
        if (!bl) {
            dataOutputStream.writeBoolean(fileItemInfo.isExecutable());
            dataOutputStream.writeBoolean(fileItemInfo.isOriginalExecutable());
        }
        return this.persistStream(byteArrayOutputStream);
    }

    protected Object readObject(InputStream inputStream, int n) throws IOException, ClassNotFoundException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n2 = dataInputStream.read();
        switch (n2) {
            case -1: {
                throw (Throwable)new EOFException();
            }
            case 1: {
                return new StringWrapper(dataInputStream.readUTF(), SharingMetadata2.access$1(this.this$0));
            }
            case 2: {
                String string;
                IFolderHandle iFolderHandle;
                int n3 = dataInputStream.readInt();
                if (n3 != 4 && n3 != 5 && n3 != 6 && n3 != 7) {
                    throw (Throwable)new StreamCorruptedException(NLS.bind((String)Messages.SharingMetadata2_0, (Object[])new Object[]{n3, 7}));
                }
                boolean bl = dataInputStream.readBoolean();
                IItemType iItemType = bl ? IFolder.ITEM_TYPE : IFileItem.ITEM_TYPE;
                String string2 = dataInputStream.readUTF();
                IVersionableHandle iVersionableHandle = (IVersionableHandle)ItemHandleHelper.fromString(iItemType, string2);
                long l = bl ? -1L : dataInputStream.readLong();
                boolean bl2 = dataInputStream.readBoolean();
                if (bl2) {
                    string2 = dataInputStream.readUTF();
                    iFolderHandle = (IFolderHandle)ItemHandleHelper.fromString(IFolder.ITEM_TYPE, string2);
                    string = dataInputStream.readUTF();
                } else {
                    iFolderHandle = null;
                    string = null;
                }
                HashCode hashCode = HashCode.readFrom((DataInputStream)dataInputStream);
                long l2 = dataInputStream.readLong();
                LineDelimiter lineDelimiter = null;
                LineDelimiter lineDelimiter2 = null;
                String string3 = null;
                String string4 = null;
                UUID uUID = null;
                UUID uUID2 = null;
                long l3 = -1L;
                String string5 = null;
                long l4 = -1L;
                long l5 = -1L;
                boolean bl3 = false;
                boolean bl4 = false;
                if (n3 != 4) {
                    int n4;
                    boolean bl5 = dataInputStream.readBoolean();
                    if (bl5) {
                        n4 = dataInputStream.readInt();
                        lineDelimiter = LineDelimiter.getLineDelimiter((int)n4);
                    }
                    if (bl5 = dataInputStream.readBoolean()) {
                        n4 = dataInputStream.readInt();
                        lineDelimiter2 = LineDelimiter.getLineDelimiter((int)n4);
                    }
                    if (bl5 = dataInputStream.readBoolean()) {
                        string3 = dataInputStream.readUTF();
                    }
                    if (bl5 = dataInputStream.readBoolean()) {
                        string4 = dataInputStream.readUTF();
                    }
                    if (n3 != 5) {
                        bl5 = dataInputStream.readBoolean();
                        if (bl5) {
                            uUID = UUID.valueOf((String)dataInputStream.readUTF());
                        }
                        if (bl5 = dataInputStream.readBoolean()) {
                            uUID2 = UUID.valueOf((String)dataInputStream.readUTF());
                        }
                        l3 = dataInputStream.readLong();
                        bl5 = dataInputStream.readBoolean();
                        if (bl5) {
                            string5 = dataInputStream.readUTF();
                        }
                        l4 = dataInputStream.readLong();
                        l5 = dataInputStream.readLong();
                        if (n3 != 6 && !bl) {
                            bl3 = dataInputStream.readBoolean();
                            bl4 = dataInputStream.readBoolean();
                        }
                    }
                } else if (!bl && iVersionableHandle.hasStateId()) {
                    string4 = string3 = MigrationUtil.guessContentType((String)string);
                    lineDelimiter = LineDelimiter.LINE_DELIMITER_NONE;
                    lineDelimiter2 = LineDelimiter.LINE_DELIMITER_NONE;
                }
                return new FileItemInfo(iVersionableHandle, l, iFolderHandle, string, hashCode, l2, lineDelimiter, lineDelimiter2, string3, string4, uUID, uUID2, l3, string5, l4, l5, bl3, bl4);
            }
        }
        throw (Throwable)new StreamCorruptedException(String.valueOf(Messages.SharingMetadata2_1) + n2);
    }
}

