/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ICopyFileAreaListener;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocalChangeManager;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.ISharingManager;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.IMetadataChangeTracker;
import com.ibm.team.filesystem.client.internal.ISharingMetadata;
import com.ibm.team.filesystem.client.internal.InstantiationLock;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.RestoreVersionableOperation;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager$$Cold;
import com.ibm.team.filesystem.client.internal.SharingManager$1;
import com.ibm.team.filesystem.client.internal.SharingManager$CoreRunnable;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.copyfileareas.ICorruptCopyFileAreaListener;
import com.ibm.team.filesystem.client.internal.ignore.IIgnoreManager;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.filesystem.client.internal.load.UpdateMutator;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeManager;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemVerifySharesOperation;
import com.ibm.team.filesystem.client.internal.operations.VerifySharesOperation;
import com.ibm.team.filesystem.client.internal.utils.IRunnableWithProgress;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.filesystem.common.internal.dto.FileAreaUpdateReport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class SharingManager
implements ISharingManager {
    public static final UUID UNKNOWN_CONFIGURATION_STATE_UUID = UUID.valueOf((String)"_R9t0ULhfEduBzK-rvZth-A");
    public static final UUID NEW_CONFIGURATION_STATE_UUID = UUID.valueOf((String)"_EHcPcCUoEdyQ476u2X18-Q");
    private static final ThreadLocal changeMonitoring = new SharingManager$1();
    private static SharingManager instance;
    public static final String PT_SHARING_MANAGER = "sharingManager";
    private static final String SCM_PRIVATE = ".jazz3";

    protected SharingManager() {
        instance = this;
    }

    public static ISchedulingRule getSchedulingRule(IShareable iShareable) {
        return CopyFileAreaStore.getSchedulingRule(iShareable);
    }

    public ISchedulingRule getExternalSchedulingRule(IShareable iShareable) {
        return null;
    }

    public IShare[] allShares(IPath iPath) throws FileSystemClientException {
        return this.getAllShares(CopyFileAreaStore.getCopyFileArea(iPath));
    }

    public IShare[] allShares(CopyFileAreaStore copyFileAreaStore) throws FileSystemClientException {
        return this.getAllShares(copyFileAreaStore);
    }

    public IShare[] allShares() throws FileSystemClientException {
        return this.getAllShares(CopyFileAreaStore.getDefaultCopyFileArea());
    }

    protected Share createShare(ISharingDescriptor iSharingDescriptor, IPath iPath, CopyFileAreaStore copyFileAreaStore) {
        return new Share(iSharingDescriptor, iPath, copyFileAreaStore);
    }

    public boolean isShared(IShareable iShareable) {
        return this.getShare(iShareable) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void conditionalShutDown() throws FileSystemClientException {
        SharingManager sharingManager = null;
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            if (instance != null) {
                sharingManager = SharingManager.getInstance();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (sharingManager != null) {
                sharingManager.shutDown();
            }
            return;
        }
    }

    public void addListener(IPath iPath, ICopyFileAreaListener iCopyFileAreaListener) {
        CopyFileAreaStore.getCopyFileArea(iPath).addListener(iCopyFileAreaListener);
    }

    public void addListener(ICopyFileAreaListener iCopyFileAreaListener) {
        CopyFileAreaStore.getDefaultCopyFileArea().addListener(iCopyFileAreaListener);
    }

    public void removeListener(IPath iPath, ICopyFileAreaListener iCopyFileAreaListener) {
        CopyFileAreaStore.getCopyFileArea(iPath).removeListener(iCopyFileAreaListener);
    }

    public void removeListener(ICopyFileAreaListener iCopyFileAreaListener) {
        CopyFileAreaStore.getDefaultCopyFileArea().removeListener(iCopyFileAreaListener);
    }

    public boolean isConnectionShared(IPath iPath, IContextHandle iContextHandle) throws FileSystemClientException {
        return CopyFileAreaStore.getCopyFileArea(iPath).isConnectionShared(iContextHandle);
    }

    public boolean isConnectionShared(IContextHandle iContextHandle) throws FileSystemClientException {
        return CopyFileAreaStore.getDefaultCopyFileArea().isConnectionShared(iContextHandle);
    }

    public IPath getMetadataPathForRoot(IPath iPath) {
        return iPath.append(SCM_PRIVATE);
    }

    public IMetadataChangeTracker getChangeTracker(CopyFileAreaStore copyFileAreaStore) {
        return (IMetadataChangeTracker)((Object)copyFileAreaStore.getMetadata());
    }

    public CopyFileAreaStore findCopyFileArea(IPath iPath) {
        return CopyFileAreaStore.getCopyFileArea(iPath);
    }

    public ILocalChangeManager getLocalChangeManager() {
        return LocalChangeManager.getInstance();
    }

    public boolean shouldIgnore(CopyFileAreaStore copyFileAreaStore, IPath iPath, boolean bl) {
        return false;
    }

    public IPath getDefaultCFARoot() {
        return null;
    }

    public IIgnoreManager getIgnoreManager() {
        return IgnoreManager.getInstance();
    }

    public VerifySharesOperation getVerifySharesOperation(IPath iPath, OutOfSyncDilemmaHandler outOfSyncDilemmaHandler) {
        return new LocalFileSystemVerifySharesOperation(iPath, outOfSyncDilemmaHandler);
    }

    public void addListener(ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener) {
        CopyFileAreaStore.addCorruptionListener(iCorruptCopyFileAreaListener);
    }

    public void removeListener(ICorruptCopyFileAreaListener iCorruptCopyFileAreaListener) {
        CopyFileAreaStore.removeCorruptionListener(iCorruptCopyFileAreaListener);
    }

    public String getMetadataRootName() {
        return SCM_PRIVATE;
    }

    public void runWithinFileSystemLock(IRunnableWithProgress iRunnableWithProgress, IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
        iRunnableWithProgress.run(iProgressMonitor);
    }

    public int getNumShares(IPath iPath, IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return CopyFileAreaStore.getCopyFileArea(iPath).getNumShares(iComponentHandle, iContextHandle, iProgressMonitor);
    }

    public int getNumShares(IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return CopyFileAreaStore.getDefaultCopyFileArea().getNumShares(iComponentHandle, iContextHandle, iProgressMonitor);
    }

    public Collection getShares(IPath iPath, IContextHandle iContextHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return CopyFileAreaStore.getCopyFileArea(iPath).getShares(iContextHandle, iComponentHandle, iProgressMonitor);
    }

    public void restoreFile(IShareable iShareable, InputStream inputStream, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException, IOException {
        RestoreVersionableOperation.restoreFile(iShareable, inputStream, iVersionableHandle, iProgressMonitor);
    }

    public void restoreFolder(IShareable iShareable, IFolderHandle iFolderHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        RestoreVersionableOperation.restoreFolder(iShareable, iFolderHandle, iProgressMonitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharingManager getInstance() {
        Class<InstantiationLock> clazz = InstantiationLock.class;
        synchronized (InstantiationLock.class) {
            if (instance != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
            IConfigurationElement[] iConfigurationElementArray = RegistryFactory.getRegistry().getConfigurationElementsFor("com.ibm.team.filesystem.client", PT_SHARING_MANAGER);
            if (iConfigurationElementArray.length > 1) {
                LoggingHelper.error("com.ibm.team.filesystem.client", "Only one sharing manager implementation can be registered", null);
            } else if (iConfigurationElementArray.length == 1) {
                try {
                    instance = (SharingManager)iConfigurationElementArray[0].createExecutableExtension("class");
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return instance;
                }
                catch (CoreException coreException) {
                    LoggingHelper.log(coreException);
                }
            }
            instance = new SharingManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Share getShare(IShareable iShareable) throws  {
        return SharingManager$$Cold.getShare(this, iShareable);
    }

    public Share getShare(IPath iPath, IPath iPath2) throws  {
        return SharingManager$$Cold.getShare(this, iPath, iPath2);
    }

    public Share getShare(CopyFileAreaStore copyFileAreaStore, String string) throws  {
        return SharingManager$$Cold.getShare(this, copyFileAreaStore, string);
    }

    public FileItemInfo getItemInfo(IShareable iShareable) throws  {
        return SharingManager$$Cold.getItemInfo(this, iShareable);
    }

    public void setItemInfo(IShareable iShareable, FileItemInfo fileItemInfo, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SharingManager$$Cold.setItemInfo(this, iShareable, fileItemInfo, iProgressMonitor);
    }

    public IShare share(Shareable shareable, ISharingDescriptor iSharingDescriptor, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.share(this, shareable, iSharingDescriptor, bl, bl2, iProgressMonitor);
    }

    private IShare[] getAllShares(CopyFileAreaStore copyFileAreaStore) throws FileSystemClientException {
        return SharingManager$$Cold.getAllShares(this, copyFileAreaStore);
    }

    public int getState(IShareable iShareable) throws  {
        return SharingManager$$Cold.getState(this, iShareable);
    }

    public void clear() throws FileSystemClientException {
        SharingManager$$Cold.clear(this);
    }

    public void shutDown() throws FileSystemClientException {
        SharingManager$$Cold.shutDown(this);
    }

    public void forget(IShareable iShareable, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SharingManager$$Cold.forget(this, iShareable, iProgressMonitor);
    }

    public ITeamRepository getRepository(IShare iShare) throws  {
        return SharingManager$$Cold.getRepository(this, iShare);
    }

    public void disableChangeMonitoring() {
        changeMonitoring.set(new Integer((Integer)changeMonitoring.get() + 1));
    }

    public void enableChangeMonitoring() {
        int n = (Integer)changeMonitoring.get();
        if (n == 0) {
            throw (Throwable)new IllegalStateException();
        }
        changeMonitoring.set(new Integer(n - 1));
    }

    public boolean isChangeMonitoringEnabled() {
        return (Integer)changeMonitoring.get() == 0;
    }

    public ISharingMetadata createSharingMetadata(IPath iPath) throws  {
        return SharingManager$$Cold.createSharingMetadata(this, iPath);
    }

    public ILocalChange getChange(Shareable shareable) throws  {
        return SharingManager$$Cold.getChange(this, shareable);
    }

    public final void doSilentChange(SharingManager$CoreRunnable sharingManager$CoreRunnable) throws CoreException {
        SharingManager$$Cold.doSilentChange(this, sharingManager$CoreRunnable);
    }

    public List findShareables(IPath iPath, IVersionableHandle iVersionableHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.findShareables(this, iPath, iVersionableHandle, iProgressMonitor);
    }

    public List findShareables(IPath iPath, IVersionableHandle iVersionableHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.findShareables(this, iPath, iVersionableHandle, iContextHandle, iProgressMonitor);
    }

    public List findShareables(IPath iPath, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.findShareables(this, iPath, iVersionableHandle, iComponentHandle, iProgressMonitor);
    }

    protected List getShareablesForPaths(IPath iPath, Collection collection) throws  {
        return SharingManager$$Cold.getShareablesForPaths(this, iPath, collection);
    }

    public IShareable findShareable(IPath iPath, IPath iPath2, boolean bl) throws  {
        return SharingManager$$Cold.findShareable(this, iPath, iPath2, bl);
    }

    public IShareable findShareable(IPath iPath, IVersionableHandle iVersionableHandle, IComponentHandle iComponentHandle, IContextHandle iContextHandle, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.findShareable(this, iPath, iVersionableHandle, iComponentHandle, iContextHandle, iProgressMonitor);
    }

    public UpdateMutator getUpdateMutator(IConnection iConnection, Collection collection, Collection collection2, FileAreaUpdateReport fileAreaUpdateReport, IPath iPath) throws TeamRepositoryException {
        return SharingManager$$Cold.getUpdateMutator(this, iConnection, collection, collection2, fileAreaUpdateReport, iPath);
    }

    public List getRootShareables(IPath iPath) throws  {
        return SharingManager$$Cold.getRootShareables(this, iPath);
    }

    public ISchedulingRule getTrackingRule(IPath iPath) throws  {
        return SharingManager$$Cold.getTrackingRule(this, iPath);
    }

    public List getPathRelativeToShares(IPath iPath, IContextHandle iContextHandle, IComponentHandle iComponentHandle, List list, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager$$Cold.getPathRelativeToShares(this, iPath, iContextHandle, iComponentHandle, list, iProgressMonitor);
    }
}

