/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IShareableVisitor;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable$1;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.ignore.IgnoreManager;
import com.ibm.team.repository.common.LineDelimiter;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public abstract class Shareable
implements IShareable {
    public IShare getShare() {
        return SharingManager.getInstance().getShare(this);
    }

    public int getState() {
        return SharingManager.getInstance().getState(this);
    }

    public boolean isLocallyModified() {
        return (this.getState() & 4) != 0;
    }

    public final IShare share(ISharingDescriptor iSharingDescriptor, boolean bl, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return this.share(iSharingDescriptor, bl, true, iProgressMonitor);
    }

    public IShare share(ISharingDescriptor iSharingDescriptor, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        return SharingManager.getInstance().share(this, iSharingDescriptor, bl, bl2, iProgressMonitor);
    }

    public IVersionableHandle getRemote() {
        FileItemInfo fileItemInfo = SharingManager.getInstance().getItemInfo(this);
        return fileItemInfo != null && fileItemInfo.getVersionableHandle().hasStateId() && fileItemInfo.isFolder() == this.getFileStorage().isFolder() ? fileItemInfo.getVersionableHandle() : null;
    }

    public IVersionableHandle getVersionable() {
        FileItemInfo fileItemInfo = SharingManager.getInstance().getItemInfo(this);
        return fileItemInfo != null && fileItemInfo.isFolder() == this.getFileStorage().isFolder() ? fileItemInfo.getVersionableHandle() : null;
    }

    public void accept(IShareableVisitor iShareableVisitor, int n, boolean bl, boolean bl2, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.accept(iShareableVisitor, n, bl, bl2 ? this.getRule() : null, iProgressMonitor);
    }

    public void accept(IShareableVisitor iShareableVisitor, int n, boolean bl, ISchedulingRule iSchedulingRule, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        IShare iShare = this.getShare();
        if (iShare == null) {
            if (iProgressMonitor != null) {
                iProgressMonitor.beginTask("", 1);
                iProgressMonitor.done();
            }
            return;
        }
        FileSystemClientException[] fileSystemClientExceptionArray = new FileSystemClientException[1];
        Shareable$1 shareable$1 = new Shareable$1(this, bl, iShareableVisitor, n, fileSystemClientExceptionArray);
        CopyFileAreaStore.getCopyFileArea(this.getRoot()).accept(shareable$1, this, iSchedulingRule, n, iProgressMonitor);
        if (fileSystemClientExceptionArray[0] != null) {
            throw (Throwable)((Object)fileSystemClientExceptionArray[0]);
        }
    }

    public abstract IFileStorage getFileStorage();

    public void forget(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SharingManager.getInstance().forget(this, iProgressMonitor);
    }

    public void unshare(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        Share share = SharingManager.getInstance().getShare(this);
        if (share == null) {
            return;
        }
        if (!share.getPath().equals((Object)this.getLocalFullPath())) {
            throw (Throwable)new IllegalStateException("Only the root of the share can be unshared");
        }
        SharingManager.getInstance().forget(this, iProgressMonitor);
    }

    public abstract Shareable getShareableFor(IPath var1, boolean var2);

    public abstract void visit(IShareableVisitor var1, int var2, IProgressMonitor var3) throws FileSystemClientException;

    public Shareable getParent() {
        IPath iPath = this.getLocalFullPath().removeLastSegments(1);
        if (iPath.isRoot()) {
            return null;
        }
        return this.getShareableFor(iPath, true);
    }

    public boolean shouldBeIgnored() {
        return IgnoreManager.getInstance().shouldBeIgnored(this);
    }

    public boolean shouldBeIgnoredLocally() {
        return false;
    }

    public abstract boolean isLocal();

    public ILocalChange getChange() {
        return SharingManager.getInstance().getChange(this);
    }

    public ISchedulingRule getRule() {
        return SharingManager.getSchedulingRule(this);
    }

    public void manage(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
    }

    public boolean isManaged(IProgressMonitor iProgressMonitor) {
        return false;
    }

    public LineDelimiter getLineDelimiter() {
        FileItemInfo fileItemInfo = SharingManager.getInstance().getItemInfo(this);
        if (fileItemInfo != null) {
            return fileItemInfo.getLineDelimiter();
        }
        return LineDelimiter.LINE_DELIMITER_NONE;
    }

    public String getContentType() {
        FileItemInfo fileItemInfo = SharingManager.getInstance().getItemInfo(this);
        if (fileItemInfo != null) {
            return fileItemInfo.getContentType();
        }
        return null;
    }

    public LineDelimiter getOriginalLineDelimiter() {
        FileItemInfo fileItemInfo = SharingManager.getInstance().getItemInfo(this);
        if (fileItemInfo != null) {
            return fileItemInfo.getOriginalLineDelimiter();
        }
        return LineDelimiter.LINE_DELIMITER_NONE;
    }

    public String getOriginalContentType() {
        FileItemInfo fileItemInfo = SharingManager.getInstance().getItemInfo(this);
        if (fileItemInfo != null) {
            return fileItemInfo.getOriginalContentType();
        }
        return null;
    }

    public boolean isExecutable() {
        return this.getFileStorage().isExecutable();
    }
}

