/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.internal.ChangeTrackingOutputStream;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileSystem;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.filesystem.client.internal.StringWrapper;
import com.ibm.team.filesystem.client.internal.copyfileareas.CopyFileAreaStore;
import com.ibm.team.filesystem.client.internal.localchanges.LocalChangeTracker;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;

public class ManagedFileStore
extends FileStore {
    private final IFileStore baseStore;
    private final IPath cfaPath;
    private final IPath sharePath;

    protected void addDatelessTouchedItem(IVersionableHandle item, IComponentHandle component, IContextHandle connection) {
        this.getTracker().registerDatelessVersionable(this.baseStore.fetchInfo().getLastModified(), item, component, connection);
    }

    public ManagedFileStore(IPath cfaPath, IPath sharePath, IFileStore baseStore) {
        this.cfaPath = cfaPath;
        this.baseStore = baseStore;
        this.sharePath = sharePath;
    }

    private Share getShare() {
        return SharingManager.getInstance().getShare(this.cfaPath, this.sharePath);
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IFileInfo[] iFileInfoArray = this.childInfosInternal(false, options, (IProgressMonitor)progress.newChild(100));
            return iFileInfoArray;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    private static void done(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.done();
        }
    }

    private boolean trackingChanges() {
        return SharingManager.getInstance().isChangeMonitoringEnabled() && !FileSystemCore.isShutDown();
    }

    private IFileInfo[] childInfosInternal(boolean isNested, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IFileInfo[] infos = this.baseStore.childInfos(options, (IProgressMonitor)progress.newChild(45));
        try {
            if (!this.trackingChanges()) {
                return infos;
            }
            Share share = this.getShare();
            if (share == null) {
                return infos;
            }
            if (!this.fetchInfoInternal(true, 0, (IProgressMonitor)progress.newChild(5)).isDirectory()) {
                return infos;
            }
            CopyFileAreaStore cfa = share.getCopyFileArea();
            if (SharingManager.getInstance().shouldIgnore(cfa, this.sharePath, true)) {
                this.getTracker().cancelChanges(share.getShareable(this.sharePath, true));
                return infos;
            }
            Map children = cfa.getChildInfos(share.getShareable(this.sharePath, true), (IProgressMonitor)progress.newChild(35));
            boolean isCaseSensitive = cfa.isCaseSensitive();
            ArrayList<IFileInfo> additions = new ArrayList<IFileInfo>();
            SubMonitor comparisonMonitor = progress.newChild(10);
            comparisonMonitor.beginTask(Messages.ManagedFileStore_0, infos.length);
            int i = 0;
            while (i < infos.length) {
                SubMonitor iterationProgress = comparisonMonitor.newChild(1);
                if (SharingManager.getInstance().shouldIgnore(cfa, this.sharePath.append(infos[i].getName()), infos[i].isDirectory())) {
                    this.getTracker().cancelChanges(share.getShareable(this.sharePath.append(infos[i].getName()), infos[i].isDirectory()));
                } else {
                    FileItemInfo fileItemInfo = (FileItemInfo)children.remove(new StringWrapper(infos[i].getName(), isCaseSensitive));
                    if (fileItemInfo == null) {
                        additions.add(infos[i]);
                    } else if (fileItemInfo.isFolder() != infos[i].isDirectory()) {
                        additions.add(infos[i]);
                        children.put(new StringWrapper(infos[i].getName(), isCaseSensitive), fileItemInfo);
                    } else if (!fileItemInfo.isFolder()) {
                        IPath childPath = this.sharePath.append(infos[i].getName());
                        Shareable shareable = (Shareable)share.getShareable(childPath, false);
                        if (((ManagedFileStore)this.getChild(infos[i].getName())).contentChanged(infos[i], share, shareable, iterationProgress)) {
                            this.getTracker().trackFileChange(childPath, (IFileItemHandle)fileItemInfo.getVersionableHandle(), shareable);
                        }
                    }
                }
                ++i;
            }
            if (!additions.isEmpty() || !children.isEmpty()) {
                IPath childPath;
                IFolderHandle item = (IFolderHandle)this.getVersionableHandle(this.sharePath);
                if (item == null && this.sharePath.segmentCount() > 1) {
                    ((ManagedFileStore)this.getParent()).childInfosInternal(true, options, (IProgressMonitor)progress.newChild(5));
                    item = (IFolderHandle)this.getVersionableHandle(this.sharePath);
                }
                progress.setWorkRemaining(10);
                SubMonitor subProgress = progress.newChild(5);
                subProgress.setWorkRemaining(children.size());
                for (Map.Entry entry : children.entrySet()) {
                    childPath = this.sharePath.append(((StringWrapper)entry.getKey()).toString());
                    if (SharingManager.getInstance().shouldIgnore(cfa, childPath, ((FileItemInfo)entry.getValue()).isFolder())) {
                        this.getTracker().cancelChanges(share.getShareable(childPath, ((FileItemInfo)entry.getValue()).isFolder()));
                        continue;
                    }
                    if (((FileItemInfo)entry.getValue()).isFolder()) {
                        this.getTracker().trackFolderDeletion(childPath, (IFolderHandle)((FileItemInfo)entry.getValue()).getVersionableHandle(), item, share.getShareable(childPath, true));
                    } else {
                        this.getTracker().trackFileDeletion(childPath, (IFileItemHandle)((FileItemInfo)entry.getValue()).getVersionableHandle(), item, share.getShareable(childPath, false));
                    }
                    cfa.deleteTreeInfo(share.getShareable(childPath, ((FileItemInfo)entry.getValue()).isFolder()), false, (IProgressMonitor)subProgress.newChild(1));
                }
                subProgress = progress.newChild(5);
                subProgress.setWorkRemaining(additions.size());
                for (IFileInfo iFileInfo : additions) {
                    childPath = this.sharePath.append(iFileInfo.getName());
                    if (iFileInfo.isDirectory()) {
                        this.getTracker().trackFolderAddition(childPath, item, share.getShareable(childPath, true), (IProgressMonitor)subProgress.newChild(1));
                        continue;
                    }
                    this.getTracker().trackFileAddition(childPath, item, share.getShareable(childPath, false), (IProgressMonitor)subProgress.newChild(1));
                }
            }
        }
        catch (RuntimeException e) {
            if (!isNested) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(e));
            }
            throw e;
        }
        catch (CoreException e) {
            if (!isNested) {
                LoggingHelper.log(FileSystemStatus.getStatusFor(e));
            }
            throw e;
        }
        return infos;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        return this.childNamesInternal(false, options, monitor);
    }

    public String[] childNamesInternal(boolean isNested, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (!this.trackingChanges()) {
                String[] stringArray = this.baseStore.childNames(options, (IProgressMonitor)progress.newChild(100));
                return stringArray;
            }
            IFileInfo[] childInfos = this.childInfosInternal(isNested, options, (IProgressMonitor)progress.newChild(100));
            String[] names = new String[childInfos.length];
            int i = childInfos.length - 1;
            while (i >= 0) {
                names[i] = childInfos[i].getName();
                --i;
            }
            String[] stringArray = names;
            return stringArray;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    public IFileStore[] childStores(int options, IProgressMonitor monitor) throws CoreException {
        return this.childStoresInternal(false, options, monitor);
    }

    public ManagedFileStore[] childStoresInternal(boolean isNested, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            String[] childNames = this.childNamesInternal(isNested, options, (IProgressMonitor)progress.newChild(100));
            ManagedFileStore[] childStores = new ManagedFileStore[childNames.length];
            int i = childStores.length - 1;
            while (i >= 0) {
                childStores[i] = new ManagedFileStore(this.cfaPath, this.sharePath.append(childNames[i]), this.baseStore.getChild(childNames[i]));
                --i;
            }
            ManagedFileStore[] managedFileStoreArray = childStores;
            return managedFileStoreArray;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    public void copy(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        this.baseStore.copy(destination, options, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        try {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            if (!this.trackingChanges()) {
                this.baseStore.delete(options, (IProgressMonitor)progress.newChild(100));
                return;
            }
            IFileInfo info = this.fetchInfoInternal(true, 0, (IProgressMonitor)progress.newChild(5));
            this.baseStore.delete(options, (IProgressMonitor)progress.newChild(70));
            Share share = this.getShare();
            if (share == null) {
                return;
            }
            CopyFileAreaStore cfa = share.getCopyFileArea();
            if (SharingManager.getInstance().shouldIgnore(cfa, this.sharePath, info.isDirectory())) {
                this.getTracker().cancelChanges(share.getShareable(this.sharePath, info.isDirectory()));
                return;
            }
            if (this.sharePath.segmentCount() == 1) {
                return;
            }
            if (!info.exists()) {
                return;
            }
            if (info.isDirectory()) {
                this.getTracker().trackFolderDeletion(this.sharePath, (IFolderHandle)this.getVersionableHandle(this.sharePath), (IFolderHandle)this.getVersionableHandle(this.sharePath.removeLastSegments(1)), share.getShareable(this.sharePath, true));
            } else {
                this.getTracker().trackFileDeletion(this.sharePath, (IFileItemHandle)this.getVersionableHandle(this.sharePath), (IFolderHandle)this.getVersionableHandle(this.sharePath.removeLastSegments(1)), share.getShareable(this.sharePath, false));
            }
            cfa.deleteTreeInfo(share.getShareable(this.sharePath, info.isDirectory()), false, (IProgressMonitor)progress.newChild(25));
            return;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        return this.fetchInfoInternal(false, options, monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IFileInfo fetchInfoInternal(boolean isNested, int options, IProgressMonitor monitor) throws CoreException {
        try {
            Share share;
            IFileInfo info;
            SubMonitor progress;
            block16: {
                block15: {
                    block14: {
                        block13: {
                            progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                            info = this.baseStore.fetchInfo(options, (IProgressMonitor)progress.newChild(70));
                            if (this.trackingChanges()) break block13;
                            IFileInfo iFileInfo = info;
                            ManagedFileStore.done(monitor);
                            return iFileInfo;
                        }
                        share = this.getShare();
                        if (share != null) break block14;
                        IFileInfo iFileInfo = info;
                        ManagedFileStore.done(monitor);
                        return iFileInfo;
                    }
                    if (!SharingManager.getInstance().shouldIgnore(share.getCopyFileArea(), this.sharePath, true)) break block15;
                    this.getTracker().cancelChanges(share.getShareable(this.sharePath, false));
                    IFileInfo iFileInfo = info;
                    ManagedFileStore.done(monitor);
                    return iFileInfo;
                }
                IVersionableHandle item = this.getVersionableHandle(this.sharePath);
                if (this.sharePath.segmentCount() > 1 && (info.exists() != (item != null) || info.exists() && info.isDirectory() != item instanceof IFolderHandle)) {
                    ((ManagedFileStore)this.getParent()).childInfosInternal(true, 0, (IProgressMonitor)progress.newChild(15));
                    item = this.getVersionableHandle(this.sharePath);
                }
                if (info.exists() && !info.isDirectory()) break block16;
                IFileInfo iFileInfo = info;
                ManagedFileStore.done(monitor);
                return iFileInfo;
            }
            try {
                Shareable shareable = (Shareable)share.getShareable(this.sharePath, false);
                progress.setWorkRemaining(15);
                if (this.contentChanged(info, share, shareable, progress.newChild(15))) {
                    this.getTracker().trackFileChange(this.sharePath, (IFileItemHandle)this.getVersionableHandle(this.sharePath), shareable);
                }
            }
            catch (RuntimeException e) {
                if (isNested) throw e;
                LoggingHelper.log(FileSystemStatus.getStatusFor(e));
            }
            catch (CoreException e) {
                if (isNested) throw e;
                LoggingHelper.log(FileSystemStatus.getStatusFor(e));
            }
            IFileInfo iFileInfo = info;
            return iFileInfo;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    private boolean contentChanged(IFileInfo info, Share share, Shareable shareable, SubMonitor progress) throws CoreException {
        HashCode newHash;
        FileItemInfo oldInfo = SharingManager.getInstance().getItemInfo(shareable);
        IFileStorage storage = shareable.getFileStorage();
        if (oldInfo == null || oldInfo.getHash() == null || info.getLength() != oldInfo.getContentLength()) {
            return true;
        }
        if (storage.supportsExecBit() ? info.getAttribute(4) != oldInfo.isOriginalExecutable() : oldInfo.isOriginalExecutable() != oldInfo.isExecutable()) {
            return true;
        }
        if (!storage.isModified(info.getLastModified())) {
            return false;
        }
        IVersionableHandle item = shareable.getVersionable();
        IComponentHandle component = share.getSharingDescriptor().getComponent();
        IContextHandle connection = share.getSharingDescriptor().getConnectionHandle();
        if (this.getTracker().containsDatelessVersionable(info.getLastModified(), item, component, connection)) {
            return false;
        }
        progress.beginTask(Messages.ManagedFileStore_1, 100);
        try {
            newHash = HashCode.createHashCode((InputStream)this.openInputStream(0, (IProgressMonitor)progress.newChild(50)));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_2, (Throwable)e));
        }
        boolean isSame = newHash.equals((Object)oldInfo.getHash());
        if (isSame) {
            this.addDatelessTouchedItem(item, component, connection);
        } else {
            this.getTracker().deregisterDatelessVersionable(item, component, connection);
        }
        return !isSame;
    }

    public IFileStore getChild(IPath path) {
        return new ManagedFileStore(this.cfaPath, this.sharePath.append(path), this.baseStore.getChild(path));
    }

    public IFileStore getChild(String name) {
        return new ManagedFileStore(this.cfaPath, this.sharePath.append(name), this.baseStore.getChild(name));
    }

    public IFileSystem getFileSystem() {
        return ManagedFileSystem.getInstance();
    }

    public String getName() {
        return this.baseStore.getName();
    }

    public IFileStore getParent() {
        IFileStore baseParent = this.baseStore.getParent();
        if (baseParent == null) {
            return null;
        }
        return this.sharePath.segmentCount() == 1 ? baseParent : new ManagedFileStore(this.cfaPath, this.sharePath.removeLastSegments(1), baseParent);
    }

    public boolean isParentOf(IFileStore other) {
        if (!(other instanceof ManagedFileStore)) {
            return false;
        }
        ManagedFileStore otherStore = (ManagedFileStore)other;
        return this.cfaPath.equals((Object)otherStore.cfaPath) && this.sharePath.isPrefixOf(otherStore.sharePath) && this.baseStore.isParentOf(otherStore.baseStore);
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            boolean deep;
            if (!this.trackingChanges()) {
                this.baseStore.mkdir(options, (IProgressMonitor)progress.newChild(100));
                ManagedFileStore managedFileStore = this;
                return managedFileStore;
            }
            boolean exists = this.fetchInfoInternal(true, 0, (IProgressMonitor)progress.newChild(5)).isDirectory();
            if (exists) {
                ManagedFileStore managedFileStore = this;
                return managedFileStore;
            }
            boolean bl = deep = (options & 4) == 0;
            if (deep) {
                int segments = this.sharePath.segmentCount();
                if (segments == 1) {
                    this.baseStore.mkdir(options, (IProgressMonitor)progress.newChild(70));
                } else {
                    SubMonitor subProgress = progress.newChild(70);
                    subProgress.setWorkRemaining(segments);
                    IFileStore parent = this.getParent();
                    if (parent != null) {
                        parent.mkdir(options, (IProgressMonitor)subProgress.newChild(segments - 1));
                    }
                    subProgress.setWorkRemaining(1);
                    this.baseStore.mkdir(options | 4, (IProgressMonitor)subProgress.newChild(1));
                }
            } else {
                this.baseStore.mkdir(options, (IProgressMonitor)progress.newChild(70));
            }
            Share share = this.getShare();
            if (share == null) {
                ManagedFileStore managedFileStore = this;
                return managedFileStore;
            }
            if (SharingManager.getInstance().shouldIgnore(share.getCopyFileArea(), this.sharePath, true)) {
                this.getTracker().cancelChanges(share.getShareable(this.sharePath, true));
                ManagedFileStore managedFileStore = this;
                return managedFileStore;
            }
            if (this.sharePath.segmentCount() == 1) {
                ManagedFileStore managedFileStore = this;
                return managedFileStore;
            }
            this.getTracker().trackFolderAddition(this.sharePath, (IFolderHandle)this.getVersionableHandle(this.sharePath.removeLastSegments(1)), share.getShareable(this.sharePath, true), (IProgressMonitor)progress.newChild(25));
            ManagedFileStore managedFileStore = this;
            return managedFileStore;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            ManagedFileStore managedDestination = null;
            if (destination instanceof ManagedFileStore) {
                managedDestination = (ManagedFileStore)destination;
                destination = managedDestination.baseStore;
            }
            if (!this.trackingChanges()) {
                this.baseStore.move(destination, options, (IProgressMonitor)progress.newChild(100));
                return;
            }
            if (managedDestination != null) {
                managedDestination.fetchInfoInternal(true, 0, (IProgressMonitor)progress.newChild(5));
            }
            progress.setWorkRemaining(100);
            IFileInfo info = this.fetchInfoInternal(true, 0, (IProgressMonitor)progress.newChild(5));
            if (!this.baseStore.toURI().equals(destination.toURI())) {
                this.baseStore.move(destination, options & 0xFFFFFFFD, (IProgressMonitor)progress.newChild(50));
            }
            progress.setWorkRemaining(45);
            Share share = this.getShare();
            Share otherShare = null;
            if (managedDestination != null && (otherShare = managedDestination.getShare()) != null && share != null && otherShare.getAnchor().equals((Object)share.getAnchor()) && otherShare.getSharingDescriptor().getConnectionHandle().sameItemId((IItemHandle)share.getSharingDescriptor().getConnectionHandle()) && otherShare.getSharingDescriptor().getComponent().sameItemId((IItemHandle)share.getSharingDescriptor().getComponent())) {
                otherShare = share;
            }
            boolean moveShare = managedDestination != null && share != null && share.getPath().makeAbsolute().equals((Object)this.sharePath.makeAbsolute());
            boolean ignoreDestination = true;
            if (otherShare != null) {
                ignoreDestination = SharingManager.getInstance().shouldIgnore(otherShare.getCopyFileArea(), managedDestination.sharePath, info.isDirectory());
            }
            boolean ignoreSource = true;
            boolean shouldRefreshDestination = false;
            if (share != null && (ignoreSource = SharingManager.getInstance().shouldIgnore(share.getCopyFileArea(), this.sharePath, info.isDirectory()))) {
                share = null;
                if (!ignoreDestination) {
                    shouldRefreshDestination = true;
                }
            }
            if (otherShare != null && ignoreDestination) {
                CopyFileAreaStore cfa;
                FileItemInfo sourceInfo;
                if (share != null && (sourceInfo = (cfa = share.getCopyFileArea()).getItemInfo(this.getSharePath())) != null && sourceInfo.getVersionableHandle() != null) {
                    progress.setWorkRemaining(50);
                    managedDestination.getTracker().cancelChanges(otherShare.getShareable(managedDestination.sharePath, info.isDirectory()));
                }
                otherShare = null;
            }
            if (otherShare == share) {
                if (share != null && !managedDestination.sharePath.equals((Object)this.sharePath)) {
                    this.getTracker().trackMove(this.sharePath, managedDestination.sharePath, this.getVersionableHandle(this.sharePath), (IFolderHandle)this.getVersionableHandle(this.sharePath.removeLastSegments(1)), (IFolderHandle)managedDestination.getVersionableHandle(managedDestination.sharePath.removeLastSegments(1)), share.getShareable(this.sharePath, info.isDirectory()));
                    share.getCopyFileArea().moveTreeInfo(share.getShareable(this.sharePath, info.isDirectory()), share.getShareable(managedDestination.sharePath, info.isDirectory()), false, (IProgressMonitor)progress.newChild(45));
                }
            } else if (moveShare) {
                if (!managedDestination.sharePath.equals((Object)this.sharePath)) {
                    share.getCopyFileArea().moveSharingInfo(this.sharePath, managedDestination.getSharePath(), (IProgressMonitor)progress.newChild(45));
                }
            } else {
                if (share != null) {
                    if (info.isDirectory()) {
                        this.getTracker().trackFolderDeletion(this.sharePath, (IFolderHandle)this.getVersionableHandle(this.sharePath), (IFolderHandle)this.getVersionableHandle(this.sharePath.removeLastSegments(1)), share.getShareable(this.sharePath, true));
                    } else {
                        this.getTracker().trackFileDeletion(this.sharePath, (IFileItemHandle)this.getVersionableHandle(this.sharePath), (IFolderHandle)this.getVersionableHandle(this.sharePath.removeLastSegments(1)), share.getShareable(this.sharePath, false));
                    }
                    share.getCopyFileArea().deleteTreeInfo(share.getShareable(this.sharePath, info.isDirectory()), false, (IProgressMonitor)progress.newChild(25));
                }
                if (otherShare != null) {
                    ArrayList<ManagedFileStore> stores = new ArrayList<ManagedFileStore>();
                    stores.add(managedDestination);
                    while (!stores.isEmpty()) {
                        progress.setWorkRemaining(stores.size() + 3);
                        ManagedFileStore store = (ManagedFileStore)((Object)stores.remove(stores.size() - 1));
                        IPath path = store.getSharePath();
                        info = store.fetchInfoInternal(true, 0, (IProgressMonitor)progress.newChild(1));
                        if (info.isDirectory()) {
                            managedDestination.getTracker().trackFolderAddition(path, (IFolderHandle)managedDestination.getVersionableHandle(path.removeLastSegments(1)), otherShare.getShareable(path, true), (IProgressMonitor)progress.newChild(1));
                            ManagedFileStore[] children = store.childStoresInternal(true, 0, (IProgressMonitor)progress.newChild(1));
                            int i = children.length - 1;
                            while (i >= 0) {
                                stores.add(children[i]);
                                --i;
                            }
                            continue;
                        }
                        managedDestination.getTracker().trackFileAddition(path, (IFolderHandle)managedDestination.getVersionableHandle(path.removeLastSegments(1)), otherShare.getShareable(path, false), (IProgressMonitor)progress.newChild(1));
                    }
                }
            }
            if (shouldRefreshDestination) {
                progress.setWorkRemaining(5);
                this.refreshSubtree(managedDestination, (IProgressMonitor)progress.newChild(5));
            }
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    private void accept(IManagedFileStoreVisitor visitor, IProgressMonitor mon) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        try {
            try {
                LinkedList<ManagedFileStore> toVisit = new LinkedList<ManagedFileStore>();
                toVisit.add(this);
                this.fetchInfo();
                while (!toVisit.isEmpty()) {
                    ManagedFileStore current = (ManagedFileStore)((Object)toVisit.remove(0));
                    boolean recurse = visitor.visit(current, (IProgressMonitor)progress.newChild(1));
                    if (recurse) {
                        ManagedFileStore[] stores;
                        ManagedFileStore[] managedFileStoreArray = stores = current.childStoresInternal(true, 0, null);
                        int n = stores.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ManagedFileStore store = managedFileStoreArray[n2];
                            toVisit.add(store);
                            ++n2;
                        }
                    }
                    progress.setWorkRemaining(toVisit.size() * 2);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                progress.done();
            }
        }
        finally {
            progress.done();
        }
    }

    private void refreshSubtree(ManagedFileStore root, IProgressMonitor mon) throws CoreException {
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)mon, (int)100);
        subProgress.setTaskName(Messages.ManagedFileStore_3);
        try {
            try {
                root.accept(new IManagedFileStoreVisitor(){

                    public boolean visit(ManagedFileStore store, IProgressMonitor mon) {
                        return true;
                    }
                }, (IProgressMonitor)subProgress.newChild(100));
            }
            catch (FileSystemClientException e) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.team.filesystem.client", Messages.ManagedFileStore_4, (Throwable)((Object)e)));
            }
        }
        finally {
            subProgress.done();
        }
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        return this.baseStore.openInputStream(options, monitor);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            if (!this.trackingChanges()) {
                OutputStream outputStream = this.baseStore.openOutputStream(options, (IProgressMonitor)progress.newChild(100));
                return outputStream;
            }
            boolean existing = this.fetchInfoInternal(true, 0, (IProgressMonitor)progress.newChild(5)).exists();
            Object result = this.baseStore.openOutputStream(options, (IProgressMonitor)progress.newChild(70));
            Share share = this.getShare();
            if (share == null) {
                OutputStream outputStream = result;
                return outputStream;
            }
            if (SharingManager.getInstance().shouldIgnore(share.getCopyFileArea(), this.sharePath, false)) {
                this.getTracker().cancelChanges(share.getShareable(this.sharePath, false));
                OutputStream outputStream = result;
                return outputStream;
            }
            if (existing) {
                FileItemInfo info = SharingManager.getInstance().getItemInfo(share.getShareable(this.sharePath, false));
                HashCode targetHash = info.getHash();
                if (info.getVersionableHandle().hasStateId()) {
                    result = new ChangeTrackingOutputStream((OutputStream)result, this, (IFileItemHandle)info.getVersionableHandle(), share, targetHash);
                } else {
                    this.getTracker().trackFileChange(this.sharePath, (IFileItemHandle)this.getVersionableHandle(this.sharePath), share.getShareable(this.sharePath, false));
                }
            } else {
                this.getTracker().trackFileAddition(this.sharePath, (IFolderHandle)this.getVersionableHandle(this.sharePath.removeLastSegments(1)), share.getShareable(this.sharePath, false), (IProgressMonitor)progress.newChild(25));
            }
            OutputStream outputStream = result;
            return outputStream;
        }
        finally {
            ManagedFileStore.done(monitor);
        }
    }

    public void putInfo(IFileInfo info, int options, IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean needRefresh = (options & 0x400) != 0 && this.trackingChanges();
        this.baseStore.putInfo(info, options, (IProgressMonitor)progress.newChild(needRefresh ? 50 : 100));
        if (needRefresh) {
            this.fetchInfo(0, (IProgressMonitor)progress.newChild(50));
        }
    }

    public URI toURI() {
        return ManagedFileSystem.getCanonicalManagedURI(this.cfaPath, this.sharePath, this.baseStore.toURI());
    }

    public IFileStore getBaseStore() {
        return this.baseStore;
    }

    public IPath getSharePath() {
        return this.sharePath;
    }

    public File toLocalFile(int options, IProgressMonitor monitor) throws CoreException {
        return this.baseStore.toLocalFile(options, monitor);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ManagedFileStore)) {
            return false;
        }
        ManagedFileStore store = (ManagedFileStore)((Object)obj);
        return this.cfaPath.equals((Object)store.cfaPath) && store.sharePath.equals((Object)this.sharePath) && store.baseStore.equals(this.baseStore);
    }

    public String toString() {
        return this.baseStore.toString();
    }

    public int hashCode() {
        return this.sharePath.toString().hashCode();
    }

    private LocalChangeTracker getTracker() {
        Share share = this.getShare();
        return share == null ? null : share.getTracker();
    }

    private IVersionableHandle getVersionableHandle(IPath path) {
        Share share = this.getShare();
        if (share == null) {
            return null;
        }
        FileItemInfo info = share.getCopyFileArea().getItemInfo(path);
        return info == null ? null : info.getVersionableHandle();
    }

    private static interface IManagedFileStoreVisitor {
        public boolean visit(ManagedFileStore var1, IProgressMonitor var2);
    }
}

