/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.LockableMap$1;
import com.ibm.team.filesystem.client.internal.ReadWriteLock;
import com.ibm.team.filesystem.client.internal.Store;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

public abstract class LockableMap {
    protected Store entries;
    private Map entriesProxy;
    private IPath path;
    private ReadWriteLock mapLock = new ReadWriteLock();

    public LockableMap(IPath iPath, File file) {
        this.path = iPath;
        this.init(file);
    }

    protected void init(File file) {
        if (file.exists()) {
            this.initEntries();
        }
        this.entriesProxy = new LockableMap$1(this);
    }

    protected abstract void initEntries();

    public Map entries() {
        return this.entriesProxy;
    }

    public void acquire(boolean bl) {
        if (bl) {
            this.mapLock.acquireWrite();
        } else {
            this.mapLock.acquireRead();
        }
    }

    public boolean release() throws FileSystemClientException {
        return this.mapLock.release();
    }

    public IPath getPath() {
        return this.path;
    }

    public void close() throws IOException {
        if (this.entries != null) {
            this.entries.close();
        }
    }
}

