/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.internal.FileItemInfo;
import com.ibm.team.filesystem.client.internal.FileStorage;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileStorage;
import com.ibm.team.filesystem.client.internal.IFileStorage$RuleKind;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.Shareable;
import com.ibm.team.filesystem.client.internal.ShareableFile;
import com.ibm.team.filesystem.client.internal.SharingManager;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;

public class LocalFileStorage
extends FileStorage
implements IFileStorage {
    protected static final Method canExecute;
    protected static final Method setExecutable;
    private final File file;
    private final IPath root;
    private final IPath fullPath;

    static {
        Method method = null;
        try {
            method = File.class.getMethod("canExecute", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        canExecute = method;
        method = null;
        try {
            method = File.class.getMethod("setExecutable", Boolean.TYPE);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
        setExecutable = method;
    }

    public LocalFileStorage(IPath iPath, File file) {
        this.file = file;
        this.root = iPath;
        String string = file.getPath();
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            LoggingHelper.error("com.ibm.team.filesystem.client", NLS.bind((String)Messages.LocalFileStorage_0, (Object[])new Object[]{string}), iOException);
        }
        this.fullPath = new Path(string).removeFirstSegments(iPath.segmentCount()).setDevice(null).makeAbsolute();
    }

    public File getFile() {
        return this.file;
    }

    public IPath getRoot() {
        return this.root;
    }

    public boolean isFolder() {
        return this.file.isDirectory();
    }

    public long getModificationStamp() {
        long l = this.file.lastModified();
        if (l == 0L) {
            return this.file.exists() ? 0 : -1;
        }
        return l;
    }

    public long getLocalTimeStamp() {
        return this.file.lastModified();
    }

    public boolean isModified(long l) {
        FileItemInfo fileItemInfo = SharingManager.getInstance().getItemInfo(new ShareableFile(this.root, this.file));
        return fileItemInfo == null || fileItemInfo.getLastModification() != l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getSize(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)1);
        try {
            if (this.file.isDirectory()) {
                return -1L;
            }
            long l = this.file.length();
            if (l == 0L && !this.file.exists()) {
                return -1L;
            }
            long l2 = l;
            return l2;
        }
        finally {
            subMonitor.done();
        }
    }

    public IFileStorage getParent() {
        if (this.fullPath.segmentCount() <= 1) {
            return null;
        }
        return new LocalFileStorage(this.root, this.file.getParentFile());
    }

    public IFileStorage getChild(String string) {
        File file = new File(this.file, string);
        if (file.exists()) {
            return new LocalFileStorage(this.root, file);
        }
        return null;
    }

    public IFileStorage[] getChildren() throws FileSystemClientException {
        File[] fileArray = this.file.listFiles();
        if (fileArray == null) {
            return null;
        }
        IFileStorage[] iFileStorageArray = new IFileStorage[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            iFileStorageArray[n] = new LocalFileStorage(this.root, fileArray[n]);
            ++n;
        }
        return iFileStorageArray;
    }

    public IVersionableHandle getRemote() {
        return new ShareableFile(this.root, this.file).getRemote();
    }

    public InputStream getContents(boolean bl) throws FileSystemClientException {
        return this.getContents();
    }

    public InputStream getContents() throws FileSystemClientException {
        if (this.file.isDirectory()) {
            return null;
        }
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, 203, Messages.LocalFileStorage_1, fileNotFoundException)));
        }
    }

    public void create(InputStream inputStream, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        this.setContents(inputStream, iProgressMonitor);
    }

    public void create(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        if (!this.file.mkdir()) {
            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(4, NLS.bind((String)Messages.LocalFileStorage_2, (Object[])new Object[]{this.fullPath}), null)));
        }
    }

    public void setContents(InputStream inputStream, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)1);
        try {
            if (this.isFolder()) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(iOException)));
                    }
                }
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(Messages.LocalFileStorage_3)));
            }
            boolean bl = false;
            try {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.file);
                    try {
                        if (inputStream != null) {
                            byte[] byArray = new byte[8192];
                            int n = inputStream.read(byArray);
                            while (n != -1) {
                                ((OutputStream)fileOutputStream).write(byArray, 0, n);
                                n = inputStream.read(byArray);
                            }
                        }
                        bl = true;
                    }
                    finally {
                        block27: {
                            try {
                                ((OutputStream)fileOutputStream).close();
                            }
                            catch (IOException iOException) {
                                if (!bl) break block27;
                                bl = false;
                                throw (Throwable)iOException;
                            }
                        }
                    }
                }
                catch (IOException iOException) {
                    throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(iOException)));
                }
            }
            finally {
                block28: {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            if (!bl) break block28;
                            throw (Throwable)((Object)new FileSystemClientException(FileSystemStatus.getStatusFor(iOException)));
                        }
                    }
                }
            }
        }
        finally {
            subMonitor.done();
        }
    }

    public IPath getFullPath() {
        return this.fullPath;
    }

    public String getName() {
        return this.file.getName();
    }

    public boolean isReadOnly() {
        return !this.file.canWrite();
    }

    public Shareable getShareable() {
        return new ShareableFile(this.root, this.file);
    }

    public boolean isExecutable() {
        if (!this.supportsExecBit()) {
            return super.isExecutable();
        }
        try {
            return (Boolean)canExecute.invoke((Object)this.file, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(illegalAccessException));
        }
        catch (InvocationTargetException invocationTargetException) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(invocationTargetException.getTargetException()));
        }
        return false;
    }

    public boolean setExecutable(boolean bl, IProgressMonitor iProgressMonitor) {
        if (!this.supportsExecBit()) {
            return super.setExecutable(bl, iProgressMonitor);
        }
        try {
            return (Boolean)setExecutable.invoke((Object)this.file, bl);
        }
        catch (IllegalAccessException illegalAccessException) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(illegalAccessException));
        }
        catch (InvocationTargetException invocationTargetException) {
            LoggingHelper.log(FileSystemStatus.getStatusFor(invocationTargetException.getTargetException()));
        }
        return false;
    }

    public boolean supportsExecBit() {
        return setExecutable != null && canExecute != null && super.supportsExecBit();
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void move(IFileStorage iFileStorage, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)1);
        try {
            LocalFileStorage localFileStorage = (LocalFileStorage)iFileStorage;
            if (!localFileStorage.root.equals((Object)this.root)) {
                throw (Throwable)new IllegalArgumentException();
            }
            if (!this.file.renameTo(localFileStorage.file)) {
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalFileStorage_4, (Object[])new Object[]{this.file, localFileStorage.file}))));
            }
        }
        finally {
            subMonitor.done();
        }
    }

    public void delete(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)100);
        try {
            if (this.exists()) {
                LocalFileStorage.deepDelete(this.file, (IProgressMonitor)subMonitor.newChild(100));
            }
        }
        finally {
            subMonitor.done();
        }
    }

    private static void deepDelete(File file, IProgressMonitor iProgressMonitor) throws FileSystemClientException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)iProgressMonitor, (int)0);
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalFileStorage_5, (Object[])new Object[]{file}))));
            }
            subMonitor.setWorkRemaining(fileArray.length);
            File[] fileArray2 = fileArray;
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray2[n2];
                LocalFileStorage.deepDelete(file2, (IProgressMonitor)subMonitor.newChild(1));
                ++n2;
            }
        }
        if (!file.delete()) {
            throw (Throwable)((Object)new FileSystemClientException(new FileSystemStatus(NLS.bind((String)Messages.LocalFileStorage_6, (Object[])new Object[]{file}))));
        }
    }

    public boolean contains(ISchedulingRule iSchedulingRule) {
        if (this == iSchedulingRule) {
            return true;
        }
        if (iSchedulingRule instanceof MultiRule) {
            MultiRule multiRule = (MultiRule)iSchedulingRule;
            ISchedulingRule[] iSchedulingRuleArray = multiRule.getChildren();
            int n = 0;
            while (n < iSchedulingRuleArray.length) {
                if (!this.contains(iSchedulingRuleArray[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        if (!(iSchedulingRule instanceof IFileStorage)) {
            return false;
        }
        return this.fullPath.isPrefixOf(((IFileStorage)iSchedulingRule).getFullPath());
    }

    public boolean isConflicting(ISchedulingRule iSchedulingRule) {
        if (!(iSchedulingRule instanceof IFileStorage)) {
            return false;
        }
        IPath iPath = ((IFileStorage)iSchedulingRule).getFullPath();
        return this.fullPath.isPrefixOf(iPath) || iPath.isPrefixOf(this.fullPath);
    }

    public String toString() {
        return this.fullPath.toString();
    }

    public void refreshCachedSubTree(IProgressMonitor iProgressMonitor) throws FileSystemClientException {
    }

    public ISchedulingRule getRule(IFileStorage$RuleKind iFileStorage$RuleKind) {
        switch (iFileStorage$RuleKind) {
            case CREATE: {
                return this.getParent() == null ? this : this.getParent();
            }
            case DELETE: {
                return this.getParent() == null ? this : this.getParent();
            }
            case MODIFY: {
                return this;
            }
            case REFRESH: {
                return null;
            }
        }
        throw (Throwable)new IllegalArgumentException("Unknown rule " + (Object)((Object)iFileStorage$RuleKind));
    }
}

