/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.repository.rcp.common.collection.SoftValueMap;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionCache {
    private Object changeSetMutex = new Object();
    private SoftValueMap<IRemoteFunction, Object> cachedRemoteFunctions = new SoftValueMap();
    private static FunctionCache instance = new FunctionCache();

    public static FunctionCache getDefault() {
        return instance;
    }

    public <T> T compute(IRemoteFunction<T> rootComputer, boolean refresh, IProgressMonitor monitor) throws TeamRepositoryException {
        Object result;
        if (!refresh && (result = this.getCachedValue(rootComputer)) != null) {
            return result;
        }
        result = rootComputer.compute(monitor);
        this.addToCache(rootComputer, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getCachedValue(IRemoteFunction<T> rootComputer) {
        Object object = this.changeSetMutex;
        synchronized (object) {
            Object result = this.cachedRemoteFunctions.get(rootComputer);
            if (result != null || this.cachedRemoteFunctions.containsKey(rootComputer)) {
                return (T)result;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void addToCache(IRemoteFunction<T> function, T result) {
        Object object = this.changeSetMutex;
        synchronized (object) {
            this.cachedRemoteFunctions.put(function, result);
        }
    }
}

