/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.IFileSystemManager;
import com.ibm.team.filesystem.client.IFileSystemView;
import com.ibm.team.filesystem.client.internal.FileSystemServiceProxy;
import com.ibm.team.filesystem.client.internal.FileSystemView;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemAcceptOperation;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemLoadOperation;
import com.ibm.team.filesystem.client.internal.operations.LocalFileSystemVerifySharesOperation;
import com.ibm.team.filesystem.client.operations.AcceptDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IAcceptOperation;
import com.ibm.team.filesystem.client.operations.ILoadOperation;
import com.ibm.team.filesystem.client.operations.IVerifyInSyncOperation;
import com.ibm.team.filesystem.client.operations.LoadDilemmaHandler;
import com.ibm.team.filesystem.client.operations.OutOfSyncDilemmaHandler;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.client.util.ThreadCheck;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.internal.ScmClientLibraryContext;
import org.eclipse.core.runtime.IPath;

public class FileSystemManager
implements IFileSystemManager {
    private final IClientLibraryContext context;

    public FileSystemManager(IClientLibraryContext iClientLibraryContext) {
        this.context = (IClientLibraryContext)new ScmClientLibraryContext(iClientLibraryContext);
    }

    public FileSystemServiceProxy getFileSystemService() {
        return new FileSystemServiceProxy(this.context);
    }

    public IFileSystemView getFileSystemView(IConnection iConnection) {
        return new FileSystemView(new FileSystemServiceProxy(this.context), iConnection);
    }

    public IAcceptOperation getLocalFileSystemAcceptOperation(IPath iPath, AcceptDilemmaHandler acceptDilemmaHandler) {
        ThreadCheck.checkLongOpsAllowed();
        if (iPath == null || !iPath.toFile().exists()) {
            throw (Throwable)new IllegalArgumentException();
        }
        return new LocalFileSystemAcceptOperation(iPath, acceptDilemmaHandler);
    }

    public IVerifyInSyncOperation getLocalFileSystemVerifyInSyncOperation(IPath iPath, OutOfSyncDilemmaHandler outOfSyncDilemmaHandler) {
        if (iPath == null || !iPath.toFile().exists()) {
            throw (Throwable)new IllegalArgumentException();
        }
        return new LocalFileSystemVerifySharesOperation(iPath, outOfSyncDilemmaHandler);
    }

    public ILoadOperation getLocalFileSystemLoadOperation(IPath iPath, int n, LoadDilemmaHandler loadDilemmaHandler) {
        if (iPath == null || !iPath.toFile().exists()) {
            throw (Throwable)new IllegalArgumentException();
        }
        if (n != 0 && n != 1 && n != 2) {
            throw (Throwable)new IllegalArgumentException();
        }
        LocalFileSystemLoadOperation localFileSystemLoadOperation = new LocalFileSystemLoadOperation(iPath, this.getLoadOperationFlags(n), loadDilemmaHandler);
        return localFileSystemLoadOperation;
    }

    private int getLoadOperationFlags(int n) {
        int n2 = 0;
        if ((n & 1) == 1) {
            n2 = 1;
        } else if ((n & 2) == 2) {
            n2 = 2;
        }
        return n2;
    }
}

