/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.internal.utils.FileContentInputStream;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.utils.IInputStreamProvider;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class FileContentInputStreamProvider
implements IInputStreamProvider {
    private ITeamRepository repo;
    private IContent content;

    public FileContentInputStreamProvider(ITeamRepository repo, IContent content) {
        this.repo = repo;
        this.content = content;
    }

    public InputStream getInputStream(IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return new FileContentInputStream(this.repo, this.content, monitor);
    }

    public String toString() {
        return "FileContent(" + this.content.getContentId().getUuidValue() + ")";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.content == null ? 0 : this.content.getContentId().hashCode());
        result = 31 * result + (this.repo == null ? 0 : this.repo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileContentInputStreamProvider other = (FileContentInputStreamProvider)obj;
        if (this.content == null ? other.content != null : !this.content.getContentId().equals((Object)other.content.getContentId())) {
            return false;
        }
        return !(this.repo == null ? other.repo != null : !this.repo.equals(other.repo));
    }
}

