/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.IFileSystemStatus;
import com.ibm.team.filesystem.client.internal.Messages;
import com.ibm.team.filesystem.client.internal.load.LoadLocation;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationDescriptor;
import com.ibm.team.filesystem.client.operations.ICollision;
import com.ibm.team.filesystem.client.operations.ILoadLocation;
import com.ibm.team.repository.common.util.NLS;
import java.util.ArrayList;
import java.util.Collection;

public class Collision
implements ICollision {
    private final IShareable shareable;
    private final ArrayList locations;
    private final boolean alreadyExists;
    private ILoadLocation loadLocation;
    private Object lock = new Object();
    private IFileSystemStatus status;

    public Collision(IShareable iShareable, ILoadLocation iLoadLocation, boolean bl) {
        this.shareable = iShareable;
        this.locations = new ArrayList();
        this.locations.add(iLoadLocation);
        this.alreadyExists = bl;
    }

    public IShareable getShareable() {
        return this.shareable;
    }

    public IFileSystemStatus getStatus() {
        if (this.status == null) {
            Object object;
            ISharingDescriptor iSharingDescriptor;
            String string = this.shareable.getLocalFullPath().makeRelative().toString();
            IShare iShare = this.shareable.getShare();
            if (iShare != null) {
                iSharingDescriptor = iShare.getSharingDescriptor();
                if (iShare != null) {
                    string = String.valueOf(string) + " [" + iSharingDescriptor.getConnectionName() + " - " + iSharingDescriptor.getComponentName() + "]";
                }
                if (((ILocalChange[])(object = FileSystemCore.getSharingManager().getLocalChangeManager().getPendingChanges(new IShare[]{iShare}))).length > 0) {
                    string = NLS.bind((String)Messages.Collision_0, (Object[])new Object[]{string, ((ILocalChange[])object).length});
                }
            }
            if (this.alreadyExists) {
                if (iShare == null || iShare.getSharingDescriptor() == null) {
                    this.status = new FileSystemStatus(2, 333, NLS.bind((String)Messages.Collision_1, (Object[])new Object[]{string}));
                } else {
                    iSharingDescriptor = iShare.getSharingDescriptor();
                    object = new ConfigurationDescriptor(iSharingDescriptor.getRepositoryId(), iSharingDescriptor.getRepositoryUri(), iSharingDescriptor.getConnectionHandle(), iSharingDescriptor.getComponent());
                    for (ILoadLocation iLoadLocation : this.locations) {
                        if (!((ConfigurationDescriptor)object).equals(((LoadLocation)iLoadLocation).getDescriptor())) continue;
                        this.status = new FileSystemStatus(2, 334, NLS.bind((String)Messages.Collision_2, (Object[])new Object[]{string}));
                        break;
                    }
                    if (this.status == null) {
                        this.status = new FileSystemStatus(4, 366, NLS.bind((String)Messages.Collision_3, (Object[])new Object[]{string}));
                    }
                }
            } else {
                this.status = this.locations.size() > 1 ? (IFileSystemStatus)new FileSystemStatus(2, 204, NLS.bind((String)Messages.Collision_4, (Object[])new Object[]{string})) : (IFileSystemStatus)new FileSystemStatus(2, 204, string);
            }
        }
        return this.status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILoadLocation getLoadLocation() {
        Object object = this.lock;
        synchronized (object) {
            return this.loadLocation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getLocations() {
        Object object = this.lock;
        synchronized (object) {
            return this.locations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLoadLocation(ILoadLocation iLoadLocation) {
        Object object = this.lock;
        synchronized (object) {
            this.loadLocation = iLoadLocation;
        }
    }

    public boolean collidedWithExistingContent() {
        return this.alreadyExists;
    }
}

