/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.client.internal;

import com.ibm.team.filesystem.client.FileSystemClientException;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.internal.FileSystemStatus;
import com.ibm.team.filesystem.client.internal.LoggingHelper;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.Share;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.repository.common.utils.HashCode;
import com.ibm.team.repository.common.utils.HashComputingOutputStream;
import com.ibm.team.scm.common.IVersionableHandle;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ChangeTrackingOutputStream
extends HashComputingOutputStream {
    HashCode targetHash;
    IFileItemHandle handle;
    private Share share;
    ManagedFileStore managed;
    boolean closed = false;

    public ChangeTrackingOutputStream(OutputStream out, ManagedFileStore managed, IFileItemHandle handle, Share share, HashCode targetHash) {
        super(out);
        this.managed = managed;
        this.handle = handle;
        this.share = share;
        this.targetHash = targetHash;
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        if (this.getHash().equals((Object)this.targetHash)) {
            this.managed.addDatelessTouchedItem((IVersionableHandle)this.handle, this.share.getSharingDescriptor().getComponent(), this.share.getSharingDescriptor().getConnectionHandle());
        } else {
            IPath path;
            try {
                path = this.share.getCopyFileArea().getLocalPathFor((IVersionableHandle)this.handle, this.share.getSharingDescriptor().getComponent(), this.share.getSharingDescriptor().getConnectionHandle(), null);
            }
            catch (FileSystemClientException e) {
                LoggingHelper.log((IStatus)new Status(4, "com.ibm.team.filesystem.client", "Error aquiring path for shareable", (Throwable)((Object)e)));
                return;
            }
            IShareable shareable = this.share.getShareable(path, false);
            this.share.getTracker().trackFileChange(shareable.getLocalFullPath(), this.handle, shareable);
        }
    }

    public void finalize() throws IOException {
        if (!this.closed) {
            this.close();
            LoggingHelper.log(new FileSystemStatus("Stream finalized without beind close()ed"));
        }
    }
}

