/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.text;

import com.ibm.team.foundation.common.text.HTMLOutputHandler;
import com.ibm.team.foundation.common.text.PlainTextHandler;
import com.ibm.team.foundation.common.text.XMLConverter;
import org.eclipse.core.runtime.Assert;

public final class XMLString {
    public static final XMLString EMPTY = XMLString.createFromXMLText("");
    private String fXMLText;

    public static XMLString createFromPlainText(String plainText) {
        HTMLOutputHandler handler = new HTMLOutputHandler();
        handler.beginDocument();
        handler.text(plainText);
        handler.endDocument();
        return handler.getHTML();
    }

    public static XMLString createFromXMLText(String xmlText) {
        return new XMLString(xmlText);
    }

    private XMLString(String xmlText) {
        Assert.isNotNull((Object)xmlText);
        this.fXMLText = xmlText;
    }

    public String getPlainText() {
        PlainTextHandler handler = new PlainTextHandler();
        XMLConverter.parseHTML(this, handler);
        return handler.getText();
    }

    public String getXMLText() {
        return this.fXMLText;
    }

    public XMLString concat(XMLString other) {
        return XMLString.createFromXMLText(String.valueOf(this.getXMLText()) + other.getXMLText());
    }

    public int hashCode() {
        return this.fXMLText.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.fXMLText.equals(((XMLString)obj).fXMLText);
    }

    public String toString() {
        return this.getXMLText();
    }
}

