/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.common.internal.util;

import com.ibm.team.foundation.common.internal.rcp.dto.RcpFactory;
import com.ibm.team.foundation.common.internal.rcp.dto.TeamFoundationExceptionDTO;
import com.ibm.team.foundation.common.internal.util.ITeamFoundationExceptionDescriptor;
import com.ibm.team.repository.common.LoginFailureException;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.StaleDataException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.ConnectionException;
import com.ibm.team.repository.common.transport.HostUnknownException;
import java.net.SocketTimeoutException;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;

public class TeamFoundationException
extends TeamRepositoryException {
    private static final long serialVersionUID = 1L;

    public TeamFoundationException(ITeamFoundationExceptionDescriptor descriptor) {
        super(descriptor.getSummary());
        this.setData(descriptor);
    }

    public TeamFoundationException(Object origin, String message, Throwable cause) {
        super(origin, message, cause);
    }

    public TeamFoundationException(Object origin, String message) {
        super(origin, message);
    }

    public TeamFoundationException(String message, Throwable cause) {
        super(message, cause);
    }

    public TeamFoundationException(String message) {
        super(message);
    }

    public TeamFoundationException(Throwable cause) {
        super(cause);
    }

    public String getId() {
        Object data = this.getData();
        if (data instanceof ITeamFoundationExceptionDescriptor) {
            return ((ITeamFoundationExceptionDescriptor)data).getId();
        }
        return null;
    }

    public String getSummary() {
        Object data = this.getData();
        if (data instanceof ITeamFoundationExceptionDescriptor) {
            return ((ITeamFoundationExceptionDescriptor)data).getSummary();
        }
        return null;
    }

    public String getDescription() {
        Object data = this.getData();
        if (data instanceof ITeamFoundationExceptionDescriptor) {
            return ((ITeamFoundationExceptionDescriptor)data).getDescription();
        }
        return null;
    }

    public boolean isExpected() {
        Object data = this.getData();
        if (data instanceof ITeamFoundationExceptionDescriptor) {
            return ((ITeamFoundationExceptionDescriptor)data).isExpected();
        }
        return false;
    }

    public static boolean isExpected(Throwable x) {
        HashSet<Throwable> seen = new HashSet<Throwable>();
        while (x != null && !seen.contains(x)) {
            seen.add(x);
            if (TeamFoundationException.internalIsExpected(x)) {
                return true;
            }
            x = x instanceof CoreException && ((CoreException)x).getStatus() != null && ((CoreException)x).getStatus().getException() != null ? ((CoreException)x).getStatus().getException() : x.getCause();
        }
        return false;
    }

    private static boolean internalIsExpected(Throwable x) {
        if (x instanceof TeamFoundationException) {
            return ((TeamFoundationException)((Object)x)).isExpected();
        }
        if (x instanceof NotLoggedInException) {
            return true;
        }
        if (x instanceof PermissionDeniedException) {
            return true;
        }
        if (x instanceof StaleDataException) {
            return true;
        }
        if (x instanceof LoginFailureException) {
            return true;
        }
        if ("com.ibm.team.process.common.advice.TeamOperationCanceledException".equals(x.getClass().getName())) {
            return true;
        }
        if ("com.ibm.team.repository.transport.client.AuthenticationException".equals(x.getClass().getName())) {
            return true;
        }
        if (x instanceof ConnectionException) {
            return true;
        }
        if (x instanceof HostUnknownException) {
            return true;
        }
        if (x instanceof OperationCanceledException) {
            return true;
        }
        return x instanceof SocketTimeoutException;
    }

    public static ITeamFoundationExceptionDescriptor createDescriptor(String id, String summary, String description, boolean expected) {
        TeamFoundationExceptionDTO dto = RcpFactory.eINSTANCE.createTeamFoundationExceptionDTO();
        dto.setId(id);
        dto.setSummary(summary);
        dto.setDescription(description);
        dto.setExpected(expected);
        return dto;
    }
}

